/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The PII entity to configure for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailPiiEntityConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailPiiEntityConfig.Builder, GuardrailPiiEntityConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailPiiEntityConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailPiiEntityConfig::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String action;

    private GuardrailPiiEntityConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.action = builder.action;
    }

    /**
     * <p>
     * Configure guardrail type when the PII entity is detected.
     * </p>
     * <p>
     * The following PIIs are used to block or mask sensitive information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>General</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ADDRESS</b>
     * </p>
     * <p>
     * A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can include
     * information such as the street, building, location, city, state, country, county, zip code, precinct, and
     * neighborhood.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AGE</b>
     * </p>
     * <p>
     * An individual's age, including the quantity and unit of time. For example, in the phrase "I am 40 years old,"
     * Guardrails recognizes "40 years" as an age.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NAME</b>
     * </p>
     * <p>
     * An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails
     * doesn't apply this entity type to names that are part of organizations or addresses. For example, guardrails
     * recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EMAIL</b>
     * </p>
     * <p>
     * An email address, such as <i>marymajor@email.com</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PHONE</b>
     * </p>
     * <p>
     * A phone number. This entity type also includes fax and pager numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>USERNAME</b>
     * </p>
     * <p>
     * A user name that identifies an account, such as a login name, screen name, nick name, or handle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PASSWORD</b>
     * </p>
     * <p>
     * An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>".
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DRIVER_ID</b>
     * </p>
     * <p>
     * The number assigned to a driver's license, which is an official document permitting an individual to operate one
     * or more motorized vehicles on a public road. A driver's license number consists of alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>LICENSE_PLATE</b>
     * </p>
     * <p>
     * A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format for
     * passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The format
     * varies depending on the location of the issuing state or country.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VEHICLE_IDENTIFICATION_NUMBER</b>
     * </p>
     * <p>
     * A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in the
     * <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Finance</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CREDIT_DEBIT_CARD_CVV</b>
     * </p>
     * <p>
     * A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit
     * cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREDIT_DEBIT_CARD_EXPIRY</b>
     * </p>
     * <p>
     * The expiration date for a credit or debit card. This number is usually four digits long and is often formatted as
     * <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as <i>01/21</i>, <i>01/2021</i>,
     * and <i>Jan 2021</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREDIT_DEBIT_CARD_NUMBER</b>
     * </p>
     * <p>
     * The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon
     * Comprehend also recognizes credit or debit card numbers when only the last four digits are present.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PIN</b>
     * </p>
     * <p>
     * A four-digit personal identification number (PIN) with which you can access your bank account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b>
     * </p>
     * <p>
     * An International Bank Account Number has specific formats in each country. For more information, see <a
     * href="https://www.iban.com/structure">www.iban.com/structure</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SWIFT_CODE</b>
     * </p>
     * <p>
     * A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch.
     * Banks use these codes for money transfers such as international wire transfers.
     * </p>
     * <p>
     * SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while eight-digit
     * codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>IT</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>IP_ADDRESS</b>
     * </p>
     * <p>
     * An IPv4 address, such as <i>198.51.100.0</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAC_ADDRESS</b>
     * </p>
     * <p>
     * A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface controller
     * (NIC).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>URL</b>
     * </p>
     * <p>
     * A web address, such as <i>www.example.com</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS_ACCESS_KEY</b>
     * </p>
     * <p>
     * A unique identifier that's associated with a secret access key; you use the access key ID and secret access key
     * to sign programmatic Amazon Web Services requests cryptographically.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS_SECRET_KEY</b>
     * </p>
     * <p>
     * A unique identifier that's associated with an access key. You use the access key ID and secret access key to sign
     * programmatic Amazon Web Services requests cryptographically.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>USA specific</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>US_BANK_ACCOUNT_NUMBER</b>
     * </p>
     * <p>
     * A US bank account number, which is typically 10 to 12 digits long.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>US_BANK_ROUTING_NUMBER</b>
     * </p>
     * <p>
     * A US bank account routing number. These are typically nine digits long,
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b>
     * </p>
     * <p>
     * A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and contain a
     * "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and forth digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>US_PASSPORT_NUMBER</b>
     * </p>
     * <p>
     * A US passport number. Passport numbers range from six to nine alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>US_SOCIAL_SECURITY_NUMBER</b>
     * </p>
     * <p>
     * A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents, and
     * temporary working residents.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Canada specific</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CA_HEALTH_NUMBER</b>
     * </p>
     * <p>
     * A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access healthcare
     * benefits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CA_SOCIAL_INSURANCE_NUMBER</b>
     * </p>
     * <p>
     * A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to access
     * government programs and benefits.
     * </p>
     * <p>
     * The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be validated through
     * a simple check-digit process called the <a href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn
     * algorithm</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>UK Specific</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b>
     * </p>
     * <p>
     * A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current system
     * formats the 10-digit number with spaces after the third and sixth digits. The final digit is an error-detecting
     * checksum.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UK_NATIONAL_INSURANCE_NUMBER</b>
     * </p>
     * <p>
     * A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social security)
     * benefits. It is also used for some purposes in the UK tax system.
     * </p>
     * <p>
     * The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO can be
     * formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b>
     * </p>
     * <p>
     * A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Custom</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to recognize and act
     * upon such as serial number, booking ID etc..
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailPiiEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Configure guardrail type when the PII entity is detected.</p>
     *         <p>
     *         The following PIIs are used to block or mask sensitive information:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>General</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ADDRESS</b>
     *         </p>
     *         <p>
     *         A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can
     *         include information such as the street, building, location, city, state, country, county, zip code,
     *         precinct, and neighborhood.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AGE</b>
     *         </p>
     *         <p>
     *         An individual's age, including the quantity and unit of time. For example, in the phrase
     *         "I am 40 years old," Guardrails recognizes "40 years" as an age.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NAME</b>
     *         </p>
     *         <p>
     *         An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss.
     *         guardrails doesn't apply this entity type to names that are part of organizations or addresses. For
     *         example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes
     *         "Jane Doe Street" as an address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EMAIL</b>
     *         </p>
     *         <p>
     *         An email address, such as <i>marymajor@email.com</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PHONE</b>
     *         </p>
     *         <p>
     *         A phone number. This entity type also includes fax and pager numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>USERNAME</b>
     *         </p>
     *         <p>
     *         A user name that identifies an account, such as a login name, screen name, nick name, or handle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PASSWORD</b>
     *         </p>
     *         <p>
     *         An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DRIVER_ID</b>
     *         </p>
     *         <p>
     *         The number assigned to a driver's license, which is an official document permitting an individual to
     *         operate one or more motorized vehicles on a public road. A driver's license number consists of
     *         alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>LICENSE_PLATE</b>
     *         </p>
     *         <p>
     *         A license plate for a vehicle is issued by the state or country where the vehicle is registered. The
     *         format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and
     *         numbers. The format varies depending on the location of the issuing state or country.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VEHICLE_IDENTIFICATION_NUMBER</b>
     *         </p>
     *         <p>
     *         A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined
     *         in the <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Finance</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CREDIT_DEBIT_CARD_CVV</b>
     *         </p>
     *         <p>
     *         A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and
     *         debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREDIT_DEBIT_CARD_EXPIRY</b>
     *         </p>
     *         <p>
     *         The expiration date for a credit or debit card. This number is usually four digits long and is often
     *         formatted as <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as
     *         <i>01/21</i>, <i>01/2021</i>, and <i>Jan 2021</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREDIT_DEBIT_CARD_NUMBER</b>
     *         </p>
     *         <p>
     *         The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However,
     *         Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are
     *         present.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PIN</b>
     *         </p>
     *         <p>
     *         A four-digit personal identification number (PIN) with which you can access your bank account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b>
     *         </p>
     *         <p>
     *         An International Bank Account Number has specific formats in each country. For more information, see <a
     *         href="https://www.iban.com/structure">www.iban.com/structure</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SWIFT_CODE</b>
     *         </p>
     *         <p>
     *         A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or
     *         branch. Banks use these codes for money transfers such as international wire transfers.
     *         </p>
     *         <p>
     *         SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while
     *         eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IT</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>IP_ADDRESS</b>
     *         </p>
     *         <p>
     *         An IPv4 address, such as <i>198.51.100.0</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAC_ADDRESS</b>
     *         </p>
     *         <p>
     *         A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface
     *         controller (NIC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>URL</b>
     *         </p>
     *         <p>
     *         A web address, such as <i>www.example.com</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AWS_ACCESS_KEY</b>
     *         </p>
     *         <p>
     *         A unique identifier that's associated with a secret access key; you use the access key ID and secret
     *         access key to sign programmatic Amazon Web Services requests cryptographically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AWS_SECRET_KEY</b>
     *         </p>
     *         <p>
     *         A unique identifier that's associated with an access key. You use the access key ID and secret access key
     *         to sign programmatic Amazon Web Services requests cryptographically.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>USA specific</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>US_BANK_ACCOUNT_NUMBER</b>
     *         </p>
     *         <p>
     *         A US bank account number, which is typically 10 to 12 digits long.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>US_BANK_ROUTING_NUMBER</b>
     *         </p>
     *         <p>
     *         A US bank account routing number. These are typically nine digits long,
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b>
     *         </p>
     *         <p>
     *         A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and
     *         contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third
     *         and forth digits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>US_PASSPORT_NUMBER</b>
     *         </p>
     *         <p>
     *         A US passport number. Passport numbers range from six to nine alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>US_SOCIAL_SECURITY_NUMBER</b>
     *         </p>
     *         <p>
     *         A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent
     *         residents, and temporary working residents.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Canada specific</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CA_HEALTH_NUMBER</b>
     *         </p>
     *         <p>
     *         A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access
     *         healthcare benefits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CA_SOCIAL_INSURANCE_NUMBER</b>
     *         </p>
     *         <p>
     *         A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to
     *         access government programs and benefits.
     *         </p>
     *         <p>
     *         The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be validated
     *         through a simple check-digit process called the <a
     *         href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn algorithm</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UK Specific</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b>
     *         </p>
     *         <p>
     *         A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current
     *         system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an
     *         error-detecting checksum.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UK_NATIONAL_INSURANCE_NUMBER</b>
     *         </p>
     *         <p>
     *         A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social
     *         security) benefits. It is also used for some purposes in the UK tax system.
     *         </p>
     *         <p>
     *         The number is nine digits long and starts with two letters, followed by six numbers and one letter. A
     *         NINO can be formatted with a space or a dash after the two letters and after the second, forth, and sixth
     *         digits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b>
     *         </p>
     *         <p>
     *         A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Custom</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to recognize
     *         and act upon such as serial number, booking ID etc..
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see GuardrailPiiEntityType
     */
    public final GuardrailPiiEntityType type() {
        return GuardrailPiiEntityType.fromValue(type);
    }

    /**
     * <p>
     * Configure guardrail type when the PII entity is detected.
     * </p>
     * <p>
     * The following PIIs are used to block or mask sensitive information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>General</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ADDRESS</b>
     * </p>
     * <p>
     * A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can include
     * information such as the street, building, location, city, state, country, county, zip code, precinct, and
     * neighborhood.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AGE</b>
     * </p>
     * <p>
     * An individual's age, including the quantity and unit of time. For example, in the phrase "I am 40 years old,"
     * Guardrails recognizes "40 years" as an age.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NAME</b>
     * </p>
     * <p>
     * An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails
     * doesn't apply this entity type to names that are part of organizations or addresses. For example, guardrails
     * recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EMAIL</b>
     * </p>
     * <p>
     * An email address, such as <i>marymajor@email.com</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PHONE</b>
     * </p>
     * <p>
     * A phone number. This entity type also includes fax and pager numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>USERNAME</b>
     * </p>
     * <p>
     * A user name that identifies an account, such as a login name, screen name, nick name, or handle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PASSWORD</b>
     * </p>
     * <p>
     * An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>".
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DRIVER_ID</b>
     * </p>
     * <p>
     * The number assigned to a driver's license, which is an official document permitting an individual to operate one
     * or more motorized vehicles on a public road. A driver's license number consists of alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>LICENSE_PLATE</b>
     * </p>
     * <p>
     * A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format for
     * passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The format
     * varies depending on the location of the issuing state or country.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VEHICLE_IDENTIFICATION_NUMBER</b>
     * </p>
     * <p>
     * A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in the
     * <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Finance</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CREDIT_DEBIT_CARD_CVV</b>
     * </p>
     * <p>
     * A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit
     * cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREDIT_DEBIT_CARD_EXPIRY</b>
     * </p>
     * <p>
     * The expiration date for a credit or debit card. This number is usually four digits long and is often formatted as
     * <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as <i>01/21</i>, <i>01/2021</i>,
     * and <i>Jan 2021</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREDIT_DEBIT_CARD_NUMBER</b>
     * </p>
     * <p>
     * The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon
     * Comprehend also recognizes credit or debit card numbers when only the last four digits are present.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PIN</b>
     * </p>
     * <p>
     * A four-digit personal identification number (PIN) with which you can access your bank account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b>
     * </p>
     * <p>
     * An International Bank Account Number has specific formats in each country. For more information, see <a
     * href="https://www.iban.com/structure">www.iban.com/structure</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SWIFT_CODE</b>
     * </p>
     * <p>
     * A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch.
     * Banks use these codes for money transfers such as international wire transfers.
     * </p>
     * <p>
     * SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while eight-digit
     * codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>IT</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>IP_ADDRESS</b>
     * </p>
     * <p>
     * An IPv4 address, such as <i>198.51.100.0</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAC_ADDRESS</b>
     * </p>
     * <p>
     * A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface controller
     * (NIC).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>URL</b>
     * </p>
     * <p>
     * A web address, such as <i>www.example.com</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS_ACCESS_KEY</b>
     * </p>
     * <p>
     * A unique identifier that's associated with a secret access key; you use the access key ID and secret access key
     * to sign programmatic Amazon Web Services requests cryptographically.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS_SECRET_KEY</b>
     * </p>
     * <p>
     * A unique identifier that's associated with an access key. You use the access key ID and secret access key to sign
     * programmatic Amazon Web Services requests cryptographically.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>USA specific</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>US_BANK_ACCOUNT_NUMBER</b>
     * </p>
     * <p>
     * A US bank account number, which is typically 10 to 12 digits long.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>US_BANK_ROUTING_NUMBER</b>
     * </p>
     * <p>
     * A US bank account routing number. These are typically nine digits long,
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b>
     * </p>
     * <p>
     * A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and contain a
     * "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and forth digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>US_PASSPORT_NUMBER</b>
     * </p>
     * <p>
     * A US passport number. Passport numbers range from six to nine alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>US_SOCIAL_SECURITY_NUMBER</b>
     * </p>
     * <p>
     * A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents, and
     * temporary working residents.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Canada specific</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CA_HEALTH_NUMBER</b>
     * </p>
     * <p>
     * A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access healthcare
     * benefits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CA_SOCIAL_INSURANCE_NUMBER</b>
     * </p>
     * <p>
     * A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to access
     * government programs and benefits.
     * </p>
     * <p>
     * The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be validated through
     * a simple check-digit process called the <a href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn
     * algorithm</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>UK Specific</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b>
     * </p>
     * <p>
     * A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current system
     * formats the 10-digit number with spaces after the third and sixth digits. The final digit is an error-detecting
     * checksum.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UK_NATIONAL_INSURANCE_NUMBER</b>
     * </p>
     * <p>
     * A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social security)
     * benefits. It is also used for some purposes in the UK tax system.
     * </p>
     * <p>
     * The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO can be
     * formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b>
     * </p>
     * <p>
     * A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Custom</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to recognize and act
     * upon such as serial number, booking ID etc..
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailPiiEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Configure guardrail type when the PII entity is detected.</p>
     *         <p>
     *         The following PIIs are used to block or mask sensitive information:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>General</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ADDRESS</b>
     *         </p>
     *         <p>
     *         A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can
     *         include information such as the street, building, location, city, state, country, county, zip code,
     *         precinct, and neighborhood.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AGE</b>
     *         </p>
     *         <p>
     *         An individual's age, including the quantity and unit of time. For example, in the phrase
     *         "I am 40 years old," Guardrails recognizes "40 years" as an age.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NAME</b>
     *         </p>
     *         <p>
     *         An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss.
     *         guardrails doesn't apply this entity type to names that are part of organizations or addresses. For
     *         example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes
     *         "Jane Doe Street" as an address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EMAIL</b>
     *         </p>
     *         <p>
     *         An email address, such as <i>marymajor@email.com</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PHONE</b>
     *         </p>
     *         <p>
     *         A phone number. This entity type also includes fax and pager numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>USERNAME</b>
     *         </p>
     *         <p>
     *         A user name that identifies an account, such as a login name, screen name, nick name, or handle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PASSWORD</b>
     *         </p>
     *         <p>
     *         An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DRIVER_ID</b>
     *         </p>
     *         <p>
     *         The number assigned to a driver's license, which is an official document permitting an individual to
     *         operate one or more motorized vehicles on a public road. A driver's license number consists of
     *         alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>LICENSE_PLATE</b>
     *         </p>
     *         <p>
     *         A license plate for a vehicle is issued by the state or country where the vehicle is registered. The
     *         format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and
     *         numbers. The format varies depending on the location of the issuing state or country.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VEHICLE_IDENTIFICATION_NUMBER</b>
     *         </p>
     *         <p>
     *         A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined
     *         in the <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Finance</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CREDIT_DEBIT_CARD_CVV</b>
     *         </p>
     *         <p>
     *         A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and
     *         debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREDIT_DEBIT_CARD_EXPIRY</b>
     *         </p>
     *         <p>
     *         The expiration date for a credit or debit card. This number is usually four digits long and is often
     *         formatted as <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as
     *         <i>01/21</i>, <i>01/2021</i>, and <i>Jan 2021</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREDIT_DEBIT_CARD_NUMBER</b>
     *         </p>
     *         <p>
     *         The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However,
     *         Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are
     *         present.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PIN</b>
     *         </p>
     *         <p>
     *         A four-digit personal identification number (PIN) with which you can access your bank account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b>
     *         </p>
     *         <p>
     *         An International Bank Account Number has specific formats in each country. For more information, see <a
     *         href="https://www.iban.com/structure">www.iban.com/structure</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SWIFT_CODE</b>
     *         </p>
     *         <p>
     *         A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or
     *         branch. Banks use these codes for money transfers such as international wire transfers.
     *         </p>
     *         <p>
     *         SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while
     *         eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IT</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>IP_ADDRESS</b>
     *         </p>
     *         <p>
     *         An IPv4 address, such as <i>198.51.100.0</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAC_ADDRESS</b>
     *         </p>
     *         <p>
     *         A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface
     *         controller (NIC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>URL</b>
     *         </p>
     *         <p>
     *         A web address, such as <i>www.example.com</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AWS_ACCESS_KEY</b>
     *         </p>
     *         <p>
     *         A unique identifier that's associated with a secret access key; you use the access key ID and secret
     *         access key to sign programmatic Amazon Web Services requests cryptographically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AWS_SECRET_KEY</b>
     *         </p>
     *         <p>
     *         A unique identifier that's associated with an access key. You use the access key ID and secret access key
     *         to sign programmatic Amazon Web Services requests cryptographically.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>USA specific</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>US_BANK_ACCOUNT_NUMBER</b>
     *         </p>
     *         <p>
     *         A US bank account number, which is typically 10 to 12 digits long.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>US_BANK_ROUTING_NUMBER</b>
     *         </p>
     *         <p>
     *         A US bank account routing number. These are typically nine digits long,
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b>
     *         </p>
     *         <p>
     *         A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and
     *         contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third
     *         and forth digits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>US_PASSPORT_NUMBER</b>
     *         </p>
     *         <p>
     *         A US passport number. Passport numbers range from six to nine alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>US_SOCIAL_SECURITY_NUMBER</b>
     *         </p>
     *         <p>
     *         A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent
     *         residents, and temporary working residents.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Canada specific</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CA_HEALTH_NUMBER</b>
     *         </p>
     *         <p>
     *         A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access
     *         healthcare benefits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CA_SOCIAL_INSURANCE_NUMBER</b>
     *         </p>
     *         <p>
     *         A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to
     *         access government programs and benefits.
     *         </p>
     *         <p>
     *         The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be validated
     *         through a simple check-digit process called the <a
     *         href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn algorithm</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UK Specific</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b>
     *         </p>
     *         <p>
     *         A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current
     *         system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an
     *         error-detecting checksum.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UK_NATIONAL_INSURANCE_NUMBER</b>
     *         </p>
     *         <p>
     *         A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social
     *         security) benefits. It is also used for some purposes in the UK tax system.
     *         </p>
     *         <p>
     *         The number is nine digits long and starts with two letters, followed by six numbers and one letter. A
     *         NINO can be formatted with a space or a dash after the two letters and after the second, forth, and sixth
     *         digits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b>
     *         </p>
     *         <p>
     *         A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Custom</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to recognize
     *         and act upon such as serial number, booking ID etc..
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see GuardrailPiiEntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Configure guardrail action when the PII entity is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return Configure guardrail action when the PII entity is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final GuardrailSensitiveInformationAction action() {
        return GuardrailSensitiveInformationAction.fromValue(action);
    }

    /**
     * <p>
     * Configure guardrail action when the PII entity is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return Configure guardrail action when the PII entity is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailPiiEntityConfig)) {
            return false;
        }
        GuardrailPiiEntityConfig other = (GuardrailPiiEntityConfig) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailPiiEntityConfig").add("Type", typeAsString()).add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("action", ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailPiiEntityConfig, T> g) {
        return obj -> g.apply((GuardrailPiiEntityConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailPiiEntityConfig> {
        /**
         * <p>
         * Configure guardrail type when the PII entity is detected.
         * </p>
         * <p>
         * The following PIIs are used to block or mask sensitive information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>General</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ADDRESS</b>
         * </p>
         * <p>
         * A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can
         * include information such as the street, building, location, city, state, country, county, zip code, precinct,
         * and neighborhood.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AGE</b>
         * </p>
         * <p>
         * An individual's age, including the quantity and unit of time. For example, in the phrase "I am 40 years old,"
         * Guardrails recognizes "40 years" as an age.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NAME</b>
         * </p>
         * <p>
         * An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails
         * doesn't apply this entity type to names that are part of organizations or addresses. For example, guardrails
         * recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EMAIL</b>
         * </p>
         * <p>
         * An email address, such as <i>marymajor@email.com</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PHONE</b>
         * </p>
         * <p>
         * A phone number. This entity type also includes fax and pager numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>USERNAME</b>
         * </p>
         * <p>
         * A user name that identifies an account, such as a login name, screen name, nick name, or handle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PASSWORD</b>
         * </p>
         * <p>
         * An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>".
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DRIVER_ID</b>
         * </p>
         * <p>
         * The number assigned to a driver's license, which is an official document permitting an individual to operate
         * one or more motorized vehicles on a public road. A driver's license number consists of alphanumeric
         * characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>LICENSE_PLATE</b>
         * </p>
         * <p>
         * A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format
         * for passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The
         * format varies depending on the location of the issuing state or country.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VEHICLE_IDENTIFICATION_NUMBER</b>
         * </p>
         * <p>
         * A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in
         * the <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Finance</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CREDIT_DEBIT_CARD_CVV</b>
         * </p>
         * <p>
         * A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit
         * cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREDIT_DEBIT_CARD_EXPIRY</b>
         * </p>
         * <p>
         * The expiration date for a credit or debit card. This number is usually four digits long and is often
         * formatted as <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as <i>01/21</i>,
         * <i>01/2021</i>, and <i>Jan 2021</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREDIT_DEBIT_CARD_NUMBER</b>
         * </p>
         * <p>
         * The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon
         * Comprehend also recognizes credit or debit card numbers when only the last four digits are present.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PIN</b>
         * </p>
         * <p>
         * A four-digit personal identification number (PIN) with which you can access your bank account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b>
         * </p>
         * <p>
         * An International Bank Account Number has specific formats in each country. For more information, see <a
         * href="https://www.iban.com/structure">www.iban.com/structure</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SWIFT_CODE</b>
         * </p>
         * <p>
         * A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch.
         * Banks use these codes for money transfers such as international wire transfers.
         * </p>
         * <p>
         * SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while
         * eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>IT</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>IP_ADDRESS</b>
         * </p>
         * <p>
         * An IPv4 address, such as <i>198.51.100.0</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAC_ADDRESS</b>
         * </p>
         * <p>
         * A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface controller
         * (NIC).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>URL</b>
         * </p>
         * <p>
         * A web address, such as <i>www.example.com</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS_ACCESS_KEY</b>
         * </p>
         * <p>
         * A unique identifier that's associated with a secret access key; you use the access key ID and secret access
         * key to sign programmatic Amazon Web Services requests cryptographically.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS_SECRET_KEY</b>
         * </p>
         * <p>
         * A unique identifier that's associated with an access key. You use the access key ID and secret access key to
         * sign programmatic Amazon Web Services requests cryptographically.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>USA specific</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>US_BANK_ACCOUNT_NUMBER</b>
         * </p>
         * <p>
         * A US bank account number, which is typically 10 to 12 digits long.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>US_BANK_ROUTING_NUMBER</b>
         * </p>
         * <p>
         * A US bank account routing number. These are typically nine digits long,
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b>
         * </p>
         * <p>
         * A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and
         * contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and
         * forth digits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>US_PASSPORT_NUMBER</b>
         * </p>
         * <p>
         * A US passport number. Passport numbers range from six to nine alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>US_SOCIAL_SECURITY_NUMBER</b>
         * </p>
         * <p>
         * A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents,
         * and temporary working residents.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Canada specific</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CA_HEALTH_NUMBER</b>
         * </p>
         * <p>
         * A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access
         * healthcare benefits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CA_SOCIAL_INSURANCE_NUMBER</b>
         * </p>
         * <p>
         * A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to
         * access government programs and benefits.
         * </p>
         * <p>
         * The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be validated
         * through a simple check-digit process called the <a href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn
         * algorithm</a>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>UK Specific</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b>
         * </p>
         * <p>
         * A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current system
         * formats the 10-digit number with spaces after the third and sixth digits. The final digit is an
         * error-detecting checksum.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UK_NATIONAL_INSURANCE_NUMBER</b>
         * </p>
         * <p>
         * A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social
         * security) benefits. It is also used for some purposes in the UK tax system.
         * </p>
         * <p>
         * The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO
         * can be formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b>
         * </p>
         * <p>
         * A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Custom</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to recognize and
         * act upon such as serial number, booking ID etc..
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param type
         *        Configure guardrail type when the PII entity is detected.</p>
         *        <p>
         *        The following PIIs are used to block or mask sensitive information:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>General</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ADDRESS</b>
         *        </p>
         *        <p>
         *        A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address
         *        can include information such as the street, building, location, city, state, country, county, zip
         *        code, precinct, and neighborhood.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AGE</b>
         *        </p>
         *        <p>
         *        An individual's age, including the quantity and unit of time. For example, in the phrase
         *        "I am 40 years old," Guardrails recognizes "40 years" as an age.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NAME</b>
         *        </p>
         *        <p>
         *        An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss.
         *        guardrails doesn't apply this entity type to names that are part of organizations or addresses. For
         *        example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes
         *        "Jane Doe Street" as an address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EMAIL</b>
         *        </p>
         *        <p>
         *        An email address, such as <i>marymajor@email.com</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PHONE</b>
         *        </p>
         *        <p>
         *        A phone number. This entity type also includes fax and pager numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>USERNAME</b>
         *        </p>
         *        <p>
         *        A user name that identifies an account, such as a login name, screen name, nick name, or handle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PASSWORD</b>
         *        </p>
         *        <p>
         *        An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DRIVER_ID</b>
         *        </p>
         *        <p>
         *        The number assigned to a driver's license, which is an official document permitting an individual to
         *        operate one or more motorized vehicles on a public road. A driver's license number consists of
         *        alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>LICENSE_PLATE</b>
         *        </p>
         *        <p>
         *        A license plate for a vehicle is issued by the state or country where the vehicle is registered. The
         *        format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and
         *        numbers. The format varies depending on the location of the issuing state or country.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VEHICLE_IDENTIFICATION_NUMBER</b>
         *        </p>
         *        <p>
         *        A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are
         *        defined in the <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Finance</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CREDIT_DEBIT_CARD_CVV</b>
         *        </p>
         *        <p>
         *        A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit
         *        and debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREDIT_DEBIT_CARD_EXPIRY</b>
         *        </p>
         *        <p>
         *        The expiration date for a credit or debit card. This number is usually four digits long and is often
         *        formatted as <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as
         *        <i>01/21</i>, <i>01/2021</i>, and <i>Jan 2021</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREDIT_DEBIT_CARD_NUMBER</b>
         *        </p>
         *        <p>
         *        The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However,
         *        Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are
         *        present.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PIN</b>
         *        </p>
         *        <p>
         *        A four-digit personal identification number (PIN) with which you can access your bank account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b>
         *        </p>
         *        <p>
         *        An International Bank Account Number has specific formats in each country. For more information, see
         *        <a href="https://www.iban.com/structure">www.iban.com/structure</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SWIFT_CODE</b>
         *        </p>
         *        <p>
         *        A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or
         *        branch. Banks use these codes for money transfers such as international wire transfers.
         *        </p>
         *        <p>
         *        SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while
         *        eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IT</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>IP_ADDRESS</b>
         *        </p>
         *        <p>
         *        An IPv4 address, such as <i>198.51.100.0</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAC_ADDRESS</b>
         *        </p>
         *        <p>
         *        A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface
         *        controller (NIC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>URL</b>
         *        </p>
         *        <p>
         *        A web address, such as <i>www.example.com</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AWS_ACCESS_KEY</b>
         *        </p>
         *        <p>
         *        A unique identifier that's associated with a secret access key; you use the access key ID and secret
         *        access key to sign programmatic Amazon Web Services requests cryptographically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AWS_SECRET_KEY</b>
         *        </p>
         *        <p>
         *        A unique identifier that's associated with an access key. You use the access key ID and secret access
         *        key to sign programmatic Amazon Web Services requests cryptographically.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>USA specific</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>US_BANK_ACCOUNT_NUMBER</b>
         *        </p>
         *        <p>
         *        A US bank account number, which is typically 10 to 12 digits long.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>US_BANK_ROUTING_NUMBER</b>
         *        </p>
         *        <p>
         *        A US bank account routing number. These are typically nine digits long,
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b>
         *        </p>
         *        <p>
         *        A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9"
         *        and contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after
         *        the third and forth digits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>US_PASSPORT_NUMBER</b>
         *        </p>
         *        <p>
         *        A US passport number. Passport numbers range from six to nine alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>US_SOCIAL_SECURITY_NUMBER</b>
         *        </p>
         *        <p>
         *        A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent
         *        residents, and temporary working residents.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Canada specific</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CA_HEALTH_NUMBER</b>
         *        </p>
         *        <p>
         *        A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access
         *        healthcare benefits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CA_SOCIAL_INSURANCE_NUMBER</b>
         *        </p>
         *        <p>
         *        A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals
         *        to access government programs and benefits.
         *        </p>
         *        <p>
         *        The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be
         *        validated through a simple check-digit process called the <a
         *        href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn algorithm</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UK Specific</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b>
         *        </p>
         *        <p>
         *        A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current
         *        system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an
         *        error-detecting checksum.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UK_NATIONAL_INSURANCE_NUMBER</b>
         *        </p>
         *        <p>
         *        A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social
         *        security) benefits. It is also used for some purposes in the UK tax system.
         *        </p>
         *        <p>
         *        The number is nine digits long and starts with two letters, followed by six numbers and one letter. A
         *        NINO can be formatted with a space or a dash after the two letters and after the second, forth, and
         *        sixth digits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b>
         *        </p>
         *        <p>
         *        A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Custom</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to
         *        recognize and act upon such as serial number, booking ID etc..
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see GuardrailPiiEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailPiiEntityType
         */
        Builder type(String type);

        /**
         * <p>
         * Configure guardrail type when the PII entity is detected.
         * </p>
         * <p>
         * The following PIIs are used to block or mask sensitive information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>General</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ADDRESS</b>
         * </p>
         * <p>
         * A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can
         * include information such as the street, building, location, city, state, country, county, zip code, precinct,
         * and neighborhood.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AGE</b>
         * </p>
         * <p>
         * An individual's age, including the quantity and unit of time. For example, in the phrase "I am 40 years old,"
         * Guardrails recognizes "40 years" as an age.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NAME</b>
         * </p>
         * <p>
         * An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails
         * doesn't apply this entity type to names that are part of organizations or addresses. For example, guardrails
         * recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EMAIL</b>
         * </p>
         * <p>
         * An email address, such as <i>marymajor@email.com</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PHONE</b>
         * </p>
         * <p>
         * A phone number. This entity type also includes fax and pager numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>USERNAME</b>
         * </p>
         * <p>
         * A user name that identifies an account, such as a login name, screen name, nick name, or handle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PASSWORD</b>
         * </p>
         * <p>
         * An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>".
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DRIVER_ID</b>
         * </p>
         * <p>
         * The number assigned to a driver's license, which is an official document permitting an individual to operate
         * one or more motorized vehicles on a public road. A driver's license number consists of alphanumeric
         * characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>LICENSE_PLATE</b>
         * </p>
         * <p>
         * A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format
         * for passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The
         * format varies depending on the location of the issuing state or country.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VEHICLE_IDENTIFICATION_NUMBER</b>
         * </p>
         * <p>
         * A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in
         * the <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Finance</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CREDIT_DEBIT_CARD_CVV</b>
         * </p>
         * <p>
         * A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit
         * cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREDIT_DEBIT_CARD_EXPIRY</b>
         * </p>
         * <p>
         * The expiration date for a credit or debit card. This number is usually four digits long and is often
         * formatted as <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as <i>01/21</i>,
         * <i>01/2021</i>, and <i>Jan 2021</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREDIT_DEBIT_CARD_NUMBER</b>
         * </p>
         * <p>
         * The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon
         * Comprehend also recognizes credit or debit card numbers when only the last four digits are present.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PIN</b>
         * </p>
         * <p>
         * A four-digit personal identification number (PIN) with which you can access your bank account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b>
         * </p>
         * <p>
         * An International Bank Account Number has specific formats in each country. For more information, see <a
         * href="https://www.iban.com/structure">www.iban.com/structure</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SWIFT_CODE</b>
         * </p>
         * <p>
         * A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch.
         * Banks use these codes for money transfers such as international wire transfers.
         * </p>
         * <p>
         * SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while
         * eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>IT</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>IP_ADDRESS</b>
         * </p>
         * <p>
         * An IPv4 address, such as <i>198.51.100.0</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAC_ADDRESS</b>
         * </p>
         * <p>
         * A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface controller
         * (NIC).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>URL</b>
         * </p>
         * <p>
         * A web address, such as <i>www.example.com</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS_ACCESS_KEY</b>
         * </p>
         * <p>
         * A unique identifier that's associated with a secret access key; you use the access key ID and secret access
         * key to sign programmatic Amazon Web Services requests cryptographically.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS_SECRET_KEY</b>
         * </p>
         * <p>
         * A unique identifier that's associated with an access key. You use the access key ID and secret access key to
         * sign programmatic Amazon Web Services requests cryptographically.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>USA specific</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>US_BANK_ACCOUNT_NUMBER</b>
         * </p>
         * <p>
         * A US bank account number, which is typically 10 to 12 digits long.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>US_BANK_ROUTING_NUMBER</b>
         * </p>
         * <p>
         * A US bank account routing number. These are typically nine digits long,
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b>
         * </p>
         * <p>
         * A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and
         * contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and
         * forth digits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>US_PASSPORT_NUMBER</b>
         * </p>
         * <p>
         * A US passport number. Passport numbers range from six to nine alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>US_SOCIAL_SECURITY_NUMBER</b>
         * </p>
         * <p>
         * A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents,
         * and temporary working residents.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Canada specific</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CA_HEALTH_NUMBER</b>
         * </p>
         * <p>
         * A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access
         * healthcare benefits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CA_SOCIAL_INSURANCE_NUMBER</b>
         * </p>
         * <p>
         * A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to
         * access government programs and benefits.
         * </p>
         * <p>
         * The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be validated
         * through a simple check-digit process called the <a href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn
         * algorithm</a>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>UK Specific</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b>
         * </p>
         * <p>
         * A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current system
         * formats the 10-digit number with spaces after the third and sixth digits. The final digit is an
         * error-detecting checksum.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UK_NATIONAL_INSURANCE_NUMBER</b>
         * </p>
         * <p>
         * A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social
         * security) benefits. It is also used for some purposes in the UK tax system.
         * </p>
         * <p>
         * The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO
         * can be formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b>
         * </p>
         * <p>
         * A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Custom</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to recognize and
         * act upon such as serial number, booking ID etc..
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param type
         *        Configure guardrail type when the PII entity is detected.</p>
         *        <p>
         *        The following PIIs are used to block or mask sensitive information:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>General</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ADDRESS</b>
         *        </p>
         *        <p>
         *        A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address
         *        can include information such as the street, building, location, city, state, country, county, zip
         *        code, precinct, and neighborhood.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AGE</b>
         *        </p>
         *        <p>
         *        An individual's age, including the quantity and unit of time. For example, in the phrase
         *        "I am 40 years old," Guardrails recognizes "40 years" as an age.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NAME</b>
         *        </p>
         *        <p>
         *        An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss.
         *        guardrails doesn't apply this entity type to names that are part of organizations or addresses. For
         *        example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes
         *        "Jane Doe Street" as an address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EMAIL</b>
         *        </p>
         *        <p>
         *        An email address, such as <i>marymajor@email.com</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PHONE</b>
         *        </p>
         *        <p>
         *        A phone number. This entity type also includes fax and pager numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>USERNAME</b>
         *        </p>
         *        <p>
         *        A user name that identifies an account, such as a login name, screen name, nick name, or handle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PASSWORD</b>
         *        </p>
         *        <p>
         *        An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DRIVER_ID</b>
         *        </p>
         *        <p>
         *        The number assigned to a driver's license, which is an official document permitting an individual to
         *        operate one or more motorized vehicles on a public road. A driver's license number consists of
         *        alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>LICENSE_PLATE</b>
         *        </p>
         *        <p>
         *        A license plate for a vehicle is issued by the state or country where the vehicle is registered. The
         *        format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and
         *        numbers. The format varies depending on the location of the issuing state or country.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VEHICLE_IDENTIFICATION_NUMBER</b>
         *        </p>
         *        <p>
         *        A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are
         *        defined in the <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Finance</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CREDIT_DEBIT_CARD_CVV</b>
         *        </p>
         *        <p>
         *        A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit
         *        and debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREDIT_DEBIT_CARD_EXPIRY</b>
         *        </p>
         *        <p>
         *        The expiration date for a credit or debit card. This number is usually four digits long and is often
         *        formatted as <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as
         *        <i>01/21</i>, <i>01/2021</i>, and <i>Jan 2021</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREDIT_DEBIT_CARD_NUMBER</b>
         *        </p>
         *        <p>
         *        The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However,
         *        Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are
         *        present.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PIN</b>
         *        </p>
         *        <p>
         *        A four-digit personal identification number (PIN) with which you can access your bank account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b>
         *        </p>
         *        <p>
         *        An International Bank Account Number has specific formats in each country. For more information, see
         *        <a href="https://www.iban.com/structure">www.iban.com/structure</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SWIFT_CODE</b>
         *        </p>
         *        <p>
         *        A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or
         *        branch. Banks use these codes for money transfers such as international wire transfers.
         *        </p>
         *        <p>
         *        SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while
         *        eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IT</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>IP_ADDRESS</b>
         *        </p>
         *        <p>
         *        An IPv4 address, such as <i>198.51.100.0</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAC_ADDRESS</b>
         *        </p>
         *        <p>
         *        A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface
         *        controller (NIC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>URL</b>
         *        </p>
         *        <p>
         *        A web address, such as <i>www.example.com</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AWS_ACCESS_KEY</b>
         *        </p>
         *        <p>
         *        A unique identifier that's associated with a secret access key; you use the access key ID and secret
         *        access key to sign programmatic Amazon Web Services requests cryptographically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AWS_SECRET_KEY</b>
         *        </p>
         *        <p>
         *        A unique identifier that's associated with an access key. You use the access key ID and secret access
         *        key to sign programmatic Amazon Web Services requests cryptographically.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>USA specific</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>US_BANK_ACCOUNT_NUMBER</b>
         *        </p>
         *        <p>
         *        A US bank account number, which is typically 10 to 12 digits long.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>US_BANK_ROUTING_NUMBER</b>
         *        </p>
         *        <p>
         *        A US bank account routing number. These are typically nine digits long,
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b>
         *        </p>
         *        <p>
         *        A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9"
         *        and contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after
         *        the third and forth digits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>US_PASSPORT_NUMBER</b>
         *        </p>
         *        <p>
         *        A US passport number. Passport numbers range from six to nine alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>US_SOCIAL_SECURITY_NUMBER</b>
         *        </p>
         *        <p>
         *        A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent
         *        residents, and temporary working residents.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Canada specific</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CA_HEALTH_NUMBER</b>
         *        </p>
         *        <p>
         *        A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access
         *        healthcare benefits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CA_SOCIAL_INSURANCE_NUMBER</b>
         *        </p>
         *        <p>
         *        A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals
         *        to access government programs and benefits.
         *        </p>
         *        <p>
         *        The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be
         *        validated through a simple check-digit process called the <a
         *        href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn algorithm</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UK Specific</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b>
         *        </p>
         *        <p>
         *        A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current
         *        system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an
         *        error-detecting checksum.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UK_NATIONAL_INSURANCE_NUMBER</b>
         *        </p>
         *        <p>
         *        A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social
         *        security) benefits. It is also used for some purposes in the UK tax system.
         *        </p>
         *        <p>
         *        The number is nine digits long and starts with two letters, followed by six numbers and one letter. A
         *        NINO can be formatted with a space or a dash after the two letters and after the second, forth, and
         *        sixth digits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b>
         *        </p>
         *        <p>
         *        A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Custom</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to
         *        recognize and act upon such as serial number, booking ID etc..
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see GuardrailPiiEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailPiiEntityType
         */
        Builder type(GuardrailPiiEntityType type);

        /**
         * <p>
         * Configure guardrail action when the PII entity is detected.
         * </p>
         * 
         * @param action
         *        Configure guardrail action when the PII entity is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(String action);

        /**
         * <p>
         * Configure guardrail action when the PII entity is detected.
         * </p>
         * 
         * @param action
         *        Configure guardrail action when the PII entity is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(GuardrailSensitiveInformationAction action);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailPiiEntityConfig model) {
            type(model.type);
            action(model.action);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailPiiEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailSensitiveInformationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public GuardrailPiiEntityConfig build() {
            return new GuardrailPiiEntityConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
