/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceProfilesRequest extends BedrockRequest implements
        ToCopyableBuilder<ListInferenceProfilesRequest.Builder, ListInferenceProfilesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListInferenceProfilesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInferenceProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> TYPE_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeEquals").getter(getter(ListInferenceProfilesRequest::typeEqualsAsString))
            .setter(setter(Builder::typeEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, TYPE_EQUALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String typeEquals;

    private ListInferenceProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.typeEquals = builder.typeEquals;
    }

    /**
     * <p>
     * The maximum number of results to return in the response. If the total number of results is greater than this
     * value, use the token returned in the response in the <code>nextToken</code> field when making another request to
     * return the next batch of results.
     * </p>
     * 
     * @return The maximum number of results to return in the response. If the total number of results is greater than
     *         this value, use the token returned in the response in the <code>nextToken</code> field when making
     *         another request to return the next batch of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter
     * the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of
     * results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         enter the token returned in the <code>nextToken</code> field in the response in this field to return the
     *         next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filters for inference profiles that match the type you specify.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
     * requests across regions with these inference profiles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile can track
     * metrics and costs when invoking the model in it. The inference profile may route requests to one or multiple
     * regions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeEquals} will
     * return {@link InferenceProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeEqualsAsString}.
     * </p>
     * 
     * @return Filters for inference profiles that match the type you specify.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
     *         requests across regions with these inference profiles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile
     *         can track metrics and costs when invoking the model in it. The inference profile may route requests to
     *         one or multiple regions.
     *         </p>
     *         </li>
     * @see InferenceProfileType
     */
    public final InferenceProfileType typeEquals() {
        return InferenceProfileType.fromValue(typeEquals);
    }

    /**
     * <p>
     * Filters for inference profiles that match the type you specify.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
     * requests across regions with these inference profiles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile can track
     * metrics and costs when invoking the model in it. The inference profile may route requests to one or multiple
     * regions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeEquals} will
     * return {@link InferenceProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeEqualsAsString}.
     * </p>
     * 
     * @return Filters for inference profiles that match the type you specify.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
     *         requests across regions with these inference profiles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile
     *         can track metrics and costs when invoking the model in it. The inference profile may route requests to
     *         one or multiple regions.
     *         </p>
     *         </li>
     * @see InferenceProfileType
     */
    public final String typeEqualsAsString() {
        return typeEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(typeEqualsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceProfilesRequest)) {
            return false;
        }
        ListInferenceProfilesRequest other = (ListInferenceProfilesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(typeEqualsAsString(), other.typeEqualsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceProfilesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("TypeEquals", typeEqualsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "typeEquals":
            return Optional.ofNullable(clazz.cast(typeEqualsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("type", TYPE_EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceProfilesRequest, T> g) {
        return obj -> g.apply((ListInferenceProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInferenceProfilesRequest> {
        /**
         * <p>
         * The maximum number of results to return in the response. If the total number of results is greater than this
         * value, use the token returned in the response in the <code>nextToken</code> field when making another request
         * to return the next batch of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response. If the total number of results is greater
         *        than this value, use the token returned in the response in the <code>nextToken</code> field when
         *        making another request to return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request,
         * enter the token returned in the <code>nextToken</code> field in the response in this field to return the next
         * batch of results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, enter the token returned in the <code>nextToken</code> field in the response in this field to
         *        return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filters for inference profiles that match the type you specify.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
         * requests across regions with these inference profiles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile can
         * track metrics and costs when invoking the model in it. The inference profile may route requests to one or
         * multiple regions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param typeEquals
         *        Filters for inference profiles that match the type you specify.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route
         *        inference requests across regions with these inference profiles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile
         *        can track metrics and costs when invoking the model in it. The inference profile may route requests to
         *        one or multiple regions.
         *        </p>
         *        </li>
         * @see InferenceProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceProfileType
         */
        Builder typeEquals(String typeEquals);

        /**
         * <p>
         * Filters for inference profiles that match the type you specify.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
         * requests across regions with these inference profiles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile can
         * track metrics and costs when invoking the model in it. The inference profile may route requests to one or
         * multiple regions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param typeEquals
         *        Filters for inference profiles that match the type you specify.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route
         *        inference requests across regions with these inference profiles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile
         *        can track metrics and costs when invoking the model in it. The inference profile may route requests to
         *        one or multiple regions.
         *        </p>
         *        </li>
         * @see InferenceProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceProfileType
         */
        Builder typeEquals(InferenceProfileType typeEquals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String typeEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceProfilesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            typeEquals(model.typeEquals);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTypeEquals() {
            return typeEquals;
        }

        public final void setTypeEquals(String typeEquals) {
            this.typeEquals = typeEquals;
        }

        @Override
        public final Builder typeEquals(String typeEquals) {
            this.typeEquals = typeEquals;
            return this;
        }

        @Override
        public final Builder typeEquals(InferenceProfileType typeEquals) {
            this.typeEquals(typeEquals == null ? null : typeEquals.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceProfilesRequest build() {
            return new ListInferenceProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
