/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisionedModelThroughputsResponse extends BedrockResponse implements
        ToCopyableBuilder<ListProvisionedModelThroughputsResponse.Builder, ListProvisionedModelThroughputsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProvisionedModelThroughputsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ProvisionedModelSummary>> PROVISIONED_MODEL_SUMMARIES_FIELD = SdkField
            .<List<ProvisionedModelSummary>> builder(MarshallingType.LIST)
            .memberName("provisionedModelSummaries")
            .getter(getter(ListProvisionedModelThroughputsResponse::provisionedModelSummaries))
            .setter(setter(Builder::provisionedModelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisionedModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisionedModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROVISIONED_MODEL_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ProvisionedModelSummary> provisionedModelSummaries;

    private ListProvisionedModelThroughputsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.provisionedModelSummaries = builder.provisionedModelSummaries;
    }

    /**
     * <p>
     * If there are more results than the number you specified in the <code>maxResults</code> field, this value is
     * returned. To see the next batch of results, include this value in the <code>nextToken</code> field in another
     * list request.
     * </p>
     * 
     * @return If there are more results than the number you specified in the <code>maxResults</code> field, this value
     *         is returned. To see the next batch of results, include this value in the <code>nextToken</code> field in
     *         another list request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisionedModelSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisionedModelSummaries() {
        return provisionedModelSummaries != null && !(provisionedModelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of summaries, one for each Provisioned Throughput in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedModelSummaries} method.
     * </p>
     * 
     * @return A list of summaries, one for each Provisioned Throughput in the response.
     */
    public final List<ProvisionedModelSummary> provisionedModelSummaries() {
        return provisionedModelSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisionedModelSummaries() ? provisionedModelSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedModelThroughputsResponse)) {
            return false;
        }
        ListProvisionedModelThroughputsResponse other = (ListProvisionedModelThroughputsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasProvisionedModelSummaries() == other.hasProvisionedModelSummaries()
                && Objects.equals(provisionedModelSummaries(), other.provisionedModelSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProvisionedModelThroughputsResponse").add("NextToken", nextToken())
                .add("ProvisionedModelSummaries", hasProvisionedModelSummaries() ? provisionedModelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "provisionedModelSummaries":
            return Optional.ofNullable(clazz.cast(provisionedModelSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("provisionedModelSummaries", PROVISIONED_MODEL_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedModelThroughputsResponse, T> g) {
        return obj -> g.apply((ListProvisionedModelThroughputsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProvisionedModelThroughputsResponse> {
        /**
         * <p>
         * If there are more results than the number you specified in the <code>maxResults</code> field, this value is
         * returned. To see the next batch of results, include this value in the <code>nextToken</code> field in another
         * list request.
         * </p>
         * 
         * @param nextToken
         *        If there are more results than the number you specified in the <code>maxResults</code> field, this
         *        value is returned. To see the next batch of results, include this value in the <code>nextToken</code>
         *        field in another list request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of summaries, one for each Provisioned Throughput in the response.
         * </p>
         * 
         * @param provisionedModelSummaries
         *        A list of summaries, one for each Provisioned Throughput in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedModelSummaries(Collection<ProvisionedModelSummary> provisionedModelSummaries);

        /**
         * <p>
         * A list of summaries, one for each Provisioned Throughput in the response.
         * </p>
         * 
         * @param provisionedModelSummaries
         *        A list of summaries, one for each Provisioned Throughput in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedModelSummaries(ProvisionedModelSummary... provisionedModelSummaries);

        /**
         * <p>
         * A list of summaries, one for each Provisioned Throughput in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.ProvisionedModelSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.ProvisionedModelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.ProvisionedModelSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedModelSummaries(List<ProvisionedModelSummary>)}.
         * 
         * @param provisionedModelSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.ProvisionedModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedModelSummaries(java.util.Collection<ProvisionedModelSummary>)
         */
        Builder provisionedModelSummaries(Consumer<ProvisionedModelSummary.Builder>... provisionedModelSummaries);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ProvisionedModelSummary> provisionedModelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedModelThroughputsResponse model) {
            super(model);
            nextToken(model.nextToken);
            provisionedModelSummaries(model.provisionedModelSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProvisionedModelSummary.Builder> getProvisionedModelSummaries() {
            List<ProvisionedModelSummary.Builder> result = ProvisionedModelSummariesCopier
                    .copyToBuilder(this.provisionedModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedModelSummaries(Collection<ProvisionedModelSummary.BuilderImpl> provisionedModelSummaries) {
            this.provisionedModelSummaries = ProvisionedModelSummariesCopier.copyFromBuilder(provisionedModelSummaries);
        }

        @Override
        public final Builder provisionedModelSummaries(Collection<ProvisionedModelSummary> provisionedModelSummaries) {
            this.provisionedModelSummaries = ProvisionedModelSummariesCopier.copy(provisionedModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedModelSummaries(ProvisionedModelSummary... provisionedModelSummaries) {
            provisionedModelSummaries(Arrays.asList(provisionedModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedModelSummaries(Consumer<ProvisionedModelSummary.Builder>... provisionedModelSummaries) {
            provisionedModelSummaries(Stream.of(provisionedModelSummaries)
                    .map(c -> ProvisionedModelSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProvisionedModelThroughputsResponse build() {
            return new ListProvisionedModelThroughputsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
