/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMarketplaceModelEndpointRequest extends BedrockRequest implements
        ToCopyableBuilder<UpdateMarketplaceModelEndpointRequest.Builder, UpdateMarketplaceModelEndpointRequest> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointArn").getter(getter(UpdateMarketplaceModelEndpointRequest::endpointArn))
            .setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointArn").build()).build();

    private static final SdkField<EndpointConfig> ENDPOINT_CONFIG_FIELD = SdkField
            .<EndpointConfig> builder(MarshallingType.SDK_POJO).memberName("endpointConfig")
            .getter(getter(UpdateMarketplaceModelEndpointRequest::endpointConfig)).setter(setter(Builder::endpointConfig))
            .constructor(EndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfig").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateMarketplaceModelEndpointRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD,
            ENDPOINT_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointArn;

    private final EndpointConfig endpointConfig;

    private final String clientRequestToken;

    private UpdateMarketplaceModelEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.endpointConfig = builder.endpointConfig;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint you want to update.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The new configuration for the endpoint, including the number and type of instances to use.
     * </p>
     * 
     * @return The new configuration for the endpoint, including the number and type of instances to use.
     */
    public final EndpointConfig endpointConfig() {
        return endpointConfig;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token is
     * listed as not required because Amazon Web Services SDKs automatically generate it for you and set this parameter.
     * If you're not using the Amazon Web Services SDK or the CLI, you must provide this token or the action will fail.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
     *         is listed as not required because Amazon Web Services SDKs automatically generate it for you and set this
     *         parameter. If you're not using the Amazon Web Services SDK or the CLI, you must provide this token or the
     *         action will fail.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMarketplaceModelEndpointRequest)) {
            return false;
        }
        UpdateMarketplaceModelEndpointRequest other = (UpdateMarketplaceModelEndpointRequest) obj;
        return Objects.equals(endpointArn(), other.endpointArn()) && Objects.equals(endpointConfig(), other.endpointConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMarketplaceModelEndpointRequest").add("EndpointArn", endpointArn())
                .add("EndpointConfig", endpointConfig()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "endpointConfig":
            return Optional.ofNullable(clazz.cast(endpointConfig()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endpointArn", ENDPOINT_ARN_FIELD);
        map.put("endpointConfig", ENDPOINT_CONFIG_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMarketplaceModelEndpointRequest, T> g) {
        return obj -> g.apply((UpdateMarketplaceModelEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMarketplaceModelEndpointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint you want to update.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) of the endpoint you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The new configuration for the endpoint, including the number and type of instances to use.
         * </p>
         * 
         * @param endpointConfig
         *        The new configuration for the endpoint, including the number and type of instances to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfig(EndpointConfig endpointConfig);

        /**
         * <p>
         * The new configuration for the endpoint, including the number and type of instances to use.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointConfig.Builder} avoiding the need
         * to create one manually via {@link EndpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointConfig(EndpointConfig)}.
         * 
         * @param endpointConfig
         *        a consumer that will call methods on {@link EndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfig(EndpointConfig)
         */
        default Builder endpointConfig(Consumer<EndpointConfig.Builder> endpointConfig) {
            return endpointConfig(EndpointConfig.builder().applyMutation(endpointConfig).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token is
         * listed as not required because Amazon Web Services SDKs automatically generate it for you and set this
         * parameter. If you're not using the Amazon Web Services SDK or the CLI, you must provide this token or the
         * action will fail.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         *        token is listed as not required because Amazon Web Services SDKs automatically generate it for you and
         *        set this parameter. If you're not using the Amazon Web Services SDK or the CLI, you must provide this
         *        token or the action will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String endpointArn;

        private EndpointConfig endpointConfig;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMarketplaceModelEndpointRequest model) {
            super(model);
            endpointArn(model.endpointArn);
            endpointConfig(model.endpointConfig);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final EndpointConfig.Builder getEndpointConfig() {
            return endpointConfig != null ? endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(EndpointConfig.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(EndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMarketplaceModelEndpointRequest build() {
            return new UpdateMarketplaceModelEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
