/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.ApplicationType;
import software.amazon.awssdk.services.bedrock.model.EvaluationBedrockKnowledgeBaseIdentifiersCopier;
import software.amazon.awssdk.services.bedrock.model.EvaluationBedrockModelIdentifiersCopier;
import software.amazon.awssdk.services.bedrock.model.EvaluationInferenceConfigSummary;
import software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus;
import software.amazon.awssdk.services.bedrock.model.EvaluationJobType;
import software.amazon.awssdk.services.bedrock.model.EvaluationTaskType;
import software.amazon.awssdk.services.bedrock.model.EvaluationTaskTypesCopier;
import software.amazon.awssdk.services.bedrock.model.EvaluatorModelIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(EvaluationSummary.getter(EvaluationSummary::jobArn)).setter(EvaluationSummary.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(EvaluationSummary.getter(EvaluationSummary::jobName)).setter(EvaluationSummary.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EvaluationSummary.getter(EvaluationSummary::statusAsString)).setter(EvaluationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(EvaluationSummary.getter(EvaluationSummary::creationTime)).setter(EvaluationSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobType").getter(EvaluationSummary.getter(EvaluationSummary::jobTypeAsString)).setter(EvaluationSummary.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final SdkField<List<String>> EVALUATION_TASK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluationTaskTypes").getter(EvaluationSummary.getter(EvaluationSummary::evaluationTaskTypesAsStrings)).setter(EvaluationSummary.setter(Builder::evaluationTaskTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationTaskTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MODEL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelIdentifiers").getter(EvaluationSummary.getter(EvaluationSummary::modelIdentifiers)).setter(EvaluationSummary.setter(Builder::modelIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RAG_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ragIdentifiers").getter(EvaluationSummary.getter(EvaluationSummary::ragIdentifiers)).setter(EvaluationSummary.setter(Builder::ragIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ragIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVALUATOR_MODEL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluatorModelIdentifiers").getter(EvaluationSummary.getter(EvaluationSummary::evaluatorModelIdentifiers)).setter(EvaluationSummary.setter(Builder::evaluatorModelIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorModelIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CUSTOM_METRICS_EVALUATOR_MODEL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customMetricsEvaluatorModelIdentifiers").getter(EvaluationSummary.getter(EvaluationSummary::customMetricsEvaluatorModelIdentifiers)).setter(EvaluationSummary.setter(Builder::customMetricsEvaluatorModelIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMetricsEvaluatorModelIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EvaluationInferenceConfigSummary> INFERENCE_CONFIG_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfigSummary").getter(EvaluationSummary.getter(EvaluationSummary::inferenceConfigSummary)).setter(EvaluationSummary.setter(Builder::inferenceConfigSummary)).constructor(EvaluationInferenceConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfigSummary").build()}).build();
    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationType").getter(EvaluationSummary.getter(EvaluationSummary::applicationTypeAsString)).setter(EvaluationSummary.setter(Builder::applicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, JOB_TYPE_FIELD, EVALUATION_TASK_TYPES_FIELD, MODEL_IDENTIFIERS_FIELD, RAG_IDENTIFIERS_FIELD, EVALUATOR_MODEL_IDENTIFIERS_FIELD, CUSTOM_METRICS_EVALUATOR_MODEL_IDENTIFIERS_FIELD, INFERENCE_CONFIG_SUMMARY_FIELD, APPLICATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobArn;
    private final String jobName;
    private final String status;
    private final Instant creationTime;
    private final String jobType;
    private final List<String> evaluationTaskTypes;
    private final List<String> modelIdentifiers;
    private final List<String> ragIdentifiers;
    private final List<String> evaluatorModelIdentifiers;
    private final List<String> customMetricsEvaluatorModelIdentifiers;
    private final EvaluationInferenceConfigSummary inferenceConfigSummary;
    private final String applicationType;

    private EvaluationSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.jobType = builder.jobType;
        this.evaluationTaskTypes = builder.evaluationTaskTypes;
        this.modelIdentifiers = builder.modelIdentifiers;
        this.ragIdentifiers = builder.ragIdentifiers;
        this.evaluatorModelIdentifiers = builder.evaluatorModelIdentifiers;
        this.customMetricsEvaluatorModelIdentifiers = builder.customMetricsEvaluatorModelIdentifiers;
        this.inferenceConfigSummary = builder.inferenceConfigSummary;
        this.applicationType = builder.applicationType;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final EvaluationJobStatus status() {
        return EvaluationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final EvaluationJobType jobType() {
        return EvaluationJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final List<EvaluationTaskType> evaluationTaskTypes() {
        return EvaluationTaskTypesCopier.copyStringToEnum(this.evaluationTaskTypes);
    }

    public final boolean hasEvaluationTaskTypes() {
        return this.evaluationTaskTypes != null && !(this.evaluationTaskTypes instanceof SdkAutoConstructList);
    }

    public final List<String> evaluationTaskTypesAsStrings() {
        return this.evaluationTaskTypes;
    }

    @Deprecated
    public final boolean hasModelIdentifiers() {
        return this.modelIdentifiers != null && !(this.modelIdentifiers instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<String> modelIdentifiers() {
        return this.modelIdentifiers;
    }

    @Deprecated
    public final boolean hasRagIdentifiers() {
        return this.ragIdentifiers != null && !(this.ragIdentifiers instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<String> ragIdentifiers() {
        return this.ragIdentifiers;
    }

    public final boolean hasEvaluatorModelIdentifiers() {
        return this.evaluatorModelIdentifiers != null && !(this.evaluatorModelIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> evaluatorModelIdentifiers() {
        return this.evaluatorModelIdentifiers;
    }

    public final boolean hasCustomMetricsEvaluatorModelIdentifiers() {
        return this.customMetricsEvaluatorModelIdentifiers != null && !(this.customMetricsEvaluatorModelIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> customMetricsEvaluatorModelIdentifiers() {
        return this.customMetricsEvaluatorModelIdentifiers;
    }

    public final EvaluationInferenceConfigSummary inferenceConfigSummary() {
        return this.inferenceConfigSummary;
    }

    public final ApplicationType applicationType() {
        return ApplicationType.fromValue(this.applicationType);
    }

    public final String applicationTypeAsString() {
        return this.applicationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationTaskTypes() ? this.evaluationTaskTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelIdentifiers() ? this.modelIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRagIdentifiers() ? this.ragIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluatorModelIdentifiers() ? this.evaluatorModelIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomMetricsEvaluatorModelIdentifiers() ? this.customMetricsEvaluatorModelIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfigSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSummary)) {
            return false;
        }
        EvaluationSummary other = (EvaluationSummary)obj;
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && this.hasEvaluationTaskTypes() == other.hasEvaluationTaskTypes() && Objects.equals(this.evaluationTaskTypesAsStrings(), other.evaluationTaskTypesAsStrings()) && this.hasModelIdentifiers() == other.hasModelIdentifiers() && Objects.equals(this.modelIdentifiers(), other.modelIdentifiers()) && this.hasRagIdentifiers() == other.hasRagIdentifiers() && Objects.equals(this.ragIdentifiers(), other.ragIdentifiers()) && this.hasEvaluatorModelIdentifiers() == other.hasEvaluatorModelIdentifiers() && Objects.equals(this.evaluatorModelIdentifiers(), other.evaluatorModelIdentifiers()) && this.hasCustomMetricsEvaluatorModelIdentifiers() == other.hasCustomMetricsEvaluatorModelIdentifiers() && Objects.equals(this.customMetricsEvaluatorModelIdentifiers(), other.customMetricsEvaluatorModelIdentifiers()) && Objects.equals(this.inferenceConfigSummary(), other.inferenceConfigSummary()) && Objects.equals(this.applicationTypeAsString(), other.applicationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationSummary").add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("JobType", (Object)this.jobTypeAsString()).add("EvaluationTaskTypes", this.hasEvaluationTaskTypes() ? this.evaluationTaskTypesAsStrings() : null).add("ModelIdentifiers", this.hasModelIdentifiers() ? this.modelIdentifiers() : null).add("RagIdentifiers", this.hasRagIdentifiers() ? this.ragIdentifiers() : null).add("EvaluatorModelIdentifiers", this.hasEvaluatorModelIdentifiers() ? this.evaluatorModelIdentifiers() : null).add("CustomMetricsEvaluatorModelIdentifiers", this.hasCustomMetricsEvaluatorModelIdentifiers() ? this.customMetricsEvaluatorModelIdentifiers() : null).add("InferenceConfigSummary", (Object)this.inferenceConfigSummary()).add("ApplicationType", (Object)this.applicationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "evaluationTaskTypes": {
                return Optional.ofNullable(clazz.cast(this.evaluationTaskTypesAsStrings()));
            }
            case "modelIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.modelIdentifiers()));
            }
            case "ragIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.ragIdentifiers()));
            }
            case "evaluatorModelIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.evaluatorModelIdentifiers()));
            }
            case "customMetricsEvaluatorModelIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.customMetricsEvaluatorModelIdentifiers()));
            }
            case "inferenceConfigSummary": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfigSummary()));
            }
            case "applicationType": {
                return Optional.ofNullable(clazz.cast(this.applicationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("jobType", JOB_TYPE_FIELD);
        map.put("evaluationTaskTypes", EVALUATION_TASK_TYPES_FIELD);
        map.put("modelIdentifiers", MODEL_IDENTIFIERS_FIELD);
        map.put("ragIdentifiers", RAG_IDENTIFIERS_FIELD);
        map.put("evaluatorModelIdentifiers", EVALUATOR_MODEL_IDENTIFIERS_FIELD);
        map.put("customMetricsEvaluatorModelIdentifiers", CUSTOM_METRICS_EVALUATOR_MODEL_IDENTIFIERS_FIELD);
        map.put("inferenceConfigSummary", INFERENCE_CONFIG_SUMMARY_FIELD);
        map.put("applicationType", APPLICATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSummary, T> g) {
        return obj -> g.apply((EvaluationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobName;
        private String status;
        private Instant creationTime;
        private String jobType;
        private List<String> evaluationTaskTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> modelIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> ragIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> evaluatorModelIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> customMetricsEvaluatorModelIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private EvaluationInferenceConfigSummary inferenceConfigSummary;
        private String applicationType;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSummary model) {
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.jobType(model.jobType);
            this.evaluationTaskTypesWithStrings(model.evaluationTaskTypes);
            this.modelIdentifiers(model.modelIdentifiers);
            this.ragIdentifiers(model.ragIdentifiers);
            this.evaluatorModelIdentifiers(model.evaluatorModelIdentifiers);
            this.customMetricsEvaluatorModelIdentifiers(model.customMetricsEvaluatorModelIdentifiers);
            this.inferenceConfigSummary(model.inferenceConfigSummary);
            this.applicationType(model.applicationType);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(EvaluationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final Collection<String> getEvaluationTaskTypes() {
            if (this.evaluationTaskTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.evaluationTaskTypes;
        }

        public final void setEvaluationTaskTypes(Collection<String> evaluationTaskTypes) {
            this.evaluationTaskTypes = EvaluationTaskTypesCopier.copy(evaluationTaskTypes);
        }

        @Override
        public final Builder evaluationTaskTypesWithStrings(Collection<String> evaluationTaskTypes) {
            this.evaluationTaskTypes = EvaluationTaskTypesCopier.copy(evaluationTaskTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationTaskTypesWithStrings(String ... evaluationTaskTypes) {
            this.evaluationTaskTypesWithStrings(Arrays.asList(evaluationTaskTypes));
            return this;
        }

        @Override
        public final Builder evaluationTaskTypes(Collection<EvaluationTaskType> evaluationTaskTypes) {
            this.evaluationTaskTypes = EvaluationTaskTypesCopier.copyEnumToString(evaluationTaskTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationTaskTypes(EvaluationTaskType ... evaluationTaskTypes) {
            this.evaluationTaskTypes(Arrays.asList(evaluationTaskTypes));
            return this;
        }

        @Deprecated
        public final Collection<String> getModelIdentifiers() {
            if (this.modelIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.modelIdentifiers;
        }

        @Deprecated
        public final void setModelIdentifiers(Collection<String> modelIdentifiers) {
            this.modelIdentifiers = EvaluationBedrockModelIdentifiersCopier.copy(modelIdentifiers);
        }

        @Override
        @Deprecated
        public final Builder modelIdentifiers(Collection<String> modelIdentifiers) {
            this.modelIdentifiers = EvaluationBedrockModelIdentifiersCopier.copy(modelIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder modelIdentifiers(String ... modelIdentifiers) {
            this.modelIdentifiers(Arrays.asList(modelIdentifiers));
            return this;
        }

        @Deprecated
        public final Collection<String> getRagIdentifiers() {
            if (this.ragIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ragIdentifiers;
        }

        @Deprecated
        public final void setRagIdentifiers(Collection<String> ragIdentifiers) {
            this.ragIdentifiers = EvaluationBedrockKnowledgeBaseIdentifiersCopier.copy(ragIdentifiers);
        }

        @Override
        @Deprecated
        public final Builder ragIdentifiers(Collection<String> ragIdentifiers) {
            this.ragIdentifiers = EvaluationBedrockKnowledgeBaseIdentifiersCopier.copy(ragIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder ragIdentifiers(String ... ragIdentifiers) {
            this.ragIdentifiers(Arrays.asList(ragIdentifiers));
            return this;
        }

        public final Collection<String> getEvaluatorModelIdentifiers() {
            if (this.evaluatorModelIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.evaluatorModelIdentifiers;
        }

        public final void setEvaluatorModelIdentifiers(Collection<String> evaluatorModelIdentifiers) {
            this.evaluatorModelIdentifiers = EvaluatorModelIdentifiersCopier.copy(evaluatorModelIdentifiers);
        }

        @Override
        public final Builder evaluatorModelIdentifiers(Collection<String> evaluatorModelIdentifiers) {
            this.evaluatorModelIdentifiers = EvaluatorModelIdentifiersCopier.copy(evaluatorModelIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluatorModelIdentifiers(String ... evaluatorModelIdentifiers) {
            this.evaluatorModelIdentifiers(Arrays.asList(evaluatorModelIdentifiers));
            return this;
        }

        public final Collection<String> getCustomMetricsEvaluatorModelIdentifiers() {
            if (this.customMetricsEvaluatorModelIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customMetricsEvaluatorModelIdentifiers;
        }

        public final void setCustomMetricsEvaluatorModelIdentifiers(Collection<String> customMetricsEvaluatorModelIdentifiers) {
            this.customMetricsEvaluatorModelIdentifiers = EvaluatorModelIdentifiersCopier.copy(customMetricsEvaluatorModelIdentifiers);
        }

        @Override
        public final Builder customMetricsEvaluatorModelIdentifiers(Collection<String> customMetricsEvaluatorModelIdentifiers) {
            this.customMetricsEvaluatorModelIdentifiers = EvaluatorModelIdentifiersCopier.copy(customMetricsEvaluatorModelIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetricsEvaluatorModelIdentifiers(String ... customMetricsEvaluatorModelIdentifiers) {
            this.customMetricsEvaluatorModelIdentifiers(Arrays.asList(customMetricsEvaluatorModelIdentifiers));
            return this;
        }

        public final EvaluationInferenceConfigSummary.Builder getInferenceConfigSummary() {
            return this.inferenceConfigSummary != null ? this.inferenceConfigSummary.toBuilder() : null;
        }

        public final void setInferenceConfigSummary(EvaluationInferenceConfigSummary.BuilderImpl inferenceConfigSummary) {
            this.inferenceConfigSummary = inferenceConfigSummary != null ? inferenceConfigSummary.build() : null;
        }

        @Override
        public final Builder inferenceConfigSummary(EvaluationInferenceConfigSummary inferenceConfigSummary) {
            this.inferenceConfigSummary = inferenceConfigSummary;
            return this;
        }

        public final String getApplicationType() {
            return this.applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        @Override
        public final Builder applicationType(ApplicationType applicationType) {
            this.applicationType(applicationType == null ? null : applicationType.toString());
            return this;
        }

        public EvaluationSummary build() {
            return new EvaluationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationSummary> {
        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder status(String var1);

        public Builder status(EvaluationJobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder jobType(String var1);

        public Builder jobType(EvaluationJobType var1);

        public Builder evaluationTaskTypesWithStrings(Collection<String> var1);

        public Builder evaluationTaskTypesWithStrings(String ... var1);

        public Builder evaluationTaskTypes(Collection<EvaluationTaskType> var1);

        public Builder evaluationTaskTypes(EvaluationTaskType ... var1);

        @Deprecated
        public Builder modelIdentifiers(Collection<String> var1);

        @Deprecated
        public Builder modelIdentifiers(String ... var1);

        @Deprecated
        public Builder ragIdentifiers(Collection<String> var1);

        @Deprecated
        public Builder ragIdentifiers(String ... var1);

        public Builder evaluatorModelIdentifiers(Collection<String> var1);

        public Builder evaluatorModelIdentifiers(String ... var1);

        public Builder customMetricsEvaluatorModelIdentifiers(Collection<String> var1);

        public Builder customMetricsEvaluatorModelIdentifiers(String ... var1);

        public Builder inferenceConfigSummary(EvaluationInferenceConfigSummary var1);

        default public Builder inferenceConfigSummary(Consumer<EvaluationInferenceConfigSummary.Builder> inferenceConfigSummary) {
            return this.inferenceConfigSummary((EvaluationInferenceConfigSummary)((EvaluationInferenceConfigSummary.Builder)EvaluationInferenceConfigSummary.builder().applyMutation(inferenceConfigSummary)).build());
        }

        public Builder applicationType(String var1);

        public Builder applicationType(ApplicationType var1);
    }
}

