/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelImportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelImportJobSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(ModelImportJobSummary.getter(ModelImportJobSummary::jobArn)).setter(ModelImportJobSummary.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(ModelImportJobSummary.getter(ModelImportJobSummary::jobName)).setter(ModelImportJobSummary.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ModelImportJobSummary.getter(ModelImportJobSummary::statusAsString)).setter(ModelImportJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(ModelImportJobSummary.getter(ModelImportJobSummary::lastModifiedTime)).setter(ModelImportJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ModelImportJobSummary.getter(ModelImportJobSummary::creationTime)).setter(ModelImportJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ModelImportJobSummary.getter(ModelImportJobSummary::endTime)).setter(ModelImportJobSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> IMPORTED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedModelArn").getter(ModelImportJobSummary.getter(ModelImportJobSummary::importedModelArn)).setter(ModelImportJobSummary.setter(Builder::importedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelArn").build()}).build();
    private static final SdkField<String> IMPORTED_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedModelName").getter(ModelImportJobSummary.getter(ModelImportJobSummary::importedModelName)).setter(ModelImportJobSummary.setter(Builder::importedModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, IMPORTED_MODEL_ARN_FIELD, IMPORTED_MODEL_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelImportJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobArn;
    private final String jobName;
    private final String status;
    private final Instant lastModifiedTime;
    private final Instant creationTime;
    private final Instant endTime;
    private final String importedModelArn;
    private final String importedModelName;

    private ModelImportJobSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.importedModelArn = builder.importedModelArn;
        this.importedModelName = builder.importedModelName;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final ModelImportJobStatus status() {
        return ModelImportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String importedModelArn() {
        return this.importedModelArn;
    }

    public final String importedModelName() {
        return this.importedModelName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedModelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelImportJobSummary)) {
            return false;
        }
        ModelImportJobSummary other = (ModelImportJobSummary)obj;
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.importedModelArn(), other.importedModelArn()) && Objects.equals(this.importedModelName(), other.importedModelName());
    }

    public final String toString() {
        return ToString.builder((String)"ModelImportJobSummary").add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("Status", (Object)this.statusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("ImportedModelArn", (Object)this.importedModelArn()).add("ImportedModelName", (Object)this.importedModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "importedModelArn": {
                return Optional.ofNullable(clazz.cast(this.importedModelArn()));
            }
            case "importedModelName": {
                return Optional.ofNullable(clazz.cast(this.importedModelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("importedModelArn", IMPORTED_MODEL_ARN_FIELD);
        map.put("importedModelName", IMPORTED_MODEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelImportJobSummary, T> g) {
        return obj -> g.apply((ModelImportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobName;
        private String status;
        private Instant lastModifiedTime;
        private Instant creationTime;
        private Instant endTime;
        private String importedModelArn;
        private String importedModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelImportJobSummary model) {
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.importedModelArn(model.importedModelArn);
            this.importedModelName(model.importedModelName);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getImportedModelArn() {
            return this.importedModelArn;
        }

        public final void setImportedModelArn(String importedModelArn) {
            this.importedModelArn = importedModelArn;
        }

        @Override
        public final Builder importedModelArn(String importedModelArn) {
            this.importedModelArn = importedModelArn;
            return this;
        }

        public final String getImportedModelName() {
            return this.importedModelName;
        }

        public final void setImportedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
        }

        @Override
        public final Builder importedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
            return this;
        }

        public ModelImportJobSummary build() {
            return new ModelImportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelImportJobSummary> {
        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder status(String var1);

        public Builder status(ModelImportJobStatus var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder importedModelArn(String var1);

        public Builder importedModelName(String var1);
    }
}

