/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.EndpointConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMarketplaceModelEndpointRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, UpdateMarketplaceModelEndpointRequest> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointArn").getter(UpdateMarketplaceModelEndpointRequest.getter(UpdateMarketplaceModelEndpointRequest::endpointArn)).setter(UpdateMarketplaceModelEndpointRequest.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointArn").build()}).build();
    private static final SdkField<EndpointConfig> ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpointConfig").getter(UpdateMarketplaceModelEndpointRequest.getter(UpdateMarketplaceModelEndpointRequest::endpointConfig)).setter(UpdateMarketplaceModelEndpointRequest.setter(Builder::endpointConfig)).constructor(EndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfig").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(UpdateMarketplaceModelEndpointRequest.getter(UpdateMarketplaceModelEndpointRequest::clientRequestToken)).setter(UpdateMarketplaceModelEndpointRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD, ENDPOINT_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMarketplaceModelEndpointRequest.memberNameToFieldInitializer();
    private final String endpointArn;
    private final EndpointConfig endpointConfig;
    private final String clientRequestToken;

    private UpdateMarketplaceModelEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.endpointConfig = builder.endpointConfig;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final EndpointConfig endpointConfig() {
        return this.endpointConfig;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMarketplaceModelEndpointRequest)) {
            return false;
        }
        UpdateMarketplaceModelEndpointRequest other = (UpdateMarketplaceModelEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.endpointConfig(), other.endpointConfig()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMarketplaceModelEndpointRequest").add("EndpointArn", (Object)this.endpointArn()).add("EndpointConfig", (Object)this.endpointConfig()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "endpointConfig": {
                return Optional.ofNullable(clazz.cast(this.endpointConfig()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpointArn", ENDPOINT_ARN_FIELD);
        map.put("endpointConfig", ENDPOINT_CONFIG_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMarketplaceModelEndpointRequest, T> g) {
        return obj -> g.apply((UpdateMarketplaceModelEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String endpointArn;
        private EndpointConfig endpointConfig;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMarketplaceModelEndpointRequest model) {
            super(model);
            this.endpointArn(model.endpointArn);
            this.endpointConfig(model.endpointConfig);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final EndpointConfig.Builder getEndpointConfig() {
            return this.endpointConfig != null ? this.endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(EndpointConfig.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(EndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMarketplaceModelEndpointRequest build() {
            return new UpdateMarketplaceModelEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMarketplaceModelEndpointRequest> {
        public Builder endpointArn(String var1);

        public Builder endpointConfig(EndpointConfig var1);

        default public Builder endpointConfig(Consumer<EndpointConfig.Builder> endpointConfig) {
            return this.endpointConfig((EndpointConfig)((EndpointConfig.Builder)EndpointConfig.builder().applyMutation(endpointConfig)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

