/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration of custom metrics to be used in an evaluation job. To learn more about using custom metrics
 * in Amazon Bedrock evaluation jobs, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-custom-metrics-prompt-formats.html"
 * >Create a prompt for a custom metrics (LLM-as-a-judge model evaluations)</a> and <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-evaluation-custom-metrics-prompt-formats.html">Create a
 * prompt for a custom metrics (RAG evaluations)</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedEvaluationCustomMetricConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedEvaluationCustomMetricConfig.Builder, AutomatedEvaluationCustomMetricConfig> {
    private static final SdkField<List<AutomatedEvaluationCustomMetricSource>> CUSTOM_METRICS_FIELD = SdkField
            .<List<AutomatedEvaluationCustomMetricSource>> builder(MarshallingType.LIST)
            .memberName("customMetrics")
            .getter(getter(AutomatedEvaluationCustomMetricConfig::customMetrics))
            .setter(setter(Builder::customMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedEvaluationCustomMetricSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedEvaluationCustomMetricSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomMetricEvaluatorModelConfig> EVALUATOR_MODEL_CONFIG_FIELD = SdkField
            .<CustomMetricEvaluatorModelConfig> builder(MarshallingType.SDK_POJO).memberName("evaluatorModelConfig")
            .getter(getter(AutomatedEvaluationCustomMetricConfig::evaluatorModelConfig))
            .setter(setter(Builder::evaluatorModelConfig)).constructor(CustomMetricEvaluatorModelConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorModelConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_METRICS_FIELD,
            EVALUATOR_MODEL_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AutomatedEvaluationCustomMetricSource> customMetrics;

    private final CustomMetricEvaluatorModelConfig evaluatorModelConfig;

    private AutomatedEvaluationCustomMetricConfig(BuilderImpl builder) {
        this.customMetrics = builder.customMetrics;
        this.evaluatorModelConfig = builder.evaluatorModelConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomMetrics() {
        return customMetrics != null && !(customMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines a list of custom metrics to be used in an Amazon Bedrock evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomMetrics} method.
     * </p>
     * 
     * @return Defines a list of custom metrics to be used in an Amazon Bedrock evaluation job.
     */
    public final List<AutomatedEvaluationCustomMetricSource> customMetrics() {
        return customMetrics;
    }

    /**
     * <p>
     * Configuration of the evaluator model you want to use to evaluate custom metrics in an Amazon Bedrock evaluation
     * job.
     * </p>
     * 
     * @return Configuration of the evaluator model you want to use to evaluate custom metrics in an Amazon Bedrock
     *         evaluation job.
     */
    public final CustomMetricEvaluatorModelConfig evaluatorModelConfig() {
        return evaluatorModelConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomMetrics() ? customMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluatorModelConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedEvaluationCustomMetricConfig)) {
            return false;
        }
        AutomatedEvaluationCustomMetricConfig other = (AutomatedEvaluationCustomMetricConfig) obj;
        return hasCustomMetrics() == other.hasCustomMetrics() && Objects.equals(customMetrics(), other.customMetrics())
                && Objects.equals(evaluatorModelConfig(), other.evaluatorModelConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedEvaluationCustomMetricConfig")
                .add("CustomMetrics", hasCustomMetrics() ? customMetrics() : null)
                .add("EvaluatorModelConfig", evaluatorModelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customMetrics":
            return Optional.ofNullable(clazz.cast(customMetrics()));
        case "evaluatorModelConfig":
            return Optional.ofNullable(clazz.cast(evaluatorModelConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customMetrics", CUSTOM_METRICS_FIELD);
        map.put("evaluatorModelConfig", EVALUATOR_MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedEvaluationCustomMetricConfig, T> g) {
        return obj -> g.apply((AutomatedEvaluationCustomMetricConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedEvaluationCustomMetricConfig> {
        /**
         * <p>
         * Defines a list of custom metrics to be used in an Amazon Bedrock evaluation job.
         * </p>
         * 
         * @param customMetrics
         *        Defines a list of custom metrics to be used in an Amazon Bedrock evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMetrics(Collection<AutomatedEvaluationCustomMetricSource> customMetrics);

        /**
         * <p>
         * Defines a list of custom metrics to be used in an Amazon Bedrock evaluation job.
         * </p>
         * 
         * @param customMetrics
         *        Defines a list of custom metrics to be used in an Amazon Bedrock evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMetrics(AutomatedEvaluationCustomMetricSource... customMetrics);

        /**
         * <p>
         * Defines a list of custom metrics to be used in an Amazon Bedrock evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationCustomMetricSource.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationCustomMetricSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationCustomMetricSource.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #customMetrics(List<AutomatedEvaluationCustomMetricSource>)}.
         * 
         * @param customMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationCustomMetricSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customMetrics(java.util.Collection<AutomatedEvaluationCustomMetricSource>)
         */
        Builder customMetrics(Consumer<AutomatedEvaluationCustomMetricSource.Builder>... customMetrics);

        /**
         * <p>
         * Configuration of the evaluator model you want to use to evaluate custom metrics in an Amazon Bedrock
         * evaluation job.
         * </p>
         * 
         * @param evaluatorModelConfig
         *        Configuration of the evaluator model you want to use to evaluate custom metrics in an Amazon Bedrock
         *        evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatorModelConfig(CustomMetricEvaluatorModelConfig evaluatorModelConfig);

        /**
         * <p>
         * Configuration of the evaluator model you want to use to evaluate custom metrics in an Amazon Bedrock
         * evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomMetricEvaluatorModelConfig.Builder}
         * avoiding the need to create one manually via {@link CustomMetricEvaluatorModelConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomMetricEvaluatorModelConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluatorModelConfig(CustomMetricEvaluatorModelConfig)}.
         * 
         * @param evaluatorModelConfig
         *        a consumer that will call methods on {@link CustomMetricEvaluatorModelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluatorModelConfig(CustomMetricEvaluatorModelConfig)
         */
        default Builder evaluatorModelConfig(Consumer<CustomMetricEvaluatorModelConfig.Builder> evaluatorModelConfig) {
            return evaluatorModelConfig(CustomMetricEvaluatorModelConfig.builder().applyMutation(evaluatorModelConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AutomatedEvaluationCustomMetricSource> customMetrics = DefaultSdkAutoConstructList.getInstance();

        private CustomMetricEvaluatorModelConfig evaluatorModelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedEvaluationCustomMetricConfig model) {
            customMetrics(model.customMetrics);
            evaluatorModelConfig(model.evaluatorModelConfig);
        }

        public final List<AutomatedEvaluationCustomMetricSource.Builder> getCustomMetrics() {
            List<AutomatedEvaluationCustomMetricSource.Builder> result = AutomatedEvaluationCustomMetricsCopier
                    .copyToBuilder(this.customMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomMetrics(Collection<AutomatedEvaluationCustomMetricSource.BuilderImpl> customMetrics) {
            this.customMetrics = AutomatedEvaluationCustomMetricsCopier.copyFromBuilder(customMetrics);
        }

        @Override
        public final Builder customMetrics(Collection<AutomatedEvaluationCustomMetricSource> customMetrics) {
            this.customMetrics = AutomatedEvaluationCustomMetricsCopier.copy(customMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetrics(AutomatedEvaluationCustomMetricSource... customMetrics) {
            customMetrics(Arrays.asList(customMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetrics(Consumer<AutomatedEvaluationCustomMetricSource.Builder>... customMetrics) {
            customMetrics(Stream.of(customMetrics)
                    .map(c -> AutomatedEvaluationCustomMetricSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CustomMetricEvaluatorModelConfig.Builder getEvaluatorModelConfig() {
            return evaluatorModelConfig != null ? evaluatorModelConfig.toBuilder() : null;
        }

        public final void setEvaluatorModelConfig(CustomMetricEvaluatorModelConfig.BuilderImpl evaluatorModelConfig) {
            this.evaluatorModelConfig = evaluatorModelConfig != null ? evaluatorModelConfig.build() : null;
        }

        @Override
        public final Builder evaluatorModelConfig(CustomMetricEvaluatorModelConfig evaluatorModelConfig) {
            this.evaluatorModelConfig = evaluatorModelConfig;
            return this;
        }

        @Override
        public AutomatedEvaluationCustomMetricConfig build() {
            return new AutomatedEvaluationCustomMetricConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
