/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An evaluation job for deletion, and it’s current status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteEvaluationJobItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteEvaluationJobItem.Builder, BatchDeleteEvaluationJobItem> {
    private static final SdkField<String> JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobIdentifier").getter(getter(BatchDeleteEvaluationJobItem::jobIdentifier))
            .setter(setter(Builder::jobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobIdentifier").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(BatchDeleteEvaluationJobItem::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_IDENTIFIER_FIELD,
            JOB_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobIdentifier;

    private final String jobStatus;

    private BatchDeleteEvaluationJobItem(BuilderImpl builder) {
        this.jobIdentifier = builder.jobIdentifier;
        this.jobStatus = builder.jobStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the evaluation job for deletion.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the evaluation job for deletion.
     */
    public final String jobIdentifier() {
        return jobIdentifier;
    }

    /**
     * <p>
     * The status of the evaluation job for deletion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link EvaluationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the evaluation job for deletion.
     * @see EvaluationJobStatus
     */
    public final EvaluationJobStatus jobStatus() {
        return EvaluationJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the evaluation job for deletion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link EvaluationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the evaluation job for deletion.
     * @see EvaluationJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteEvaluationJobItem)) {
            return false;
        }
        BatchDeleteEvaluationJobItem other = (BatchDeleteEvaluationJobItem) obj;
        return Objects.equals(jobIdentifier(), other.jobIdentifier())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteEvaluationJobItem")
                .add("JobIdentifier", jobIdentifier() == null ? null : "*** Sensitive Data Redacted ***")
                .add("JobStatus", jobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobIdentifier":
            return Optional.ofNullable(clazz.cast(jobIdentifier()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobIdentifier", JOB_IDENTIFIER_FIELD);
        map.put("jobStatus", JOB_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteEvaluationJobItem, T> g) {
        return obj -> g.apply((BatchDeleteEvaluationJobItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteEvaluationJobItem> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the evaluation job for deletion.
         * </p>
         * 
         * @param jobIdentifier
         *        The Amazon Resource Name (ARN) of the evaluation job for deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobIdentifier(String jobIdentifier);

        /**
         * <p>
         * The status of the evaluation job for deletion.
         * </p>
         * 
         * @param jobStatus
         *        The status of the evaluation job for deletion.
         * @see EvaluationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the evaluation job for deletion.
         * </p>
         * 
         * @param jobStatus
         *        The status of the evaluation job for deletion.
         * @see EvaluationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobStatus
         */
        Builder jobStatus(EvaluationJobStatus jobStatus);
    }

    static final class BuilderImpl implements Builder {
        private String jobIdentifier;

        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteEvaluationJobItem model) {
            jobIdentifier(model.jobIdentifier);
            jobStatus(model.jobStatus);
        }

        public final String getJobIdentifier() {
            return jobIdentifier;
        }

        public final void setJobIdentifier(String jobIdentifier) {
            this.jobIdentifier = jobIdentifier;
        }

        @Override
        public final Builder jobIdentifier(String jobIdentifier) {
            this.jobIdentifier = jobIdentifier;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(EvaluationJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        @Override
        public BatchDeleteEvaluationJobItem build() {
            return new BatchDeleteEvaluationJobItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
