/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteEvaluationJobResponse extends BedrockResponse implements
        ToCopyableBuilder<BatchDeleteEvaluationJobResponse.Builder, BatchDeleteEvaluationJobResponse> {
    private static final SdkField<List<BatchDeleteEvaluationJobError>> ERRORS_FIELD = SdkField
            .<List<BatchDeleteEvaluationJobError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchDeleteEvaluationJobResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDeleteEvaluationJobError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDeleteEvaluationJobError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchDeleteEvaluationJobItem>> EVALUATION_JOBS_FIELD = SdkField
            .<List<BatchDeleteEvaluationJobItem>> builder(MarshallingType.LIST)
            .memberName("evaluationJobs")
            .getter(getter(BatchDeleteEvaluationJobResponse::evaluationJobs))
            .setter(setter(Builder::evaluationJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDeleteEvaluationJobItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDeleteEvaluationJobItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD,
            EVALUATION_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchDeleteEvaluationJobError> errors;

    private final List<BatchDeleteEvaluationJobItem> evaluationJobs;

    private BatchDeleteEvaluationJobResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.evaluationJobs = builder.evaluationJobs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON object containing the HTTP status codes and the ARNs of evaluation jobs that failed to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A JSON object containing the HTTP status codes and the ARNs of evaluation jobs that failed to be deleted.
     */
    public final List<BatchDeleteEvaluationJobError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluationJobs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluationJobs() {
        return evaluationJobs != null && !(evaluationJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of evaluation jobs for deletion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluationJobs} method.
     * </p>
     * 
     * @return The list of evaluation jobs for deletion.
     */
    public final List<BatchDeleteEvaluationJobItem> evaluationJobs() {
        return evaluationJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluationJobs() ? evaluationJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteEvaluationJobResponse)) {
            return false;
        }
        BatchDeleteEvaluationJobResponse other = (BatchDeleteEvaluationJobResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasEvaluationJobs() == other.hasEvaluationJobs() && Objects.equals(evaluationJobs(), other.evaluationJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteEvaluationJobResponse").add("Errors", hasErrors() ? errors() : null)
                .add("EvaluationJobs", hasEvaluationJobs() ? evaluationJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "evaluationJobs":
            return Optional.ofNullable(clazz.cast(evaluationJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errors", ERRORS_FIELD);
        map.put("evaluationJobs", EVALUATION_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteEvaluationJobResponse, T> g) {
        return obj -> g.apply((BatchDeleteEvaluationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteEvaluationJobResponse> {
        /**
         * <p>
         * A JSON object containing the HTTP status codes and the ARNs of evaluation jobs that failed to be deleted.
         * </p>
         * 
         * @param errors
         *        A JSON object containing the HTTP status codes and the ARNs of evaluation jobs that failed to be
         *        deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchDeleteEvaluationJobError> errors);

        /**
         * <p>
         * A JSON object containing the HTTP status codes and the ARNs of evaluation jobs that failed to be deleted.
         * </p>
         * 
         * @param errors
         *        A JSON object containing the HTTP status codes and the ARNs of evaluation jobs that failed to be
         *        deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchDeleteEvaluationJobError... errors);

        /**
         * <p>
         * A JSON object containing the HTTP status codes and the ARNs of evaluation jobs that failed to be deleted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchDeleteEvaluationJobError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchDeleteEvaluationJobError>)
         */
        Builder errors(Consumer<BatchDeleteEvaluationJobError.Builder>... errors);

        /**
         * <p>
         * The list of evaluation jobs for deletion.
         * </p>
         * 
         * @param evaluationJobs
         *        The list of evaluation jobs for deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationJobs(Collection<BatchDeleteEvaluationJobItem> evaluationJobs);

        /**
         * <p>
         * The list of evaluation jobs for deletion.
         * </p>
         * 
         * @param evaluationJobs
         *        The list of evaluation jobs for deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationJobs(BatchDeleteEvaluationJobItem... evaluationJobs);

        /**
         * <p>
         * The list of evaluation jobs for deletion.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluationJobs(List<BatchDeleteEvaluationJobItem>)}.
         * 
         * @param evaluationJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationJobs(java.util.Collection<BatchDeleteEvaluationJobItem>)
         */
        Builder evaluationJobs(Consumer<BatchDeleteEvaluationJobItem.Builder>... evaluationJobs);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private List<BatchDeleteEvaluationJobError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<BatchDeleteEvaluationJobItem> evaluationJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteEvaluationJobResponse model) {
            super(model);
            errors(model.errors);
            evaluationJobs(model.evaluationJobs);
        }

        public final List<BatchDeleteEvaluationJobError.Builder> getErrors() {
            List<BatchDeleteEvaluationJobError.Builder> result = BatchDeleteEvaluationJobErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDeleteEvaluationJobError.BuilderImpl> errors) {
            this.errors = BatchDeleteEvaluationJobErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDeleteEvaluationJobError> errors) {
            this.errors = BatchDeleteEvaluationJobErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDeleteEvaluationJobError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDeleteEvaluationJobError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchDeleteEvaluationJobError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchDeleteEvaluationJobItem.Builder> getEvaluationJobs() {
            List<BatchDeleteEvaluationJobItem.Builder> result = BatchDeleteEvaluationJobItemsCopier
                    .copyToBuilder(this.evaluationJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationJobs(Collection<BatchDeleteEvaluationJobItem.BuilderImpl> evaluationJobs) {
            this.evaluationJobs = BatchDeleteEvaluationJobItemsCopier.copyFromBuilder(evaluationJobs);
        }

        @Override
        public final Builder evaluationJobs(Collection<BatchDeleteEvaluationJobItem> evaluationJobs) {
            this.evaluationJobs = BatchDeleteEvaluationJobItemsCopier.copy(evaluationJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationJobs(BatchDeleteEvaluationJobItem... evaluationJobs) {
            evaluationJobs(Arrays.asList(evaluationJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationJobs(Consumer<BatchDeleteEvaluationJobItem.Builder>... evaluationJobs) {
            evaluationJobs(Stream.of(evaluationJobs).map(c -> BatchDeleteEvaluationJobItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteEvaluationJobResponse build() {
            return new BatchDeleteEvaluationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
