/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of the evaluator model you want to use to evaluate custom metrics in an Amazon Bedrock evaluation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomMetricEvaluatorModelConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomMetricEvaluatorModelConfig.Builder, CustomMetricEvaluatorModelConfig> {
    private static final SdkField<List<CustomMetricBedrockEvaluatorModel>> BEDROCK_EVALUATOR_MODELS_FIELD = SdkField
            .<List<CustomMetricBedrockEvaluatorModel>> builder(MarshallingType.LIST)
            .memberName("bedrockEvaluatorModels")
            .getter(getter(CustomMetricEvaluatorModelConfig::bedrockEvaluatorModels))
            .setter(setter(Builder::bedrockEvaluatorModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockEvaluatorModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomMetricBedrockEvaluatorModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomMetricBedrockEvaluatorModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BEDROCK_EVALUATOR_MODELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CustomMetricBedrockEvaluatorModel> bedrockEvaluatorModels;

    private CustomMetricEvaluatorModelConfig(BuilderImpl builder) {
        this.bedrockEvaluatorModels = builder.bedrockEvaluatorModels;
    }

    /**
     * For responses, this returns true if the service returned a value for the BedrockEvaluatorModels property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBedrockEvaluatorModels() {
        return bedrockEvaluatorModels != null && !(bedrockEvaluatorModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the model you want to evaluate custom metrics in an Amazon Bedrock evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBedrockEvaluatorModels} method.
     * </p>
     * 
     * @return Defines the model you want to evaluate custom metrics in an Amazon Bedrock evaluation job.
     */
    public final List<CustomMetricBedrockEvaluatorModel> bedrockEvaluatorModels() {
        return bedrockEvaluatorModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBedrockEvaluatorModels() ? bedrockEvaluatorModels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomMetricEvaluatorModelConfig)) {
            return false;
        }
        CustomMetricEvaluatorModelConfig other = (CustomMetricEvaluatorModelConfig) obj;
        return hasBedrockEvaluatorModels() == other.hasBedrockEvaluatorModels()
                && Objects.equals(bedrockEvaluatorModels(), other.bedrockEvaluatorModels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomMetricEvaluatorModelConfig")
                .add("BedrockEvaluatorModels", hasBedrockEvaluatorModels() ? bedrockEvaluatorModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockEvaluatorModels":
            return Optional.ofNullable(clazz.cast(bedrockEvaluatorModels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bedrockEvaluatorModels", BEDROCK_EVALUATOR_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomMetricEvaluatorModelConfig, T> g) {
        return obj -> g.apply((CustomMetricEvaluatorModelConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomMetricEvaluatorModelConfig> {
        /**
         * <p>
         * Defines the model you want to evaluate custom metrics in an Amazon Bedrock evaluation job.
         * </p>
         * 
         * @param bedrockEvaluatorModels
         *        Defines the model you want to evaluate custom metrics in an Amazon Bedrock evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockEvaluatorModels(Collection<CustomMetricBedrockEvaluatorModel> bedrockEvaluatorModels);

        /**
         * <p>
         * Defines the model you want to evaluate custom metrics in an Amazon Bedrock evaluation job.
         * </p>
         * 
         * @param bedrockEvaluatorModels
         *        Defines the model you want to evaluate custom metrics in an Amazon Bedrock evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockEvaluatorModels(CustomMetricBedrockEvaluatorModel... bedrockEvaluatorModels);

        /**
         * <p>
         * Defines the model you want to evaluate custom metrics in an Amazon Bedrock evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.CustomMetricBedrockEvaluatorModel.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.CustomMetricBedrockEvaluatorModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.CustomMetricBedrockEvaluatorModel.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #bedrockEvaluatorModels(List<CustomMetricBedrockEvaluatorModel>)}.
         * 
         * @param bedrockEvaluatorModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.CustomMetricBedrockEvaluatorModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockEvaluatorModels(java.util.Collection<CustomMetricBedrockEvaluatorModel>)
         */
        Builder bedrockEvaluatorModels(Consumer<CustomMetricBedrockEvaluatorModel.Builder>... bedrockEvaluatorModels);
    }

    static final class BuilderImpl implements Builder {
        private List<CustomMetricBedrockEvaluatorModel> bedrockEvaluatorModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomMetricEvaluatorModelConfig model) {
            bedrockEvaluatorModels(model.bedrockEvaluatorModels);
        }

        public final List<CustomMetricBedrockEvaluatorModel.Builder> getBedrockEvaluatorModels() {
            List<CustomMetricBedrockEvaluatorModel.Builder> result = CustomMetricBedrockEvaluatorModelsCopier
                    .copyToBuilder(this.bedrockEvaluatorModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBedrockEvaluatorModels(
                Collection<CustomMetricBedrockEvaluatorModel.BuilderImpl> bedrockEvaluatorModels) {
            this.bedrockEvaluatorModels = CustomMetricBedrockEvaluatorModelsCopier.copyFromBuilder(bedrockEvaluatorModels);
        }

        @Override
        public final Builder bedrockEvaluatorModels(Collection<CustomMetricBedrockEvaluatorModel> bedrockEvaluatorModels) {
            this.bedrockEvaluatorModels = CustomMetricBedrockEvaluatorModelsCopier.copy(bedrockEvaluatorModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bedrockEvaluatorModels(CustomMetricBedrockEvaluatorModel... bedrockEvaluatorModels) {
            bedrockEvaluatorModels(Arrays.asList(bedrockEvaluatorModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bedrockEvaluatorModels(Consumer<CustomMetricBedrockEvaluatorModel.Builder>... bedrockEvaluatorModels) {
            bedrockEvaluatorModels(Stream.of(bedrockEvaluatorModels)
                    .map(c -> CustomMetricBedrockEvaluatorModel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomMetricEvaluatorModelConfig build() {
            return new CustomMetricEvaluatorModelConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
