/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>CustomModelUnit</code> (CMU) is an abstract view of the hardware utilization that Amazon Bedrock needs to
 * host a single copy of your custom model. A model copy represents a single instance of your imported model that is
 * ready to serve inference requests. Amazon Bedrock determines the number of custom model units that a model copy needs
 * when you import the custom model.
 * </p>
 * <p>
 * You can use <code>CustomModelUnits</code> to estimate the cost of running your custom model. For more information,
 * see Calculate the cost of running a custom model in the Amazon Bedrock user guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomModelUnits implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomModelUnits.Builder, CustomModelUnits> {
    private static final SdkField<Integer> CUSTOM_MODEL_UNITS_PER_MODEL_COPY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("customModelUnitsPerModelCopy")
            .getter(getter(CustomModelUnits::customModelUnitsPerModelCopy))
            .setter(setter(Builder::customModelUnitsPerModelCopy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelUnitsPerModelCopy")
                    .build()).build();

    private static final SdkField<String> CUSTOM_MODEL_UNITS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customModelUnitsVersion").getter(getter(CustomModelUnits::customModelUnitsVersion))
            .setter(setter(Builder::customModelUnitsVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelUnitsVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_MODEL_UNITS_PER_MODEL_COPY_FIELD, CUSTOM_MODEL_UNITS_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer customModelUnitsPerModelCopy;

    private final String customModelUnitsVersion;

    private CustomModelUnits(BuilderImpl builder) {
        this.customModelUnitsPerModelCopy = builder.customModelUnitsPerModelCopy;
        this.customModelUnitsVersion = builder.customModelUnitsVersion;
    }

    /**
     * <p>
     * The number of custom model units used to host a model copy.
     * </p>
     * 
     * @return The number of custom model units used to host a model copy.
     */
    public final Integer customModelUnitsPerModelCopy() {
        return customModelUnitsPerModelCopy;
    }

    /**
     * <p>
     * The version of the custom model unit. Use to determine the billing rate for the custom model unit.
     * </p>
     * 
     * @return The version of the custom model unit. Use to determine the billing rate for the custom model unit.
     */
    public final String customModelUnitsVersion() {
        return customModelUnitsVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customModelUnitsPerModelCopy());
        hashCode = 31 * hashCode + Objects.hashCode(customModelUnitsVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelUnits)) {
            return false;
        }
        CustomModelUnits other = (CustomModelUnits) obj;
        return Objects.equals(customModelUnitsPerModelCopy(), other.customModelUnitsPerModelCopy())
                && Objects.equals(customModelUnitsVersion(), other.customModelUnitsVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomModelUnits").add("CustomModelUnitsPerModelCopy", customModelUnitsPerModelCopy())
                .add("CustomModelUnitsVersion", customModelUnitsVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customModelUnitsPerModelCopy":
            return Optional.ofNullable(clazz.cast(customModelUnitsPerModelCopy()));
        case "customModelUnitsVersion":
            return Optional.ofNullable(clazz.cast(customModelUnitsVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customModelUnitsPerModelCopy", CUSTOM_MODEL_UNITS_PER_MODEL_COPY_FIELD);
        map.put("customModelUnitsVersion", CUSTOM_MODEL_UNITS_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomModelUnits, T> g) {
        return obj -> g.apply((CustomModelUnits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomModelUnits> {
        /**
         * <p>
         * The number of custom model units used to host a model copy.
         * </p>
         * 
         * @param customModelUnitsPerModelCopy
         *        The number of custom model units used to host a model copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelUnitsPerModelCopy(Integer customModelUnitsPerModelCopy);

        /**
         * <p>
         * The version of the custom model unit. Use to determine the billing rate for the custom model unit.
         * </p>
         * 
         * @param customModelUnitsVersion
         *        The version of the custom model unit. Use to determine the billing rate for the custom model unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelUnitsVersion(String customModelUnitsVersion);
    }

    static final class BuilderImpl implements Builder {
        private Integer customModelUnitsPerModelCopy;

        private String customModelUnitsVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomModelUnits model) {
            customModelUnitsPerModelCopy(model.customModelUnitsPerModelCopy);
            customModelUnitsVersion(model.customModelUnitsVersion);
        }

        public final Integer getCustomModelUnitsPerModelCopy() {
            return customModelUnitsPerModelCopy;
        }

        public final void setCustomModelUnitsPerModelCopy(Integer customModelUnitsPerModelCopy) {
            this.customModelUnitsPerModelCopy = customModelUnitsPerModelCopy;
        }

        @Override
        public final Builder customModelUnitsPerModelCopy(Integer customModelUnitsPerModelCopy) {
            this.customModelUnitsPerModelCopy = customModelUnitsPerModelCopy;
            return this;
        }

        public final String getCustomModelUnitsVersion() {
            return customModelUnitsVersion;
        }

        public final void setCustomModelUnitsVersion(String customModelUnitsVersion) {
            this.customModelUnitsVersion = customModelUnitsVersion;
        }

        @Override
        public final Builder customModelUnitsVersion(String customModelUnitsVersion) {
            this.customModelUnitsVersion = customModelUnitsVersion;
            return this;
        }

        @Override
        public CustomModelUnits build() {
            return new CustomModelUnits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
