/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the prompt datasets, built-in metric names and custom metric names, and the task type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationDatasetMetricConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationDatasetMetricConfig.Builder, EvaluationDatasetMetricConfig> {
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskType").getter(getter(EvaluationDatasetMetricConfig::taskTypeAsString))
            .setter(setter(Builder::taskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskType").build()).build();

    private static final SdkField<EvaluationDataset> DATASET_FIELD = SdkField
            .<EvaluationDataset> builder(MarshallingType.SDK_POJO).memberName("dataset")
            .getter(getter(EvaluationDatasetMetricConfig::dataset)).setter(setter(Builder::dataset))
            .constructor(EvaluationDataset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataset").build()).build();

    private static final SdkField<List<String>> METRIC_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("metricNames")
            .getter(getter(EvaluationDatasetMetricConfig::metricNames))
            .setter(setter(Builder::metricNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TYPE_FIELD,
            DATASET_FIELD, METRIC_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String taskType;

    private final EvaluationDataset dataset;

    private final List<String> metricNames;

    private EvaluationDatasetMetricConfig(BuilderImpl builder) {
        this.taskType = builder.taskType;
        this.dataset = builder.dataset;
        this.metricNames = builder.metricNames;
    }

    /**
     * <p>
     * The the type of task you want to evaluate for your evaluation job. This applies only to model evaluation jobs and
     * is ignored for knowledge base evaluation jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link EvaluationTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The the type of task you want to evaluate for your evaluation job. This applies only to model evaluation
     *         jobs and is ignored for knowledge base evaluation jobs.
     * @see EvaluationTaskType
     */
    public final EvaluationTaskType taskType() {
        return EvaluationTaskType.fromValue(taskType);
    }

    /**
     * <p>
     * The the type of task you want to evaluate for your evaluation job. This applies only to model evaluation jobs and
     * is ignored for knowledge base evaluation jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link EvaluationTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The the type of task you want to evaluate for your evaluation job. This applies only to model evaluation
     *         jobs and is ignored for knowledge base evaluation jobs.
     * @see EvaluationTaskType
     */
    public final String taskTypeAsString() {
        return taskType;
    }

    /**
     * <p>
     * Specifies the prompt dataset.
     * </p>
     * 
     * @return Specifies the prompt dataset.
     */
    public final EvaluationDataset dataset() {
        return dataset;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricNames() {
        return metricNames != null && !(metricNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the metrics you want to use for your evaluation job.
     * </p>
     * <p>
     * For knowledge base evaluation jobs that evaluate retrieval only, valid values are "
     * <code>Builtin.ContextRelevance</code>", "<code>Builtin.ContextCoverage</code>".
     * </p>
     * <p>
     * For knowledge base evaluation jobs that evaluate retrieval with response generation, valid values are "
     * <code>Builtin.Correctness</code>", "<code>Builtin.Completeness</code>", "<code>Builtin.Helpfulness</code>", "
     * <code>Builtin.LogicalCoherence</code>", "<code>Builtin.Faithfulness</code>", "<code>Builtin.Harmfulness</code>
     * ", "<code>Builtin.Stereotyping</code>", "<code>Builtin.Refusal</code>".
     * </p>
     * <p>
     * For automated model evaluation jobs, valid values are "<code>Builtin.Accuracy</code>", "
     * <code>Builtin.Robustness</code>", and "<code>Builtin.Toxicity</code>
     * ". In model evaluation jobs that use a LLM as judge you can specify "<code>Builtin.Correctness</code>", "
     * <code>Builtin.Completeness"</code>, "<code>Builtin.Faithfulness"</code>, "<code>Builtin.Helpfulness</code>", "
     * <code>Builtin.Coherence</code>", "<code>Builtin.Relevance</code>", "<code>Builtin.FollowingInstructions</code>
     * ", "<code>Builtin.ProfessionalStyleAndTone</code>
     * ", You can also specify the following responsible AI related metrics only for model evaluation job that use a LLM as judge "
     * <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", and "<code>Builtin.Refusal</code>".
     * </p>
     * <p>
     * For human-based model evaluation jobs, the list of strings must match the <code>name</code> parameter specified
     * in <code>HumanEvaluationCustomMetric</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricNames} method.
     * </p>
     * 
     * @return The names of the metrics you want to use for your evaluation job.</p>
     *         <p>
     *         For knowledge base evaluation jobs that evaluate retrieval only, valid values are "
     *         <code>Builtin.ContextRelevance</code>", "<code>Builtin.ContextCoverage</code>".
     *         </p>
     *         <p>
     *         For knowledge base evaluation jobs that evaluate retrieval with response generation, valid values are "
     *         <code>Builtin.Correctness</code>", "<code>Builtin.Completeness</code>", "<code>Builtin.Helpfulness</code>
     *         ", "<code>Builtin.LogicalCoherence</code>", "<code>Builtin.Faithfulness</code>", "
     *         <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", "<code>Builtin.Refusal</code>".
     *         </p>
     *         <p>
     *         For automated model evaluation jobs, valid values are "<code>Builtin.Accuracy</code>", "
     *         <code>Builtin.Robustness</code>", and "<code>Builtin.Toxicity</code>
     *         ". In model evaluation jobs that use a LLM as judge you can specify "<code>Builtin.Correctness</code>", "
     *         <code>Builtin.Completeness"</code>, "<code>Builtin.Faithfulness"</code>, "
     *         <code>Builtin.Helpfulness</code>", "<code>Builtin.Coherence</code>", "<code>Builtin.Relevance</code>", "
     *         <code>Builtin.FollowingInstructions</code>", "<code>Builtin.ProfessionalStyleAndTone</code>
     *         ", You can also specify the following responsible AI related metrics only for model evaluation job that use a LLM as judge "
     *         <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", and "<code>Builtin.Refusal</code>
     *         ".
     *         </p>
     *         <p>
     *         For human-based model evaluation jobs, the list of strings must match the <code>name</code> parameter
     *         specified in <code>HumanEvaluationCustomMetric</code>.
     */
    public final List<String> metricNames() {
        return metricNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataset());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricNames() ? metricNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationDatasetMetricConfig)) {
            return false;
        }
        EvaluationDatasetMetricConfig other = (EvaluationDatasetMetricConfig) obj;
        return Objects.equals(taskTypeAsString(), other.taskTypeAsString()) && Objects.equals(dataset(), other.dataset())
                && hasMetricNames() == other.hasMetricNames() && Objects.equals(metricNames(), other.metricNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationDatasetMetricConfig").add("TaskType", taskTypeAsString()).add("Dataset", dataset())
                .add("MetricNames", metricNames() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskType":
            return Optional.ofNullable(clazz.cast(taskTypeAsString()));
        case "dataset":
            return Optional.ofNullable(clazz.cast(dataset()));
        case "metricNames":
            return Optional.ofNullable(clazz.cast(metricNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskType", TASK_TYPE_FIELD);
        map.put("dataset", DATASET_FIELD);
        map.put("metricNames", METRIC_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationDatasetMetricConfig, T> g) {
        return obj -> g.apply((EvaluationDatasetMetricConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationDatasetMetricConfig> {
        /**
         * <p>
         * The the type of task you want to evaluate for your evaluation job. This applies only to model evaluation jobs
         * and is ignored for knowledge base evaluation jobs.
         * </p>
         * 
         * @param taskType
         *        The the type of task you want to evaluate for your evaluation job. This applies only to model
         *        evaluation jobs and is ignored for knowledge base evaluation jobs.
         * @see EvaluationTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationTaskType
         */
        Builder taskType(String taskType);

        /**
         * <p>
         * The the type of task you want to evaluate for your evaluation job. This applies only to model evaluation jobs
         * and is ignored for knowledge base evaluation jobs.
         * </p>
         * 
         * @param taskType
         *        The the type of task you want to evaluate for your evaluation job. This applies only to model
         *        evaluation jobs and is ignored for knowledge base evaluation jobs.
         * @see EvaluationTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationTaskType
         */
        Builder taskType(EvaluationTaskType taskType);

        /**
         * <p>
         * Specifies the prompt dataset.
         * </p>
         * 
         * @param dataset
         *        Specifies the prompt dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataset(EvaluationDataset dataset);

        /**
         * <p>
         * Specifies the prompt dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationDataset.Builder} avoiding the
         * need to create one manually via {@link EvaluationDataset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationDataset.Builder#build()} is called immediately and its
         * result is passed to {@link #dataset(EvaluationDataset)}.
         * 
         * @param dataset
         *        a consumer that will call methods on {@link EvaluationDataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataset(EvaluationDataset)
         */
        default Builder dataset(Consumer<EvaluationDataset.Builder> dataset) {
            return dataset(EvaluationDataset.builder().applyMutation(dataset).build());
        }

        /**
         * <p>
         * The names of the metrics you want to use for your evaluation job.
         * </p>
         * <p>
         * For knowledge base evaluation jobs that evaluate retrieval only, valid values are "
         * <code>Builtin.ContextRelevance</code>", "<code>Builtin.ContextCoverage</code>".
         * </p>
         * <p>
         * For knowledge base evaluation jobs that evaluate retrieval with response generation, valid values are "
         * <code>Builtin.Correctness</code>", "<code>Builtin.Completeness</code>", "<code>Builtin.Helpfulness</code>", "
         * <code>Builtin.LogicalCoherence</code>", "<code>Builtin.Faithfulness</code>", "
         * <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", "<code>Builtin.Refusal</code>".
         * </p>
         * <p>
         * For automated model evaluation jobs, valid values are "<code>Builtin.Accuracy</code>", "
         * <code>Builtin.Robustness</code>", and "<code>Builtin.Toxicity</code>
         * ". In model evaluation jobs that use a LLM as judge you can specify "<code>Builtin.Correctness</code>", "
         * <code>Builtin.Completeness"</code>, "<code>Builtin.Faithfulness"</code>, "<code>Builtin.Helpfulness</code>
         * ", "<code>Builtin.Coherence</code>", "<code>Builtin.Relevance</code>", "
         * <code>Builtin.FollowingInstructions</code>", "<code>Builtin.ProfessionalStyleAndTone</code>
         * ", You can also specify the following responsible AI related metrics only for model evaluation job that use a LLM as judge "
         * <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", and "<code>Builtin.Refusal</code>".
         * </p>
         * <p>
         * For human-based model evaluation jobs, the list of strings must match the <code>name</code> parameter
         * specified in <code>HumanEvaluationCustomMetric</code>.
         * </p>
         * 
         * @param metricNames
         *        The names of the metrics you want to use for your evaluation job.</p>
         *        <p>
         *        For knowledge base evaluation jobs that evaluate retrieval only, valid values are "
         *        <code>Builtin.ContextRelevance</code>", "<code>Builtin.ContextCoverage</code>".
         *        </p>
         *        <p>
         *        For knowledge base evaluation jobs that evaluate retrieval with response generation, valid values are
         *        "<code>Builtin.Correctness</code>", "<code>Builtin.Completeness</code>", "
         *        <code>Builtin.Helpfulness</code>", "<code>Builtin.LogicalCoherence</code>", "
         *        <code>Builtin.Faithfulness</code>", "<code>Builtin.Harmfulness</code>", "
         *        <code>Builtin.Stereotyping</code>", "<code>Builtin.Refusal</code>".
         *        </p>
         *        <p>
         *        For automated model evaluation jobs, valid values are "<code>Builtin.Accuracy</code>", "
         *        <code>Builtin.Robustness</code>", and "<code>Builtin.Toxicity</code>
         *        ". In model evaluation jobs that use a LLM as judge you can specify "<code>Builtin.Correctness</code>
         *        ", "<code>Builtin.Completeness"</code>, "<code>Builtin.Faithfulness"</code>, "
         *        <code>Builtin.Helpfulness</code>", "<code>Builtin.Coherence</code>", "<code>Builtin.Relevance</code>
         *        ", "<code>Builtin.FollowingInstructions</code>", "<code>Builtin.ProfessionalStyleAndTone</code>
         *        ", You can also specify the following responsible AI related metrics only for model evaluation job that use a LLM as judge "
         *        <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", and "
         *        <code>Builtin.Refusal</code>".
         *        </p>
         *        <p>
         *        For human-based model evaluation jobs, the list of strings must match the <code>name</code> parameter
         *        specified in <code>HumanEvaluationCustomMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNames(Collection<String> metricNames);

        /**
         * <p>
         * The names of the metrics you want to use for your evaluation job.
         * </p>
         * <p>
         * For knowledge base evaluation jobs that evaluate retrieval only, valid values are "
         * <code>Builtin.ContextRelevance</code>", "<code>Builtin.ContextCoverage</code>".
         * </p>
         * <p>
         * For knowledge base evaluation jobs that evaluate retrieval with response generation, valid values are "
         * <code>Builtin.Correctness</code>", "<code>Builtin.Completeness</code>", "<code>Builtin.Helpfulness</code>", "
         * <code>Builtin.LogicalCoherence</code>", "<code>Builtin.Faithfulness</code>", "
         * <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", "<code>Builtin.Refusal</code>".
         * </p>
         * <p>
         * For automated model evaluation jobs, valid values are "<code>Builtin.Accuracy</code>", "
         * <code>Builtin.Robustness</code>", and "<code>Builtin.Toxicity</code>
         * ". In model evaluation jobs that use a LLM as judge you can specify "<code>Builtin.Correctness</code>", "
         * <code>Builtin.Completeness"</code>, "<code>Builtin.Faithfulness"</code>, "<code>Builtin.Helpfulness</code>
         * ", "<code>Builtin.Coherence</code>", "<code>Builtin.Relevance</code>", "
         * <code>Builtin.FollowingInstructions</code>", "<code>Builtin.ProfessionalStyleAndTone</code>
         * ", You can also specify the following responsible AI related metrics only for model evaluation job that use a LLM as judge "
         * <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", and "<code>Builtin.Refusal</code>".
         * </p>
         * <p>
         * For human-based model evaluation jobs, the list of strings must match the <code>name</code> parameter
         * specified in <code>HumanEvaluationCustomMetric</code>.
         * </p>
         * 
         * @param metricNames
         *        The names of the metrics you want to use for your evaluation job.</p>
         *        <p>
         *        For knowledge base evaluation jobs that evaluate retrieval only, valid values are "
         *        <code>Builtin.ContextRelevance</code>", "<code>Builtin.ContextCoverage</code>".
         *        </p>
         *        <p>
         *        For knowledge base evaluation jobs that evaluate retrieval with response generation, valid values are
         *        "<code>Builtin.Correctness</code>", "<code>Builtin.Completeness</code>", "
         *        <code>Builtin.Helpfulness</code>", "<code>Builtin.LogicalCoherence</code>", "
         *        <code>Builtin.Faithfulness</code>", "<code>Builtin.Harmfulness</code>", "
         *        <code>Builtin.Stereotyping</code>", "<code>Builtin.Refusal</code>".
         *        </p>
         *        <p>
         *        For automated model evaluation jobs, valid values are "<code>Builtin.Accuracy</code>", "
         *        <code>Builtin.Robustness</code>", and "<code>Builtin.Toxicity</code>
         *        ". In model evaluation jobs that use a LLM as judge you can specify "<code>Builtin.Correctness</code>
         *        ", "<code>Builtin.Completeness"</code>, "<code>Builtin.Faithfulness"</code>, "
         *        <code>Builtin.Helpfulness</code>", "<code>Builtin.Coherence</code>", "<code>Builtin.Relevance</code>
         *        ", "<code>Builtin.FollowingInstructions</code>", "<code>Builtin.ProfessionalStyleAndTone</code>
         *        ", You can also specify the following responsible AI related metrics only for model evaluation job that use a LLM as judge "
         *        <code>Builtin.Harmfulness</code>", "<code>Builtin.Stereotyping</code>", and "
         *        <code>Builtin.Refusal</code>".
         *        </p>
         *        <p>
         *        For human-based model evaluation jobs, the list of strings must match the <code>name</code> parameter
         *        specified in <code>HumanEvaluationCustomMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNames(String... metricNames);
    }

    static final class BuilderImpl implements Builder {
        private String taskType;

        private EvaluationDataset dataset;

        private List<String> metricNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationDatasetMetricConfig model) {
            taskType(model.taskType);
            dataset(model.dataset);
            metricNames(model.metricNames);
        }

        public final String getTaskType() {
            return taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(EvaluationTaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final EvaluationDataset.Builder getDataset() {
            return dataset != null ? dataset.toBuilder() : null;
        }

        public final void setDataset(EvaluationDataset.BuilderImpl dataset) {
            this.dataset = dataset != null ? dataset.build() : null;
        }

        @Override
        public final Builder dataset(EvaluationDataset dataset) {
            this.dataset = dataset;
            return this;
        }

        public final Collection<String> getMetricNames() {
            if (metricNames instanceof SdkAutoConstructList) {
                return null;
            }
            return metricNames;
        }

        public final void setMetricNames(Collection<String> metricNames) {
            this.metricNames = EvaluationMetricNamesCopier.copy(metricNames);
        }

        @Override
        public final Builder metricNames(Collection<String> metricNames) {
            this.metricNames = EvaluationMetricNamesCopier.copy(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNames(String... metricNames) {
            metricNames(Arrays.asList(metricNames));
            return this;
        }

        @Override
        public EvaluationDatasetMetricConfig build() {
            return new EvaluationDatasetMetricConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
