/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of the inference model for an evaluation job.
 * </p>
 * <p>
 * For automated model evaluation jobs, only a single model is supported.
 * </p>
 * <p>
 * For human-based model evaluation jobs, your annotator can compare the responses for up to two different models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationInferenceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationInferenceConfig.Builder, EvaluationInferenceConfig> {
    private static final SdkField<List<EvaluationModelConfig>> MODELS_FIELD = SdkField
            .<List<EvaluationModelConfig>> builder(MarshallingType.LIST)
            .memberName("models")
            .getter(getter(EvaluationInferenceConfig::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationModelConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationModelConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RAGConfig>> RAG_CONFIGS_FIELD = SdkField
            .<List<RAGConfig>> builder(MarshallingType.LIST)
            .memberName("ragConfigs")
            .getter(getter(EvaluationInferenceConfig::ragConfigs))
            .setter(setter(Builder::ragConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ragConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RAGConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RAGConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODELS_FIELD,
            RAG_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EvaluationModelConfig> models;

    private final List<RAGConfig> ragConfigs;

    private final Type type;

    private EvaluationInferenceConfig(BuilderImpl builder) {
        this.models = builder.models;
        this.ragConfigs = builder.ragConfigs;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the inference models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return Specifies the inference models.
     */
    public final List<EvaluationModelConfig> models() {
        return models;
    }

    /**
     * For responses, this returns true if the service returned a value for the RagConfigs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRagConfigs() {
        return ragConfigs != null && !(ragConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the configuration details of the inference for a knowledge base evaluation job, including either the
     * retrieval only configuration or the retrieval with response generation configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRagConfigs} method.
     * </p>
     * 
     * @return Contains the configuration details of the inference for a knowledge base evaluation job, including either
     *         the retrieval only configuration or the retrieval with response generation configuration.
     */
    public final List<RAGConfig> ragConfigs() {
        return ragConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRagConfigs() ? ragConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationInferenceConfig)) {
            return false;
        }
        EvaluationInferenceConfig other = (EvaluationInferenceConfig) obj;
        return hasModels() == other.hasModels() && Objects.equals(models(), other.models())
                && hasRagConfigs() == other.hasRagConfigs() && Objects.equals(ragConfigs(), other.ragConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationInferenceConfig").add("Models", hasModels() ? models() : null)
                .add("RagConfigs", hasRagConfigs() ? ragConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        case "ragConfigs":
            return Optional.ofNullable(clazz.cast(ragConfigs()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #models()} initialized to the given value.
     *
     * <p>
     * Specifies the inference models.
     * </p>
     * 
     * @param models
     *        Specifies the inference models.
     */
    public static EvaluationInferenceConfig fromModels(List<EvaluationModelConfig> models) {
        return builder().models(models).build();
    }

    /**
     * Create an instance of this class with {@link #ragConfigs()} initialized to the given value.
     *
     * <p>
     * Contains the configuration details of the inference for a knowledge base evaluation job, including either the
     * retrieval only configuration or the retrieval with response generation configuration.
     * </p>
     * 
     * @param ragConfigs
     *        Contains the configuration details of the inference for a knowledge base evaluation job, including either
     *        the retrieval only configuration or the retrieval with response generation configuration.
     */
    public static EvaluationInferenceConfig fromRagConfigs(List<RAGConfig> ragConfigs) {
        return builder().ragConfigs(ragConfigs).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("models", MODELS_FIELD);
        map.put("ragConfigs", RAG_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationInferenceConfig, T> g) {
        return obj -> g.apply((EvaluationInferenceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationInferenceConfig> {
        /**
         * <p>
         * Specifies the inference models.
         * </p>
         * 
         * @param models
         *        Specifies the inference models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<EvaluationModelConfig> models);

        /**
         * <p>
         * Specifies the inference models.
         * </p>
         * 
         * @param models
         *        Specifies the inference models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(EvaluationModelConfig... models);

        /**
         * <p>
         * Specifies the inference models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #models(List<EvaluationModelConfig>)}.
         * 
         * @param models
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(java.util.Collection<EvaluationModelConfig>)
         */
        Builder models(Consumer<EvaluationModelConfig.Builder>... models);

        /**
         * <p>
         * Contains the configuration details of the inference for a knowledge base evaluation job, including either the
         * retrieval only configuration or the retrieval with response generation configuration.
         * </p>
         * 
         * @param ragConfigs
         *        Contains the configuration details of the inference for a knowledge base evaluation job, including
         *        either the retrieval only configuration or the retrieval with response generation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ragConfigs(Collection<RAGConfig> ragConfigs);

        /**
         * <p>
         * Contains the configuration details of the inference for a knowledge base evaluation job, including either the
         * retrieval only configuration or the retrieval with response generation configuration.
         * </p>
         * 
         * @param ragConfigs
         *        Contains the configuration details of the inference for a knowledge base evaluation job, including
         *        either the retrieval only configuration or the retrieval with response generation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ragConfigs(RAGConfig... ragConfigs);

        /**
         * <p>
         * Contains the configuration details of the inference for a knowledge base evaluation job, including either the
         * retrieval only configuration or the retrieval with response generation configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.RAGConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrock.model.RAGConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.RAGConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #ragConfigs(List<RAGConfig>)}.
         * 
         * @param ragConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.RAGConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ragConfigs(java.util.Collection<RAGConfig>)
         */
        Builder ragConfigs(Consumer<RAGConfig.Builder>... ragConfigs);
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationModelConfig> models = DefaultSdkAutoConstructList.getInstance();

        private List<RAGConfig> ragConfigs = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationInferenceConfig model) {
            models(model.models);
            ragConfigs(model.ragConfigs);
        }

        public final List<EvaluationModelConfig.Builder> getModels() {
            List<EvaluationModelConfig.Builder> result = EvaluationModelConfigsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<EvaluationModelConfig.BuilderImpl> models) {
            Object oldValue = this.models;
            this.models = EvaluationModelConfigsCopier.copyFromBuilder(models);
            handleUnionValueChange(Type.MODELS, oldValue, this.models);
        }

        @Override
        public final Builder models(Collection<EvaluationModelConfig> models) {
            Object oldValue = this.models;
            this.models = EvaluationModelConfigsCopier.copy(models);
            handleUnionValueChange(Type.MODELS, oldValue, this.models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(EvaluationModelConfig... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<EvaluationModelConfig.Builder>... models) {
            models(Stream.of(models).map(c -> EvaluationModelConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RAGConfig.Builder> getRagConfigs() {
            List<RAGConfig.Builder> result = RagConfigsCopier.copyToBuilder(this.ragConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRagConfigs(Collection<RAGConfig.BuilderImpl> ragConfigs) {
            Object oldValue = this.ragConfigs;
            this.ragConfigs = RagConfigsCopier.copyFromBuilder(ragConfigs);
            handleUnionValueChange(Type.RAG_CONFIGS, oldValue, this.ragConfigs);
        }

        @Override
        public final Builder ragConfigs(Collection<RAGConfig> ragConfigs) {
            Object oldValue = this.ragConfigs;
            this.ragConfigs = RagConfigsCopier.copy(ragConfigs);
            handleUnionValueChange(Type.RAG_CONFIGS, oldValue, this.ragConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ragConfigs(RAGConfig... ragConfigs) {
            ragConfigs(Arrays.asList(ragConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ragConfigs(Consumer<RAGConfig.Builder>... ragConfigs) {
            ragConfigs(Stream.of(ragConfigs).map(c -> RAGConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EvaluationInferenceConfig build() {
            return new EvaluationInferenceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationInferenceConfig#type()
     */
    public enum Type {
        MODELS,

        RAG_CONFIGS,

        UNKNOWN_TO_SDK_VERSION
    }
}
