/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the models used in an Amazon Bedrock model evaluation job. These resources can be models in Amazon
 * Bedrock or models outside of Amazon Bedrock that you use to generate your own inference response data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationModelConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationModelConfigSummary.Builder, EvaluationModelConfigSummary> {
    private static final SdkField<List<String>> BEDROCK_MODEL_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("bedrockModelIdentifiers")
            .getter(getter(EvaluationModelConfigSummary::bedrockModelIdentifiers))
            .setter(setter(Builder::bedrockModelIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PRECOMPUTED_INFERENCE_SOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("precomputedInferenceSourceIdentifiers")
            .getter(getter(EvaluationModelConfigSummary::precomputedInferenceSourceIdentifiers))
            .setter(setter(Builder::precomputedInferenceSourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("precomputedInferenceSourceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BEDROCK_MODEL_IDENTIFIERS_FIELD, PRECOMPUTED_INFERENCE_SOURCE_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> bedrockModelIdentifiers;

    private final List<String> precomputedInferenceSourceIdentifiers;

    private EvaluationModelConfigSummary(BuilderImpl builder) {
        this.bedrockModelIdentifiers = builder.bedrockModelIdentifiers;
        this.precomputedInferenceSourceIdentifiers = builder.precomputedInferenceSourceIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the BedrockModelIdentifiers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBedrockModelIdentifiers() {
        return bedrockModelIdentifiers != null && !(bedrockModelIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the models used for the evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBedrockModelIdentifiers} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the models used for the evaluation job.
     */
    public final List<String> bedrockModelIdentifiers() {
        return bedrockModelIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrecomputedInferenceSourceIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPrecomputedInferenceSourceIdentifiers() {
        return precomputedInferenceSourceIdentifiers != null
                && !(precomputedInferenceSourceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A label that identifies the models used for a model evaluation job where you provide your own inference response
     * data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrecomputedInferenceSourceIdentifiers}
     * method.
     * </p>
     * 
     * @return A label that identifies the models used for a model evaluation job where you provide your own inference
     *         response data.
     */
    public final List<String> precomputedInferenceSourceIdentifiers() {
        return precomputedInferenceSourceIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBedrockModelIdentifiers() ? bedrockModelIdentifiers() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPrecomputedInferenceSourceIdentifiers() ? precomputedInferenceSourceIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationModelConfigSummary)) {
            return false;
        }
        EvaluationModelConfigSummary other = (EvaluationModelConfigSummary) obj;
        return hasBedrockModelIdentifiers() == other.hasBedrockModelIdentifiers()
                && Objects.equals(bedrockModelIdentifiers(), other.bedrockModelIdentifiers())
                && hasPrecomputedInferenceSourceIdentifiers() == other.hasPrecomputedInferenceSourceIdentifiers()
                && Objects.equals(precomputedInferenceSourceIdentifiers(), other.precomputedInferenceSourceIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EvaluationModelConfigSummary")
                .add("BedrockModelIdentifiers", hasBedrockModelIdentifiers() ? bedrockModelIdentifiers() : null)
                .add("PrecomputedInferenceSourceIdentifiers",
                        hasPrecomputedInferenceSourceIdentifiers() ? precomputedInferenceSourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockModelIdentifiers":
            return Optional.ofNullable(clazz.cast(bedrockModelIdentifiers()));
        case "precomputedInferenceSourceIdentifiers":
            return Optional.ofNullable(clazz.cast(precomputedInferenceSourceIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bedrockModelIdentifiers", BEDROCK_MODEL_IDENTIFIERS_FIELD);
        map.put("precomputedInferenceSourceIdentifiers", PRECOMPUTED_INFERENCE_SOURCE_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationModelConfigSummary, T> g) {
        return obj -> g.apply((EvaluationModelConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationModelConfigSummary> {
        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the models used for the evaluation job.
         * </p>
         * 
         * @param bedrockModelIdentifiers
         *        The Amazon Resource Names (ARNs) of the models used for the evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockModelIdentifiers(Collection<String> bedrockModelIdentifiers);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the models used for the evaluation job.
         * </p>
         * 
         * @param bedrockModelIdentifiers
         *        The Amazon Resource Names (ARNs) of the models used for the evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockModelIdentifiers(String... bedrockModelIdentifiers);

        /**
         * <p>
         * A label that identifies the models used for a model evaluation job where you provide your own inference
         * response data.
         * </p>
         * 
         * @param precomputedInferenceSourceIdentifiers
         *        A label that identifies the models used for a model evaluation job where you provide your own
         *        inference response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precomputedInferenceSourceIdentifiers(Collection<String> precomputedInferenceSourceIdentifiers);

        /**
         * <p>
         * A label that identifies the models used for a model evaluation job where you provide your own inference
         * response data.
         * </p>
         * 
         * @param precomputedInferenceSourceIdentifiers
         *        A label that identifies the models used for a model evaluation job where you provide your own
         *        inference response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precomputedInferenceSourceIdentifiers(String... precomputedInferenceSourceIdentifiers);
    }

    static final class BuilderImpl implements Builder {
        private List<String> bedrockModelIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> precomputedInferenceSourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationModelConfigSummary model) {
            bedrockModelIdentifiers(model.bedrockModelIdentifiers);
            precomputedInferenceSourceIdentifiers(model.precomputedInferenceSourceIdentifiers);
        }

        public final Collection<String> getBedrockModelIdentifiers() {
            if (bedrockModelIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return bedrockModelIdentifiers;
        }

        public final void setBedrockModelIdentifiers(Collection<String> bedrockModelIdentifiers) {
            this.bedrockModelIdentifiers = EvaluationBedrockModelIdentifiersCopier.copy(bedrockModelIdentifiers);
        }

        @Override
        public final Builder bedrockModelIdentifiers(Collection<String> bedrockModelIdentifiers) {
            this.bedrockModelIdentifiers = EvaluationBedrockModelIdentifiersCopier.copy(bedrockModelIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bedrockModelIdentifiers(String... bedrockModelIdentifiers) {
            bedrockModelIdentifiers(Arrays.asList(bedrockModelIdentifiers));
            return this;
        }

        public final Collection<String> getPrecomputedInferenceSourceIdentifiers() {
            if (precomputedInferenceSourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return precomputedInferenceSourceIdentifiers;
        }

        public final void setPrecomputedInferenceSourceIdentifiers(Collection<String> precomputedInferenceSourceIdentifiers) {
            this.precomputedInferenceSourceIdentifiers = EvaluationPrecomputedInferenceSourceIdentifiersCopier
                    .copy(precomputedInferenceSourceIdentifiers);
        }

        @Override
        public final Builder precomputedInferenceSourceIdentifiers(Collection<String> precomputedInferenceSourceIdentifiers) {
            this.precomputedInferenceSourceIdentifiers = EvaluationPrecomputedInferenceSourceIdentifiersCopier
                    .copy(precomputedInferenceSourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder precomputedInferenceSourceIdentifiers(String... precomputedInferenceSourceIdentifiers) {
            precomputedInferenceSourceIdentifiers(Arrays.asList(precomputedInferenceSourceIdentifiers));
            return this;
        }

        @Override
        public EvaluationModelConfigSummary build() {
            return new EvaluationModelConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
