/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you provide your own
 * inference response data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationPrecomputedRetrieveAndGenerateSourceConfig
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<EvaluationPrecomputedRetrieveAndGenerateSourceConfig.Builder, EvaluationPrecomputedRetrieveAndGenerateSourceConfig> {
    private static final SdkField<String> RAG_SOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ragSourceIdentifier")
            .getter(getter(EvaluationPrecomputedRetrieveAndGenerateSourceConfig::ragSourceIdentifier))
            .setter(setter(Builder::ragSourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ragSourceIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAG_SOURCE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ragSourceIdentifier;

    private EvaluationPrecomputedRetrieveAndGenerateSourceConfig(BuilderImpl builder) {
        this.ragSourceIdentifier = builder.ragSourceIdentifier;
    }

    /**
     * <p>
     * A label that identifies the RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you
     * provide your own inference response data.
     * </p>
     * 
     * @return A label that identifies the RAG source used for a retrieve-and-generate Knowledge Base evaluation job
     *         where you provide your own inference response data.
     */
    public final String ragSourceIdentifier() {
        return ragSourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ragSourceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationPrecomputedRetrieveAndGenerateSourceConfig)) {
            return false;
        }
        EvaluationPrecomputedRetrieveAndGenerateSourceConfig other = (EvaluationPrecomputedRetrieveAndGenerateSourceConfig) obj;
        return Objects.equals(ragSourceIdentifier(), other.ragSourceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationPrecomputedRetrieveAndGenerateSourceConfig")
                .add("RagSourceIdentifier", ragSourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ragSourceIdentifier":
            return Optional.ofNullable(clazz.cast(ragSourceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ragSourceIdentifier", RAG_SOURCE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationPrecomputedRetrieveAndGenerateSourceConfig, T> g) {
        return obj -> g.apply((EvaluationPrecomputedRetrieveAndGenerateSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationPrecomputedRetrieveAndGenerateSourceConfig> {
        /**
         * <p>
         * A label that identifies the RAG source used for a retrieve-and-generate Knowledge Base evaluation job where
         * you provide your own inference response data.
         * </p>
         * 
         * @param ragSourceIdentifier
         *        A label that identifies the RAG source used for a retrieve-and-generate Knowledge Base evaluation job
         *        where you provide your own inference response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ragSourceIdentifier(String ragSourceIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String ragSourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationPrecomputedRetrieveAndGenerateSourceConfig model) {
            ragSourceIdentifier(model.ragSourceIdentifier);
        }

        public final String getRagSourceIdentifier() {
            return ragSourceIdentifier;
        }

        public final void setRagSourceIdentifier(String ragSourceIdentifier) {
            this.ragSourceIdentifier = ragSourceIdentifier;
        }

        @Override
        public final Builder ragSourceIdentifier(String ragSourceIdentifier) {
            this.ragSourceIdentifier = ragSourceIdentifier;
            return this;
        }

        @Override
        public EvaluationPrecomputedRetrieveAndGenerateSourceConfig build() {
            return new EvaluationPrecomputedRetrieveAndGenerateSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
