/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the RAG resources used in an Amazon Bedrock Knowledge Base evaluation job. These resources can be
 * Knowledge Bases in Amazon Bedrock or RAG sources outside of Amazon Bedrock that you use to generate your own
 * inference response data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationRagConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationRagConfigSummary.Builder, EvaluationRagConfigSummary> {
    private static final SdkField<List<String>> BEDROCK_KNOWLEDGE_BASE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("bedrockKnowledgeBaseIdentifiers")
            .getter(getter(EvaluationRagConfigSummary::bedrockKnowledgeBaseIdentifiers))
            .setter(setter(Builder::bedrockKnowledgeBaseIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockKnowledgeBaseIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PRECOMPUTED_RAG_SOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("precomputedRagSourceIdentifiers")
            .getter(getter(EvaluationRagConfigSummary::precomputedRagSourceIdentifiers))
            .setter(setter(Builder::precomputedRagSourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("precomputedRagSourceIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BEDROCK_KNOWLEDGE_BASE_IDENTIFIERS_FIELD, PRECOMPUTED_RAG_SOURCE_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> bedrockKnowledgeBaseIdentifiers;

    private final List<String> precomputedRagSourceIdentifiers;

    private EvaluationRagConfigSummary(BuilderImpl builder) {
        this.bedrockKnowledgeBaseIdentifiers = builder.bedrockKnowledgeBaseIdentifiers;
        this.precomputedRagSourceIdentifiers = builder.precomputedRagSourceIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the BedrockKnowledgeBaseIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasBedrockKnowledgeBaseIdentifiers() {
        return bedrockKnowledgeBaseIdentifiers != null && !(bedrockKnowledgeBaseIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the Knowledge Base resources used for a Knowledge Base evaluation job where
     * Amazon Bedrock invokes the Knowledge Base for you.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBedrockKnowledgeBaseIdentifiers}
     * method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the Knowledge Base resources used for a Knowledge Base evaluation job
     *         where Amazon Bedrock invokes the Knowledge Base for you.
     */
    public final List<String> bedrockKnowledgeBaseIdentifiers() {
        return bedrockKnowledgeBaseIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrecomputedRagSourceIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPrecomputedRagSourceIdentifiers() {
        return precomputedRagSourceIdentifiers != null && !(precomputedRagSourceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A label that identifies the RAG sources used for a Knowledge Base evaluation job where you provide your own
     * inference response data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrecomputedRagSourceIdentifiers}
     * method.
     * </p>
     * 
     * @return A label that identifies the RAG sources used for a Knowledge Base evaluation job where you provide your
     *         own inference response data.
     */
    public final List<String> precomputedRagSourceIdentifiers() {
        return precomputedRagSourceIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasBedrockKnowledgeBaseIdentifiers() ? bedrockKnowledgeBaseIdentifiers() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPrecomputedRagSourceIdentifiers() ? precomputedRagSourceIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationRagConfigSummary)) {
            return false;
        }
        EvaluationRagConfigSummary other = (EvaluationRagConfigSummary) obj;
        return hasBedrockKnowledgeBaseIdentifiers() == other.hasBedrockKnowledgeBaseIdentifiers()
                && Objects.equals(bedrockKnowledgeBaseIdentifiers(), other.bedrockKnowledgeBaseIdentifiers())
                && hasPrecomputedRagSourceIdentifiers() == other.hasPrecomputedRagSourceIdentifiers()
                && Objects.equals(precomputedRagSourceIdentifiers(), other.precomputedRagSourceIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EvaluationRagConfigSummary")
                .add("BedrockKnowledgeBaseIdentifiers",
                        hasBedrockKnowledgeBaseIdentifiers() ? bedrockKnowledgeBaseIdentifiers() : null)
                .add("PrecomputedRagSourceIdentifiers",
                        hasPrecomputedRagSourceIdentifiers() ? precomputedRagSourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockKnowledgeBaseIdentifiers":
            return Optional.ofNullable(clazz.cast(bedrockKnowledgeBaseIdentifiers()));
        case "precomputedRagSourceIdentifiers":
            return Optional.ofNullable(clazz.cast(precomputedRagSourceIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bedrockKnowledgeBaseIdentifiers", BEDROCK_KNOWLEDGE_BASE_IDENTIFIERS_FIELD);
        map.put("precomputedRagSourceIdentifiers", PRECOMPUTED_RAG_SOURCE_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationRagConfigSummary, T> g) {
        return obj -> g.apply((EvaluationRagConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationRagConfigSummary> {
        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Knowledge Base resources used for a Knowledge Base evaluation job
         * where Amazon Bedrock invokes the Knowledge Base for you.
         * </p>
         * 
         * @param bedrockKnowledgeBaseIdentifiers
         *        The Amazon Resource Names (ARNs) of the Knowledge Base resources used for a Knowledge Base evaluation
         *        job where Amazon Bedrock invokes the Knowledge Base for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockKnowledgeBaseIdentifiers(Collection<String> bedrockKnowledgeBaseIdentifiers);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Knowledge Base resources used for a Knowledge Base evaluation job
         * where Amazon Bedrock invokes the Knowledge Base for you.
         * </p>
         * 
         * @param bedrockKnowledgeBaseIdentifiers
         *        The Amazon Resource Names (ARNs) of the Knowledge Base resources used for a Knowledge Base evaluation
         *        job where Amazon Bedrock invokes the Knowledge Base for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockKnowledgeBaseIdentifiers(String... bedrockKnowledgeBaseIdentifiers);

        /**
         * <p>
         * A label that identifies the RAG sources used for a Knowledge Base evaluation job where you provide your own
         * inference response data.
         * </p>
         * 
         * @param precomputedRagSourceIdentifiers
         *        A label that identifies the RAG sources used for a Knowledge Base evaluation job where you provide
         *        your own inference response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precomputedRagSourceIdentifiers(Collection<String> precomputedRagSourceIdentifiers);

        /**
         * <p>
         * A label that identifies the RAG sources used for a Knowledge Base evaluation job where you provide your own
         * inference response data.
         * </p>
         * 
         * @param precomputedRagSourceIdentifiers
         *        A label that identifies the RAG sources used for a Knowledge Base evaluation job where you provide
         *        your own inference response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precomputedRagSourceIdentifiers(String... precomputedRagSourceIdentifiers);
    }

    static final class BuilderImpl implements Builder {
        private List<String> bedrockKnowledgeBaseIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> precomputedRagSourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationRagConfigSummary model) {
            bedrockKnowledgeBaseIdentifiers(model.bedrockKnowledgeBaseIdentifiers);
            precomputedRagSourceIdentifiers(model.precomputedRagSourceIdentifiers);
        }

        public final Collection<String> getBedrockKnowledgeBaseIdentifiers() {
            if (bedrockKnowledgeBaseIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return bedrockKnowledgeBaseIdentifiers;
        }

        public final void setBedrockKnowledgeBaseIdentifiers(Collection<String> bedrockKnowledgeBaseIdentifiers) {
            this.bedrockKnowledgeBaseIdentifiers = EvaluationBedrockKnowledgeBaseIdentifiersCopier
                    .copy(bedrockKnowledgeBaseIdentifiers);
        }

        @Override
        public final Builder bedrockKnowledgeBaseIdentifiers(Collection<String> bedrockKnowledgeBaseIdentifiers) {
            this.bedrockKnowledgeBaseIdentifiers = EvaluationBedrockKnowledgeBaseIdentifiersCopier
                    .copy(bedrockKnowledgeBaseIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bedrockKnowledgeBaseIdentifiers(String... bedrockKnowledgeBaseIdentifiers) {
            bedrockKnowledgeBaseIdentifiers(Arrays.asList(bedrockKnowledgeBaseIdentifiers));
            return this;
        }

        public final Collection<String> getPrecomputedRagSourceIdentifiers() {
            if (precomputedRagSourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return precomputedRagSourceIdentifiers;
        }

        public final void setPrecomputedRagSourceIdentifiers(Collection<String> precomputedRagSourceIdentifiers) {
            this.precomputedRagSourceIdentifiers = EvaluationPrecomputedRagSourceIdentifiersCopier
                    .copy(precomputedRagSourceIdentifiers);
        }

        @Override
        public final Builder precomputedRagSourceIdentifiers(Collection<String> precomputedRagSourceIdentifiers) {
            this.precomputedRagSourceIdentifiers = EvaluationPrecomputedRagSourceIdentifiersCopier
                    .copy(precomputedRagSourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder precomputedRagSourceIdentifiers(String... precomputedRagSourceIdentifiers) {
            precomputedRagSourceIdentifiers(Arrays.asList(precomputedRagSourceIdentifiers));
            return this;
        }

        @Override
        public EvaluationRagConfigSummary build() {
            return new EvaluationRagConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
