/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelCopyJobResponse extends BedrockResponse implements
        ToCopyableBuilder<GetModelCopyJobResponse.Builder, GetModelCopyJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetModelCopyJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetModelCopyJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetModelCopyJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TARGET_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetModelArn").getter(getter(GetModelCopyJobResponse::targetModelArn))
            .setter(setter(Builder::targetModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelArn").build()).build();

    private static final SdkField<String> TARGET_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetModelName").getter(getter(GetModelCopyJobResponse::targetModelName))
            .setter(setter(Builder::targetModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelName").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccountId").getter(getter(GetModelCopyJobResponse::sourceAccountId))
            .setter(setter(Builder::sourceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountId").build()).build();

    private static final SdkField<String> SOURCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceModelArn").getter(getter(GetModelCopyJobResponse::sourceModelArn))
            .setter(setter(Builder::sourceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceModelArn").build()).build();

    private static final SdkField<String> TARGET_MODEL_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetModelKmsKeyArn").getter(getter(GetModelCopyJobResponse::targetModelKmsKeyArn))
            .setter(setter(Builder::targetModelKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelKmsKeyArn").build())
            .build();

    private static final SdkField<List<Tag>> TARGET_MODEL_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("targetModelTags")
            .getter(getter(GetModelCopyJobResponse::targetModelTags))
            .setter(setter(Builder::targetModelTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(GetModelCopyJobResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<String> SOURCE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceModelName").getter(getter(GetModelCopyJobResponse::sourceModelName))
            .setter(setter(Builder::sourceModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, STATUS_FIELD,
            CREATION_TIME_FIELD, TARGET_MODEL_ARN_FIELD, TARGET_MODEL_NAME_FIELD, SOURCE_ACCOUNT_ID_FIELD,
            SOURCE_MODEL_ARN_FIELD, TARGET_MODEL_KMS_KEY_ARN_FIELD, TARGET_MODEL_TAGS_FIELD, FAILURE_MESSAGE_FIELD,
            SOURCE_MODEL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobArn;

    private final String status;

    private final Instant creationTime;

    private final String targetModelArn;

    private final String targetModelName;

    private final String sourceAccountId;

    private final String sourceModelArn;

    private final String targetModelKmsKeyArn;

    private final List<Tag> targetModelTags;

    private final String failureMessage;

    private final String sourceModelName;

    private GetModelCopyJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.targetModelArn = builder.targetModelArn;
        this.targetModelName = builder.targetModelName;
        this.sourceAccountId = builder.sourceAccountId;
        this.sourceModelArn = builder.sourceModelArn;
        this.targetModelKmsKeyArn = builder.targetModelKmsKeyArn;
        this.targetModelTags = builder.targetModelTags;
        this.failureMessage = builder.failureMessage;
        this.sourceModelName = builder.sourceModelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model copy job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model copy job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The status of the model copy job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCopyJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the model copy job.
     * @see ModelCopyJobStatus
     */
    public final ModelCopyJobStatus status() {
        return ModelCopyJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the model copy job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCopyJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the model copy job.
     * @see ModelCopyJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the model copy job was created.
     * </p>
     * 
     * @return The time at which the model copy job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the copied model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the copied model.
     */
    public final String targetModelArn() {
        return targetModelArn;
    }

    /**
     * <p>
     * The name of the copied model.
     * </p>
     * 
     * @return The name of the copied model.
     */
    public final String targetModelName() {
        return targetModelName;
    }

    /**
     * <p>
     * The unique identifier of the account that the model being copied originated from.
     * </p>
     * 
     * @return The unique identifier of the account that the model being copied originated from.
     */
    public final String sourceAccountId() {
        return sourceAccountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the original model being copied.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the original model being copied.
     */
    public final String sourceModelArn() {
        return sourceModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key encrypting the copied model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key encrypting the copied model.
     */
    public final String targetModelKmsKeyArn() {
        return targetModelKmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetModelTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetModelTags() {
        return targetModelTags != null && !(targetModelTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the copied model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetModelTags} method.
     * </p>
     * 
     * @return The tags associated with the copied model.
     */
    public final List<Tag> targetModelTags() {
        return targetModelTags;
    }

    /**
     * <p>
     * An error message for why the model copy job failed.
     * </p>
     * 
     * @return An error message for why the model copy job failed.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The name of the original model being copied.
     * </p>
     * 
     * @return The name of the original model being copied.
     */
    public final String sourceModelName() {
        return sourceModelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(targetModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetModelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetModelTags() ? targetModelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(sourceModelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelCopyJobResponse)) {
            return false;
        }
        GetModelCopyJobResponse other = (GetModelCopyJobResponse) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(targetModelArn(), other.targetModelArn())
                && Objects.equals(targetModelName(), other.targetModelName())
                && Objects.equals(sourceAccountId(), other.sourceAccountId())
                && Objects.equals(sourceModelArn(), other.sourceModelArn())
                && Objects.equals(targetModelKmsKeyArn(), other.targetModelKmsKeyArn())
                && hasTargetModelTags() == other.hasTargetModelTags()
                && Objects.equals(targetModelTags(), other.targetModelTags())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(sourceModelName(), other.sourceModelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetModelCopyJobResponse").add("JobArn", jobArn()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("TargetModelArn", targetModelArn())
                .add("TargetModelName", targetModelName()).add("SourceAccountId", sourceAccountId())
                .add("SourceModelArn", sourceModelArn()).add("TargetModelKmsKeyArn", targetModelKmsKeyArn())
                .add("TargetModelTags", hasTargetModelTags() ? targetModelTags() : null).add("FailureMessage", failureMessage())
                .add("SourceModelName", sourceModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "targetModelArn":
            return Optional.ofNullable(clazz.cast(targetModelArn()));
        case "targetModelName":
            return Optional.ofNullable(clazz.cast(targetModelName()));
        case "sourceAccountId":
            return Optional.ofNullable(clazz.cast(sourceAccountId()));
        case "sourceModelArn":
            return Optional.ofNullable(clazz.cast(sourceModelArn()));
        case "targetModelKmsKeyArn":
            return Optional.ofNullable(clazz.cast(targetModelKmsKeyArn()));
        case "targetModelTags":
            return Optional.ofNullable(clazz.cast(targetModelTags()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "sourceModelName":
            return Optional.ofNullable(clazz.cast(sourceModelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("targetModelArn", TARGET_MODEL_ARN_FIELD);
        map.put("targetModelName", TARGET_MODEL_NAME_FIELD);
        map.put("sourceAccountId", SOURCE_ACCOUNT_ID_FIELD);
        map.put("sourceModelArn", SOURCE_MODEL_ARN_FIELD);
        map.put("targetModelKmsKeyArn", TARGET_MODEL_KMS_KEY_ARN_FIELD);
        map.put("targetModelTags", TARGET_MODEL_TAGS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("sourceModelName", SOURCE_MODEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetModelCopyJobResponse, T> g) {
        return obj -> g.apply((GetModelCopyJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetModelCopyJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model copy job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the model copy job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The status of the model copy job.
         * </p>
         * 
         * @param status
         *        The status of the model copy job.
         * @see ModelCopyJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCopyJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the model copy job.
         * </p>
         * 
         * @param status
         *        The status of the model copy job.
         * @see ModelCopyJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCopyJobStatus
         */
        Builder status(ModelCopyJobStatus status);

        /**
         * <p>
         * The time at which the model copy job was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the model copy job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the copied model.
         * </p>
         * 
         * @param targetModelArn
         *        The Amazon Resource Name (ARN) of the copied model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelArn(String targetModelArn);

        /**
         * <p>
         * The name of the copied model.
         * </p>
         * 
         * @param targetModelName
         *        The name of the copied model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelName(String targetModelName);

        /**
         * <p>
         * The unique identifier of the account that the model being copied originated from.
         * </p>
         * 
         * @param sourceAccountId
         *        The unique identifier of the account that the model being copied originated from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountId(String sourceAccountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the original model being copied.
         * </p>
         * 
         * @param sourceModelArn
         *        The Amazon Resource Name (ARN) of the original model being copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceModelArn(String sourceModelArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key encrypting the copied model.
         * </p>
         * 
         * @param targetModelKmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key encrypting the copied model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelKmsKeyArn(String targetModelKmsKeyArn);

        /**
         * <p>
         * The tags associated with the copied model.
         * </p>
         * 
         * @param targetModelTags
         *        The tags associated with the copied model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelTags(Collection<Tag> targetModelTags);

        /**
         * <p>
         * The tags associated with the copied model.
         * </p>
         * 
         * @param targetModelTags
         *        The tags associated with the copied model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelTags(Tag... targetModelTags);

        /**
         * <p>
         * The tags associated with the copied model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #targetModelTags(List<Tag>)}.
         * 
         * @param targetModelTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetModelTags(java.util.Collection<Tag>)
         */
        Builder targetModelTags(Consumer<Tag.Builder>... targetModelTags);

        /**
         * <p>
         * An error message for why the model copy job failed.
         * </p>
         * 
         * @param failureMessage
         *        An error message for why the model copy job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The name of the original model being copied.
         * </p>
         * 
         * @param sourceModelName
         *        The name of the original model being copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceModelName(String sourceModelName);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String jobArn;

        private String status;

        private Instant creationTime;

        private String targetModelArn;

        private String targetModelName;

        private String sourceAccountId;

        private String sourceModelArn;

        private String targetModelKmsKeyArn;

        private List<Tag> targetModelTags = DefaultSdkAutoConstructList.getInstance();

        private String failureMessage;

        private String sourceModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelCopyJobResponse model) {
            super(model);
            jobArn(model.jobArn);
            status(model.status);
            creationTime(model.creationTime);
            targetModelArn(model.targetModelArn);
            targetModelName(model.targetModelName);
            sourceAccountId(model.sourceAccountId);
            sourceModelArn(model.sourceModelArn);
            targetModelKmsKeyArn(model.targetModelKmsKeyArn);
            targetModelTags(model.targetModelTags);
            failureMessage(model.failureMessage);
            sourceModelName(model.sourceModelName);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCopyJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getTargetModelArn() {
            return targetModelArn;
        }

        public final void setTargetModelArn(String targetModelArn) {
            this.targetModelArn = targetModelArn;
        }

        @Override
        public final Builder targetModelArn(String targetModelArn) {
            this.targetModelArn = targetModelArn;
            return this;
        }

        public final String getTargetModelName() {
            return targetModelName;
        }

        public final void setTargetModelName(String targetModelName) {
            this.targetModelName = targetModelName;
        }

        @Override
        public final Builder targetModelName(String targetModelName) {
            this.targetModelName = targetModelName;
            return this;
        }

        public final String getSourceAccountId() {
            return sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final String getSourceModelArn() {
            return sourceModelArn;
        }

        public final void setSourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
        }

        @Override
        public final Builder sourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
            return this;
        }

        public final String getTargetModelKmsKeyArn() {
            return targetModelKmsKeyArn;
        }

        public final void setTargetModelKmsKeyArn(String targetModelKmsKeyArn) {
            this.targetModelKmsKeyArn = targetModelKmsKeyArn;
        }

        @Override
        public final Builder targetModelKmsKeyArn(String targetModelKmsKeyArn) {
            this.targetModelKmsKeyArn = targetModelKmsKeyArn;
            return this;
        }

        public final List<Tag.Builder> getTargetModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.targetModelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetModelTags(Collection<Tag.BuilderImpl> targetModelTags) {
            this.targetModelTags = TagListCopier.copyFromBuilder(targetModelTags);
        }

        @Override
        public final Builder targetModelTags(Collection<Tag> targetModelTags) {
            this.targetModelTags = TagListCopier.copy(targetModelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetModelTags(Tag... targetModelTags) {
            targetModelTags(Arrays.asList(targetModelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetModelTags(Consumer<Tag.Builder>... targetModelTags) {
            targetModelTags(Stream.of(targetModelTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getSourceModelName() {
            return sourceModelName;
        }

        public final void setSourceModelName(String sourceModelName) {
            this.sourceModelName = sourceModelName;
        }

        @Override
        public final Builder sourceModelName(String sourceModelName) {
            this.sourceModelName = sourceModelName;
            return this;
        }

        @Override
        public GetModelCopyJobResponse build() {
            return new GetModelCopyJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
