/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelInvocationJobResponse extends BedrockResponse implements
        ToCopyableBuilder<GetModelInvocationJobResponse.Builder, GetModelInvocationJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetModelInvocationJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(GetModelInvocationJobResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(GetModelInvocationJobResponse::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(GetModelInvocationJobResponse::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetModelInvocationJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetModelInvocationJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(GetModelInvocationJobResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("submitTime")
            .getter(getter(GetModelInvocationJobResponse::submitTime))
            .setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(GetModelInvocationJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(GetModelInvocationJobResponse::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ModelInvocationJobInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<ModelInvocationJobInputDataConfig> builder(MarshallingType.SDK_POJO).memberName("inputDataConfig")
            .getter(getter(GetModelInvocationJobResponse::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(ModelInvocationJobInputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataConfig").build()).build();

    private static final SdkField<ModelInvocationJobOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<ModelInvocationJobOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(GetModelInvocationJobResponse::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(ModelInvocationJobOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(GetModelInvocationJobResponse::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<Integer> TIMEOUT_DURATION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutDurationInHours").getter(getter(GetModelInvocationJobResponse::timeoutDurationInHours))
            .setter(setter(Builder::timeoutDurationInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutDurationInHours").build())
            .build();

    private static final SdkField<Instant> JOB_EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("jobExpirationTime")
            .getter(getter(GetModelInvocationJobResponse::jobExpirationTime))
            .setter(setter(Builder::jobExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExpirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD,
            MODEL_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, VPC_CONFIG_FIELD,
            TIMEOUT_DURATION_IN_HOURS_FIELD, JOB_EXPIRATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobArn;

    private final String jobName;

    private final String modelId;

    private final String clientRequestToken;

    private final String roleArn;

    private final String status;

    private final String message;

    private final Instant submitTime;

    private final Instant lastModifiedTime;

    private final Instant endTime;

    private final ModelInvocationJobInputDataConfig inputDataConfig;

    private final ModelInvocationJobOutputDataConfig outputDataConfig;

    private final VpcConfig vpcConfig;

    private final Integer timeoutDurationInHours;

    private final Instant jobExpirationTime;

    private GetModelInvocationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.modelId = builder.modelId;
        this.clientRequestToken = builder.clientRequestToken;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.vpcConfig = builder.vpcConfig;
        this.timeoutDurationInHours = builder.timeoutDurationInHours;
        this.jobExpirationTime = builder.jobExpirationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the batch inference job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The name of the batch inference job.
     * </p>
     * 
     * @return The name of the batch inference job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The unique identifier of the foundation model used for model inference.
     * </p>
     * 
     * @return The unique identifier of the foundation model used for model inference.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You
     * can use the console to create a default service role or follow the steps at <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for batch
     * inference</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch
     *         inference. You can use the console to create a default service role or follow the steps at <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for
     *         batch inference</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the batch inference job.
     * </p>
     * <p>
     * The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submitted – This job has been submitted to a queue for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Validating – This job is being validated for the requirements described in <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload your
     * batch inference data</a>. The criteria include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Your IAM service role has access to the Amazon S3 buckets containing your files.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
     * validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your files fulfill the requirements for file size and number of records. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Scheduled – This job has been validated and is now in a queue. The job will automatically start when it reaches
     * its turn.
     * </p>
     * </li>
     * <li>
     * <p>
     * Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration. Submit a
     * new job request.
     * </p>
     * </li>
     * <li>
     * <p>
     * InProgress – This job has begun. You can start viewing the results in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed – This job has successfully completed. View the output files in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * PartiallyCompleted – This job has partially completed. Not all of your records could be processed in time. View
     * the output files in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – This job has failed. Check the failure message for any further details. For further assistance, reach
     * out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web ServicesSupport Center</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopped – This job was stopped by a user.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopping – This job is being stopped by a user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelInvocationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch inference job.</p>
     *         <p>
     *         The following statuses are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Submitted – This job has been submitted to a queue for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Validating – This job is being validated for the requirements described in <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload
     *         your batch inference data</a>. The criteria include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your IAM service role has access to the Amazon S3 buckets containing your files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
     *         validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your files fulfill the requirements for file size and number of records. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Scheduled – This job has been validated and is now in a queue. The job will automatically start when it
     *         reaches its turn.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration.
     *         Submit a new job request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InProgress – This job has begun. You can start viewing the results in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed – This job has successfully completed. View the output files in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PartiallyCompleted – This job has partially completed. Not all of your records could be processed in
     *         time. View the output files in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – This job has failed. Check the failure message for any further details. For further assistance,
     *         reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web ServicesSupport
     *         Center</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopped – This job was stopped by a user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopping – This job is being stopped by a user.
     *         </p>
     *         </li>
     * @see ModelInvocationJobStatus
     */
    public final ModelInvocationJobStatus status() {
        return ModelInvocationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the batch inference job.
     * </p>
     * <p>
     * The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submitted – This job has been submitted to a queue for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Validating – This job is being validated for the requirements described in <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload your
     * batch inference data</a>. The criteria include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Your IAM service role has access to the Amazon S3 buckets containing your files.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
     * validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your files fulfill the requirements for file size and number of records. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Scheduled – This job has been validated and is now in a queue. The job will automatically start when it reaches
     * its turn.
     * </p>
     * </li>
     * <li>
     * <p>
     * Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration. Submit a
     * new job request.
     * </p>
     * </li>
     * <li>
     * <p>
     * InProgress – This job has begun. You can start viewing the results in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed – This job has successfully completed. View the output files in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * PartiallyCompleted – This job has partially completed. Not all of your records could be processed in time. View
     * the output files in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – This job has failed. Check the failure message for any further details. For further assistance, reach
     * out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web ServicesSupport Center</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopped – This job was stopped by a user.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopping – This job is being stopped by a user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelInvocationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch inference job.</p>
     *         <p>
     *         The following statuses are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Submitted – This job has been submitted to a queue for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Validating – This job is being validated for the requirements described in <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload
     *         your batch inference data</a>. The criteria include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your IAM service role has access to the Amazon S3 buckets containing your files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
     *         validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your files fulfill the requirements for file size and number of records. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Scheduled – This job has been validated and is now in a queue. The job will automatically start when it
     *         reaches its turn.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration.
     *         Submit a new job request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InProgress – This job has begun. You can start viewing the results in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed – This job has successfully completed. View the output files in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PartiallyCompleted – This job has partially completed. Not all of your records could be processed in
     *         time. View the output files in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – This job has failed. Check the failure message for any further details. For further assistance,
     *         reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web ServicesSupport
     *         Center</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopped – This job was stopped by a user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopping – This job is being stopped by a user.
     *         </p>
     *         </li>
     * @see ModelInvocationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the batch inference job failed, this field contains a message describing why the job failed.
     * </p>
     * 
     * @return If the batch inference job failed, this field contains a message describing why the job failed.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The time at which the batch inference job was submitted.
     * </p>
     * 
     * @return The time at which the batch inference job was submitted.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * The time at which the batch inference job was last modified.
     * </p>
     * 
     * @return The time at which the batch inference job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The time at which the batch inference job ended.
     * </p>
     * 
     * @return The time at which the batch inference job ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Details about the location of the input to the batch inference job.
     * </p>
     * 
     * @return Details about the location of the input to the batch inference job.
     */
    public final ModelInvocationJobInputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Details about the location of the output of the batch inference job.
     * </p>
     * 
     * @return Details about the location of the output of the batch inference job.
     */
    public final ModelInvocationJobOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more
     * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc">Protect batch inference
     * jobs using a VPC</a>.
     * </p>
     * 
     * @return The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more
     *         information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc">Protect batch
     *         inference jobs using a VPC</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The number of hours after which batch inference job was set to time out.
     * </p>
     * 
     * @return The number of hours after which batch inference job was set to time out.
     */
    public final Integer timeoutDurationInHours() {
        return timeoutDurationInHours;
    }

    /**
     * <p>
     * The time at which the batch inference job times or timed out.
     * </p>
     * 
     * @return The time at which the batch inference job times or timed out.
     */
    public final Instant jobExpirationTime() {
        return jobExpirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(jobExpirationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelInvocationJobResponse)) {
            return false;
        }
        GetModelInvocationJobResponse other = (GetModelInvocationJobResponse) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(modelId(), other.modelId()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(submitTime(), other.submitTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(timeoutDurationInHours(), other.timeoutDurationInHours())
                && Objects.equals(jobExpirationTime(), other.jobExpirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetModelInvocationJobResponse").add("JobArn", jobArn()).add("JobName", jobName())
                .add("ModelId", modelId()).add("ClientRequestToken", clientRequestToken()).add("RoleArn", roleArn())
                .add("Status", statusAsString()).add("Message", message() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SubmitTime", submitTime()).add("LastModifiedTime", lastModifiedTime()).add("EndTime", endTime())
                .add("InputDataConfig", inputDataConfig()).add("OutputDataConfig", outputDataConfig())
                .add("VpcConfig", vpcConfig()).add("TimeoutDurationInHours", timeoutDurationInHours())
                .add("JobExpirationTime", jobExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "submitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "inputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "timeoutDurationInHours":
            return Optional.ofNullable(clazz.cast(timeoutDurationInHours()));
        case "jobExpirationTime":
            return Optional.ofNullable(clazz.cast(jobExpirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("submitTime", SUBMIT_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("inputDataConfig", INPUT_DATA_CONFIG_FIELD);
        map.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("timeoutDurationInHours", TIMEOUT_DURATION_IN_HOURS_FIELD);
        map.put("jobExpirationTime", JOB_EXPIRATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetModelInvocationJobResponse, T> g) {
        return obj -> g.apply((GetModelInvocationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetModelInvocationJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the batch inference job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The name of the batch inference job.
         * </p>
         * 
         * @param jobName
         *        The name of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The unique identifier of the foundation model used for model inference.
         * </p>
         * 
         * @param modelId
         *        The unique identifier of the foundation model used for model inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference.
         * You can use the console to create a default service role or follow the steps at <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for batch
         * inference</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch
         *        inference. You can use the console to create a default service role or follow the steps at <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role
         *        for batch inference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the batch inference job.
         * </p>
         * <p>
         * The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Submitted – This job has been submitted to a queue for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Validating – This job is being validated for the requirements described in <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload your
         * batch inference data</a>. The criteria include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Your IAM service role has access to the Amazon S3 buckets containing your files.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
         * validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your files fulfill the requirements for file size and number of records. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scheduled – This job has been validated and is now in a queue. The job will automatically start when it
         * reaches its turn.
         * </p>
         * </li>
         * <li>
         * <p>
         * Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration.
         * Submit a new job request.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress – This job has begun. You can start viewing the results in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed – This job has successfully completed. View the output files in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * PartiallyCompleted – This job has partially completed. Not all of your records could be processed in time.
         * View the output files in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – This job has failed. Check the failure message for any further details. For further assistance,
         * reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web ServicesSupport
         * Center</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopped – This job was stopped by a user.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopping – This job is being stopped by a user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the batch inference job.</p>
         *        <p>
         *        The following statuses are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Submitted – This job has been submitted to a queue for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Validating – This job is being validated for the requirements described in <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and
         *        upload your batch inference data</a>. The criteria include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Your IAM service role has access to the Amazon S3 buckets containing your files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your files are .jsonl files and each individual record is a JSON object in the correct format. Note
         *        that validation doesn't check if the <code>modelInput</code> value matches the request body for the
         *        model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your files fulfill the requirements for file size and number of records. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scheduled – This job has been validated and is now in a queue. The job will automatically start when
         *        it reaches its turn.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Expired – This job timed out because it was scheduled but didn't begin before the set timeout
         *        duration. Submit a new job request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress – This job has begun. You can start viewing the results in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed – This job has successfully completed. View the output files in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PartiallyCompleted – This job has partially completed. Not all of your records could be processed in
         *        time. View the output files in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – This job has failed. Check the failure message for any further details. For further
         *        assistance, reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web
         *        ServicesSupport Center</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopped – This job was stopped by a user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopping – This job is being stopped by a user.
         *        </p>
         *        </li>
         * @see ModelInvocationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelInvocationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the batch inference job.
         * </p>
         * <p>
         * The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Submitted – This job has been submitted to a queue for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Validating – This job is being validated for the requirements described in <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload your
         * batch inference data</a>. The criteria include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Your IAM service role has access to the Amazon S3 buckets containing your files.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
         * validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your files fulfill the requirements for file size and number of records. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scheduled – This job has been validated and is now in a queue. The job will automatically start when it
         * reaches its turn.
         * </p>
         * </li>
         * <li>
         * <p>
         * Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration.
         * Submit a new job request.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress – This job has begun. You can start viewing the results in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed – This job has successfully completed. View the output files in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * PartiallyCompleted – This job has partially completed. Not all of your records could be processed in time.
         * View the output files in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – This job has failed. Check the failure message for any further details. For further assistance,
         * reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web ServicesSupport
         * Center</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopped – This job was stopped by a user.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopping – This job is being stopped by a user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the batch inference job.</p>
         *        <p>
         *        The following statuses are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Submitted – This job has been submitted to a queue for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Validating – This job is being validated for the requirements described in <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and
         *        upload your batch inference data</a>. The criteria include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Your IAM service role has access to the Amazon S3 buckets containing your files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your files are .jsonl files and each individual record is a JSON object in the correct format. Note
         *        that validation doesn't check if the <code>modelInput</code> value matches the request body for the
         *        model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your files fulfill the requirements for file size and number of records. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scheduled – This job has been validated and is now in a queue. The job will automatically start when
         *        it reaches its turn.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Expired – This job timed out because it was scheduled but didn't begin before the set timeout
         *        duration. Submit a new job request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress – This job has begun. You can start viewing the results in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed – This job has successfully completed. View the output files in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PartiallyCompleted – This job has partially completed. Not all of your records could be processed in
         *        time. View the output files in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – This job has failed. Check the failure message for any further details. For further
         *        assistance, reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web
         *        ServicesSupport Center</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopped – This job was stopped by a user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopping – This job is being stopped by a user.
         *        </p>
         *        </li>
         * @see ModelInvocationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelInvocationJobStatus
         */
        Builder status(ModelInvocationJobStatus status);

        /**
         * <p>
         * If the batch inference job failed, this field contains a message describing why the job failed.
         * </p>
         * 
         * @param message
         *        If the batch inference job failed, this field contains a message describing why the job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time at which the batch inference job was submitted.
         * </p>
         * 
         * @param submitTime
         *        The time at which the batch inference job was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * The time at which the batch inference job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time at which the batch inference job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The time at which the batch inference job ended.
         * </p>
         * 
         * @param endTime
         *        The time at which the batch inference job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Details about the location of the input to the batch inference job.
         * </p>
         * 
         * @param inputDataConfig
         *        Details about the location of the input to the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(ModelInvocationJobInputDataConfig inputDataConfig);

        /**
         * <p>
         * Details about the location of the input to the batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModelInvocationJobInputDataConfig.Builder} avoiding the need to create one manually via
         * {@link ModelInvocationJobInputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationJobInputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDataConfig(ModelInvocationJobInputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link ModelInvocationJobInputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(ModelInvocationJobInputDataConfig)
         */
        default Builder inputDataConfig(Consumer<ModelInvocationJobInputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(ModelInvocationJobInputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * Details about the location of the output of the batch inference job.
         * </p>
         * 
         * @param outputDataConfig
         *        Details about the location of the output of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(ModelInvocationJobOutputDataConfig outputDataConfig);

        /**
         * <p>
         * Details about the location of the output of the batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModelInvocationJobOutputDataConfig.Builder} avoiding the need to create one manually via
         * {@link ModelInvocationJobOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationJobOutputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDataConfig(ModelInvocationJobOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link ModelInvocationJobOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(ModelInvocationJobOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<ModelInvocationJobOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(ModelInvocationJobOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more
         * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc">Protect batch
         * inference jobs using a VPC</a>.
         * </p>
         * 
         * @param vpcConfig
         *        The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more
         *        information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc">Protect
         *        batch inference jobs using a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more
         * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc">Protect batch
         * inference jobs using a VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The number of hours after which batch inference job was set to time out.
         * </p>
         * 
         * @param timeoutDurationInHours
         *        The number of hours after which batch inference job was set to time out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutDurationInHours(Integer timeoutDurationInHours);

        /**
         * <p>
         * The time at which the batch inference job times or timed out.
         * </p>
         * 
         * @param jobExpirationTime
         *        The time at which the batch inference job times or timed out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExpirationTime(Instant jobExpirationTime);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String jobArn;

        private String jobName;

        private String modelId;

        private String clientRequestToken;

        private String roleArn;

        private String status;

        private String message;

        private Instant submitTime;

        private Instant lastModifiedTime;

        private Instant endTime;

        private ModelInvocationJobInputDataConfig inputDataConfig;

        private ModelInvocationJobOutputDataConfig outputDataConfig;

        private VpcConfig vpcConfig;

        private Integer timeoutDurationInHours;

        private Instant jobExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelInvocationJobResponse model) {
            super(model);
            jobArn(model.jobArn);
            jobName(model.jobName);
            modelId(model.modelId);
            clientRequestToken(model.clientRequestToken);
            roleArn(model.roleArn);
            status(model.status);
            message(model.message);
            submitTime(model.submitTime);
            lastModifiedTime(model.lastModifiedTime);
            endTime(model.endTime);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            vpcConfig(model.vpcConfig);
            timeoutDurationInHours(model.timeoutDurationInHours);
            jobExpirationTime(model.jobExpirationTime);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelInvocationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ModelInvocationJobInputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(ModelInvocationJobInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(ModelInvocationJobInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final ModelInvocationJobOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(ModelInvocationJobOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(ModelInvocationJobOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Integer getTimeoutDurationInHours() {
            return timeoutDurationInHours;
        }

        public final void setTimeoutDurationInHours(Integer timeoutDurationInHours) {
            this.timeoutDurationInHours = timeoutDurationInHours;
        }

        @Override
        public final Builder timeoutDurationInHours(Integer timeoutDurationInHours) {
            this.timeoutDurationInHours = timeoutDurationInHours;
            return this;
        }

        public final Instant getJobExpirationTime() {
            return jobExpirationTime;
        }

        public final void setJobExpirationTime(Instant jobExpirationTime) {
            this.jobExpirationTime = jobExpirationTime;
        }

        @Override
        public final Builder jobExpirationTime(Instant jobExpirationTime) {
            this.jobExpirationTime = jobExpirationTime;
            return this;
        }

        @Override
        public GetModelInvocationJobResponse build() {
            return new GetModelInvocationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
