/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about topics for the guardrail to identify and deny.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailTopicConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailTopicConfig.Builder, GuardrailTopicConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GuardrailTopicConfig::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(GuardrailTopicConfig::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<List<String>> EXAMPLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("examples")
            .getter(getter(GuardrailTopicConfig::examples))
            .setter(setter(Builder::examples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("examples").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailTopicConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> INPUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputAction").getter(getter(GuardrailTopicConfig::inputActionAsString))
            .setter(setter(Builder::inputAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAction").build()).build();

    private static final SdkField<String> OUTPUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputAction").getter(getter(GuardrailTopicConfig::outputActionAsString))
            .setter(setter(Builder::outputAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAction").build()).build();

    private static final SdkField<Boolean> INPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("inputEnabled").getter(getter(GuardrailTopicConfig::inputEnabled)).setter(setter(Builder::inputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputEnabled").build()).build();

    private static final SdkField<Boolean> OUTPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("outputEnabled").getter(getter(GuardrailTopicConfig::outputEnabled))
            .setter(setter(Builder::outputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFINITION_FIELD,
            EXAMPLES_FIELD, TYPE_FIELD, INPUT_ACTION_FIELD, OUTPUT_ACTION_FIELD, INPUT_ENABLED_FIELD, OUTPUT_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String definition;

    private final List<String> examples;

    private final String type;

    private final String inputAction;

    private final String outputAction;

    private final Boolean inputEnabled;

    private final Boolean outputEnabled;

    private GuardrailTopicConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.definition = builder.definition;
        this.examples = builder.examples;
        this.type = builder.type;
        this.inputAction = builder.inputAction;
        this.outputAction = builder.outputAction;
        this.inputEnabled = builder.inputEnabled;
        this.outputEnabled = builder.outputEnabled;
    }

    /**
     * <p>
     * The name of the topic to deny.
     * </p>
     * 
     * @return The name of the topic to deny.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A definition of the topic to deny.
     * </p>
     * 
     * @return A definition of the topic to deny.
     */
    public final String definition() {
        return definition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Examples property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExamples() {
        return examples != null && !(examples instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExamples} method.
     * </p>
     * 
     * @return A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the
     *         topic.
     */
    public final List<String> examples() {
        return examples;
    }

    /**
     * <p>
     * Specifies to deny the topic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailTopicType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies to deny the topic.
     * @see GuardrailTopicType
     */
    public final GuardrailTopicType type() {
        return GuardrailTopicType.fromValue(type);
    }

    /**
     * <p>
     * Specifies to deny the topic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailTopicType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies to deny the topic.
     * @see GuardrailTopicType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the input. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputAction} will
     * return {@link GuardrailTopicAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the input. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailTopicAction
     */
    public final GuardrailTopicAction inputAction() {
        return GuardrailTopicAction.fromValue(inputAction);
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the input. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputAction} will
     * return {@link GuardrailTopicAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the input. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailTopicAction
     */
    public final String inputActionAsString() {
        return inputAction;
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the output. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputAction} will
     * return {@link GuardrailTopicAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the output. Supported values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailTopicAction
     */
    public final GuardrailTopicAction outputAction() {
        return GuardrailTopicAction.fromValue(outputAction);
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the output. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputAction} will
     * return {@link GuardrailTopicAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the output. Supported values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailTopicAction
     */
    public final String outputActionAsString() {
        return outputAction;
    }

    /**
     * <p>
     * Specifies whether to enable guardrail evaluation on the input. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Specifies whether to enable guardrail evaluation on the input. When disabled, you aren't charged for the
     *         evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean inputEnabled() {
        return inputEnabled;
    }

    /**
     * <p>
     * Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
     *         evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean outputEnabled() {
        return outputEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(hasExamples() ? examples() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outputEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTopicConfig)) {
            return false;
        }
        GuardrailTopicConfig other = (GuardrailTopicConfig) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(definition(), other.definition())
                && hasExamples() == other.hasExamples() && Objects.equals(examples(), other.examples())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(inputActionAsString(), other.inputActionAsString())
                && Objects.equals(outputActionAsString(), other.outputActionAsString())
                && Objects.equals(inputEnabled(), other.inputEnabled()) && Objects.equals(outputEnabled(), other.outputEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailTopicConfig").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Definition", definition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Examples", examples() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("InputAction", inputActionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OutputAction", outputActionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InputEnabled", inputEnabled()).add("OutputEnabled", outputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "examples":
            return Optional.ofNullable(clazz.cast(examples()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "inputAction":
            return Optional.ofNullable(clazz.cast(inputActionAsString()));
        case "outputAction":
            return Optional.ofNullable(clazz.cast(outputActionAsString()));
        case "inputEnabled":
            return Optional.ofNullable(clazz.cast(inputEnabled()));
        case "outputEnabled":
            return Optional.ofNullable(clazz.cast(outputEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("examples", EXAMPLES_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("inputAction", INPUT_ACTION_FIELD);
        map.put("outputAction", OUTPUT_ACTION_FIELD);
        map.put("inputEnabled", INPUT_ENABLED_FIELD);
        map.put("outputEnabled", OUTPUT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTopicConfig, T> g) {
        return obj -> g.apply((GuardrailTopicConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailTopicConfig> {
        /**
         * <p>
         * The name of the topic to deny.
         * </p>
         * 
         * @param name
         *        The name of the topic to deny.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A definition of the topic to deny.
         * </p>
         * 
         * @param definition
         *        A definition of the topic to deny.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.
         * </p>
         * 
         * @param examples
         *        A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the
         *        topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder examples(Collection<String> examples);

        /**
         * <p>
         * A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.
         * </p>
         * 
         * @param examples
         *        A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the
         *        topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder examples(String... examples);

        /**
         * <p>
         * Specifies to deny the topic.
         * </p>
         * 
         * @param type
         *        Specifies to deny the topic.
         * @see GuardrailTopicType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTopicType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies to deny the topic.
         * </p>
         * 
         * @param type
         *        Specifies to deny the topic.
         * @see GuardrailTopicType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTopicType
         */
        Builder type(GuardrailTopicType type);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the input. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAction
         *        Specifies the action to take when harmful content is detected in the input. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailTopicAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTopicAction
         */
        Builder inputAction(String inputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the input. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAction
         *        Specifies the action to take when harmful content is detected in the input. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailTopicAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTopicAction
         */
        Builder inputAction(GuardrailTopicAction inputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the output. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputAction
         *        Specifies the action to take when harmful content is detected in the output. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailTopicAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTopicAction
         */
        Builder outputAction(String outputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the output. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputAction
         *        Specifies the action to take when harmful content is detected in the output. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailTopicAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTopicAction
         */
        Builder outputAction(GuardrailTopicAction outputAction);

        /**
         * <p>
         * Specifies whether to enable guardrail evaluation on the input. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param inputEnabled
         *        Specifies whether to enable guardrail evaluation on the input. When disabled, you aren't charged for
         *        the evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputEnabled(Boolean inputEnabled);

        /**
         * <p>
         * Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param outputEnabled
         *        Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for
         *        the evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEnabled(Boolean outputEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String definition;

        private List<String> examples = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String inputAction;

        private String outputAction;

        private Boolean inputEnabled;

        private Boolean outputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTopicConfig model) {
            name(model.name);
            definition(model.definition);
            examples(model.examples);
            type(model.type);
            inputAction(model.inputAction);
            outputAction(model.outputAction);
            inputEnabled(model.inputEnabled);
            outputEnabled(model.outputEnabled);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final Collection<String> getExamples() {
            if (examples instanceof SdkAutoConstructList) {
                return null;
            }
            return examples;
        }

        public final void setExamples(Collection<String> examples) {
            this.examples = GuardrailTopicExamplesCopier.copy(examples);
        }

        @Override
        public final Builder examples(Collection<String> examples) {
            this.examples = GuardrailTopicExamplesCopier.copy(examples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder examples(String... examples) {
            examples(Arrays.asList(examples));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailTopicType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getInputAction() {
            return inputAction;
        }

        public final void setInputAction(String inputAction) {
            this.inputAction = inputAction;
        }

        @Override
        public final Builder inputAction(String inputAction) {
            this.inputAction = inputAction;
            return this;
        }

        @Override
        public final Builder inputAction(GuardrailTopicAction inputAction) {
            this.inputAction(inputAction == null ? null : inputAction.toString());
            return this;
        }

        public final String getOutputAction() {
            return outputAction;
        }

        public final void setOutputAction(String outputAction) {
            this.outputAction = outputAction;
        }

        @Override
        public final Builder outputAction(String outputAction) {
            this.outputAction = outputAction;
            return this;
        }

        @Override
        public final Builder outputAction(GuardrailTopicAction outputAction) {
            this.outputAction(outputAction == null ? null : outputAction.toString());
            return this;
        }

        public final Boolean getInputEnabled() {
            return inputEnabled;
        }

        public final void setInputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
        }

        @Override
        public final Builder inputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
            return this;
        }

        public final Boolean getOutputEnabled() {
            return outputEnabled;
        }

        public final void setOutputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
        }

        @Override
        public final Builder outputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
            return this;
        }

        @Override
        public GuardrailTopicConfig build() {
            return new GuardrailTopicConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
