/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A word to configure for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailWordConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailWordConfig.Builder, GuardrailWordConfig> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(GuardrailWordConfig::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<String> INPUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputAction").getter(getter(GuardrailWordConfig::inputActionAsString))
            .setter(setter(Builder::inputAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAction").build()).build();

    private static final SdkField<String> OUTPUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputAction").getter(getter(GuardrailWordConfig::outputActionAsString))
            .setter(setter(Builder::outputAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAction").build()).build();

    private static final SdkField<Boolean> INPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("inputEnabled").getter(getter(GuardrailWordConfig::inputEnabled)).setter(setter(Builder::inputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputEnabled").build()).build();

    private static final SdkField<Boolean> OUTPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("outputEnabled").getter(getter(GuardrailWordConfig::outputEnabled))
            .setter(setter(Builder::outputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD,
            INPUT_ACTION_FIELD, OUTPUT_ACTION_FIELD, INPUT_ENABLED_FIELD, OUTPUT_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String text;

    private final String inputAction;

    private final String outputAction;

    private final Boolean inputEnabled;

    private final Boolean outputEnabled;

    private GuardrailWordConfig(BuilderImpl builder) {
        this.text = builder.text;
        this.inputAction = builder.inputAction;
        this.outputAction = builder.outputAction;
        this.inputEnabled = builder.inputEnabled;
        this.outputEnabled = builder.outputEnabled;
    }

    /**
     * <p>
     * Text of the word configured for the guardrail to block.
     * </p>
     * 
     * @return Text of the word configured for the guardrail to block.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the input. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputAction} will
     * return {@link GuardrailWordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the input. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailWordAction
     */
    public final GuardrailWordAction inputAction() {
        return GuardrailWordAction.fromValue(inputAction);
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the input. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputAction} will
     * return {@link GuardrailWordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the input. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailWordAction
     */
    public final String inputActionAsString() {
        return inputAction;
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the output. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputAction} will
     * return {@link GuardrailWordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the output. Supported values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailWordAction
     */
    public final GuardrailWordAction outputAction() {
        return GuardrailWordAction.fromValue(outputAction);
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the output. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputAction} will
     * return {@link GuardrailWordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the output. Supported values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailWordAction
     */
    public final String outputActionAsString() {
        return outputAction;
    }

    /**
     * <p>
     * Specifies whether to enable guardrail evaluation on the intput. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Specifies whether to enable guardrail evaluation on the intput. When disabled, you aren't charged for the
     *         evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean inputEnabled() {
        return inputEnabled;
    }

    /**
     * <p>
     * Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
     *         evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean outputEnabled() {
        return outputEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(inputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outputEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailWordConfig)) {
            return false;
        }
        GuardrailWordConfig other = (GuardrailWordConfig) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(inputActionAsString(), other.inputActionAsString())
                && Objects.equals(outputActionAsString(), other.outputActionAsString())
                && Objects.equals(inputEnabled(), other.inputEnabled()) && Objects.equals(outputEnabled(), other.outputEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailWordConfig").add("Text", text())
                .add("InputAction", inputActionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OutputAction", outputActionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InputEnabled", inputEnabled()).add("OutputEnabled", outputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "inputAction":
            return Optional.ofNullable(clazz.cast(inputActionAsString()));
        case "outputAction":
            return Optional.ofNullable(clazz.cast(outputActionAsString()));
        case "inputEnabled":
            return Optional.ofNullable(clazz.cast(inputEnabled()));
        case "outputEnabled":
            return Optional.ofNullable(clazz.cast(outputEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("inputAction", INPUT_ACTION_FIELD);
        map.put("outputAction", OUTPUT_ACTION_FIELD);
        map.put("inputEnabled", INPUT_ENABLED_FIELD);
        map.put("outputEnabled", OUTPUT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailWordConfig, T> g) {
        return obj -> g.apply((GuardrailWordConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailWordConfig> {
        /**
         * <p>
         * Text of the word configured for the guardrail to block.
         * </p>
         * 
         * @param text
         *        Text of the word configured for the guardrail to block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the input. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAction
         *        Specifies the action to take when harmful content is detected in the input. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailWordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordAction
         */
        Builder inputAction(String inputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the input. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAction
         *        Specifies the action to take when harmful content is detected in the input. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailWordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordAction
         */
        Builder inputAction(GuardrailWordAction inputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the output. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputAction
         *        Specifies the action to take when harmful content is detected in the output. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailWordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordAction
         */
        Builder outputAction(String outputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the output. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputAction
         *        Specifies the action to take when harmful content is detected in the output. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailWordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordAction
         */
        Builder outputAction(GuardrailWordAction outputAction);

        /**
         * <p>
         * Specifies whether to enable guardrail evaluation on the intput. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param inputEnabled
         *        Specifies whether to enable guardrail evaluation on the intput. When disabled, you aren't charged for
         *        the evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputEnabled(Boolean inputEnabled);

        /**
         * <p>
         * Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param outputEnabled
         *        Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for
         *        the evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEnabled(Boolean outputEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private String inputAction;

        private String outputAction;

        private Boolean inputEnabled;

        private Boolean outputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailWordConfig model) {
            text(model.text);
            inputAction(model.inputAction);
            outputAction(model.outputAction);
            inputEnabled(model.inputEnabled);
            outputEnabled(model.outputEnabled);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getInputAction() {
            return inputAction;
        }

        public final void setInputAction(String inputAction) {
            this.inputAction = inputAction;
        }

        @Override
        public final Builder inputAction(String inputAction) {
            this.inputAction = inputAction;
            return this;
        }

        @Override
        public final Builder inputAction(GuardrailWordAction inputAction) {
            this.inputAction(inputAction == null ? null : inputAction.toString());
            return this;
        }

        public final String getOutputAction() {
            return outputAction;
        }

        public final void setOutputAction(String outputAction) {
            this.outputAction = outputAction;
        }

        @Override
        public final Builder outputAction(String outputAction) {
            this.outputAction = outputAction;
            return this;
        }

        @Override
        public final Builder outputAction(GuardrailWordAction outputAction) {
            this.outputAction(outputAction == null ? null : outputAction.toString());
            return this;
        }

        public final Boolean getInputEnabled() {
            return inputEnabled;
        }

        public final void setInputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
        }

        @Override
        public final Builder inputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
            return this;
        }

        public final Boolean getOutputEnabled() {
            return outputEnabled;
        }

        public final void setOutputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
        }

        @Override
        public final Builder outputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
            return this;
        }

        @Override
        public GuardrailWordConfig build() {
            return new GuardrailWordConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
