/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelImportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelImportJobSummary.Builder, ModelImportJobSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(ModelImportJobSummary::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(ModelImportJobSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ModelImportJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(ModelImportJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ModelImportJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ModelImportJobSummary::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> IMPORTED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedModelArn").getter(getter(ModelImportJobSummary::importedModelArn))
            .setter(setter(Builder::importedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelArn").build()).build();

    private static final SdkField<String> IMPORTED_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedModelName").getter(getter(ModelImportJobSummary::importedModelName))
            .setter(setter(Builder::importedModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD,
            STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, IMPORTED_MODEL_ARN_FIELD,
            IMPORTED_MODEL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobArn;

    private final String jobName;

    private final String status;

    private final Instant lastModifiedTime;

    private final Instant creationTime;

    private final Instant endTime;

    private final String importedModelArn;

    private final String importedModelName;

    private ModelImportJobSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.importedModelArn = builder.importedModelArn;
        this.importedModelName = builder.importedModelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the import job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the import job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The name of the import job.
     * </p>
     * 
     * @return The name of the import job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The status of the imported job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the imported job.
     * @see ModelImportJobStatus
     */
    public final ModelImportJobStatus status() {
        return ModelImportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the imported job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the imported job.
     * @see ModelImportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time when the import job was last modified.
     * </p>
     * 
     * @return The time when the import job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The time import job was created.
     * </p>
     * 
     * @return The time import job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when import job ended.
     * </p>
     * 
     * @return The time when import job ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The Amazon resource Name (ARN) of the imported model.
     * </p>
     * 
     * @return The Amazon resource Name (ARN) of the imported model.
     */
    public final String importedModelArn() {
        return importedModelArn;
    }

    /**
     * <p>
     * The name of the imported model.
     * </p>
     * 
     * @return The name of the imported model.
     */
    public final String importedModelName() {
        return importedModelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(importedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(importedModelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelImportJobSummary)) {
            return false;
        }
        ModelImportJobSummary other = (ModelImportJobSummary) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(importedModelArn(), other.importedModelArn())
                && Objects.equals(importedModelName(), other.importedModelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelImportJobSummary").add("JobArn", jobArn()).add("JobName", jobName())
                .add("Status", statusAsString()).add("LastModifiedTime", lastModifiedTime()).add("CreationTime", creationTime())
                .add("EndTime", endTime()).add("ImportedModelArn", importedModelArn())
                .add("ImportedModelName", importedModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "importedModelArn":
            return Optional.ofNullable(clazz.cast(importedModelArn()));
        case "importedModelName":
            return Optional.ofNullable(clazz.cast(importedModelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("importedModelArn", IMPORTED_MODEL_ARN_FIELD);
        map.put("importedModelName", IMPORTED_MODEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelImportJobSummary, T> g) {
        return obj -> g.apply((ModelImportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelImportJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the import job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The name of the import job.
         * </p>
         * 
         * @param jobName
         *        The name of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The status of the imported job.
         * </p>
         * 
         * @param status
         *        The status of the imported job.
         * @see ModelImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelImportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the imported job.
         * </p>
         * 
         * @param status
         *        The status of the imported job.
         * @see ModelImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelImportJobStatus
         */
        Builder status(ModelImportJobStatus status);

        /**
         * <p>
         * The time when the import job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the import job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The time import job was created.
         * </p>
         * 
         * @param creationTime
         *        The time import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when import job ended.
         * </p>
         * 
         * @param endTime
         *        The time when import job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The Amazon resource Name (ARN) of the imported model.
         * </p>
         * 
         * @param importedModelArn
         *        The Amazon resource Name (ARN) of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelArn(String importedModelArn);

        /**
         * <p>
         * The name of the imported model.
         * </p>
         * 
         * @param importedModelName
         *        The name of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelName(String importedModelName);
    }

    static final class BuilderImpl implements Builder {
        private String jobArn;

        private String jobName;

        private String status;

        private Instant lastModifiedTime;

        private Instant creationTime;

        private Instant endTime;

        private String importedModelArn;

        private String importedModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelImportJobSummary model) {
            jobArn(model.jobArn);
            jobName(model.jobName);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            creationTime(model.creationTime);
            endTime(model.endTime);
            importedModelArn(model.importedModelArn);
            importedModelName(model.importedModelName);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getImportedModelArn() {
            return importedModelArn;
        }

        public final void setImportedModelArn(String importedModelArn) {
            this.importedModelArn = importedModelArn;
        }

        @Override
        public final Builder importedModelArn(String importedModelArn) {
            this.importedModelArn = importedModelArn;
            return this;
        }

        public final String getImportedModelName() {
            return importedModelName;
        }

        public final void setImportedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
        }

        @Override
        public final Builder importedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
            return this;
        }

        @Override
        public ModelImportJobSummary build() {
            return new ModelImportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
