/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the value and corresponding definition for one rating in a custom metric rating scale.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RatingScaleItem implements SdkPojo, Serializable, ToCopyableBuilder<RatingScaleItem.Builder, RatingScaleItem> {
    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(RatingScaleItem::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<RatingScaleItemValue> VALUE_FIELD = SdkField
            .<RatingScaleItemValue> builder(MarshallingType.SDK_POJO).memberName("value").getter(getter(RatingScaleItem::value))
            .setter(setter(Builder::value)).constructor(RatingScaleItemValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DEFINITION_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String definition;

    private final RatingScaleItemValue value;

    private RatingScaleItem(BuilderImpl builder) {
        this.definition = builder.definition;
        this.value = builder.value;
    }

    /**
     * <p>
     * Defines the definition for one rating in a custom metric rating scale.
     * </p>
     * 
     * @return Defines the definition for one rating in a custom metric rating scale.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * Defines the value for one rating in a custom metric rating scale.
     * </p>
     * 
     * @return Defines the value for one rating in a custom metric rating scale.
     */
    public final RatingScaleItemValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RatingScaleItem)) {
            return false;
        }
        RatingScaleItem other = (RatingScaleItem) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RatingScaleItem").add("Definition", definition()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("definition", DEFINITION_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RatingScaleItem, T> g) {
        return obj -> g.apply((RatingScaleItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RatingScaleItem> {
        /**
         * <p>
         * Defines the definition for one rating in a custom metric rating scale.
         * </p>
         * 
         * @param definition
         *        Defines the definition for one rating in a custom metric rating scale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * Defines the value for one rating in a custom metric rating scale.
         * </p>
         * 
         * @param value
         *        Defines the value for one rating in a custom metric rating scale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(RatingScaleItemValue value);

        /**
         * <p>
         * Defines the value for one rating in a custom metric rating scale.
         * </p>
         * This is a convenience method that creates an instance of the {@link RatingScaleItemValue.Builder} avoiding
         * the need to create one manually via {@link RatingScaleItemValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RatingScaleItemValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(RatingScaleItemValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link RatingScaleItemValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(RatingScaleItemValue)
         */
        default Builder value(Consumer<RatingScaleItemValue.Builder> value) {
            return value(RatingScaleItemValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String definition;

        private RatingScaleItemValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(RatingScaleItem model) {
            definition(model.definition);
            value(model.value);
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final RatingScaleItemValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(RatingScaleItemValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(RatingScaleItemValue value) {
            this.value = value;
            return this;
        }

        @Override
        public RatingScaleItem build() {
            return new RatingScaleItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
