/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the value for one rating in a custom metric rating scale.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RatingScaleItemValue implements SdkPojo, Serializable,
        ToCopyableBuilder<RatingScaleItemValue.Builder, RatingScaleItemValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(RatingScaleItemValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<Float> FLOAT_VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("floatValue").getter(getter(RatingScaleItemValue::floatValue)).setter(setter(Builder::floatValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("floatValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            FLOAT_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final Float floatValue;

    private final Type type;

    private RatingScaleItemValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.floatValue = builder.floatValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * A string representing the value for a rating in a custom metric rating scale.
     * </p>
     * 
     * @return A string representing the value for a rating in a custom metric rating scale.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * A floating point number representing the value for a rating in a custom metric rating scale.
     * </p>
     * 
     * @return A floating point number representing the value for a rating in a custom metric rating scale.
     */
    public final Float floatValue() {
        return floatValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(floatValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RatingScaleItemValue)) {
            return false;
        }
        RatingScaleItemValue other = (RatingScaleItemValue) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(floatValue(), other.floatValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RatingScaleItemValue").add("StringValue", stringValue()).add("FloatValue", floatValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "floatValue":
            return Optional.ofNullable(clazz.cast(floatValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * A string representing the value for a rating in a custom metric rating scale.
     * </p>
     * 
     * @param stringValue
     *        A string representing the value for a rating in a custom metric rating scale.
     */
    public static RatingScaleItemValue fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #floatValue()} initialized to the given value.
     *
     * <p>
     * A floating point number representing the value for a rating in a custom metric rating scale.
     * </p>
     * 
     * @param floatValue
     *        A floating point number representing the value for a rating in a custom metric rating scale.
     */
    public static RatingScaleItemValue fromFloatValue(Float floatValue) {
        return builder().floatValue(floatValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("floatValue", FLOAT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RatingScaleItemValue, T> g) {
        return obj -> g.apply((RatingScaleItemValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RatingScaleItemValue> {
        /**
         * <p>
         * A string representing the value for a rating in a custom metric rating scale.
         * </p>
         * 
         * @param stringValue
         *        A string representing the value for a rating in a custom metric rating scale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * A floating point number representing the value for a rating in a custom metric rating scale.
         * </p>
         * 
         * @param floatValue
         *        A floating point number representing the value for a rating in a custom metric rating scale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floatValue(Float floatValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private Float floatValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RatingScaleItemValue model) {
            stringValue(model.stringValue);
            floatValue(model.floatValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Float getFloatValue() {
            return floatValue;
        }

        public final void setFloatValue(Float floatValue) {
            Object oldValue = this.floatValue;
            this.floatValue = floatValue;
            handleUnionValueChange(Type.FLOAT_VALUE, oldValue, this.floatValue);
        }

        @Override
        public final Builder floatValue(Float floatValue) {
            Object oldValue = this.floatValue;
            this.floatValue = floatValue;
            handleUnionValueChange(Type.FLOAT_VALUE, oldValue, this.floatValue);
            return this;
        }

        @Override
        public RatingScaleItemValue build() {
            return new RatingScaleItemValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RatingScaleItemValue#type()
     */
    public enum Type {
        STRING_VALUE,

        FLOAT_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
