/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMarketplaceModelEndpointResponse extends BedrockResponse implements
        ToCopyableBuilder<UpdateMarketplaceModelEndpointResponse.Builder, UpdateMarketplaceModelEndpointResponse> {
    private static final SdkField<MarketplaceModelEndpoint> MARKETPLACE_MODEL_ENDPOINT_FIELD = SdkField
            .<MarketplaceModelEndpoint> builder(MarshallingType.SDK_POJO).memberName("marketplaceModelEndpoint")
            .getter(getter(UpdateMarketplaceModelEndpointResponse::marketplaceModelEndpoint))
            .setter(setter(Builder::marketplaceModelEndpoint)).constructor(MarketplaceModelEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceModelEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MARKETPLACE_MODEL_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MarketplaceModelEndpoint marketplaceModelEndpoint;

    private UpdateMarketplaceModelEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.marketplaceModelEndpoint = builder.marketplaceModelEndpoint;
    }

    /**
     * <p>
     * Details about the updated endpoint.
     * </p>
     * 
     * @return Details about the updated endpoint.
     */
    public final MarketplaceModelEndpoint marketplaceModelEndpoint() {
        return marketplaceModelEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceModelEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMarketplaceModelEndpointResponse)) {
            return false;
        }
        UpdateMarketplaceModelEndpointResponse other = (UpdateMarketplaceModelEndpointResponse) obj;
        return Objects.equals(marketplaceModelEndpoint(), other.marketplaceModelEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMarketplaceModelEndpointResponse")
                .add("MarketplaceModelEndpoint", marketplaceModelEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "marketplaceModelEndpoint":
            return Optional.ofNullable(clazz.cast(marketplaceModelEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("marketplaceModelEndpoint", MARKETPLACE_MODEL_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMarketplaceModelEndpointResponse, T> g) {
        return obj -> g.apply((UpdateMarketplaceModelEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMarketplaceModelEndpointResponse> {
        /**
         * <p>
         * Details about the updated endpoint.
         * </p>
         * 
         * @param marketplaceModelEndpoint
         *        Details about the updated endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceModelEndpoint(MarketplaceModelEndpoint marketplaceModelEndpoint);

        /**
         * <p>
         * Details about the updated endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link MarketplaceModelEndpoint.Builder}
         * avoiding the need to create one manually via {@link MarketplaceModelEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MarketplaceModelEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #marketplaceModelEndpoint(MarketplaceModelEndpoint)}.
         * 
         * @param marketplaceModelEndpoint
         *        a consumer that will call methods on {@link MarketplaceModelEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketplaceModelEndpoint(MarketplaceModelEndpoint)
         */
        default Builder marketplaceModelEndpoint(Consumer<MarketplaceModelEndpoint.Builder> marketplaceModelEndpoint) {
            return marketplaceModelEndpoint(MarketplaceModelEndpoint.builder().applyMutation(marketplaceModelEndpoint).build());
        }
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private MarketplaceModelEndpoint marketplaceModelEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMarketplaceModelEndpointResponse model) {
            super(model);
            marketplaceModelEndpoint(model.marketplaceModelEndpoint);
        }

        public final MarketplaceModelEndpoint.Builder getMarketplaceModelEndpoint() {
            return marketplaceModelEndpoint != null ? marketplaceModelEndpoint.toBuilder() : null;
        }

        public final void setMarketplaceModelEndpoint(MarketplaceModelEndpoint.BuilderImpl marketplaceModelEndpoint) {
            this.marketplaceModelEndpoint = marketplaceModelEndpoint != null ? marketplaceModelEndpoint.build() : null;
        }

        @Override
        public final Builder marketplaceModelEndpoint(MarketplaceModelEndpoint marketplaceModelEndpoint) {
            this.marketplaceModelEndpoint = marketplaceModelEndpoint;
            return this;
        }

        @Override
        public UpdateMarketplaceModelEndpointResponse build() {
            return new UpdateMarketplaceModelEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
