/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In a model evaluation job that uses human workers you must define the name of the metric, and how you want that
 * metric rated <code>ratingMethod</code>, and an optional description of the metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanEvaluationCustomMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanEvaluationCustomMetric.Builder, HumanEvaluationCustomMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(HumanEvaluationCustomMetric::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(HumanEvaluationCustomMetric::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> RATING_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ratingMethod").getter(getter(HumanEvaluationCustomMetric::ratingMethod))
            .setter(setter(Builder::ratingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ratingMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            RATING_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String ratingMethod;

    private HumanEvaluationCustomMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.ratingMethod = builder.ratingMethod;
    }

    /**
     * <p>
     * The name of the metric. Your human evaluators will see this name in the evaluation UI.
     * </p>
     * 
     * @return The name of the metric. Your human evaluators will see this name in the evaluation UI.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description of the metric. Use this parameter to provide more details about the metric.
     * </p>
     * 
     * @return An optional description of the metric. Use this parameter to provide more details about the metric.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Choose how you want your human workers to evaluation your model. Valid values for rating methods are
     * <code>ThumbsUpDown</code>, <code>IndividualLikertScale</code>,<code>ComparisonLikertScale</code>,
     * <code>ComparisonChoice</code>, and <code>ComparisonRank</code>
     * </p>
     * 
     * @return Choose how you want your human workers to evaluation your model. Valid values for rating methods are
     *         <code>ThumbsUpDown</code>, <code>IndividualLikertScale</code>,<code>ComparisonLikertScale</code>,
     *         <code>ComparisonChoice</code>, and <code>ComparisonRank</code>
     */
    public final String ratingMethod() {
        return ratingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ratingMethod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanEvaluationCustomMetric)) {
            return false;
        }
        HumanEvaluationCustomMetric other = (HumanEvaluationCustomMetric) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(ratingMethod(), other.ratingMethod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanEvaluationCustomMetric")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RatingMethod", ratingMethod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ratingMethod":
            return Optional.ofNullable(clazz.cast(ratingMethod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("ratingMethod", RATING_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HumanEvaluationCustomMetric, T> g) {
        return obj -> g.apply((HumanEvaluationCustomMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanEvaluationCustomMetric> {
        /**
         * <p>
         * The name of the metric. Your human evaluators will see this name in the evaluation UI.
         * </p>
         * 
         * @param name
         *        The name of the metric. Your human evaluators will see this name in the evaluation UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description of the metric. Use this parameter to provide more details about the metric.
         * </p>
         * 
         * @param description
         *        An optional description of the metric. Use this parameter to provide more details about the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Choose how you want your human workers to evaluation your model. Valid values for rating methods are
         * <code>ThumbsUpDown</code>, <code>IndividualLikertScale</code>,<code>ComparisonLikertScale</code>,
         * <code>ComparisonChoice</code>, and <code>ComparisonRank</code>
         * </p>
         * 
         * @param ratingMethod
         *        Choose how you want your human workers to evaluation your model. Valid values for rating methods are
         *        <code>ThumbsUpDown</code>, <code>IndividualLikertScale</code>,<code>ComparisonLikertScale</code>,
         *        <code>ComparisonChoice</code>, and <code>ComparisonRank</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ratingMethod(String ratingMethod);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String ratingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanEvaluationCustomMetric model) {
            name(model.name);
            description(model.description);
            ratingMethod(model.ratingMethod);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRatingMethod() {
            return ratingMethod;
        }

        public final void setRatingMethod(String ratingMethod) {
            this.ratingMethod = ratingMethod;
        }

        @Override
        public final Builder ratingMethod(String ratingMethod) {
            this.ratingMethod = ratingMethod;
            return this;
        }

        @Override
        public HumanEvaluationCustomMetric build() {
            return new HumanEvaluationCustomMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
