/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Array of up to 10 validators.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationDataConfig.Builder, ValidationDataConfig> {
    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField
            .<List<Validator>> builder(MarshallingType.LIST)
            .memberName("validators")
            .getter(getter(ValidationDataConfig::validators))
            .setter(setter(Builder::validators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Validator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Validator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Validator> validators;

    private ValidationDataConfig(BuilderImpl builder) {
        this.validators = builder.validators;
    }

    /**
     * For responses, this returns true if the service returned a value for the Validators property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValidators() {
        return validators != null && !(validators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the validators.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidators} method.
     * </p>
     * 
     * @return Information about the validators.
     */
    public final List<Validator> validators() {
        return validators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValidators() ? validators() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationDataConfig)) {
            return false;
        }
        ValidationDataConfig other = (ValidationDataConfig) obj;
        return hasValidators() == other.hasValidators() && Objects.equals(validators(), other.validators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationDataConfig").add("Validators", hasValidators() ? validators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "validators":
            return Optional.ofNullable(clazz.cast(validators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("validators", VALIDATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationDataConfig, T> g) {
        return obj -> g.apply((ValidationDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationDataConfig> {
        /**
         * <p>
         * Information about the validators.
         * </p>
         * 
         * @param validators
         *        Information about the validators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Collection<Validator> validators);

        /**
         * <p>
         * Information about the validators.
         * </p>
         * 
         * @param validators
         *        Information about the validators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Validator... validators);

        /**
         * <p>
         * Information about the validators.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Validator.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrock.model.Validator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Validator.Builder#build()} is called immediately and its
         * result is passed to {@link #validators(List<Validator>)}.
         * 
         * @param validators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.Validator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validators(java.util.Collection<Validator>)
         */
        Builder validators(Consumer<Validator.Builder>... validators);
    }

    static final class BuilderImpl implements Builder {
        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationDataConfig model) {
            validators(model.validators);
        }

        public final List<Validator.Builder> getValidators() {
            List<Validator.Builder> result = ValidatorsCopier.copyToBuilder(this.validators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorsCopier.copyFromBuilder(validators);
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorsCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator... validators) {
            validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder>... validators) {
            validators(Stream.of(validators).map(c -> Validator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ValidationDataConfig build() {
            return new ValidationDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
