/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the custom metrics, how tasks will be rated, the flow definition ARN, and your custom prompt datasets.
 * Model evaluation jobs use human workers <i>only</i> support the use of custom prompt datasets. To learn more about
 * custom prompt datasets and the required format, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-prompt-datasets-custom.html">Custom
 * prompt datasets</a>.
 * </p>
 * <p>
 * When you create custom metrics in <code>HumanEvaluationCustomMetric</code> you must specify the metric's
 * <code>name</code>. The list of <code>names</code> specified in the <code>HumanEvaluationCustomMetric</code> array,
 * must match the <code>metricNames</code> array of strings specified in <code>EvaluationDatasetMetricConfig</code>. For
 * example, if in the <code>HumanEvaluationCustomMetric</code> array your specified the names
 * <code>"accuracy", "toxicity", "readability"</code> as custom metrics <i>then</i> the <code>metricNames</code> array
 * would need to look like the following <code>["accuracy", "toxicity", "readability"]</code> in
 * <code>EvaluationDatasetMetricConfig</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanEvaluationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanEvaluationConfig.Builder, HumanEvaluationConfig> {
    private static final SdkField<HumanWorkflowConfig> HUMAN_WORKFLOW_CONFIG_FIELD = SdkField
            .<HumanWorkflowConfig> builder(MarshallingType.SDK_POJO).memberName("humanWorkflowConfig")
            .getter(getter(HumanEvaluationConfig::humanWorkflowConfig)).setter(setter(Builder::humanWorkflowConfig))
            .constructor(HumanWorkflowConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("humanWorkflowConfig").build())
            .build();

    private static final SdkField<List<HumanEvaluationCustomMetric>> CUSTOM_METRICS_FIELD = SdkField
            .<List<HumanEvaluationCustomMetric>> builder(MarshallingType.LIST)
            .memberName("customMetrics")
            .getter(getter(HumanEvaluationConfig::customMetrics))
            .setter(setter(Builder::customMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HumanEvaluationCustomMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(HumanEvaluationCustomMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EvaluationDatasetMetricConfig>> DATASET_METRIC_CONFIGS_FIELD = SdkField
            .<List<EvaluationDatasetMetricConfig>> builder(MarshallingType.LIST)
            .memberName("datasetMetricConfigs")
            .getter(getter(HumanEvaluationConfig::datasetMetricConfigs))
            .setter(setter(Builder::datasetMetricConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetMetricConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationDatasetMetricConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationDatasetMetricConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_WORKFLOW_CONFIG_FIELD,
            CUSTOM_METRICS_FIELD, DATASET_METRIC_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HumanWorkflowConfig humanWorkflowConfig;

    private final List<HumanEvaluationCustomMetric> customMetrics;

    private final List<EvaluationDatasetMetricConfig> datasetMetricConfigs;

    private HumanEvaluationConfig(BuilderImpl builder) {
        this.humanWorkflowConfig = builder.humanWorkflowConfig;
        this.customMetrics = builder.customMetrics;
        this.datasetMetricConfigs = builder.datasetMetricConfigs;
    }

    /**
     * <p>
     * The parameters of the human workflow.
     * </p>
     * 
     * @return The parameters of the human workflow.
     */
    public final HumanWorkflowConfig humanWorkflowConfig() {
        return humanWorkflowConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomMetrics() {
        return customMetrics != null && !(customMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>HumanEvaluationCustomMetric</code> object. It contains the names the metrics, how the metrics are to be
     * evaluated, an optional description.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomMetrics} method.
     * </p>
     * 
     * @return A <code>HumanEvaluationCustomMetric</code> object. It contains the names the metrics, how the metrics are
     *         to be evaluated, an optional description.
     */
    public final List<HumanEvaluationCustomMetric> customMetrics() {
        return customMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasetMetricConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasetMetricConfigs() {
        return datasetMetricConfigs != null && !(datasetMetricConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasetMetricConfigs} method.
     * </p>
     * 
     * @return Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
     */
    public final List<EvaluationDatasetMetricConfig> datasetMetricConfigs() {
        return datasetMetricConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanWorkflowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomMetrics() ? customMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetMetricConfigs() ? datasetMetricConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanEvaluationConfig)) {
            return false;
        }
        HumanEvaluationConfig other = (HumanEvaluationConfig) obj;
        return Objects.equals(humanWorkflowConfig(), other.humanWorkflowConfig())
                && hasCustomMetrics() == other.hasCustomMetrics() && Objects.equals(customMetrics(), other.customMetrics())
                && hasDatasetMetricConfigs() == other.hasDatasetMetricConfigs()
                && Objects.equals(datasetMetricConfigs(), other.datasetMetricConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanEvaluationConfig").add("HumanWorkflowConfig", humanWorkflowConfig())
                .add("CustomMetrics", hasCustomMetrics() ? customMetrics() : null)
                .add("DatasetMetricConfigs", hasDatasetMetricConfigs() ? datasetMetricConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "humanWorkflowConfig":
            return Optional.ofNullable(clazz.cast(humanWorkflowConfig()));
        case "customMetrics":
            return Optional.ofNullable(clazz.cast(customMetrics()));
        case "datasetMetricConfigs":
            return Optional.ofNullable(clazz.cast(datasetMetricConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("humanWorkflowConfig", HUMAN_WORKFLOW_CONFIG_FIELD);
        map.put("customMetrics", CUSTOM_METRICS_FIELD);
        map.put("datasetMetricConfigs", DATASET_METRIC_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HumanEvaluationConfig, T> g) {
        return obj -> g.apply((HumanEvaluationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanEvaluationConfig> {
        /**
         * <p>
         * The parameters of the human workflow.
         * </p>
         * 
         * @param humanWorkflowConfig
         *        The parameters of the human workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanWorkflowConfig(HumanWorkflowConfig humanWorkflowConfig);

        /**
         * <p>
         * The parameters of the human workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link HumanWorkflowConfig.Builder} avoiding the
         * need to create one manually via {@link HumanWorkflowConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HumanWorkflowConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #humanWorkflowConfig(HumanWorkflowConfig)}.
         * 
         * @param humanWorkflowConfig
         *        a consumer that will call methods on {@link HumanWorkflowConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanWorkflowConfig(HumanWorkflowConfig)
         */
        default Builder humanWorkflowConfig(Consumer<HumanWorkflowConfig.Builder> humanWorkflowConfig) {
            return humanWorkflowConfig(HumanWorkflowConfig.builder().applyMutation(humanWorkflowConfig).build());
        }

        /**
         * <p>
         * A <code>HumanEvaluationCustomMetric</code> object. It contains the names the metrics, how the metrics are to
         * be evaluated, an optional description.
         * </p>
         * 
         * @param customMetrics
         *        A <code>HumanEvaluationCustomMetric</code> object. It contains the names the metrics, how the metrics
         *        are to be evaluated, an optional description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMetrics(Collection<HumanEvaluationCustomMetric> customMetrics);

        /**
         * <p>
         * A <code>HumanEvaluationCustomMetric</code> object. It contains the names the metrics, how the metrics are to
         * be evaluated, an optional description.
         * </p>
         * 
         * @param customMetrics
         *        A <code>HumanEvaluationCustomMetric</code> object. It contains the names the metrics, how the metrics
         *        are to be evaluated, an optional description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMetrics(HumanEvaluationCustomMetric... customMetrics);

        /**
         * <p>
         * A <code>HumanEvaluationCustomMetric</code> object. It contains the names the metrics, how the metrics are to
         * be evaluated, an optional description.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #customMetrics(List<HumanEvaluationCustomMetric>)}.
         * 
         * @param customMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customMetrics(java.util.Collection<HumanEvaluationCustomMetric>)
         */
        Builder customMetrics(Consumer<HumanEvaluationCustomMetric.Builder>... customMetrics);

        /**
         * <p>
         * Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
         * </p>
         * 
         * @param datasetMetricConfigs
         *        Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> datasetMetricConfigs);

        /**
         * <p>
         * Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
         * </p>
         * 
         * @param datasetMetricConfigs
         *        Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetMetricConfigs(EvaluationDatasetMetricConfig... datasetMetricConfigs);

        /**
         * <p>
         * Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetMetricConfigs(List<EvaluationDatasetMetricConfig>)}.
         * 
         * @param datasetMetricConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetMetricConfigs(java.util.Collection<EvaluationDatasetMetricConfig>)
         */
        Builder datasetMetricConfigs(Consumer<EvaluationDatasetMetricConfig.Builder>... datasetMetricConfigs);
    }

    static final class BuilderImpl implements Builder {
        private HumanWorkflowConfig humanWorkflowConfig;

        private List<HumanEvaluationCustomMetric> customMetrics = DefaultSdkAutoConstructList.getInstance();

        private List<EvaluationDatasetMetricConfig> datasetMetricConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HumanEvaluationConfig model) {
            humanWorkflowConfig(model.humanWorkflowConfig);
            customMetrics(model.customMetrics);
            datasetMetricConfigs(model.datasetMetricConfigs);
        }

        public final HumanWorkflowConfig.Builder getHumanWorkflowConfig() {
            return humanWorkflowConfig != null ? humanWorkflowConfig.toBuilder() : null;
        }

        public final void setHumanWorkflowConfig(HumanWorkflowConfig.BuilderImpl humanWorkflowConfig) {
            this.humanWorkflowConfig = humanWorkflowConfig != null ? humanWorkflowConfig.build() : null;
        }

        @Override
        public final Builder humanWorkflowConfig(HumanWorkflowConfig humanWorkflowConfig) {
            this.humanWorkflowConfig = humanWorkflowConfig;
            return this;
        }

        public final List<HumanEvaluationCustomMetric.Builder> getCustomMetrics() {
            List<HumanEvaluationCustomMetric.Builder> result = HumanEvaluationCustomMetricsCopier
                    .copyToBuilder(this.customMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomMetrics(Collection<HumanEvaluationCustomMetric.BuilderImpl> customMetrics) {
            this.customMetrics = HumanEvaluationCustomMetricsCopier.copyFromBuilder(customMetrics);
        }

        @Override
        public final Builder customMetrics(Collection<HumanEvaluationCustomMetric> customMetrics) {
            this.customMetrics = HumanEvaluationCustomMetricsCopier.copy(customMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetrics(HumanEvaluationCustomMetric... customMetrics) {
            customMetrics(Arrays.asList(customMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetrics(Consumer<HumanEvaluationCustomMetric.Builder>... customMetrics) {
            customMetrics(Stream.of(customMetrics).map(c -> HumanEvaluationCustomMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EvaluationDatasetMetricConfig.Builder> getDatasetMetricConfigs() {
            List<EvaluationDatasetMetricConfig.Builder> result = EvaluationDatasetMetricConfigsCopier
                    .copyToBuilder(this.datasetMetricConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetMetricConfigs(Collection<EvaluationDatasetMetricConfig.BuilderImpl> datasetMetricConfigs) {
            this.datasetMetricConfigs = EvaluationDatasetMetricConfigsCopier.copyFromBuilder(datasetMetricConfigs);
        }

        @Override
        public final Builder datasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> datasetMetricConfigs) {
            this.datasetMetricConfigs = EvaluationDatasetMetricConfigsCopier.copy(datasetMetricConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetMetricConfigs(EvaluationDatasetMetricConfig... datasetMetricConfigs) {
            datasetMetricConfigs(Arrays.asList(datasetMetricConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetMetricConfigs(Consumer<EvaluationDatasetMetricConfig.Builder>... datasetMetricConfigs) {
            datasetMetricConfigs(Stream.of(datasetMetricConfigs)
                    .map(c -> EvaluationDatasetMetricConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public HumanEvaluationConfig build() {
            return new HumanEvaluationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
