/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelCustomizationJobsResponse extends BedrockResponse implements
        ToCopyableBuilder<ListModelCustomizationJobsResponse.Builder, ListModelCustomizationJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListModelCustomizationJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ModelCustomizationJobSummary>> MODEL_CUSTOMIZATION_JOB_SUMMARIES_FIELD = SdkField
            .<List<ModelCustomizationJobSummary>> builder(MarshallingType.LIST)
            .memberName("modelCustomizationJobSummaries")
            .getter(getter(ListModelCustomizationJobsResponse::modelCustomizationJobSummaries))
            .setter(setter(Builder::modelCustomizationJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelCustomizationJobSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelCustomizationJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelCustomizationJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MODEL_CUSTOMIZATION_JOB_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ModelCustomizationJobSummary> modelCustomizationJobSummaries;

    private ListModelCustomizationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelCustomizationJobSummaries = builder.modelCustomizationJobSummaries;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
     * this token when making another request in the <code>nextToken</code> field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         use this token when making another request in the <code>nextToken</code> field to return the next batch
     *         of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelCustomizationJobSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModelCustomizationJobSummaries() {
        return modelCustomizationJobSummaries != null && !(modelCustomizationJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Job summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelCustomizationJobSummaries} method.
     * </p>
     * 
     * @return Job summaries.
     */
    public final List<ModelCustomizationJobSummary> modelCustomizationJobSummaries() {
        return modelCustomizationJobSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasModelCustomizationJobSummaries() ? modelCustomizationJobSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCustomizationJobsResponse)) {
            return false;
        }
        ListModelCustomizationJobsResponse other = (ListModelCustomizationJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasModelCustomizationJobSummaries() == other.hasModelCustomizationJobSummaries()
                && Objects.equals(modelCustomizationJobSummaries(), other.modelCustomizationJobSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListModelCustomizationJobsResponse")
                .add("NextToken", nextToken())
                .add("ModelCustomizationJobSummaries",
                        hasModelCustomizationJobSummaries() ? modelCustomizationJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "modelCustomizationJobSummaries":
            return Optional.ofNullable(clazz.cast(modelCustomizationJobSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("modelCustomizationJobSummaries", MODEL_CUSTOMIZATION_JOB_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelCustomizationJobsResponse, T> g) {
        return obj -> g.apply((ListModelCustomizationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListModelCustomizationJobsResponse> {
        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
         * this token when making another request in the <code>nextToken</code> field to return the next batch of
         * results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, use this token when making another request in the <code>nextToken</code> field to return the
         *        next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Job summaries.
         * </p>
         * 
         * @param modelCustomizationJobSummaries
         *        Job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCustomizationJobSummaries(Collection<ModelCustomizationJobSummary> modelCustomizationJobSummaries);

        /**
         * <p>
         * Job summaries.
         * </p>
         * 
         * @param modelCustomizationJobSummaries
         *        Job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCustomizationJobSummaries(ModelCustomizationJobSummary... modelCustomizationJobSummaries);

        /**
         * <p>
         * Job summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #modelCustomizationJobSummaries(List<ModelCustomizationJobSummary>)}.
         * 
         * @param modelCustomizationJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelCustomizationJobSummaries(java.util.Collection<ModelCustomizationJobSummary>)
         */
        Builder modelCustomizationJobSummaries(Consumer<ModelCustomizationJobSummary.Builder>... modelCustomizationJobSummaries);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ModelCustomizationJobSummary> modelCustomizationJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCustomizationJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            modelCustomizationJobSummaries(model.modelCustomizationJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelCustomizationJobSummary.Builder> getModelCustomizationJobSummaries() {
            List<ModelCustomizationJobSummary.Builder> result = ModelCustomizationJobSummariesCopier
                    .copyToBuilder(this.modelCustomizationJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelCustomizationJobSummaries(
                Collection<ModelCustomizationJobSummary.BuilderImpl> modelCustomizationJobSummaries) {
            this.modelCustomizationJobSummaries = ModelCustomizationJobSummariesCopier
                    .copyFromBuilder(modelCustomizationJobSummaries);
        }

        @Override
        public final Builder modelCustomizationJobSummaries(
                Collection<ModelCustomizationJobSummary> modelCustomizationJobSummaries) {
            this.modelCustomizationJobSummaries = ModelCustomizationJobSummariesCopier.copy(modelCustomizationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCustomizationJobSummaries(ModelCustomizationJobSummary... modelCustomizationJobSummaries) {
            modelCustomizationJobSummaries(Arrays.asList(modelCustomizationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCustomizationJobSummaries(
                Consumer<ModelCustomizationJobSummary.Builder>... modelCustomizationJobSummaries) {
            modelCustomizationJobSummaries(Stream.of(modelCustomizationJobSummaries)
                    .map(c -> ModelCustomizationJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelCustomizationJobsResponse build() {
            return new ListModelCustomizationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
