/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the usage terms of an offer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TermDetails implements SdkPojo, Serializable, ToCopyableBuilder<TermDetails.Builder, TermDetails> {
    private static final SdkField<PricingTerm> USAGE_BASED_PRICING_TERM_FIELD = SdkField
            .<PricingTerm> builder(MarshallingType.SDK_POJO).memberName("usageBasedPricingTerm")
            .getter(getter(TermDetails::usageBasedPricingTerm)).setter(setter(Builder::usageBasedPricingTerm))
            .constructor(PricingTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageBasedPricingTerm").build())
            .build();

    private static final SdkField<LegalTerm> LEGAL_TERM_FIELD = SdkField.<LegalTerm> builder(MarshallingType.SDK_POJO)
            .memberName("legalTerm").getter(getter(TermDetails::legalTerm)).setter(setter(Builder::legalTerm))
            .constructor(LegalTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalTerm").build()).build();

    private static final SdkField<SupportTerm> SUPPORT_TERM_FIELD = SdkField.<SupportTerm> builder(MarshallingType.SDK_POJO)
            .memberName("supportTerm").getter(getter(TermDetails::supportTerm)).setter(setter(Builder::supportTerm))
            .constructor(SupportTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportTerm").build()).build();

    private static final SdkField<ValidityTerm> VALIDITY_TERM_FIELD = SdkField.<ValidityTerm> builder(MarshallingType.SDK_POJO)
            .memberName("validityTerm").getter(getter(TermDetails::validityTerm)).setter(setter(Builder::validityTerm))
            .constructor(ValidityTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validityTerm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            USAGE_BASED_PRICING_TERM_FIELD, LEGAL_TERM_FIELD, SUPPORT_TERM_FIELD, VALIDITY_TERM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PricingTerm usageBasedPricingTerm;

    private final LegalTerm legalTerm;

    private final SupportTerm supportTerm;

    private final ValidityTerm validityTerm;

    private TermDetails(BuilderImpl builder) {
        this.usageBasedPricingTerm = builder.usageBasedPricingTerm;
        this.legalTerm = builder.legalTerm;
        this.supportTerm = builder.supportTerm;
        this.validityTerm = builder.validityTerm;
    }

    /**
     * Returns the value of the UsageBasedPricingTerm property for this object.
     * 
     * @return The value of the UsageBasedPricingTerm property for this object.
     */
    public final PricingTerm usageBasedPricingTerm() {
        return usageBasedPricingTerm;
    }

    /**
     * <p>
     * Describes the legal terms.
     * </p>
     * 
     * @return Describes the legal terms.
     */
    public final LegalTerm legalTerm() {
        return legalTerm;
    }

    /**
     * <p>
     * Describes the support terms.
     * </p>
     * 
     * @return Describes the support terms.
     */
    public final SupportTerm supportTerm() {
        return supportTerm;
    }

    /**
     * <p>
     * Describes the validity terms.
     * </p>
     * 
     * @return Describes the validity terms.
     */
    public final ValidityTerm validityTerm() {
        return validityTerm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usageBasedPricingTerm());
        hashCode = 31 * hashCode + Objects.hashCode(legalTerm());
        hashCode = 31 * hashCode + Objects.hashCode(supportTerm());
        hashCode = 31 * hashCode + Objects.hashCode(validityTerm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermDetails)) {
            return false;
        }
        TermDetails other = (TermDetails) obj;
        return Objects.equals(usageBasedPricingTerm(), other.usageBasedPricingTerm())
                && Objects.equals(legalTerm(), other.legalTerm()) && Objects.equals(supportTerm(), other.supportTerm())
                && Objects.equals(validityTerm(), other.validityTerm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TermDetails").add("UsageBasedPricingTerm", usageBasedPricingTerm())
                .add("LegalTerm", legalTerm()).add("SupportTerm", supportTerm()).add("ValidityTerm", validityTerm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usageBasedPricingTerm":
            return Optional.ofNullable(clazz.cast(usageBasedPricingTerm()));
        case "legalTerm":
            return Optional.ofNullable(clazz.cast(legalTerm()));
        case "supportTerm":
            return Optional.ofNullable(clazz.cast(supportTerm()));
        case "validityTerm":
            return Optional.ofNullable(clazz.cast(validityTerm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("usageBasedPricingTerm", USAGE_BASED_PRICING_TERM_FIELD);
        map.put("legalTerm", LEGAL_TERM_FIELD);
        map.put("supportTerm", SUPPORT_TERM_FIELD);
        map.put("validityTerm", VALIDITY_TERM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TermDetails, T> g) {
        return obj -> g.apply((TermDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TermDetails> {
        /**
         * Sets the value of the UsageBasedPricingTerm property for this object.
         *
         * @param usageBasedPricingTerm
         *        The new value for the UsageBasedPricingTerm property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageBasedPricingTerm(PricingTerm usageBasedPricingTerm);

        /**
         * Sets the value of the UsageBasedPricingTerm property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PricingTerm.Builder} avoiding the need to
         * create one manually via {@link PricingTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PricingTerm.Builder#build()} is called immediately and its result
         * is passed to {@link #usageBasedPricingTerm(PricingTerm)}.
         * 
         * @param usageBasedPricingTerm
         *        a consumer that will call methods on {@link PricingTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageBasedPricingTerm(PricingTerm)
         */
        default Builder usageBasedPricingTerm(Consumer<PricingTerm.Builder> usageBasedPricingTerm) {
            return usageBasedPricingTerm(PricingTerm.builder().applyMutation(usageBasedPricingTerm).build());
        }

        /**
         * <p>
         * Describes the legal terms.
         * </p>
         * 
         * @param legalTerm
         *        Describes the legal terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalTerm(LegalTerm legalTerm);

        /**
         * <p>
         * Describes the legal terms.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegalTerm.Builder} avoiding the need to
         * create one manually via {@link LegalTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegalTerm.Builder#build()} is called immediately and its result
         * is passed to {@link #legalTerm(LegalTerm)}.
         * 
         * @param legalTerm
         *        a consumer that will call methods on {@link LegalTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legalTerm(LegalTerm)
         */
        default Builder legalTerm(Consumer<LegalTerm.Builder> legalTerm) {
            return legalTerm(LegalTerm.builder().applyMutation(legalTerm).build());
        }

        /**
         * <p>
         * Describes the support terms.
         * </p>
         * 
         * @param supportTerm
         *        Describes the support terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportTerm(SupportTerm supportTerm);

        /**
         * <p>
         * Describes the support terms.
         * </p>
         * This is a convenience method that creates an instance of the {@link SupportTerm.Builder} avoiding the need to
         * create one manually via {@link SupportTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SupportTerm.Builder#build()} is called immediately and its result
         * is passed to {@link #supportTerm(SupportTerm)}.
         * 
         * @param supportTerm
         *        a consumer that will call methods on {@link SupportTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportTerm(SupportTerm)
         */
        default Builder supportTerm(Consumer<SupportTerm.Builder> supportTerm) {
            return supportTerm(SupportTerm.builder().applyMutation(supportTerm).build());
        }

        /**
         * <p>
         * Describes the validity terms.
         * </p>
         * 
         * @param validityTerm
         *        Describes the validity terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validityTerm(ValidityTerm validityTerm);

        /**
         * <p>
         * Describes the validity terms.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidityTerm.Builder} avoiding the need
         * to create one manually via {@link ValidityTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidityTerm.Builder#build()} is called immediately and its
         * result is passed to {@link #validityTerm(ValidityTerm)}.
         * 
         * @param validityTerm
         *        a consumer that will call methods on {@link ValidityTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validityTerm(ValidityTerm)
         */
        default Builder validityTerm(Consumer<ValidityTerm.Builder> validityTerm) {
            return validityTerm(ValidityTerm.builder().applyMutation(validityTerm).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PricingTerm usageBasedPricingTerm;

        private LegalTerm legalTerm;

        private SupportTerm supportTerm;

        private ValidityTerm validityTerm;

        private BuilderImpl() {
        }

        private BuilderImpl(TermDetails model) {
            usageBasedPricingTerm(model.usageBasedPricingTerm);
            legalTerm(model.legalTerm);
            supportTerm(model.supportTerm);
            validityTerm(model.validityTerm);
        }

        public final PricingTerm.Builder getUsageBasedPricingTerm() {
            return usageBasedPricingTerm != null ? usageBasedPricingTerm.toBuilder() : null;
        }

        public final void setUsageBasedPricingTerm(PricingTerm.BuilderImpl usageBasedPricingTerm) {
            this.usageBasedPricingTerm = usageBasedPricingTerm != null ? usageBasedPricingTerm.build() : null;
        }

        @Override
        public final Builder usageBasedPricingTerm(PricingTerm usageBasedPricingTerm) {
            this.usageBasedPricingTerm = usageBasedPricingTerm;
            return this;
        }

        public final LegalTerm.Builder getLegalTerm() {
            return legalTerm != null ? legalTerm.toBuilder() : null;
        }

        public final void setLegalTerm(LegalTerm.BuilderImpl legalTerm) {
            this.legalTerm = legalTerm != null ? legalTerm.build() : null;
        }

        @Override
        public final Builder legalTerm(LegalTerm legalTerm) {
            this.legalTerm = legalTerm;
            return this;
        }

        public final SupportTerm.Builder getSupportTerm() {
            return supportTerm != null ? supportTerm.toBuilder() : null;
        }

        public final void setSupportTerm(SupportTerm.BuilderImpl supportTerm) {
            this.supportTerm = supportTerm != null ? supportTerm.build() : null;
        }

        @Override
        public final Builder supportTerm(SupportTerm supportTerm) {
            this.supportTerm = supportTerm;
            return this;
        }

        public final ValidityTerm.Builder getValidityTerm() {
            return validityTerm != null ? validityTerm.toBuilder() : null;
        }

        public final void setValidityTerm(ValidityTerm.BuilderImpl validityTerm) {
            this.validityTerm = validityTerm != null ? validityTerm.build() : null;
        }

        @Override
        public final Builder validityTerm(ValidityTerm validityTerm) {
            this.validityTerm = validityTerm;
            return this;
        }

        @Override
        public TermDetails build() {
            return new TermDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
