/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metric for the validator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidatorMetric implements SdkPojo, Serializable, ToCopyableBuilder<ValidatorMetric.Builder, ValidatorMetric> {
    private static final SdkField<Float> VALIDATION_LOSS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("validationLoss").getter(getter(ValidatorMetric::validationLoss)).setter(setter(Builder::validationLoss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationLoss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_LOSS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float validationLoss;

    private ValidatorMetric(BuilderImpl builder) {
        this.validationLoss = builder.validationLoss;
    }

    /**
     * <p>
     * The validation loss associated with this validator.
     * </p>
     * 
     * @return The validation loss associated with this validator.
     */
    public final Float validationLoss() {
        return validationLoss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(validationLoss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatorMetric)) {
            return false;
        }
        ValidatorMetric other = (ValidatorMetric) obj;
        return Objects.equals(validationLoss(), other.validationLoss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidatorMetric").add("ValidationLoss", validationLoss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "validationLoss":
            return Optional.ofNullable(clazz.cast(validationLoss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("validationLoss", VALIDATION_LOSS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidatorMetric, T> g) {
        return obj -> g.apply((ValidatorMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidatorMetric> {
        /**
         * <p>
         * The validation loss associated with this validator.
         * </p>
         * 
         * @param validationLoss
         *        The validation loss associated with this validator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationLoss(Float validationLoss);
    }

    static final class BuilderImpl implements Builder {
        private Float validationLoss;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatorMetric model) {
            validationLoss(model.validationLoss);
        }

        public final Float getValidationLoss() {
            return validationLoss;
        }

        public final void setValidationLoss(Float validationLoss) {
            this.validationLoss = validationLoss;
        }

        @Override
        public final Builder validationLoss(Float validationLoss) {
            this.validationLoss = validationLoss;
            return this;
        }

        @Override
        public ValidatorMetric build() {
            return new ValidatorMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
