/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel;
import software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModelsCopier;
import software.amazon.awssdk.services.bedrock.model.RoutingCriteria;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePromptRouterRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreatePromptRouterRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreatePromptRouterRequest.getter(CreatePromptRouterRequest::clientRequestToken)).setter(CreatePromptRouterRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> PROMPT_ROUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptRouterName").getter(CreatePromptRouterRequest.getter(CreatePromptRouterRequest::promptRouterName)).setter(CreatePromptRouterRequest.setter(Builder::promptRouterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptRouterName").build()}).build();
    private static final SdkField<List<PromptRouterTargetModel>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("models").getter(CreatePromptRouterRequest.getter(CreatePromptRouterRequest::models)).setter(CreatePromptRouterRequest.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptRouterTargetModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreatePromptRouterRequest.getter(CreatePromptRouterRequest::description)).setter(CreatePromptRouterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<RoutingCriteria> ROUTING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("routingCriteria").getter(CreatePromptRouterRequest.getter(CreatePromptRouterRequest::routingCriteria)).setter(CreatePromptRouterRequest.setter(Builder::routingCriteria)).constructor(RoutingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingCriteria").build()}).build();
    private static final SdkField<PromptRouterTargetModel> FALLBACK_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fallbackModel").getter(CreatePromptRouterRequest.getter(CreatePromptRouterRequest::fallbackModel)).setter(CreatePromptRouterRequest.setter(Builder::fallbackModel)).constructor(PromptRouterTargetModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackModel").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreatePromptRouterRequest.getter(CreatePromptRouterRequest::tags)).setter(CreatePromptRouterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, PROMPT_ROUTER_NAME_FIELD, MODELS_FIELD, DESCRIPTION_FIELD, ROUTING_CRITERIA_FIELD, FALLBACK_MODEL_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePromptRouterRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final String promptRouterName;
    private final List<PromptRouterTargetModel> models;
    private final String description;
    private final RoutingCriteria routingCriteria;
    private final PromptRouterTargetModel fallbackModel;
    private final List<Tag> tags;

    private CreatePromptRouterRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.promptRouterName = builder.promptRouterName;
        this.models = builder.models;
        this.description = builder.description;
        this.routingCriteria = builder.routingCriteria;
        this.fallbackModel = builder.fallbackModel;
        this.tags = builder.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String promptRouterName() {
        return this.promptRouterName;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<PromptRouterTargetModel> models() {
        return this.models;
    }

    public final String description() {
        return this.description;
    }

    public final RoutingCriteria routingCriteria() {
        return this.routingCriteria;
    }

    public final PromptRouterTargetModel fallbackModel() {
        return this.fallbackModel;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptRouterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePromptRouterRequest)) {
            return false;
        }
        CreatePromptRouterRequest other = (CreatePromptRouterRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.promptRouterName(), other.promptRouterName()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.routingCriteria(), other.routingCriteria()) && Objects.equals(this.fallbackModel(), other.fallbackModel()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePromptRouterRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("PromptRouterName", (Object)this.promptRouterName()).add("Models", this.hasModels() ? this.models() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("RoutingCriteria", (Object)this.routingCriteria()).add("FallbackModel", (Object)this.fallbackModel()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "promptRouterName": {
                return Optional.ofNullable(clazz.cast(this.promptRouterName()));
            }
            case "models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "routingCriteria": {
                return Optional.ofNullable(clazz.cast(this.routingCriteria()));
            }
            case "fallbackModel": {
                return Optional.ofNullable(clazz.cast(this.fallbackModel()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("promptRouterName", PROMPT_ROUTER_NAME_FIELD);
        map.put("models", MODELS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("routingCriteria", ROUTING_CRITERIA_FIELD);
        map.put("fallbackModel", FALLBACK_MODEL_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePromptRouterRequest, T> g) {
        return obj -> g.apply((CreatePromptRouterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String promptRouterName;
        private List<PromptRouterTargetModel> models = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private RoutingCriteria routingCriteria;
        private PromptRouterTargetModel fallbackModel;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePromptRouterRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.promptRouterName(model.promptRouterName);
            this.models(model.models);
            this.description(model.description);
            this.routingCriteria(model.routingCriteria);
            this.fallbackModel(model.fallbackModel);
            this.tags(model.tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getPromptRouterName() {
            return this.promptRouterName;
        }

        public final void setPromptRouterName(String promptRouterName) {
            this.promptRouterName = promptRouterName;
        }

        @Override
        public final Builder promptRouterName(String promptRouterName) {
            this.promptRouterName = promptRouterName;
            return this;
        }

        public final List<PromptRouterTargetModel.Builder> getModels() {
            List<PromptRouterTargetModel.Builder> result = PromptRouterTargetModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<PromptRouterTargetModel.BuilderImpl> models) {
            this.models = PromptRouterTargetModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<PromptRouterTargetModel> models) {
            this.models = PromptRouterTargetModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(PromptRouterTargetModel ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<PromptRouterTargetModel.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (PromptRouterTargetModel)((PromptRouterTargetModel.Builder)PromptRouterTargetModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RoutingCriteria.Builder getRoutingCriteria() {
            return this.routingCriteria != null ? this.routingCriteria.toBuilder() : null;
        }

        public final void setRoutingCriteria(RoutingCriteria.BuilderImpl routingCriteria) {
            this.routingCriteria = routingCriteria != null ? routingCriteria.build() : null;
        }

        @Override
        public final Builder routingCriteria(RoutingCriteria routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        public final PromptRouterTargetModel.Builder getFallbackModel() {
            return this.fallbackModel != null ? this.fallbackModel.toBuilder() : null;
        }

        public final void setFallbackModel(PromptRouterTargetModel.BuilderImpl fallbackModel) {
            this.fallbackModel = fallbackModel != null ? fallbackModel.build() : null;
        }

        @Override
        public final Builder fallbackModel(PromptRouterTargetModel fallbackModel) {
            this.fallbackModel = fallbackModel;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePromptRouterRequest build() {
            return new CreatePromptRouterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePromptRouterRequest> {
        public Builder clientRequestToken(String var1);

        public Builder promptRouterName(String var1);

        public Builder models(Collection<PromptRouterTargetModel> var1);

        public Builder models(PromptRouterTargetModel ... var1);

        public Builder models(Consumer<PromptRouterTargetModel.Builder> ... var1);

        public Builder description(String var1);

        public Builder routingCriteria(RoutingCriteria var1);

        default public Builder routingCriteria(Consumer<RoutingCriteria.Builder> routingCriteria) {
            return this.routingCriteria((RoutingCriteria)((RoutingCriteria.Builder)RoutingCriteria.builder().applyMutation(routingCriteria)).build());
        }

        public Builder fallbackModel(PromptRouterTargetModel var1);

        default public Builder fallbackModel(Consumer<PromptRouterTargetModel.Builder> fallbackModel) {
            return this.fallbackModel((PromptRouterTargetModel)((PromptRouterTargetModel.Builder)PromptRouterTargetModel.builder().applyMutation(fallbackModel)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

