/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a guardrail.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListGuardrails.html#API_ListGuardrails_ResponseSyntax"
 * >ListGuardrails response body</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailSummary.Builder, GuardrailSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GuardrailSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GuardrailSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GuardrailSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GuardrailSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GuardrailSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(GuardrailSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GuardrailSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GuardrailSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<GuardrailCrossRegionDetails> CROSS_REGION_DETAILS_FIELD = SdkField
            .<GuardrailCrossRegionDetails> builder(MarshallingType.SDK_POJO).memberName("crossRegionDetails")
            .getter(getter(GuardrailSummary::crossRegionDetails)).setter(setter(Builder::crossRegionDetails))
            .constructor(GuardrailCrossRegionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossRegionDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            STATUS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, VERSION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            CROSS_REGION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String status;

    private final String name;

    private final String description;

    private final String version;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final GuardrailCrossRegionDetails crossRegionDetails;

    private GuardrailSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.name = builder.name;
        this.description = builder.description;
        this.version = builder.version;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.crossRegionDetails = builder.crossRegionDetails;
    }

    /**
     * <p>
     * The unique identifier of the guardrail.
     * </p>
     * 
     * @return The unique identifier of the guardrail.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the guardrail.
     * </p>
     * 
     * @return The ARN of the guardrail.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GuardrailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the guardrail.
     * @see GuardrailStatus
     */
    public final GuardrailStatus status() {
        return GuardrailStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GuardrailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the guardrail.
     * @see GuardrailStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the guardrail.
     * </p>
     * 
     * @return The name of the guardrail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the guardrail.
     * </p>
     * 
     * @return A description of the guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version of the guardrail.
     * </p>
     * 
     * @return The version of the guardrail.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The date and time at which the guardrail was created.
     * </p>
     * 
     * @return The date and time at which the guardrail was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time at which the guardrail was last updated.
     * </p>
     * 
     * @return The date and time at which the guardrail was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Details about the system-defined guardrail profile that you're using with your guardrail, including the guardrail
     * profile ID and Amazon Resource Name (ARN).
     * </p>
     * 
     * @return Details about the system-defined guardrail profile that you're using with your guardrail, including the
     *         guardrail profile ID and Amazon Resource Name (ARN).
     */
    public final GuardrailCrossRegionDetails crossRegionDetails() {
        return crossRegionDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(crossRegionDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailSummary)) {
            return false;
        }
        GuardrailSummary other = (GuardrailSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(version(), other.version())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(crossRegionDetails(), other.crossRegionDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailSummary").add("Id", id()).add("Arn", arn()).add("Status", statusAsString())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Version", version())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("CrossRegionDetails", crossRegionDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "crossRegionDetails":
            return Optional.ofNullable(clazz.cast(crossRegionDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("crossRegionDetails", CROSS_REGION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailSummary, T> g) {
        return obj -> g.apply((GuardrailSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailSummary> {
        /**
         * <p>
         * The unique identifier of the guardrail.
         * </p>
         * 
         * @param id
         *        The unique identifier of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the guardrail.
         * </p>
         * 
         * @param arn
         *        The ARN of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the guardrail.
         * </p>
         * 
         * @param status
         *        The status of the guardrail.
         * @see GuardrailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the guardrail.
         * </p>
         * 
         * @param status
         *        The status of the guardrail.
         * @see GuardrailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailStatus
         */
        Builder status(GuardrailStatus status);

        /**
         * <p>
         * The name of the guardrail.
         * </p>
         * 
         * @param name
         *        The name of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the guardrail.
         * </p>
         * 
         * @param description
         *        A description of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the guardrail.
         * </p>
         * 
         * @param version
         *        The version of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The date and time at which the guardrail was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time at which the guardrail was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time at which the guardrail was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time at which the guardrail was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Details about the system-defined guardrail profile that you're using with your guardrail, including the
         * guardrail profile ID and Amazon Resource Name (ARN).
         * </p>
         * 
         * @param crossRegionDetails
         *        Details about the system-defined guardrail profile that you're using with your guardrail, including
         *        the guardrail profile ID and Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionDetails(GuardrailCrossRegionDetails crossRegionDetails);

        /**
         * <p>
         * Details about the system-defined guardrail profile that you're using with your guardrail, including the
         * guardrail profile ID and Amazon Resource Name (ARN).
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailCrossRegionDetails.Builder}
         * avoiding the need to create one manually via {@link GuardrailCrossRegionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailCrossRegionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #crossRegionDetails(GuardrailCrossRegionDetails)}.
         * 
         * @param crossRegionDetails
         *        a consumer that will call methods on {@link GuardrailCrossRegionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossRegionDetails(GuardrailCrossRegionDetails)
         */
        default Builder crossRegionDetails(Consumer<GuardrailCrossRegionDetails.Builder> crossRegionDetails) {
            return crossRegionDetails(GuardrailCrossRegionDetails.builder().applyMutation(crossRegionDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private String name;

        private String description;

        private String version;

        private Instant createdAt;

        private Instant updatedAt;

        private GuardrailCrossRegionDetails crossRegionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailSummary model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            name(model.name);
            description(model.description);
            version(model.version);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            crossRegionDetails(model.crossRegionDetails);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GuardrailStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final GuardrailCrossRegionDetails.Builder getCrossRegionDetails() {
            return crossRegionDetails != null ? crossRegionDetails.toBuilder() : null;
        }

        public final void setCrossRegionDetails(GuardrailCrossRegionDetails.BuilderImpl crossRegionDetails) {
            this.crossRegionDetails = crossRegionDetails != null ? crossRegionDetails.build() : null;
        }

        @Override
        public final Builder crossRegionDetails(GuardrailCrossRegionDetails crossRegionDetails) {
            this.crossRegionDetails = crossRegionDetails;
            return this;
        }

        @Override
        public GuardrailSummary build() {
            return new GuardrailSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
