/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.OfferType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFoundationModelAgreementOffersRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, ListFoundationModelAgreementOffersRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(ListFoundationModelAgreementOffersRequest.getter(ListFoundationModelAgreementOffersRequest::modelId)).setter(ListFoundationModelAgreementOffersRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()}).build();
    private static final SdkField<String> OFFER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offerType").getter(ListFoundationModelAgreementOffersRequest.getter(ListFoundationModelAgreementOffersRequest::offerTypeAsString)).setter(ListFoundationModelAgreementOffersRequest.setter(Builder::offerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("offerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, OFFER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFoundationModelAgreementOffersRequest.memberNameToFieldInitializer();
    private final String modelId;
    private final String offerType;

    private ListFoundationModelAgreementOffersRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.offerType = builder.offerType;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final OfferType offerType() {
        return OfferType.fromValue(this.offerType);
    }

    public final String offerTypeAsString() {
        return this.offerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoundationModelAgreementOffersRequest)) {
            return false;
        }
        ListFoundationModelAgreementOffersRequest other = (ListFoundationModelAgreementOffersRequest)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.offerTypeAsString(), other.offerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListFoundationModelAgreementOffersRequest").add("ModelId", (Object)this.modelId()).add("OfferType", (Object)this.offerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "offerType": {
                return Optional.ofNullable(clazz.cast(this.offerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("offerType", OFFER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFoundationModelAgreementOffersRequest, T> g) {
        return obj -> g.apply((ListFoundationModelAgreementOffersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String modelId;
        private String offerType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoundationModelAgreementOffersRequest model) {
            super(model);
            this.modelId(model.modelId);
            this.offerType(model.offerType);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getOfferType() {
            return this.offerType;
        }

        public final void setOfferType(String offerType) {
            this.offerType = offerType;
        }

        @Override
        public final Builder offerType(String offerType) {
            this.offerType = offerType;
            return this;
        }

        @Override
        public final Builder offerType(OfferType offerType) {
            this.offerType(offerType == null ? null : offerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFoundationModelAgreementOffersRequest build() {
            return new ListFoundationModelAgreementOffersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFoundationModelAgreementOffersRequest> {
        public Builder modelId(String var1);

        public Builder offerType(String var1);

        public Builder offerType(OfferType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

