/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.MetadataAttributeSchema;
import software.amazon.awssdk.services.bedrock.model.MetadataAttributeSchemaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImplicitFilterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImplicitFilterConfiguration> {
    private static final SdkField<List<MetadataAttributeSchema>> METADATA_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadataAttributes").getter(ImplicitFilterConfiguration.getter(ImplicitFilterConfiguration::metadataAttributes)).setter(ImplicitFilterConfiguration.setter(Builder::metadataAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataAttributeSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(ImplicitFilterConfiguration.getter(ImplicitFilterConfiguration::modelArn)).setter(ImplicitFilterConfiguration.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_ATTRIBUTES_FIELD, MODEL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImplicitFilterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MetadataAttributeSchema> metadataAttributes;
    private final String modelArn;

    private ImplicitFilterConfiguration(BuilderImpl builder) {
        this.metadataAttributes = builder.metadataAttributes;
        this.modelArn = builder.modelArn;
    }

    public final boolean hasMetadataAttributes() {
        return this.metadataAttributes != null && !(this.metadataAttributes instanceof SdkAutoConstructList);
    }

    public final List<MetadataAttributeSchema> metadataAttributes() {
        return this.metadataAttributes;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataAttributes() ? this.metadataAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImplicitFilterConfiguration)) {
            return false;
        }
        ImplicitFilterConfiguration other = (ImplicitFilterConfiguration)obj;
        return this.hasMetadataAttributes() == other.hasMetadataAttributes() && Objects.equals(this.metadataAttributes(), other.metadataAttributes()) && Objects.equals(this.modelArn(), other.modelArn());
    }

    public final String toString() {
        return ToString.builder((String)"ImplicitFilterConfiguration").add("MetadataAttributes", (Object)(this.metadataAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelArn", (Object)this.modelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadataAttributes": {
                return Optional.ofNullable(clazz.cast(this.metadataAttributes()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metadataAttributes", METADATA_ATTRIBUTES_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImplicitFilterConfiguration, T> g) {
        return obj -> g.apply((ImplicitFilterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MetadataAttributeSchema> metadataAttributes = DefaultSdkAutoConstructList.getInstance();
        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ImplicitFilterConfiguration model) {
            this.metadataAttributes(model.metadataAttributes);
            this.modelArn(model.modelArn);
        }

        public final List<MetadataAttributeSchema.Builder> getMetadataAttributes() {
            List<MetadataAttributeSchema.Builder> result = MetadataAttributeSchemaListCopier.copyToBuilder(this.metadataAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataAttributes(Collection<MetadataAttributeSchema.BuilderImpl> metadataAttributes) {
            this.metadataAttributes = MetadataAttributeSchemaListCopier.copyFromBuilder(metadataAttributes);
        }

        @Override
        public final Builder metadataAttributes(Collection<MetadataAttributeSchema> metadataAttributes) {
            this.metadataAttributes = MetadataAttributeSchemaListCopier.copy(metadataAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataAttributes(MetadataAttributeSchema ... metadataAttributes) {
            this.metadataAttributes(Arrays.asList(metadataAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataAttributes(Consumer<MetadataAttributeSchema.Builder> ... metadataAttributes) {
            this.metadataAttributes(Stream.of(metadataAttributes).map(c -> (MetadataAttributeSchema)((MetadataAttributeSchema.Builder)MetadataAttributeSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public ImplicitFilterConfiguration build() {
            return new ImplicitFilterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImplicitFilterConfiguration> {
        public Builder metadataAttributes(Collection<MetadataAttributeSchema> var1);

        public Builder metadataAttributes(MetadataAttributeSchema ... var1);

        public Builder metadataAttributes(Consumer<MetadataAttributeSchema.Builder> ... var1);

        public Builder modelArn(String var1);
    }
}

