/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildDocumentContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyBuildWorkflowDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyBuildWorkflowDocument> {
    private static final SdkField<SdkBytes> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("document").getter(AutomatedReasoningPolicyBuildWorkflowDocument.getter(AutomatedReasoningPolicyBuildWorkflowDocument::document)).setter(AutomatedReasoningPolicyBuildWorkflowDocument.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<String> DOCUMENT_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentContentType").getter(AutomatedReasoningPolicyBuildWorkflowDocument.getter(AutomatedReasoningPolicyBuildWorkflowDocument::documentContentTypeAsString)).setter(AutomatedReasoningPolicyBuildWorkflowDocument.setter(Builder::documentContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentContentType").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentName").getter(AutomatedReasoningPolicyBuildWorkflowDocument.getter(AutomatedReasoningPolicyBuildWorkflowDocument::documentName)).setter(AutomatedReasoningPolicyBuildWorkflowDocument.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentName").build()}).build();
    private static final SdkField<String> DOCUMENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentDescription").getter(AutomatedReasoningPolicyBuildWorkflowDocument.getter(AutomatedReasoningPolicyBuildWorkflowDocument::documentDescription)).setter(AutomatedReasoningPolicyBuildWorkflowDocument.setter(Builder::documentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, DOCUMENT_CONTENT_TYPE_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyBuildWorkflowDocument.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes document;
    private final String documentContentType;
    private final String documentName;
    private final String documentDescription;

    private AutomatedReasoningPolicyBuildWorkflowDocument(BuilderImpl builder) {
        this.document = builder.document;
        this.documentContentType = builder.documentContentType;
        this.documentName = builder.documentName;
        this.documentDescription = builder.documentDescription;
    }

    public final SdkBytes document() {
        return this.document;
    }

    public final AutomatedReasoningPolicyBuildDocumentContentType documentContentType() {
        return AutomatedReasoningPolicyBuildDocumentContentType.fromValue(this.documentContentType);
    }

    public final String documentContentTypeAsString() {
        return this.documentContentType;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentDescription() {
        return this.documentDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildWorkflowDocument)) {
            return false;
        }
        AutomatedReasoningPolicyBuildWorkflowDocument other = (AutomatedReasoningPolicyBuildWorkflowDocument)obj;
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.documentContentTypeAsString(), other.documentContentTypeAsString()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentDescription(), other.documentDescription());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyBuildWorkflowDocument").add("Document", (Object)this.document()).add("DocumentContentType", (Object)this.documentContentTypeAsString()).add("DocumentName", (Object)(this.documentName() == null ? null : "*** Sensitive Data Redacted ***")).add("DocumentDescription", (Object)(this.documentDescription() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "documentContentType": {
                return Optional.ofNullable(clazz.cast(this.documentContentTypeAsString()));
            }
            case "documentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "documentDescription": {
                return Optional.ofNullable(clazz.cast(this.documentDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("document", DOCUMENT_FIELD);
        map.put("documentContentType", DOCUMENT_CONTENT_TYPE_FIELD);
        map.put("documentName", DOCUMENT_NAME_FIELD);
        map.put("documentDescription", DOCUMENT_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildWorkflowDocument, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildWorkflowDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes document;
        private String documentContentType;
        private String documentName;
        private String documentDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildWorkflowDocument model) {
            this.document(model.document);
            this.documentContentType(model.documentContentType);
            this.documentName(model.documentName);
            this.documentDescription(model.documentDescription);
        }

        public final ByteBuffer getDocument() {
            return this.document == null ? null : this.document.asByteBuffer();
        }

        public final void setDocument(ByteBuffer document) {
            this.document(document == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)document));
        }

        @Override
        public final Builder document(SdkBytes document) {
            this.document = document;
            return this;
        }

        public final String getDocumentContentType() {
            return this.documentContentType;
        }

        public final void setDocumentContentType(String documentContentType) {
            this.documentContentType = documentContentType;
        }

        @Override
        public final Builder documentContentType(String documentContentType) {
            this.documentContentType = documentContentType;
            return this;
        }

        @Override
        public final Builder documentContentType(AutomatedReasoningPolicyBuildDocumentContentType documentContentType) {
            this.documentContentType(documentContentType == null ? null : documentContentType.toString());
            return this;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentDescription() {
            return this.documentDescription;
        }

        public final void setDocumentDescription(String documentDescription) {
            this.documentDescription = documentDescription;
        }

        @Override
        public final Builder documentDescription(String documentDescription) {
            this.documentDescription = documentDescription;
            return this;
        }

        public AutomatedReasoningPolicyBuildWorkflowDocument build() {
            return new AutomatedReasoningPolicyBuildWorkflowDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyBuildWorkflowDocument> {
        public Builder document(SdkBytes var1);

        public Builder documentContentType(String var1);

        public Builder documentContentType(AutomatedReasoningPolicyBuildDocumentContentType var1);

        public Builder documentName(String var1);

        public Builder documentDescription(String var1);
    }
}

