/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowSource;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowType;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAutomatedReasoningPolicyBuildWorkflowRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, StartAutomatedReasoningPolicyBuildWorkflowRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(StartAutomatedReasoningPolicyBuildWorkflowRequest.getter(StartAutomatedReasoningPolicyBuildWorkflowRequest::policyArn)).setter(StartAutomatedReasoningPolicyBuildWorkflowRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()}).build();
    private static final SdkField<String> BUILD_WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildWorkflowType").getter(StartAutomatedReasoningPolicyBuildWorkflowRequest.getter(StartAutomatedReasoningPolicyBuildWorkflowRequest::buildWorkflowTypeAsString)).setter(StartAutomatedReasoningPolicyBuildWorkflowRequest.setter(Builder::buildWorkflowType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("buildWorkflowType").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(StartAutomatedReasoningPolicyBuildWorkflowRequest.getter(StartAutomatedReasoningPolicyBuildWorkflowRequest::clientRequestToken)).setter(StartAutomatedReasoningPolicyBuildWorkflowRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-client-token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<AutomatedReasoningPolicyBuildWorkflowSource> SOURCE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceContent").getter(StartAutomatedReasoningPolicyBuildWorkflowRequest.getter(StartAutomatedReasoningPolicyBuildWorkflowRequest::sourceContent)).setter(StartAutomatedReasoningPolicyBuildWorkflowRequest.setter(Builder::sourceContent)).constructor(AutomatedReasoningPolicyBuildWorkflowSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceContent").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, BUILD_WORKFLOW_TYPE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, SOURCE_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAutomatedReasoningPolicyBuildWorkflowRequest.memberNameToFieldInitializer();
    private final String policyArn;
    private final String buildWorkflowType;
    private final String clientRequestToken;
    private final AutomatedReasoningPolicyBuildWorkflowSource sourceContent;

    private StartAutomatedReasoningPolicyBuildWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowType = builder.buildWorkflowType;
        this.clientRequestToken = builder.clientRequestToken;
        this.sourceContent = builder.sourceContent;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final AutomatedReasoningPolicyBuildWorkflowType buildWorkflowType() {
        return AutomatedReasoningPolicyBuildWorkflowType.fromValue(this.buildWorkflowType);
    }

    public final String buildWorkflowTypeAsString() {
        return this.buildWorkflowType;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final AutomatedReasoningPolicyBuildWorkflowSource sourceContent() {
        return this.sourceContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildWorkflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomatedReasoningPolicyBuildWorkflowRequest)) {
            return false;
        }
        StartAutomatedReasoningPolicyBuildWorkflowRequest other = (StartAutomatedReasoningPolicyBuildWorkflowRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.buildWorkflowTypeAsString(), other.buildWorkflowTypeAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.sourceContent(), other.sourceContent());
    }

    public final String toString() {
        return ToString.builder((String)"StartAutomatedReasoningPolicyBuildWorkflowRequest").add("PolicyArn", (Object)this.policyArn()).add("BuildWorkflowType", (Object)this.buildWorkflowTypeAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("SourceContent", (Object)this.sourceContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "buildWorkflowType": {
                return Optional.ofNullable(clazz.cast(this.buildWorkflowTypeAsString()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "sourceContent": {
                return Optional.ofNullable(clazz.cast(this.sourceContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowType", BUILD_WORKFLOW_TYPE_FIELD);
        map.put("x-amz-client-token", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("sourceContent", SOURCE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAutomatedReasoningPolicyBuildWorkflowRequest, T> g) {
        return obj -> g.apply((StartAutomatedReasoningPolicyBuildWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String buildWorkflowType;
        private String clientRequestToken;
        private AutomatedReasoningPolicyBuildWorkflowSource sourceContent;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomatedReasoningPolicyBuildWorkflowRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.buildWorkflowType(model.buildWorkflowType);
            this.clientRequestToken(model.clientRequestToken);
            this.sourceContent(model.sourceContent);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowType() {
            return this.buildWorkflowType;
        }

        public final void setBuildWorkflowType(String buildWorkflowType) {
            this.buildWorkflowType = buildWorkflowType;
        }

        @Override
        public final Builder buildWorkflowType(String buildWorkflowType) {
            this.buildWorkflowType = buildWorkflowType;
            return this;
        }

        @Override
        public final Builder buildWorkflowType(AutomatedReasoningPolicyBuildWorkflowType buildWorkflowType) {
            this.buildWorkflowType(buildWorkflowType == null ? null : buildWorkflowType.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final AutomatedReasoningPolicyBuildWorkflowSource.Builder getSourceContent() {
            return this.sourceContent != null ? this.sourceContent.toBuilder() : null;
        }

        public final void setSourceContent(AutomatedReasoningPolicyBuildWorkflowSource.BuilderImpl sourceContent) {
            this.sourceContent = sourceContent != null ? sourceContent.build() : null;
        }

        @Override
        public final Builder sourceContent(AutomatedReasoningPolicyBuildWorkflowSource sourceContent) {
            this.sourceContent = sourceContent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAutomatedReasoningPolicyBuildWorkflowRequest build() {
            return new StartAutomatedReasoningPolicyBuildWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAutomatedReasoningPolicyBuildWorkflowRequest> {
        public Builder policyArn(String var1);

        public Builder buildWorkflowType(String var1);

        public Builder buildWorkflowType(AutomatedReasoningPolicyBuildWorkflowType var1);

        public Builder clientRequestToken(String var1);

        public Builder sourceContent(AutomatedReasoningPolicyBuildWorkflowSource var1);

        default public Builder sourceContent(Consumer<AutomatedReasoningPolicyBuildWorkflowSource.Builder> sourceContent) {
            return this.sourceContent((AutomatedReasoningPolicyBuildWorkflowSource)((AutomatedReasoningPolicyBuildWorkflowSource.Builder)AutomatedReasoningPolicyBuildWorkflowSource.builder().applyMutation(sourceContent)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

