/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutomatedReasoningPolicyResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, UpdateAutomatedReasoningPolicyResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(UpdateAutomatedReasoningPolicyResponse.getter(UpdateAutomatedReasoningPolicyResponse::policyArn)).setter(UpdateAutomatedReasoningPolicyResponse.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateAutomatedReasoningPolicyResponse.getter(UpdateAutomatedReasoningPolicyResponse::name)).setter(UpdateAutomatedReasoningPolicyResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DEFINITION_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definitionHash").getter(UpdateAutomatedReasoningPolicyResponse.getter(UpdateAutomatedReasoningPolicyResponse::definitionHash)).setter(UpdateAutomatedReasoningPolicyResponse.setter(Builder::definitionHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionHash").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdateAutomatedReasoningPolicyResponse.getter(UpdateAutomatedReasoningPolicyResponse::updatedAt)).setter(UpdateAutomatedReasoningPolicyResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, NAME_FIELD, DEFINITION_HASH_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutomatedReasoningPolicyResponse.memberNameToFieldInitializer();
    private final String policyArn;
    private final String name;
    private final String definitionHash;
    private final Instant updatedAt;

    private UpdateAutomatedReasoningPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.name = builder.name;
        this.definitionHash = builder.definitionHash;
        this.updatedAt = builder.updatedAt;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String name() {
        return this.name;
    }

    public final String definitionHash() {
        return this.definitionHash;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyResponse)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyResponse other = (UpdateAutomatedReasoningPolicyResponse)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.definitionHash(), other.definitionHash()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutomatedReasoningPolicyResponse").add("PolicyArn", (Object)this.policyArn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("DefinitionHash", (Object)this.definitionHash()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "definitionHash": {
                return Optional.ofNullable(clazz.cast(this.definitionHash()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("definitionHash", DEFINITION_HASH_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyResponse, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String policyArn;
        private String name;
        private String definitionHash;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyResponse model) {
            super(model);
            this.policyArn(model.policyArn);
            this.name(model.name);
            this.definitionHash(model.definitionHash);
            this.updatedAt(model.updatedAt);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefinitionHash() {
            return this.definitionHash;
        }

        public final void setDefinitionHash(String definitionHash) {
            this.definitionHash = definitionHash;
        }

        @Override
        public final Builder definitionHash(String definitionHash) {
            this.definitionHash = definitionHash;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyResponse build() {
            return new UpdateAutomatedReasoningPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyResponse> {
        public Builder policyArn(String var1);

        public Builder name(String var1);

        public Builder definitionHash(String var1);

        public Builder updatedAt(Instant var1);
    }
}

