/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobRequest;
import software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobResponse;
import software.amazon.awssdk.services.bedrock.model.CancelAutomatedReasoningPolicyBuildWorkflowRequest;
import software.amazon.awssdk.services.bedrock.model.CancelAutomatedReasoningPolicyBuildWorkflowResponse;
import software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyRequest;
import software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyResponse;
import software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyTestCaseRequest;
import software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyTestCaseResponse;
import software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyVersionRequest;
import software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyVersionResponse;
import software.amazon.awssdk.services.bedrock.model.CreateCustomModelDeploymentRequest;
import software.amazon.awssdk.services.bedrock.model.CreateCustomModelDeploymentResponse;
import software.amazon.awssdk.services.bedrock.model.CreateCustomModelRequest;
import software.amazon.awssdk.services.bedrock.model.CreateCustomModelResponse;
import software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobRequest;
import software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobResponse;
import software.amazon.awssdk.services.bedrock.model.CreateFoundationModelAgreementRequest;
import software.amazon.awssdk.services.bedrock.model.CreateFoundationModelAgreementResponse;
import software.amazon.awssdk.services.bedrock.model.CreateGuardrailRequest;
import software.amazon.awssdk.services.bedrock.model.CreateGuardrailResponse;
import software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionRequest;
import software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionResponse;
import software.amazon.awssdk.services.bedrock.model.CreateInferenceProfileRequest;
import software.amazon.awssdk.services.bedrock.model.CreateInferenceProfileResponse;
import software.amazon.awssdk.services.bedrock.model.CreateMarketplaceModelEndpointRequest;
import software.amazon.awssdk.services.bedrock.model.CreateMarketplaceModelEndpointResponse;
import software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobRequest;
import software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobResponse;
import software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobRequest;
import software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobResponse;
import software.amazon.awssdk.services.bedrock.model.CreateModelImportJobRequest;
import software.amazon.awssdk.services.bedrock.model.CreateModelImportJobResponse;
import software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobRequest;
import software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobResponse;
import software.amazon.awssdk.services.bedrock.model.CreatePromptRouterRequest;
import software.amazon.awssdk.services.bedrock.model.CreatePromptRouterResponse;
import software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputRequest;
import software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyBuildWorkflowRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyBuildWorkflowResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyTestCaseRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyTestCaseResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteCustomModelDeploymentRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteCustomModelDeploymentResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteCustomModelRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteCustomModelResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteFoundationModelAgreementRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteFoundationModelAgreementResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteGuardrailRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteGuardrailResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteImportedModelRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteImportedModelResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteInferenceProfileRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteInferenceProfileResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteMarketplaceModelEndpointRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteMarketplaceModelEndpointResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteModelInvocationLoggingConfigurationRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteModelInvocationLoggingConfigurationResponse;
import software.amazon.awssdk.services.bedrock.model.DeletePromptRouterRequest;
import software.amazon.awssdk.services.bedrock.model.DeletePromptRouterResponse;
import software.amazon.awssdk.services.bedrock.model.DeleteProvisionedModelThroughputRequest;
import software.amazon.awssdk.services.bedrock.model.DeleteProvisionedModelThroughputResponse;
import software.amazon.awssdk.services.bedrock.model.DeregisterMarketplaceModelEndpointRequest;
import software.amazon.awssdk.services.bedrock.model.DeregisterMarketplaceModelEndpointResponse;
import software.amazon.awssdk.services.bedrock.model.ExportAutomatedReasoningPolicyVersionRequest;
import software.amazon.awssdk.services.bedrock.model.ExportAutomatedReasoningPolicyVersionResponse;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyAnnotationsRequest;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyAnnotationsResponse;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyBuildWorkflowRequest;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyBuildWorkflowResponse;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyBuildWorkflowResultAssetsResponse;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyNextScenarioRequest;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyNextScenarioResponse;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyRequest;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyResponse;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyTestCaseRequest;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyTestCaseResponse;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyTestResultRequest;
import software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyTestResultResponse;
import software.amazon.awssdk.services.bedrock.model.GetCustomModelDeploymentRequest;
import software.amazon.awssdk.services.bedrock.model.GetCustomModelDeploymentResponse;
import software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest;
import software.amazon.awssdk.services.bedrock.model.GetCustomModelResponse;
import software.amazon.awssdk.services.bedrock.model.GetEvaluationJobRequest;
import software.amazon.awssdk.services.bedrock.model.GetEvaluationJobResponse;
import software.amazon.awssdk.services.bedrock.model.GetFoundationModelAvailabilityRequest;
import software.amazon.awssdk.services.bedrock.model.GetFoundationModelAvailabilityResponse;
import software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest;
import software.amazon.awssdk.services.bedrock.model.GetFoundationModelResponse;
import software.amazon.awssdk.services.bedrock.model.GetGuardrailRequest;
import software.amazon.awssdk.services.bedrock.model.GetGuardrailResponse;
import software.amazon.awssdk.services.bedrock.model.GetImportedModelRequest;
import software.amazon.awssdk.services.bedrock.model.GetImportedModelResponse;
import software.amazon.awssdk.services.bedrock.model.GetInferenceProfileRequest;
import software.amazon.awssdk.services.bedrock.model.GetInferenceProfileResponse;
import software.amazon.awssdk.services.bedrock.model.GetMarketplaceModelEndpointRequest;
import software.amazon.awssdk.services.bedrock.model.GetMarketplaceModelEndpointResponse;
import software.amazon.awssdk.services.bedrock.model.GetModelCopyJobRequest;
import software.amazon.awssdk.services.bedrock.model.GetModelCopyJobResponse;
import software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobRequest;
import software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobResponse;
import software.amazon.awssdk.services.bedrock.model.GetModelImportJobRequest;
import software.amazon.awssdk.services.bedrock.model.GetModelImportJobResponse;
import software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobRequest;
import software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobResponse;
import software.amazon.awssdk.services.bedrock.model.GetModelInvocationLoggingConfigurationRequest;
import software.amazon.awssdk.services.bedrock.model.GetModelInvocationLoggingConfigurationResponse;
import software.amazon.awssdk.services.bedrock.model.GetPromptRouterRequest;
import software.amazon.awssdk.services.bedrock.model.GetPromptRouterResponse;
import software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputRequest;
import software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputResponse;
import software.amazon.awssdk.services.bedrock.model.GetUseCaseForModelAccessRequest;
import software.amazon.awssdk.services.bedrock.model.GetUseCaseForModelAccessResponse;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesResponse;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsResponse;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesResponse;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsResponse;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsResponse;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse;
import software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ListFoundationModelAgreementOffersRequest;
import software.amazon.awssdk.services.bedrock.model.ListFoundationModelAgreementOffersResponse;
import software.amazon.awssdk.services.bedrock.model.ListFoundationModelsRequest;
import software.amazon.awssdk.services.bedrock.model.ListFoundationModelsResponse;
import software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest;
import software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse;
import software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest;
import software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse;
import software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest;
import software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse;
import software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest;
import software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsResponse;
import software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest;
import software.amazon.awssdk.services.bedrock.model.ListPromptRoutersResponse;
import software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest;
import software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse;
import software.amazon.awssdk.services.bedrock.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bedrock.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest;
import software.amazon.awssdk.services.bedrock.model.PutModelInvocationLoggingConfigurationResponse;
import software.amazon.awssdk.services.bedrock.model.PutUseCaseForModelAccessRequest;
import software.amazon.awssdk.services.bedrock.model.PutUseCaseForModelAccessResponse;
import software.amazon.awssdk.services.bedrock.model.RegisterMarketplaceModelEndpointRequest;
import software.amazon.awssdk.services.bedrock.model.RegisterMarketplaceModelEndpointResponse;
import software.amazon.awssdk.services.bedrock.model.StartAutomatedReasoningPolicyBuildWorkflowRequest;
import software.amazon.awssdk.services.bedrock.model.StartAutomatedReasoningPolicyBuildWorkflowResponse;
import software.amazon.awssdk.services.bedrock.model.StartAutomatedReasoningPolicyTestWorkflowRequest;
import software.amazon.awssdk.services.bedrock.model.StartAutomatedReasoningPolicyTestWorkflowResponse;
import software.amazon.awssdk.services.bedrock.model.StopEvaluationJobRequest;
import software.amazon.awssdk.services.bedrock.model.StopEvaluationJobResponse;
import software.amazon.awssdk.services.bedrock.model.StopModelCustomizationJobRequest;
import software.amazon.awssdk.services.bedrock.model.StopModelCustomizationJobResponse;
import software.amazon.awssdk.services.bedrock.model.StopModelInvocationJobRequest;
import software.amazon.awssdk.services.bedrock.model.StopModelInvocationJobResponse;
import software.amazon.awssdk.services.bedrock.model.TagResourceRequest;
import software.amazon.awssdk.services.bedrock.model.TagResourceResponse;
import software.amazon.awssdk.services.bedrock.model.UntagResourceRequest;
import software.amazon.awssdk.services.bedrock.model.UntagResourceResponse;
import software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyAnnotationsRequest;
import software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyAnnotationsResponse;
import software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyRequest;
import software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyResponse;
import software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyTestCaseRequest;
import software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyTestCaseResponse;
import software.amazon.awssdk.services.bedrock.model.UpdateGuardrailRequest;
import software.amazon.awssdk.services.bedrock.model.UpdateGuardrailResponse;
import software.amazon.awssdk.services.bedrock.model.UpdateMarketplaceModelEndpointRequest;
import software.amazon.awssdk.services.bedrock.model.UpdateMarketplaceModelEndpointResponse;
import software.amazon.awssdk.services.bedrock.model.UpdateProvisionedModelThroughputRequest;
import software.amazon.awssdk.services.bedrock.model.UpdateProvisionedModelThroughputResponse;
import software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPoliciesPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyBuildWorkflowsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestCasesPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestResultsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListCustomModelDeploymentsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListCustomModelsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListEvaluationJobsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListGuardrailsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListImportedModelsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListInferenceProfilesPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListMarketplaceModelEndpointsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListModelCopyJobsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListModelCustomizationJobsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListModelImportJobsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListModelInvocationJobsPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListPromptRoutersPublisher;
import software.amazon.awssdk.services.bedrock.paginators.ListProvisionedModelThroughputsPublisher;

/**
 * Service client for accessing Amazon Bedrock asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Describes the API operations for creating, managing, fine-turning, and evaluating Amazon Bedrock models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock";

    /**
     * <p>
     * Deletes a batch of evaluation jobs. An evaluation job can only be deleted if it has following status
     * <code>FAILED</code>, <code>COMPLETED</code>, and <code>STOPPED</code>. You can request up to 25 model evaluation
     * jobs be deleted in a single request.
     * </p>
     *
     * @param batchDeleteEvaluationJobRequest
     * @return A Java Future containing the result of the BatchDeleteEvaluationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.BatchDeleteEvaluationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/BatchDeleteEvaluationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteEvaluationJobResponse> batchDeleteEvaluationJob(
            BatchDeleteEvaluationJobRequest batchDeleteEvaluationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a batch of evaluation jobs. An evaluation job can only be deleted if it has following status
     * <code>FAILED</code>, <code>COMPLETED</code>, and <code>STOPPED</code>. You can request up to 25 model evaluation
     * jobs be deleted in a single request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteEvaluationJobRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteEvaluationJobRequest#builder()}
     * </p>
     *
     * @param batchDeleteEvaluationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteEvaluationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.BatchDeleteEvaluationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/BatchDeleteEvaluationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteEvaluationJobResponse> batchDeleteEvaluationJob(
            Consumer<BatchDeleteEvaluationJobRequest.Builder> batchDeleteEvaluationJobRequest) {
        return batchDeleteEvaluationJob(BatchDeleteEvaluationJobRequest.builder().applyMutation(batchDeleteEvaluationJobRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a running Automated Reasoning policy build workflow. This stops the policy generation process and
     * prevents further processing of the source documents.
     * </p>
     *
     * @param cancelAutomatedReasoningPolicyBuildWorkflowRequest
     * @return A Java Future containing the result of the CancelAutomatedReasoningPolicyBuildWorkflow operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CancelAutomatedReasoningPolicyBuildWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CancelAutomatedReasoningPolicyBuildWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelAutomatedReasoningPolicyBuildWorkflowResponse> cancelAutomatedReasoningPolicyBuildWorkflow(
            CancelAutomatedReasoningPolicyBuildWorkflowRequest cancelAutomatedReasoningPolicyBuildWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a running Automated Reasoning policy build workflow. This stops the policy generation process and
     * prevents further processing of the source documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CancelAutomatedReasoningPolicyBuildWorkflowRequest.Builder} avoiding the need to create one manually via
     * {@link CancelAutomatedReasoningPolicyBuildWorkflowRequest#builder()}
     * </p>
     *
     * @param cancelAutomatedReasoningPolicyBuildWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CancelAutomatedReasoningPolicyBuildWorkflowRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CancelAutomatedReasoningPolicyBuildWorkflow operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CancelAutomatedReasoningPolicyBuildWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CancelAutomatedReasoningPolicyBuildWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelAutomatedReasoningPolicyBuildWorkflowResponse> cancelAutomatedReasoningPolicyBuildWorkflow(
            Consumer<CancelAutomatedReasoningPolicyBuildWorkflowRequest.Builder> cancelAutomatedReasoningPolicyBuildWorkflowRequest) {
        return cancelAutomatedReasoningPolicyBuildWorkflow(CancelAutomatedReasoningPolicyBuildWorkflowRequest.builder()
                .applyMutation(cancelAutomatedReasoningPolicyBuildWorkflowRequest).build());
    }

    /**
     * <p>
     * Creates an Automated Reasoning policy for Amazon Bedrock Guardrails. Automated Reasoning policies use
     * mathematical techniques to detect hallucinations, suggest corrections, and highlight unstated assumptions in the
     * responses of your GenAI application.
     * </p>
     * <p>
     * To create a policy, you upload a source document that describes the rules that you're encoding. Automated
     * Reasoning extracts important concepts from the source document that will become variables in the policy and
     * infers policy rules.
     * </p>
     *
     * @param createAutomatedReasoningPolicyRequest
     * @return A Java Future containing the result of the CreateAutomatedReasoningPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateAutomatedReasoningPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateAutomatedReasoningPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAutomatedReasoningPolicyResponse> createAutomatedReasoningPolicy(
            CreateAutomatedReasoningPolicyRequest createAutomatedReasoningPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Automated Reasoning policy for Amazon Bedrock Guardrails. Automated Reasoning policies use
     * mathematical techniques to detect hallucinations, suggest corrections, and highlight unstated assumptions in the
     * responses of your GenAI application.
     * </p>
     * <p>
     * To create a policy, you upload a source document that describes the rules that you're encoding. Automated
     * Reasoning extracts important concepts from the source document that will become variables in the policy and
     * infers policy rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutomatedReasoningPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAutomatedReasoningPolicyRequest#builder()}
     * </p>
     *
     * @param createAutomatedReasoningPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAutomatedReasoningPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateAutomatedReasoningPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateAutomatedReasoningPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAutomatedReasoningPolicyResponse> createAutomatedReasoningPolicy(
            Consumer<CreateAutomatedReasoningPolicyRequest.Builder> createAutomatedReasoningPolicyRequest) {
        return createAutomatedReasoningPolicy(CreateAutomatedReasoningPolicyRequest.builder()
                .applyMutation(createAutomatedReasoningPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a test for an Automated Reasoning policy. Tests validate that your policy works as expected by providing
     * sample inputs and expected outcomes. Use tests to verify policy behavior before deploying to production.
     * </p>
     *
     * @param createAutomatedReasoningPolicyTestCaseRequest
     * @return A Java Future containing the result of the CreateAutomatedReasoningPolicyTestCase operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateAutomatedReasoningPolicyTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateAutomatedReasoningPolicyTestCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAutomatedReasoningPolicyTestCaseResponse> createAutomatedReasoningPolicyTestCase(
            CreateAutomatedReasoningPolicyTestCaseRequest createAutomatedReasoningPolicyTestCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a test for an Automated Reasoning policy. Tests validate that your policy works as expected by providing
     * sample inputs and expected outcomes. Use tests to verify policy behavior before deploying to production.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateAutomatedReasoningPolicyTestCaseRequest.Builder} avoiding the need to create one manually via
     * {@link CreateAutomatedReasoningPolicyTestCaseRequest#builder()}
     * </p>
     *
     * @param createAutomatedReasoningPolicyTestCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyTestCaseRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateAutomatedReasoningPolicyTestCase operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateAutomatedReasoningPolicyTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateAutomatedReasoningPolicyTestCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAutomatedReasoningPolicyTestCaseResponse> createAutomatedReasoningPolicyTestCase(
            Consumer<CreateAutomatedReasoningPolicyTestCaseRequest.Builder> createAutomatedReasoningPolicyTestCaseRequest) {
        return createAutomatedReasoningPolicyTestCase(CreateAutomatedReasoningPolicyTestCaseRequest.builder()
                .applyMutation(createAutomatedReasoningPolicyTestCaseRequest).build());
    }

    /**
     * <p>
     * Creates a new version of an existing Automated Reasoning policy. This allows you to iterate on your policy rules
     * while maintaining previous versions for rollback or comparison purposes.
     * </p>
     *
     * @param createAutomatedReasoningPolicyVersionRequest
     * @return A Java Future containing the result of the CreateAutomatedReasoningPolicyVersion operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateAutomatedReasoningPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateAutomatedReasoningPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAutomatedReasoningPolicyVersionResponse> createAutomatedReasoningPolicyVersion(
            CreateAutomatedReasoningPolicyVersionRequest createAutomatedReasoningPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of an existing Automated Reasoning policy. This allows you to iterate on your policy rules
     * while maintaining previous versions for rollback or comparison purposes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateAutomatedReasoningPolicyVersionRequest.Builder} avoiding the need to create one manually via
     * {@link CreateAutomatedReasoningPolicyVersionRequest#builder()}
     * </p>
     *
     * @param createAutomatedReasoningPolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateAutomatedReasoningPolicyVersionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateAutomatedReasoningPolicyVersion operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateAutomatedReasoningPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateAutomatedReasoningPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAutomatedReasoningPolicyVersionResponse> createAutomatedReasoningPolicyVersion(
            Consumer<CreateAutomatedReasoningPolicyVersionRequest.Builder> createAutomatedReasoningPolicyVersionRequest) {
        return createAutomatedReasoningPolicyVersion(CreateAutomatedReasoningPolicyVersionRequest.builder()
                .applyMutation(createAutomatedReasoningPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Creates a new custom model in Amazon Bedrock. After the model is active, you can use it for inference.
     * </p>
     * <p>
     * To use the model for inference, you must purchase Provisioned Throughput for it. You can't use On-demand
     * inference with these custom models. For more information about Provisioned Throughput, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a>.
     * </p>
     * <p>
     * The model appears in <code>ListCustomModels</code> with a <code>customizationType</code> of <code>imported</code>
     * . To track the status of the new model, you use the <code>GetCustomModel</code> API operation. The model can be
     * in the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Creating</code> - Initial state during validation and registration
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Active</code> - Model is ready for use in inference
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - Creation process encountered an error
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModel.html">GetCustomModel</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModels.html">ListCustomModels</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModel.html">DeleteCustomModel</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createCustomModelRequest
     * @return A Java Future containing the result of the CreateCustomModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateCustomModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateCustomModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCustomModelResponse> createCustomModel(CreateCustomModelRequest createCustomModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom model in Amazon Bedrock. After the model is active, you can use it for inference.
     * </p>
     * <p>
     * To use the model for inference, you must purchase Provisioned Throughput for it. You can't use On-demand
     * inference with these custom models. For more information about Provisioned Throughput, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a>.
     * </p>
     * <p>
     * The model appears in <code>ListCustomModels</code> with a <code>customizationType</code> of <code>imported</code>
     * . To track the status of the new model, you use the <code>GetCustomModel</code> API operation. The model can be
     * in the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Creating</code> - Initial state during validation and registration
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Active</code> - Model is ready for use in inference
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - Creation process encountered an error
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModel.html">GetCustomModel</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModels.html">ListCustomModels</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModel.html">DeleteCustomModel</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomModelRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCustomModelRequest#builder()}
     * </p>
     *
     * @param createCustomModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateCustomModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCustomModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateCustomModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateCustomModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCustomModelResponse> createCustomModel(
            Consumer<CreateCustomModelRequest.Builder> createCustomModelRequest) {
        return createCustomModel(CreateCustomModelRequest.builder().applyMutation(createCustomModelRequest).build());
    }

    /**
     * <p>
     * Deploys a custom model for on-demand inference in Amazon Bedrock. After you deploy your custom model, you use the
     * deployment's Amazon Resource Name (ARN) as the <code>modelId</code> parameter when you submit prompts and
     * generate responses with model inference.
     * </p>
     * <p>
     * For more information about setting up on-demand inference for custom models, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Set up inference for a
     * custom model</a>.
     * </p>
     * <p>
     * The following actions are related to the <code>CreateCustomModelDeployment</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModelDeployment.html">
     * GetCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModelDeployments.html">
     * ListCustomModelDeployments</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html">
     * DeleteCustomModelDeployment</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createCustomModelDeploymentRequest
     * @return A Java Future containing the result of the CreateCustomModelDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateCustomModelDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateCustomModelDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomModelDeploymentResponse> createCustomModelDeployment(
            CreateCustomModelDeploymentRequest createCustomModelDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys a custom model for on-demand inference in Amazon Bedrock. After you deploy your custom model, you use the
     * deployment's Amazon Resource Name (ARN) as the <code>modelId</code> parameter when you submit prompts and
     * generate responses with model inference.
     * </p>
     * <p>
     * For more information about setting up on-demand inference for custom models, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Set up inference for a
     * custom model</a>.
     * </p>
     * <p>
     * The following actions are related to the <code>CreateCustomModelDeployment</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModelDeployment.html">
     * GetCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModelDeployments.html">
     * ListCustomModelDeployments</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html">
     * DeleteCustomModelDeployment</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomModelDeploymentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomModelDeploymentRequest#builder()}
     * </p>
     *
     * @param createCustomModelDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateCustomModelDeploymentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateCustomModelDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateCustomModelDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateCustomModelDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomModelDeploymentResponse> createCustomModelDeployment(
            Consumer<CreateCustomModelDeploymentRequest.Builder> createCustomModelDeploymentRequest) {
        return createCustomModelDeployment(CreateCustomModelDeploymentRequest.builder()
                .applyMutation(createCustomModelDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates an evaluation job.
     * </p>
     *
     * @param createEvaluationJobRequest
     * @return A Java Future containing the result of the CreateEvaluationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateEvaluationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateEvaluationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEvaluationJobResponse> createEvaluationJob(
            CreateEvaluationJobRequest createEvaluationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an evaluation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEvaluationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEvaluationJobRequest#builder()}
     * </p>
     *
     * @param createEvaluationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEvaluationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateEvaluationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateEvaluationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEvaluationJobResponse> createEvaluationJob(
            Consumer<CreateEvaluationJobRequest.Builder> createEvaluationJobRequest) {
        return createEvaluationJob(CreateEvaluationJobRequest.builder().applyMutation(createEvaluationJobRequest).build());
    }

    /**
     * <p>
     * Request a model access agreement for the specified model.
     * </p>
     *
     * @param createFoundationModelAgreementRequest
     * @return A Java Future containing the result of the CreateFoundationModelAgreement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateFoundationModelAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateFoundationModelAgreement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFoundationModelAgreementResponse> createFoundationModelAgreement(
            CreateFoundationModelAgreementRequest createFoundationModelAgreementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request a model access agreement for the specified model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFoundationModelAgreementRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFoundationModelAgreementRequest#builder()}
     * </p>
     *
     * @param createFoundationModelAgreementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateFoundationModelAgreementRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateFoundationModelAgreement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateFoundationModelAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateFoundationModelAgreement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFoundationModelAgreementResponse> createFoundationModelAgreement(
            Consumer<CreateFoundationModelAgreementRequest.Builder> createFoundationModelAgreementRequest) {
        return createFoundationModelAgreement(CreateFoundationModelAgreementRequest.builder()
                .applyMutation(createFoundationModelAgreementRequest).build());
    }

    /**
     * <p>
     * Creates a guardrail to block topics and to implement safeguards for your generative AI applications.
     * </p>
     * <p>
     * You can configure the following policies in a guardrail to avoid undesirable and harmful content, filter out
     * denied topics and words, and remove sensitive information for privacy protection.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Content filters</b> - Adjust filter strengths to block input prompts or model responses containing harmful
     * content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Denied topics</b> - Define a set of topics that are undesirable in the context of your application. These
     * topics will be blocked if detected in user queries or model responses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Word filters</b> - Configure filters to block undesirable words, phrases, and profanity. Such words can
     * include offensive terms, competitor names etc.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Sensitive information filters</b> - Block or mask sensitive information such as personally identifiable
     * information (PII) or custom regex in user inputs and model responses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In addition to the above policies, you can also configure the messages to be returned to the user if a user input
     * or model response is in violation of the policies defined in the guardrail.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">Amazon
     * Bedrock Guardrails</a> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     *
     * @param createGuardrailRequest
     * @return A Java Future containing the result of the CreateGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGuardrailResponse> createGuardrail(CreateGuardrailRequest createGuardrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a guardrail to block topics and to implement safeguards for your generative AI applications.
     * </p>
     * <p>
     * You can configure the following policies in a guardrail to avoid undesirable and harmful content, filter out
     * denied topics and words, and remove sensitive information for privacy protection.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Content filters</b> - Adjust filter strengths to block input prompts or model responses containing harmful
     * content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Denied topics</b> - Define a set of topics that are undesirable in the context of your application. These
     * topics will be blocked if detected in user queries or model responses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Word filters</b> - Configure filters to block undesirable words, phrases, and profanity. Such words can
     * include offensive terms, competitor names etc.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Sensitive information filters</b> - Block or mask sensitive information such as personally identifiable
     * information (PII) or custom regex in user inputs and model responses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In addition to the above policies, you can also configure the messages to be returned to the user if a user input
     * or model response is in violation of the policies defined in the guardrail.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">Amazon
     * Bedrock Guardrails</a> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGuardrailRequest.Builder} avoiding the need
     * to create one manually via {@link CreateGuardrailRequest#builder()}
     * </p>
     *
     * @param createGuardrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateGuardrailRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGuardrailResponse> createGuardrail(
            Consumer<CreateGuardrailRequest.Builder> createGuardrailRequest) {
        return createGuardrail(CreateGuardrailRequest.builder().applyMutation(createGuardrailRequest).build());
    }

    /**
     * <p>
     * Creates a version of the guardrail. Use this API to create a snapshot of the guardrail when you are satisfied
     * with a configuration, or to compare the configuration with another version.
     * </p>
     *
     * @param createGuardrailVersionRequest
     * @return A Java Future containing the result of the CreateGuardrailVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateGuardrailVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateGuardrailVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGuardrailVersionResponse> createGuardrailVersion(
            CreateGuardrailVersionRequest createGuardrailVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of the guardrail. Use this API to create a snapshot of the guardrail when you are satisfied
     * with a configuration, or to compare the configuration with another version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGuardrailVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGuardrailVersionRequest#builder()}
     * </p>
     *
     * @param createGuardrailVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGuardrailVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateGuardrailVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateGuardrailVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGuardrailVersionResponse> createGuardrailVersion(
            Consumer<CreateGuardrailVersionRequest.Builder> createGuardrailVersionRequest) {
        return createGuardrailVersion(CreateGuardrailVersionRequest.builder().applyMutation(createGuardrailVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an application inference profile to track metrics and costs when invoking a model. To create an
     * application inference profile for a foundation model in one region, specify the ARN of the model in that region.
     * To create an application inference profile for a foundation model across multiple regions, specify the ARN of the
     * system-defined inference profile that contains the regions that you want to route requests to. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">Increase throughput and
     * resilience with cross-region inference in Amazon Bedrock</a>. in the Amazon Bedrock User Guide.
     * </p>
     *
     * @param createInferenceProfileRequest
     * @return A Java Future containing the result of the CreateInferenceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateInferenceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateInferenceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceProfileResponse> createInferenceProfile(
            CreateInferenceProfileRequest createInferenceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application inference profile to track metrics and costs when invoking a model. To create an
     * application inference profile for a foundation model in one region, specify the ARN of the model in that region.
     * To create an application inference profile for a foundation model across multiple regions, specify the ARN of the
     * system-defined inference profile that contains the regions that you want to route requests to. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">Increase throughput and
     * resilience with cross-region inference in Amazon Bedrock</a>. in the Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInferenceProfileRequest#builder()}
     * </p>
     *
     * @param createInferenceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateInferenceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInferenceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateInferenceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateInferenceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceProfileResponse> createInferenceProfile(
            Consumer<CreateInferenceProfileRequest.Builder> createInferenceProfileRequest) {
        return createInferenceProfile(CreateInferenceProfileRequest.builder().applyMutation(createInferenceProfileRequest)
                .build());
    }

    /**
     * <p>
     * Creates an endpoint for a model from Amazon Bedrock Marketplace. The endpoint is hosted by Amazon SageMaker.
     * </p>
     *
     * @param createMarketplaceModelEndpointRequest
     * @return A Java Future containing the result of the CreateMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMarketplaceModelEndpointResponse> createMarketplaceModelEndpoint(
            CreateMarketplaceModelEndpointRequest createMarketplaceModelEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint for a model from Amazon Bedrock Marketplace. The endpoint is hosted by Amazon SageMaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMarketplaceModelEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link CreateMarketplaceModelEndpointRequest#builder()}
     * </p>
     *
     * @param createMarketplaceModelEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateMarketplaceModelEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMarketplaceModelEndpointResponse> createMarketplaceModelEndpoint(
            Consumer<CreateMarketplaceModelEndpointRequest.Builder> createMarketplaceModelEndpointRequest) {
        return createMarketplaceModelEndpoint(CreateMarketplaceModelEndpointRequest.builder()
                .applyMutation(createMarketplaceModelEndpointRequest).build());
    }

    /**
     * <p>
     * Copies a model to another region so that it can be used there. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other
     * regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     *
     * @param createModelCopyJobRequest
     * @return A Java Future containing the result of the CreateModelCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateModelCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelCopyJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateModelCopyJobResponse> createModelCopyJob(CreateModelCopyJobRequest createModelCopyJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a model to another region so that it can be used there. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other
     * regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelCopyJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelCopyJobRequest#builder()}
     * </p>
     *
     * @param createModelCopyJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateModelCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelCopyJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateModelCopyJobResponse> createModelCopyJob(
            Consumer<CreateModelCopyJobRequest.Builder> createModelCopyJobRequest) {
        return createModelCopyJob(CreateModelCopyJobRequest.builder().applyMutation(createModelCopyJobRequest).build());
    }

    /**
     * <p>
     * Creates a fine-tuning job to customize a base model.
     * </p>
     * <p>
     * You specify the base foundation model and the location of the training data. After the model-customization job
     * completes successfully, your custom model resource will be ready to use. Amazon Bedrock returns validation loss
     * metrics and output generations after the job completes.
     * </p>
     * <p>
     * For information on the format of training and validation data, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-prepare.html">Prepare the
     * datasets</a>.
     * </p>
     * <p>
     * Model-customization jobs are asynchronous and the completion time depends on the base model and the
     * training/validation data size. To monitor a job, use the <code>GetModelCustomizationJob</code> operation to
     * retrieve the job status.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param createModelCustomizationJobRequest
     * @return A Java Future containing the result of the CreateModelCustomizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateModelCustomizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelCustomizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelCustomizationJobResponse> createModelCustomizationJob(
            CreateModelCustomizationJobRequest createModelCustomizationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fine-tuning job to customize a base model.
     * </p>
     * <p>
     * You specify the base foundation model and the location of the training data. After the model-customization job
     * completes successfully, your custom model resource will be ready to use. Amazon Bedrock returns validation loss
     * metrics and output generations after the job completes.
     * </p>
     * <p>
     * For information on the format of training and validation data, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-prepare.html">Prepare the
     * datasets</a>.
     * </p>
     * <p>
     * Model-customization jobs are asynchronous and the completion time depends on the base model and the
     * training/validation data size. To monitor a job, use the <code>GetModelCustomizationJob</code> operation to
     * retrieve the job status.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelCustomizationJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateModelCustomizationJobRequest#builder()}
     * </p>
     *
     * @param createModelCustomizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateModelCustomizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateModelCustomizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelCustomizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelCustomizationJobResponse> createModelCustomizationJob(
            Consumer<CreateModelCustomizationJobRequest.Builder> createModelCustomizationJobRequest) {
        return createModelCustomizationJob(CreateModelCustomizationJobRequest.builder()
                .applyMutation(createModelCustomizationJobRequest).build());
    }

    /**
     * <p>
     * Creates a model import job to import model that you have customized in other environments, such as Amazon
     * SageMaker. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a>
     * </p>
     *
     * @param createModelImportJobRequest
     * @return A Java Future containing the result of the CreateModelImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateModelImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateModelImportJobResponse> createModelImportJob(
            CreateModelImportJobRequest createModelImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model import job to import model that you have customized in other environments, such as Amazon
     * SageMaker. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelImportJobRequest#builder()}
     * </p>
     *
     * @param createModelImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateModelImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateModelImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateModelImportJobResponse> createModelImportJob(
            Consumer<CreateModelImportJobRequest.Builder> createModelImportJobRequest) {
        return createModelImportJob(CreateModelImportJobRequest.builder().applyMutation(createModelImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a batch inference job to invoke a model on multiple prompts. Format your data according to <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data">Format your inference data</a>
     * and upload it to an Amazon S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference.html">Process multiple prompts with
     * batch inference</a>.
     * </p>
     * <p>
     * The response returns a <code>jobArn</code> that you can use to stop or get details about the job.
     * </p>
     *
     * @param createModelInvocationJobRequest
     * @return A Java Future containing the result of the CreateModelInvocationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateModelInvocationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelInvocationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelInvocationJobResponse> createModelInvocationJob(
            CreateModelInvocationJobRequest createModelInvocationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch inference job to invoke a model on multiple prompts. Format your data according to <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data">Format your inference data</a>
     * and upload it to an Amazon S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference.html">Process multiple prompts with
     * batch inference</a>.
     * </p>
     * <p>
     * The response returns a <code>jobArn</code> that you can use to stop or get details about the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelInvocationJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateModelInvocationJobRequest#builder()}
     * </p>
     *
     * @param createModelInvocationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelInvocationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateModelInvocationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelInvocationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelInvocationJobResponse> createModelInvocationJob(
            Consumer<CreateModelInvocationJobRequest.Builder> createModelInvocationJobRequest) {
        return createModelInvocationJob(CreateModelInvocationJobRequest.builder().applyMutation(createModelInvocationJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a prompt router that manages the routing of requests between multiple foundation models based on the
     * routing criteria.
     * </p>
     *
     * @param createPromptRouterRequest
     * @return A Java Future containing the result of the CreatePromptRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreatePromptRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreatePromptRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePromptRouterResponse> createPromptRouter(CreatePromptRouterRequest createPromptRouterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a prompt router that manages the routing of requests between multiple foundation models based on the
     * routing criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePromptRouterRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePromptRouterRequest#builder()}
     * </p>
     *
     * @param createPromptRouterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreatePromptRouterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePromptRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreatePromptRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreatePromptRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePromptRouterResponse> createPromptRouter(
            Consumer<CreatePromptRouterRequest.Builder> createPromptRouterRequest) {
        return createPromptRouter(CreatePromptRouterRequest.builder().applyMutation(createPromptRouterRequest).build());
    }

    /**
     * <p>
     * Creates dedicated throughput for a base or custom model with the model units and for the duration that you
     * specify. For pricing details, see <a href="http://aws.amazon.com/bedrock/pricing/">Amazon Bedrock Pricing</a>.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     *
     * @param createProvisionedModelThroughputRequest
     * @return A Java Future containing the result of the CreateProvisionedModelThroughput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateProvisionedModelThroughput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateProvisionedModelThroughput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProvisionedModelThroughputResponse> createProvisionedModelThroughput(
            CreateProvisionedModelThroughputRequest createProvisionedModelThroughputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates dedicated throughput for a base or custom model with the model units and for the duration that you
     * specify. For pricing details, see <a href="http://aws.amazon.com/bedrock/pricing/">Amazon Bedrock Pricing</a>.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisionedModelThroughputRequest.Builder}
     * avoiding the need to create one manually via {@link CreateProvisionedModelThroughputRequest#builder()}
     * </p>
     *
     * @param createProvisionedModelThroughputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateProvisionedModelThroughput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.CreateProvisionedModelThroughput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateProvisionedModelThroughput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProvisionedModelThroughputResponse> createProvisionedModelThroughput(
            Consumer<CreateProvisionedModelThroughputRequest.Builder> createProvisionedModelThroughputRequest) {
        return createProvisionedModelThroughput(CreateProvisionedModelThroughputRequest.builder()
                .applyMutation(createProvisionedModelThroughputRequest).build());
    }

    /**
     * <p>
     * Deletes an Automated Reasoning policy or policy version. This operation is idempotent. If you delete a policy
     * more than once, each call succeeds. Deleting a policy removes it permanently and cannot be undone.
     * </p>
     *
     * @param deleteAutomatedReasoningPolicyRequest
     * @return A Java Future containing the result of the DeleteAutomatedReasoningPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteAutomatedReasoningPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteAutomatedReasoningPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAutomatedReasoningPolicyResponse> deleteAutomatedReasoningPolicy(
            DeleteAutomatedReasoningPolicyRequest deleteAutomatedReasoningPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Automated Reasoning policy or policy version. This operation is idempotent. If you delete a policy
     * more than once, each call succeeds. Deleting a policy removes it permanently and cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAutomatedReasoningPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAutomatedReasoningPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAutomatedReasoningPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAutomatedReasoningPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteAutomatedReasoningPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteAutomatedReasoningPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAutomatedReasoningPolicyResponse> deleteAutomatedReasoningPolicy(
            Consumer<DeleteAutomatedReasoningPolicyRequest.Builder> deleteAutomatedReasoningPolicyRequest) {
        return deleteAutomatedReasoningPolicy(DeleteAutomatedReasoningPolicyRequest.builder()
                .applyMutation(deleteAutomatedReasoningPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an Automated Reasoning policy build workflow and its associated artifacts. This permanently removes the
     * workflow history and any generated assets.
     * </p>
     *
     * @param deleteAutomatedReasoningPolicyBuildWorkflowRequest
     * @return A Java Future containing the result of the DeleteAutomatedReasoningPolicyBuildWorkflow operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteAutomatedReasoningPolicyBuildWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteAutomatedReasoningPolicyBuildWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAutomatedReasoningPolicyBuildWorkflowResponse> deleteAutomatedReasoningPolicyBuildWorkflow(
            DeleteAutomatedReasoningPolicyBuildWorkflowRequest deleteAutomatedReasoningPolicyBuildWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Automated Reasoning policy build workflow and its associated artifacts. This permanently removes the
     * workflow history and any generated assets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteAutomatedReasoningPolicyBuildWorkflowRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteAutomatedReasoningPolicyBuildWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteAutomatedReasoningPolicyBuildWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyBuildWorkflowRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteAutomatedReasoningPolicyBuildWorkflow operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteAutomatedReasoningPolicyBuildWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteAutomatedReasoningPolicyBuildWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAutomatedReasoningPolicyBuildWorkflowResponse> deleteAutomatedReasoningPolicyBuildWorkflow(
            Consumer<DeleteAutomatedReasoningPolicyBuildWorkflowRequest.Builder> deleteAutomatedReasoningPolicyBuildWorkflowRequest) {
        return deleteAutomatedReasoningPolicyBuildWorkflow(DeleteAutomatedReasoningPolicyBuildWorkflowRequest.builder()
                .applyMutation(deleteAutomatedReasoningPolicyBuildWorkflowRequest).build());
    }

    /**
     * <p>
     * Deletes an Automated Reasoning policy test. This operation is idempotent; if you delete a test more than once,
     * each call succeeds.
     * </p>
     *
     * @param deleteAutomatedReasoningPolicyTestCaseRequest
     * @return A Java Future containing the result of the DeleteAutomatedReasoningPolicyTestCase operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ResourceInUseException Thrown when attempting to delete or modify a resource that is currently being
     *         used by other resources or operations. For example, trying to delete an Automated Reasoning policy that
     *         is referenced by an active guardrail.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteAutomatedReasoningPolicyTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteAutomatedReasoningPolicyTestCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAutomatedReasoningPolicyTestCaseResponse> deleteAutomatedReasoningPolicyTestCase(
            DeleteAutomatedReasoningPolicyTestCaseRequest deleteAutomatedReasoningPolicyTestCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Automated Reasoning policy test. This operation is idempotent; if you delete a test more than once,
     * each call succeeds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteAutomatedReasoningPolicyTestCaseRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteAutomatedReasoningPolicyTestCaseRequest#builder()}
     * </p>
     *
     * @param deleteAutomatedReasoningPolicyTestCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteAutomatedReasoningPolicyTestCaseRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteAutomatedReasoningPolicyTestCase operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ResourceInUseException Thrown when attempting to delete or modify a resource that is currently being
     *         used by other resources or operations. For example, trying to delete an Automated Reasoning policy that
     *         is referenced by an active guardrail.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteAutomatedReasoningPolicyTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteAutomatedReasoningPolicyTestCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAutomatedReasoningPolicyTestCaseResponse> deleteAutomatedReasoningPolicyTestCase(
            Consumer<DeleteAutomatedReasoningPolicyTestCaseRequest.Builder> deleteAutomatedReasoningPolicyTestCaseRequest) {
        return deleteAutomatedReasoningPolicyTestCase(DeleteAutomatedReasoningPolicyTestCaseRequest.builder()
                .applyMutation(deleteAutomatedReasoningPolicyTestCaseRequest).build());
    }

    /**
     * <p>
     * Deletes a custom model that you created earlier. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param deleteCustomModelRequest
     * @return A Java Future containing the result of the DeleteCustomModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteCustomModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteCustomModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCustomModelResponse> deleteCustomModel(DeleteCustomModelRequest deleteCustomModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom model that you created earlier. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomModelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCustomModelRequest#builder()}
     * </p>
     *
     * @param deleteCustomModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteCustomModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCustomModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteCustomModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteCustomModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCustomModelResponse> deleteCustomModel(
            Consumer<DeleteCustomModelRequest.Builder> deleteCustomModelRequest) {
        return deleteCustomModel(DeleteCustomModelRequest.builder().applyMutation(deleteCustomModelRequest).build());
    }

    /**
     * <p>
     * Deletes a custom model deployment. This operation stops the deployment and removes it from your account. After
     * deletion, the deployment ARN can no longer be used for inference requests.
     * </p>
     * <p>
     * The following actions are related to the <code>DeleteCustomModelDeployment</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html">
     * CreateCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModelDeployment.html">
     * GetCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModelDeployments.html">
     * ListCustomModelDeployments</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteCustomModelDeploymentRequest
     * @return A Java Future containing the result of the DeleteCustomModelDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteCustomModelDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteCustomModelDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomModelDeploymentResponse> deleteCustomModelDeployment(
            DeleteCustomModelDeploymentRequest deleteCustomModelDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom model deployment. This operation stops the deployment and removes it from your account. After
     * deletion, the deployment ARN can no longer be used for inference requests.
     * </p>
     * <p>
     * The following actions are related to the <code>DeleteCustomModelDeployment</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html">
     * CreateCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModelDeployment.html">
     * GetCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModelDeployments.html">
     * ListCustomModelDeployments</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomModelDeploymentRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomModelDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteCustomModelDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteCustomModelDeploymentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteCustomModelDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteCustomModelDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteCustomModelDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomModelDeploymentResponse> deleteCustomModelDeployment(
            Consumer<DeleteCustomModelDeploymentRequest.Builder> deleteCustomModelDeploymentRequest) {
        return deleteCustomModelDeployment(DeleteCustomModelDeploymentRequest.builder()
                .applyMutation(deleteCustomModelDeploymentRequest).build());
    }

    /**
     * <p>
     * Delete the model access agreement for the specified model.
     * </p>
     *
     * @param deleteFoundationModelAgreementRequest
     * @return A Java Future containing the result of the DeleteFoundationModelAgreement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteFoundationModelAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteFoundationModelAgreement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFoundationModelAgreementResponse> deleteFoundationModelAgreement(
            DeleteFoundationModelAgreementRequest deleteFoundationModelAgreementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the model access agreement for the specified model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFoundationModelAgreementRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFoundationModelAgreementRequest#builder()}
     * </p>
     *
     * @param deleteFoundationModelAgreementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteFoundationModelAgreementRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFoundationModelAgreement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteFoundationModelAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteFoundationModelAgreement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFoundationModelAgreementResponse> deleteFoundationModelAgreement(
            Consumer<DeleteFoundationModelAgreementRequest.Builder> deleteFoundationModelAgreementRequest) {
        return deleteFoundationModelAgreement(DeleteFoundationModelAgreementRequest.builder()
                .applyMutation(deleteFoundationModelAgreementRequest).build());
    }

    /**
     * <p>
     * Deletes a guardrail.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To delete a guardrail, only specify the ARN of the guardrail in the <code>guardrailIdentifier</code> field. If
     * you delete a guardrail, all of its versions will be deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a version of a guardrail, specify the ARN of the guardrail in the <code>guardrailIdentifier</code>
     * field and the version in the <code>guardrailVersion</code> field.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteGuardrailRequest
     * @return A Java Future containing the result of the DeleteGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGuardrailResponse> deleteGuardrail(DeleteGuardrailRequest deleteGuardrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a guardrail.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To delete a guardrail, only specify the ARN of the guardrail in the <code>guardrailIdentifier</code> field. If
     * you delete a guardrail, all of its versions will be deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a version of a guardrail, specify the ARN of the guardrail in the <code>guardrailIdentifier</code>
     * field and the version in the <code>guardrailVersion</code> field.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGuardrailRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteGuardrailRequest#builder()}
     * </p>
     *
     * @param deleteGuardrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteGuardrailRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGuardrailResponse> deleteGuardrail(
            Consumer<DeleteGuardrailRequest.Builder> deleteGuardrailRequest) {
        return deleteGuardrail(DeleteGuardrailRequest.builder().applyMutation(deleteGuardrailRequest).build());
    }

    /**
     * <p>
     * Deletes a custom model that you imported earlier. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param deleteImportedModelRequest
     * @return A Java Future containing the result of the DeleteImportedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteImportedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteImportedModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteImportedModelResponse> deleteImportedModel(
            DeleteImportedModelRequest deleteImportedModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom model that you imported earlier. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImportedModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImportedModelRequest#builder()}
     * </p>
     *
     * @param deleteImportedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteImportedModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteImportedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteImportedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteImportedModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteImportedModelResponse> deleteImportedModel(
            Consumer<DeleteImportedModelRequest.Builder> deleteImportedModelRequest) {
        return deleteImportedModel(DeleteImportedModelRequest.builder().applyMutation(deleteImportedModelRequest).build());
    }

    /**
     * <p>
     * Deletes an application inference profile. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">Increase throughput and
     * resilience with cross-region inference in Amazon Bedrock</a>. in the Amazon Bedrock User Guide.
     * </p>
     *
     * @param deleteInferenceProfileRequest
     * @return A Java Future containing the result of the DeleteInferenceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteInferenceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteInferenceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInferenceProfileResponse> deleteInferenceProfile(
            DeleteInferenceProfileRequest deleteInferenceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application inference profile. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">Increase throughput and
     * resilience with cross-region inference in Amazon Bedrock</a>. in the Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInferenceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInferenceProfileRequest#builder()}
     * </p>
     *
     * @param deleteInferenceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteInferenceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInferenceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteInferenceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteInferenceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInferenceProfileResponse> deleteInferenceProfile(
            Consumer<DeleteInferenceProfileRequest.Builder> deleteInferenceProfileRequest) {
        return deleteInferenceProfile(DeleteInferenceProfileRequest.builder().applyMutation(deleteInferenceProfileRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an endpoint for a model from Amazon Bedrock Marketplace.
     * </p>
     *
     * @param deleteMarketplaceModelEndpointRequest
     * @return A Java Future containing the result of the DeleteMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMarketplaceModelEndpointResponse> deleteMarketplaceModelEndpoint(
            DeleteMarketplaceModelEndpointRequest deleteMarketplaceModelEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an endpoint for a model from Amazon Bedrock Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMarketplaceModelEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMarketplaceModelEndpointRequest#builder()}
     * </p>
     *
     * @param deleteMarketplaceModelEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteMarketplaceModelEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMarketplaceModelEndpointResponse> deleteMarketplaceModelEndpoint(
            Consumer<DeleteMarketplaceModelEndpointRequest.Builder> deleteMarketplaceModelEndpointRequest) {
        return deleteMarketplaceModelEndpoint(DeleteMarketplaceModelEndpointRequest.builder()
                .applyMutation(deleteMarketplaceModelEndpointRequest).build());
    }

    /**
     * <p>
     * Delete the invocation logging.
     * </p>
     *
     * @param deleteModelInvocationLoggingConfigurationRequest
     * @return A Java Future containing the result of the DeleteModelInvocationLoggingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteModelInvocationLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteModelInvocationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelInvocationLoggingConfigurationResponse> deleteModelInvocationLoggingConfiguration(
            DeleteModelInvocationLoggingConfigurationRequest deleteModelInvocationLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the invocation logging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteModelInvocationLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteModelInvocationLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteModelInvocationLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteModelInvocationLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteModelInvocationLoggingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteModelInvocationLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteModelInvocationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelInvocationLoggingConfigurationResponse> deleteModelInvocationLoggingConfiguration(
            Consumer<DeleteModelInvocationLoggingConfigurationRequest.Builder> deleteModelInvocationLoggingConfigurationRequest) {
        return deleteModelInvocationLoggingConfiguration(DeleteModelInvocationLoggingConfigurationRequest.builder()
                .applyMutation(deleteModelInvocationLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a specified prompt router. This action cannot be undone.
     * </p>
     *
     * @param deletePromptRouterRequest
     * @return A Java Future containing the result of the DeletePromptRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeletePromptRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeletePromptRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePromptRouterResponse> deletePromptRouter(DeletePromptRouterRequest deletePromptRouterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified prompt router. This action cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePromptRouterRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePromptRouterRequest#builder()}
     * </p>
     *
     * @param deletePromptRouterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeletePromptRouterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePromptRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeletePromptRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeletePromptRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePromptRouterResponse> deletePromptRouter(
            Consumer<DeletePromptRouterRequest.Builder> deletePromptRouterRequest) {
        return deletePromptRouter(DeletePromptRouterRequest.builder().applyMutation(deletePromptRouterRequest).build());
    }

    /**
     * <p>
     * Deletes a Provisioned Throughput. You can't delete a Provisioned Throughput before the commitment term is over.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     *
     * @param deleteProvisionedModelThroughputRequest
     * @return A Java Future containing the result of the DeleteProvisionedModelThroughput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteProvisionedModelThroughput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteProvisionedModelThroughput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisionedModelThroughputResponse> deleteProvisionedModelThroughput(
            DeleteProvisionedModelThroughputRequest deleteProvisionedModelThroughputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Provisioned Throughput. You can't delete a Provisioned Throughput before the commitment term is over.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisionedModelThroughputRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProvisionedModelThroughputRequest#builder()}
     * </p>
     *
     * @param deleteProvisionedModelThroughputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeleteProvisionedModelThroughputRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteProvisionedModelThroughput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeleteProvisionedModelThroughput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteProvisionedModelThroughput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisionedModelThroughputResponse> deleteProvisionedModelThroughput(
            Consumer<DeleteProvisionedModelThroughputRequest.Builder> deleteProvisionedModelThroughputRequest) {
        return deleteProvisionedModelThroughput(DeleteProvisionedModelThroughputRequest.builder()
                .applyMutation(deleteProvisionedModelThroughputRequest).build());
    }

    /**
     * <p>
     * Deregisters an endpoint for a model from Amazon Bedrock Marketplace. This operation removes the endpoint's
     * association with Amazon Bedrock but does not delete the underlying Amazon SageMaker endpoint.
     * </p>
     *
     * @param deregisterMarketplaceModelEndpointRequest
     * @return A Java Future containing the result of the DeregisterMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeregisterMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeregisterMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterMarketplaceModelEndpointResponse> deregisterMarketplaceModelEndpoint(
            DeregisterMarketplaceModelEndpointRequest deregisterMarketplaceModelEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an endpoint for a model from Amazon Bedrock Marketplace. This operation removes the endpoint's
     * association with Amazon Bedrock but does not delete the underlying Amazon SageMaker endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterMarketplaceModelEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterMarketplaceModelEndpointRequest#builder()}
     * </p>
     *
     * @param deregisterMarketplaceModelEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.DeregisterMarketplaceModelEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeregisterMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.DeregisterMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeregisterMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterMarketplaceModelEndpointResponse> deregisterMarketplaceModelEndpoint(
            Consumer<DeregisterMarketplaceModelEndpointRequest.Builder> deregisterMarketplaceModelEndpointRequest) {
        return deregisterMarketplaceModelEndpoint(DeregisterMarketplaceModelEndpointRequest.builder()
                .applyMutation(deregisterMarketplaceModelEndpointRequest).build());
    }

    /**
     * <p>
     * Exports the policy definition for an Automated Reasoning policy version. Returns the complete policy definition
     * including rules, variables, and custom variable types in a structured format.
     * </p>
     *
     * @param exportAutomatedReasoningPolicyVersionRequest
     * @return A Java Future containing the result of the ExportAutomatedReasoningPolicyVersion operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ExportAutomatedReasoningPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ExportAutomatedReasoningPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportAutomatedReasoningPolicyVersionResponse> exportAutomatedReasoningPolicyVersion(
            ExportAutomatedReasoningPolicyVersionRequest exportAutomatedReasoningPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports the policy definition for an Automated Reasoning policy version. Returns the complete policy definition
     * including rules, variables, and custom variable types in a structured format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ExportAutomatedReasoningPolicyVersionRequest.Builder} avoiding the need to create one manually via
     * {@link ExportAutomatedReasoningPolicyVersionRequest#builder()}
     * </p>
     *
     * @param exportAutomatedReasoningPolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ExportAutomatedReasoningPolicyVersionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ExportAutomatedReasoningPolicyVersion operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ExportAutomatedReasoningPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ExportAutomatedReasoningPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportAutomatedReasoningPolicyVersionResponse> exportAutomatedReasoningPolicyVersion(
            Consumer<ExportAutomatedReasoningPolicyVersionRequest.Builder> exportAutomatedReasoningPolicyVersionRequest) {
        return exportAutomatedReasoningPolicyVersion(ExportAutomatedReasoningPolicyVersionRequest.builder()
                .applyMutation(exportAutomatedReasoningPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves details about an Automated Reasoning policy or policy version. Returns information including the policy
     * definition, metadata, and timestamps.
     * </p>
     *
     * @param getAutomatedReasoningPolicyRequest
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyResponse> getAutomatedReasoningPolicy(
            GetAutomatedReasoningPolicyRequest getAutomatedReasoningPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an Automated Reasoning policy or policy version. Returns information including the policy
     * definition, metadata, and timestamps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutomatedReasoningPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetAutomatedReasoningPolicyRequest#builder()}
     * </p>
     *
     * @param getAutomatedReasoningPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyResponse> getAutomatedReasoningPolicy(
            Consumer<GetAutomatedReasoningPolicyRequest.Builder> getAutomatedReasoningPolicyRequest) {
        return getAutomatedReasoningPolicy(GetAutomatedReasoningPolicyRequest.builder()
                .applyMutation(getAutomatedReasoningPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the current annotations for an Automated Reasoning policy build workflow. Annotations contain
     * corrections to the rules, variables and types to be applied to the policy.
     * </p>
     *
     * @param getAutomatedReasoningPolicyAnnotationsRequest
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyAnnotations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyAnnotations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyAnnotations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyAnnotationsResponse> getAutomatedReasoningPolicyAnnotations(
            GetAutomatedReasoningPolicyAnnotationsRequest getAutomatedReasoningPolicyAnnotationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current annotations for an Automated Reasoning policy build workflow. Annotations contain
     * corrections to the rules, variables and types to be applied to the policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAutomatedReasoningPolicyAnnotationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetAutomatedReasoningPolicyAnnotationsRequest#builder()}
     * </p>
     *
     * @param getAutomatedReasoningPolicyAnnotationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyAnnotationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyAnnotations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyAnnotations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyAnnotations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyAnnotationsResponse> getAutomatedReasoningPolicyAnnotations(
            Consumer<GetAutomatedReasoningPolicyAnnotationsRequest.Builder> getAutomatedReasoningPolicyAnnotationsRequest) {
        return getAutomatedReasoningPolicyAnnotations(GetAutomatedReasoningPolicyAnnotationsRequest.builder()
                .applyMutation(getAutomatedReasoningPolicyAnnotationsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about an Automated Reasoning policy build workflow, including its status,
     * configuration, and metadata.
     * </p>
     *
     * @param getAutomatedReasoningPolicyBuildWorkflowRequest
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyBuildWorkflow operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyBuildWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyBuildWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyBuildWorkflowResponse> getAutomatedReasoningPolicyBuildWorkflow(
            GetAutomatedReasoningPolicyBuildWorkflowRequest getAutomatedReasoningPolicyBuildWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about an Automated Reasoning policy build workflow, including its status,
     * configuration, and metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAutomatedReasoningPolicyBuildWorkflowRequest.Builder} avoiding the need to create one manually via
     * {@link GetAutomatedReasoningPolicyBuildWorkflowRequest#builder()}
     * </p>
     *
     * @param getAutomatedReasoningPolicyBuildWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyBuildWorkflowRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyBuildWorkflow operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyBuildWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyBuildWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyBuildWorkflowResponse> getAutomatedReasoningPolicyBuildWorkflow(
            Consumer<GetAutomatedReasoningPolicyBuildWorkflowRequest.Builder> getAutomatedReasoningPolicyBuildWorkflowRequest) {
        return getAutomatedReasoningPolicyBuildWorkflow(GetAutomatedReasoningPolicyBuildWorkflowRequest.builder()
                .applyMutation(getAutomatedReasoningPolicyBuildWorkflowRequest).build());
    }

    /**
     * <p>
     * Retrieves the resulting assets from a completed Automated Reasoning policy build workflow, including build logs,
     * quality reports, and generated policy artifacts.
     * </p>
     *
     * @param getAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyBuildWorkflowResultAssets operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyBuildWorkflowResultAssets
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyBuildWorkflowResultAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyBuildWorkflowResultAssetsResponse> getAutomatedReasoningPolicyBuildWorkflowResultAssets(
            GetAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest getAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resulting assets from a completed Automated Reasoning policy build workflow, including build logs,
     * quality reports, and generated policy artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest.Builder} avoiding the need to create one
     * manually via {@link GetAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest#builder()}
     * </p>
     *
     * @param getAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyBuildWorkflowResultAssets operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyBuildWorkflowResultAssets
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyBuildWorkflowResultAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyBuildWorkflowResultAssetsResponse> getAutomatedReasoningPolicyBuildWorkflowResultAssets(
            Consumer<GetAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest.Builder> getAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest) {
        return getAutomatedReasoningPolicyBuildWorkflowResultAssets(GetAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest
                .builder().applyMutation(getAutomatedReasoningPolicyBuildWorkflowResultAssetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the next test scenario for validating an Automated Reasoning policy. This is used during the
     * interactive policy refinement process to test policy behavior.
     * </p>
     *
     * @param getAutomatedReasoningPolicyNextScenarioRequest
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyNextScenario operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyNextScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyNextScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyNextScenarioResponse> getAutomatedReasoningPolicyNextScenario(
            GetAutomatedReasoningPolicyNextScenarioRequest getAutomatedReasoningPolicyNextScenarioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the next test scenario for validating an Automated Reasoning policy. This is used during the
     * interactive policy refinement process to test policy behavior.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAutomatedReasoningPolicyNextScenarioRequest.Builder} avoiding the need to create one manually via
     * {@link GetAutomatedReasoningPolicyNextScenarioRequest#builder()}
     * </p>
     *
     * @param getAutomatedReasoningPolicyNextScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyNextScenarioRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyNextScenario operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyNextScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyNextScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyNextScenarioResponse> getAutomatedReasoningPolicyNextScenario(
            Consumer<GetAutomatedReasoningPolicyNextScenarioRequest.Builder> getAutomatedReasoningPolicyNextScenarioRequest) {
        return getAutomatedReasoningPolicyNextScenario(GetAutomatedReasoningPolicyNextScenarioRequest.builder()
                .applyMutation(getAutomatedReasoningPolicyNextScenarioRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a specific Automated Reasoning policy test.
     * </p>
     *
     * @param getAutomatedReasoningPolicyTestCaseRequest
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyTestCase operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyTestCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyTestCaseResponse> getAutomatedReasoningPolicyTestCase(
            GetAutomatedReasoningPolicyTestCaseRequest getAutomatedReasoningPolicyTestCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific Automated Reasoning policy test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutomatedReasoningPolicyTestCaseRequest.Builder}
     * avoiding the need to create one manually via {@link GetAutomatedReasoningPolicyTestCaseRequest#builder()}
     * </p>
     *
     * @param getAutomatedReasoningPolicyTestCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyTestCaseRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyTestCase operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyTestCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyTestCaseResponse> getAutomatedReasoningPolicyTestCase(
            Consumer<GetAutomatedReasoningPolicyTestCaseRequest.Builder> getAutomatedReasoningPolicyTestCaseRequest) {
        return getAutomatedReasoningPolicyTestCase(GetAutomatedReasoningPolicyTestCaseRequest.builder()
                .applyMutation(getAutomatedReasoningPolicyTestCaseRequest).build());
    }

    /**
     * <p>
     * Retrieves the test result for a specific Automated Reasoning policy test. Returns detailed validation findings
     * and execution status.
     * </p>
     *
     * @param getAutomatedReasoningPolicyTestResultRequest
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyTestResult operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyTestResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyTestResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyTestResultResponse> getAutomatedReasoningPolicyTestResult(
            GetAutomatedReasoningPolicyTestResultRequest getAutomatedReasoningPolicyTestResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the test result for a specific Automated Reasoning policy test. Returns detailed validation findings
     * and execution status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAutomatedReasoningPolicyTestResultRequest.Builder} avoiding the need to create one manually via
     * {@link GetAutomatedReasoningPolicyTestResultRequest#builder()}
     * </p>
     *
     * @param getAutomatedReasoningPolicyTestResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetAutomatedReasoningPolicyTestResultRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAutomatedReasoningPolicyTestResult operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetAutomatedReasoningPolicyTestResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetAutomatedReasoningPolicyTestResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutomatedReasoningPolicyTestResultResponse> getAutomatedReasoningPolicyTestResult(
            Consumer<GetAutomatedReasoningPolicyTestResultRequest.Builder> getAutomatedReasoningPolicyTestResultRequest) {
        return getAutomatedReasoningPolicyTestResult(GetAutomatedReasoningPolicyTestResultRequest.builder()
                .applyMutation(getAutomatedReasoningPolicyTestResultRequest).build());
    }

    /**
     * <p>
     * Get the properties associated with a Amazon Bedrock custom model that you have created. For more information, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param getCustomModelRequest
     * @return A Java Future containing the result of the GetCustomModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetCustomModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetCustomModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCustomModelResponse> getCustomModel(GetCustomModelRequest getCustomModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the properties associated with a Amazon Bedrock custom model that you have created. For more information, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomModelRequest.Builder} avoiding the need to
     * create one manually via {@link GetCustomModelRequest#builder()}
     * </p>
     *
     * @param getCustomModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCustomModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetCustomModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetCustomModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCustomModelResponse> getCustomModel(Consumer<GetCustomModelRequest.Builder> getCustomModelRequest) {
        return getCustomModel(GetCustomModelRequest.builder().applyMutation(getCustomModelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a custom model deployment, including its status, configuration, and metadata. Use
     * this operation to monitor the deployment status and retrieve details needed for inference requests.
     * </p>
     * <p>
     * The following actions are related to the <code>GetCustomModelDeployment</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html">
     * CreateCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModelDeployments.html">
     * ListCustomModelDeployments</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html">
     * DeleteCustomModelDeployment</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getCustomModelDeploymentRequest
     * @return A Java Future containing the result of the GetCustomModelDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetCustomModelDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetCustomModelDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomModelDeploymentResponse> getCustomModelDeployment(
            GetCustomModelDeploymentRequest getCustomModelDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a custom model deployment, including its status, configuration, and metadata. Use
     * this operation to monitor the deployment status and retrieve details needed for inference requests.
     * </p>
     * <p>
     * The following actions are related to the <code>GetCustomModelDeployment</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html">
     * CreateCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModelDeployments.html">
     * ListCustomModelDeployments</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html">
     * DeleteCustomModelDeployment</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomModelDeploymentRequest.Builder} avoiding
     * the need to create one manually via {@link GetCustomModelDeploymentRequest#builder()}
     * </p>
     *
     * @param getCustomModelDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetCustomModelDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCustomModelDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetCustomModelDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetCustomModelDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomModelDeploymentResponse> getCustomModelDeployment(
            Consumer<GetCustomModelDeploymentRequest.Builder> getCustomModelDeploymentRequest) {
        return getCustomModelDeployment(GetCustomModelDeploymentRequest.builder().applyMutation(getCustomModelDeploymentRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about an evaluation job, such as the status of the job.
     * </p>
     *
     * @param getEvaluationJobRequest
     * @return A Java Future containing the result of the GetEvaluationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetEvaluationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetEvaluationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEvaluationJobResponse> getEvaluationJob(GetEvaluationJobRequest getEvaluationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an evaluation job, such as the status of the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvaluationJobRequest.Builder} avoiding the need
     * to create one manually via {@link GetEvaluationJobRequest#builder()}
     * </p>
     *
     * @param getEvaluationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetEvaluationJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEvaluationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetEvaluationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetEvaluationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEvaluationJobResponse> getEvaluationJob(
            Consumer<GetEvaluationJobRequest.Builder> getEvaluationJobRequest) {
        return getEvaluationJob(GetEvaluationJobRequest.builder().applyMutation(getEvaluationJobRequest).build());
    }

    /**
     * <p>
     * Get details about a Amazon Bedrock foundation model.
     * </p>
     *
     * @param getFoundationModelRequest
     * @return A Java Future containing the result of the GetFoundationModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetFoundationModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetFoundationModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFoundationModelResponse> getFoundationModel(GetFoundationModelRequest getFoundationModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details about a Amazon Bedrock foundation model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFoundationModelRequest.Builder} avoiding the
     * need to create one manually via {@link GetFoundationModelRequest#builder()}
     * </p>
     *
     * @param getFoundationModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFoundationModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetFoundationModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetFoundationModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFoundationModelResponse> getFoundationModel(
            Consumer<GetFoundationModelRequest.Builder> getFoundationModelRequest) {
        return getFoundationModel(GetFoundationModelRequest.builder().applyMutation(getFoundationModelRequest).build());
    }

    /**
     * <p>
     * Get information about the Foundation model availability.
     * </p>
     *
     * @param getFoundationModelAvailabilityRequest
     * @return A Java Future containing the result of the GetFoundationModelAvailability operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetFoundationModelAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetFoundationModelAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFoundationModelAvailabilityResponse> getFoundationModelAvailability(
            GetFoundationModelAvailabilityRequest getFoundationModelAvailabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about the Foundation model availability.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFoundationModelAvailabilityRequest.Builder}
     * avoiding the need to create one manually via {@link GetFoundationModelAvailabilityRequest#builder()}
     * </p>
     *
     * @param getFoundationModelAvailabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetFoundationModelAvailabilityRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetFoundationModelAvailability operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetFoundationModelAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetFoundationModelAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFoundationModelAvailabilityResponse> getFoundationModelAvailability(
            Consumer<GetFoundationModelAvailabilityRequest.Builder> getFoundationModelAvailabilityRequest) {
        return getFoundationModelAvailability(GetFoundationModelAvailabilityRequest.builder()
                .applyMutation(getFoundationModelAvailabilityRequest).build());
    }

    /**
     * <p>
     * Gets details about a guardrail. If you don't specify a version, the response returns details for the
     * <code>DRAFT</code> version.
     * </p>
     *
     * @param getGuardrailRequest
     * @return A Java Future containing the result of the GetGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGuardrailResponse> getGuardrail(GetGuardrailRequest getGuardrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a guardrail. If you don't specify a version, the response returns details for the
     * <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGuardrailRequest.Builder} avoiding the need to
     * create one manually via {@link GetGuardrailRequest#builder()}
     * </p>
     *
     * @param getGuardrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetGuardrailRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGuardrailResponse> getGuardrail(Consumer<GetGuardrailRequest.Builder> getGuardrailRequest) {
        return getGuardrail(GetGuardrailRequest.builder().applyMutation(getGuardrailRequest).build());
    }

    /**
     * <p>
     * Gets properties associated with a customized model you imported.
     * </p>
     *
     * @param getImportedModelRequest
     * @return A Java Future containing the result of the GetImportedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetImportedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetImportedModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportedModelResponse> getImportedModel(GetImportedModelRequest getImportedModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets properties associated with a customized model you imported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportedModelRequest.Builder} avoiding the need
     * to create one manually via {@link GetImportedModelRequest#builder()}
     * </p>
     *
     * @param getImportedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetImportedModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImportedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetImportedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetImportedModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportedModelResponse> getImportedModel(
            Consumer<GetImportedModelRequest.Builder> getImportedModelRequest) {
        return getImportedModel(GetImportedModelRequest.builder().applyMutation(getImportedModelRequest).build());
    }

    /**
     * <p>
     * Gets information about an inference profile. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">Increase throughput and
     * resilience with cross-region inference in Amazon Bedrock</a>. in the Amazon Bedrock User Guide.
     * </p>
     *
     * @param getInferenceProfileRequest
     * @return A Java Future containing the result of the GetInferenceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetInferenceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetInferenceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInferenceProfileResponse> getInferenceProfile(
            GetInferenceProfileRequest getInferenceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an inference profile. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">Increase throughput and
     * resilience with cross-region inference in Amazon Bedrock</a>. in the Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInferenceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetInferenceProfileRequest#builder()}
     * </p>
     *
     * @param getInferenceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetInferenceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInferenceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetInferenceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetInferenceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInferenceProfileResponse> getInferenceProfile(
            Consumer<GetInferenceProfileRequest.Builder> getInferenceProfileRequest) {
        return getInferenceProfile(GetInferenceProfileRequest.builder().applyMutation(getInferenceProfileRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a specific endpoint for a model from Amazon Bedrock Marketplace.
     * </p>
     *
     * @param getMarketplaceModelEndpointRequest
     * @return A Java Future containing the result of the GetMarketplaceModelEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMarketplaceModelEndpointResponse> getMarketplaceModelEndpoint(
            GetMarketplaceModelEndpointRequest getMarketplaceModelEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific endpoint for a model from Amazon Bedrock Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMarketplaceModelEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link GetMarketplaceModelEndpointRequest#builder()}
     * </p>
     *
     * @param getMarketplaceModelEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetMarketplaceModelEndpointRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetMarketplaceModelEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMarketplaceModelEndpointResponse> getMarketplaceModelEndpoint(
            Consumer<GetMarketplaceModelEndpointRequest.Builder> getMarketplaceModelEndpointRequest) {
        return getMarketplaceModelEndpoint(GetMarketplaceModelEndpointRequest.builder()
                .applyMutation(getMarketplaceModelEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a model copy job. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other
     * regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     *
     * @param getModelCopyJobRequest
     * @return A Java Future containing the result of the GetModelCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetModelCopyJobResponse> getModelCopyJob(GetModelCopyJobRequest getModelCopyJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a model copy job. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other
     * regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelCopyJobRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelCopyJobRequest#builder()}
     * </p>
     *
     * @param getModelCopyJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetModelCopyJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetModelCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetModelCopyJobResponse> getModelCopyJob(
            Consumer<GetModelCopyJobRequest.Builder> getModelCopyJobRequest) {
        return getModelCopyJob(GetModelCopyJobRequest.builder().applyMutation(getModelCopyJobRequest).build());
    }

    /**
     * <p>
     * Retrieves the properties associated with a model-customization job, including the status of the job. For more
     * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom
     * models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     *
     * @param getModelCustomizationJobRequest
     * @return A Java Future containing the result of the GetModelCustomizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelCustomizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelCustomizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetModelCustomizationJobResponse> getModelCustomizationJob(
            GetModelCustomizationJobRequest getModelCustomizationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the properties associated with a model-customization job, including the status of the job. For more
     * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom
     * models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelCustomizationJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetModelCustomizationJobRequest#builder()}
     * </p>
     *
     * @param getModelCustomizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetModelCustomizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelCustomizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelCustomizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetModelCustomizationJobResponse> getModelCustomizationJob(
            Consumer<GetModelCustomizationJobRequest.Builder> getModelCustomizationJobRequest) {
        return getModelCustomizationJob(GetModelCustomizationJobRequest.builder().applyMutation(getModelCustomizationJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the properties associated with import model job, including the status of the job. For more information,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param getModelImportJobRequest
     * @return A Java Future containing the result of the GetModelImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetModelImportJobResponse> getModelImportJob(GetModelImportJobRequest getModelImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the properties associated with import model job, including the status of the job. For more information,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelImportJobRequest#builder()}
     * </p>
     *
     * @param getModelImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetModelImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetModelImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetModelImportJobResponse> getModelImportJob(
            Consumer<GetModelImportJobRequest.Builder> getModelImportJobRequest) {
        return getModelImportJob(GetModelImportJobRequest.builder().applyMutation(getModelImportJobRequest).build());
    }

    /**
     * <p>
     * Gets details about a batch inference job. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-monitor">Monitor batch inference
     * jobs</a>
     * </p>
     *
     * @param getModelInvocationJobRequest
     * @return A Java Future containing the result of the GetModelInvocationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelInvocationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelInvocationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetModelInvocationJobResponse> getModelInvocationJob(
            GetModelInvocationJobRequest getModelInvocationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a batch inference job. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-monitor">Monitor batch inference
     * jobs</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelInvocationJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetModelInvocationJobRequest#builder()}
     * </p>
     *
     * @param getModelInvocationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetModelInvocationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelInvocationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelInvocationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetModelInvocationJobResponse> getModelInvocationJob(
            Consumer<GetModelInvocationJobRequest.Builder> getModelInvocationJobRequest) {
        return getModelInvocationJob(GetModelInvocationJobRequest.builder().applyMutation(getModelInvocationJobRequest).build());
    }

    /**
     * <p>
     * Get the current configuration values for model invocation logging.
     * </p>
     *
     * @param getModelInvocationLoggingConfigurationRequest
     * @return A Java Future containing the result of the GetModelInvocationLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelInvocationLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelInvocationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetModelInvocationLoggingConfigurationResponse> getModelInvocationLoggingConfiguration(
            GetModelInvocationLoggingConfigurationRequest getModelInvocationLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the current configuration values for model invocation logging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetModelInvocationLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetModelInvocationLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param getModelInvocationLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetModelInvocationLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetModelInvocationLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetModelInvocationLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelInvocationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetModelInvocationLoggingConfigurationResponse> getModelInvocationLoggingConfiguration(
            Consumer<GetModelInvocationLoggingConfigurationRequest.Builder> getModelInvocationLoggingConfigurationRequest) {
        return getModelInvocationLoggingConfiguration(GetModelInvocationLoggingConfigurationRequest.builder()
                .applyMutation(getModelInvocationLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a prompt router.
     * </p>
     *
     * @param getPromptRouterRequest
     * @return A Java Future containing the result of the GetPromptRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetPromptRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetPromptRouter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPromptRouterResponse> getPromptRouter(GetPromptRouterRequest getPromptRouterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a prompt router.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPromptRouterRequest.Builder} avoiding the need
     * to create one manually via {@link GetPromptRouterRequest#builder()}
     * </p>
     *
     * @param getPromptRouterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetPromptRouterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPromptRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetPromptRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetPromptRouter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPromptRouterResponse> getPromptRouter(
            Consumer<GetPromptRouterRequest.Builder> getPromptRouterRequest) {
        return getPromptRouter(GetPromptRouterRequest.builder().applyMutation(getPromptRouterRequest).build());
    }

    /**
     * <p>
     * Returns details for a Provisioned Throughput. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     *
     * @param getProvisionedModelThroughputRequest
     * @return A Java Future containing the result of the GetProvisionedModelThroughput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetProvisionedModelThroughput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetProvisionedModelThroughput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProvisionedModelThroughputResponse> getProvisionedModelThroughput(
            GetProvisionedModelThroughputRequest getProvisionedModelThroughputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for a Provisioned Throughput. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisionedModelThroughputRequest.Builder}
     * avoiding the need to create one manually via {@link GetProvisionedModelThroughputRequest#builder()}
     * </p>
     *
     * @param getProvisionedModelThroughputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetProvisionedModelThroughput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetProvisionedModelThroughput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetProvisionedModelThroughput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProvisionedModelThroughputResponse> getProvisionedModelThroughput(
            Consumer<GetProvisionedModelThroughputRequest.Builder> getProvisionedModelThroughputRequest) {
        return getProvisionedModelThroughput(GetProvisionedModelThroughputRequest.builder()
                .applyMutation(getProvisionedModelThroughputRequest).build());
    }

    /**
     * <p>
     * Get usecase for model access.
     * </p>
     *
     * @param getUseCaseForModelAccessRequest
     * @return A Java Future containing the result of the GetUseCaseForModelAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetUseCaseForModelAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetUseCaseForModelAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUseCaseForModelAccessResponse> getUseCaseForModelAccess(
            GetUseCaseForModelAccessRequest getUseCaseForModelAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get usecase for model access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUseCaseForModelAccessRequest.Builder} avoiding
     * the need to create one manually via {@link GetUseCaseForModelAccessRequest#builder()}
     * </p>
     *
     * @param getUseCaseForModelAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.GetUseCaseForModelAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUseCaseForModelAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.GetUseCaseForModelAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetUseCaseForModelAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUseCaseForModelAccessResponse> getUseCaseForModelAccess(
            Consumer<GetUseCaseForModelAccessRequest.Builder> getUseCaseForModelAccessRequest) {
        return getUseCaseForModelAccess(GetUseCaseForModelAccessRequest.builder().applyMutation(getUseCaseForModelAccessRequest)
                .build());
    }

    /**
     * <p>
     * Lists all Automated Reasoning policies in your account, with optional filtering by policy ARN. This helps you
     * manage and discover existing policies.
     * </p>
     *
     * @param listAutomatedReasoningPoliciesRequest
     * @return A Java Future containing the result of the ListAutomatedReasoningPolicies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutomatedReasoningPoliciesResponse> listAutomatedReasoningPolicies(
            ListAutomatedReasoningPoliciesRequest listAutomatedReasoningPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Automated Reasoning policies in your account, with optional filtering by policy ARN. This helps you
     * manage and discover existing policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutomatedReasoningPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAutomatedReasoningPoliciesRequest#builder()}
     * </p>
     *
     * @param listAutomatedReasoningPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAutomatedReasoningPolicies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutomatedReasoningPoliciesResponse> listAutomatedReasoningPolicies(
            Consumer<ListAutomatedReasoningPoliciesRequest.Builder> listAutomatedReasoningPoliciesRequest) {
        return listAutomatedReasoningPolicies(ListAutomatedReasoningPoliciesRequest.builder()
                .applyMutation(listAutomatedReasoningPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutomatedReasoningPolicies(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPoliciesPublisher publisher = client.listAutomatedReasoningPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPoliciesPublisher publisher = client.listAutomatedReasoningPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutomatedReasoningPolicies(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAutomatedReasoningPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomatedReasoningPoliciesPublisher listAutomatedReasoningPoliciesPaginator(
            ListAutomatedReasoningPoliciesRequest listAutomatedReasoningPoliciesRequest) {
        return new ListAutomatedReasoningPoliciesPublisher(this, listAutomatedReasoningPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutomatedReasoningPolicies(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPoliciesPublisher publisher = client.listAutomatedReasoningPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPoliciesPublisher publisher = client.listAutomatedReasoningPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutomatedReasoningPolicies(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutomatedReasoningPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAutomatedReasoningPoliciesRequest#builder()}
     * </p>
     *
     * @param listAutomatedReasoningPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomatedReasoningPoliciesPublisher listAutomatedReasoningPoliciesPaginator(
            Consumer<ListAutomatedReasoningPoliciesRequest.Builder> listAutomatedReasoningPoliciesRequest) {
        return listAutomatedReasoningPoliciesPaginator(ListAutomatedReasoningPoliciesRequest.builder()
                .applyMutation(listAutomatedReasoningPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all build workflows for an Automated Reasoning policy, showing the history of policy creation and
     * modification attempts.
     * </p>
     *
     * @param listAutomatedReasoningPolicyBuildWorkflowsRequest
     * @return A Java Future containing the result of the ListAutomatedReasoningPolicyBuildWorkflows operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyBuildWorkflows
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyBuildWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutomatedReasoningPolicyBuildWorkflowsResponse> listAutomatedReasoningPolicyBuildWorkflows(
            ListAutomatedReasoningPolicyBuildWorkflowsRequest listAutomatedReasoningPolicyBuildWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all build workflows for an Automated Reasoning policy, showing the history of policy creation and
     * modification attempts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAutomatedReasoningPolicyBuildWorkflowsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAutomatedReasoningPolicyBuildWorkflowsRequest#builder()}
     * </p>
     *
     * @param listAutomatedReasoningPolicyBuildWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAutomatedReasoningPolicyBuildWorkflows operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyBuildWorkflows
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyBuildWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutomatedReasoningPolicyBuildWorkflowsResponse> listAutomatedReasoningPolicyBuildWorkflows(
            Consumer<ListAutomatedReasoningPolicyBuildWorkflowsRequest.Builder> listAutomatedReasoningPolicyBuildWorkflowsRequest) {
        return listAutomatedReasoningPolicyBuildWorkflows(ListAutomatedReasoningPolicyBuildWorkflowsRequest.builder()
                .applyMutation(listAutomatedReasoningPolicyBuildWorkflowsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutomatedReasoningPolicyBuildWorkflows(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyBuildWorkflowsPublisher publisher = client.listAutomatedReasoningPolicyBuildWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyBuildWorkflowsPublisher publisher = client.listAutomatedReasoningPolicyBuildWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutomatedReasoningPolicyBuildWorkflows(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAutomatedReasoningPolicyBuildWorkflowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyBuildWorkflows
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyBuildWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomatedReasoningPolicyBuildWorkflowsPublisher listAutomatedReasoningPolicyBuildWorkflowsPaginator(
            ListAutomatedReasoningPolicyBuildWorkflowsRequest listAutomatedReasoningPolicyBuildWorkflowsRequest) {
        return new ListAutomatedReasoningPolicyBuildWorkflowsPublisher(this, listAutomatedReasoningPolicyBuildWorkflowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutomatedReasoningPolicyBuildWorkflows(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyBuildWorkflowsPublisher publisher = client.listAutomatedReasoningPolicyBuildWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyBuildWorkflowsPublisher publisher = client.listAutomatedReasoningPolicyBuildWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutomatedReasoningPolicyBuildWorkflows(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAutomatedReasoningPolicyBuildWorkflowsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAutomatedReasoningPolicyBuildWorkflowsRequest#builder()}
     * </p>
     *
     * @param listAutomatedReasoningPolicyBuildWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyBuildWorkflows
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyBuildWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomatedReasoningPolicyBuildWorkflowsPublisher listAutomatedReasoningPolicyBuildWorkflowsPaginator(
            Consumer<ListAutomatedReasoningPolicyBuildWorkflowsRequest.Builder> listAutomatedReasoningPolicyBuildWorkflowsRequest) {
        return listAutomatedReasoningPolicyBuildWorkflowsPaginator(ListAutomatedReasoningPolicyBuildWorkflowsRequest.builder()
                .applyMutation(listAutomatedReasoningPolicyBuildWorkflowsRequest).build());
    }

    /**
     * <p>
     * Lists tests for an Automated Reasoning policy. We recommend using pagination to ensure that the operation returns
     * quickly and successfully.
     * </p>
     *
     * @param listAutomatedReasoningPolicyTestCasesRequest
     * @return A Java Future containing the result of the ListAutomatedReasoningPolicyTestCases operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyTestCases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutomatedReasoningPolicyTestCasesResponse> listAutomatedReasoningPolicyTestCases(
            ListAutomatedReasoningPolicyTestCasesRequest listAutomatedReasoningPolicyTestCasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tests for an Automated Reasoning policy. We recommend using pagination to ensure that the operation returns
     * quickly and successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAutomatedReasoningPolicyTestCasesRequest.Builder} avoiding the need to create one manually via
     * {@link ListAutomatedReasoningPolicyTestCasesRequest#builder()}
     * </p>
     *
     * @param listAutomatedReasoningPolicyTestCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAutomatedReasoningPolicyTestCases operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyTestCases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutomatedReasoningPolicyTestCasesResponse> listAutomatedReasoningPolicyTestCases(
            Consumer<ListAutomatedReasoningPolicyTestCasesRequest.Builder> listAutomatedReasoningPolicyTestCasesRequest) {
        return listAutomatedReasoningPolicyTestCases(ListAutomatedReasoningPolicyTestCasesRequest.builder()
                .applyMutation(listAutomatedReasoningPolicyTestCasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutomatedReasoningPolicyTestCases(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestCasesPublisher publisher = client.listAutomatedReasoningPolicyTestCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestCasesPublisher publisher = client.listAutomatedReasoningPolicyTestCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutomatedReasoningPolicyTestCases(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAutomatedReasoningPolicyTestCasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyTestCases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomatedReasoningPolicyTestCasesPublisher listAutomatedReasoningPolicyTestCasesPaginator(
            ListAutomatedReasoningPolicyTestCasesRequest listAutomatedReasoningPolicyTestCasesRequest) {
        return new ListAutomatedReasoningPolicyTestCasesPublisher(this, listAutomatedReasoningPolicyTestCasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutomatedReasoningPolicyTestCases(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestCasesPublisher publisher = client.listAutomatedReasoningPolicyTestCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestCasesPublisher publisher = client.listAutomatedReasoningPolicyTestCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutomatedReasoningPolicyTestCases(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAutomatedReasoningPolicyTestCasesRequest.Builder} avoiding the need to create one manually via
     * {@link ListAutomatedReasoningPolicyTestCasesRequest#builder()}
     * </p>
     *
     * @param listAutomatedReasoningPolicyTestCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyTestCases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomatedReasoningPolicyTestCasesPublisher listAutomatedReasoningPolicyTestCasesPaginator(
            Consumer<ListAutomatedReasoningPolicyTestCasesRequest.Builder> listAutomatedReasoningPolicyTestCasesRequest) {
        return listAutomatedReasoningPolicyTestCasesPaginator(ListAutomatedReasoningPolicyTestCasesRequest.builder()
                .applyMutation(listAutomatedReasoningPolicyTestCasesRequest).build());
    }

    /**
     * <p>
     * Lists test results for an Automated Reasoning policy, showing how the policy performed against various test
     * scenarios and validation checks.
     * </p>
     *
     * @param listAutomatedReasoningPolicyTestResultsRequest
     * @return A Java Future containing the result of the ListAutomatedReasoningPolicyTestResults operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyTestResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyTestResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutomatedReasoningPolicyTestResultsResponse> listAutomatedReasoningPolicyTestResults(
            ListAutomatedReasoningPolicyTestResultsRequest listAutomatedReasoningPolicyTestResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists test results for an Automated Reasoning policy, showing how the policy performed against various test
     * scenarios and validation checks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAutomatedReasoningPolicyTestResultsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAutomatedReasoningPolicyTestResultsRequest#builder()}
     * </p>
     *
     * @param listAutomatedReasoningPolicyTestResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAutomatedReasoningPolicyTestResults operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyTestResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyTestResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutomatedReasoningPolicyTestResultsResponse> listAutomatedReasoningPolicyTestResults(
            Consumer<ListAutomatedReasoningPolicyTestResultsRequest.Builder> listAutomatedReasoningPolicyTestResultsRequest) {
        return listAutomatedReasoningPolicyTestResults(ListAutomatedReasoningPolicyTestResultsRequest.builder()
                .applyMutation(listAutomatedReasoningPolicyTestResultsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutomatedReasoningPolicyTestResults(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestResultsPublisher publisher = client.listAutomatedReasoningPolicyTestResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestResultsPublisher publisher = client.listAutomatedReasoningPolicyTestResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutomatedReasoningPolicyTestResults(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAutomatedReasoningPolicyTestResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyTestResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyTestResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomatedReasoningPolicyTestResultsPublisher listAutomatedReasoningPolicyTestResultsPaginator(
            ListAutomatedReasoningPolicyTestResultsRequest listAutomatedReasoningPolicyTestResultsRequest) {
        return new ListAutomatedReasoningPolicyTestResultsPublisher(this, listAutomatedReasoningPolicyTestResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutomatedReasoningPolicyTestResults(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestResultsPublisher publisher = client.listAutomatedReasoningPolicyTestResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListAutomatedReasoningPolicyTestResultsPublisher publisher = client.listAutomatedReasoningPolicyTestResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutomatedReasoningPolicyTestResults(software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAutomatedReasoningPolicyTestResultsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAutomatedReasoningPolicyTestResultsRequest#builder()}
     * </p>
     *
     * @param listAutomatedReasoningPolicyTestResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListAutomatedReasoningPolicyTestResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListAutomatedReasoningPolicyTestResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomatedReasoningPolicyTestResultsPublisher listAutomatedReasoningPolicyTestResultsPaginator(
            Consumer<ListAutomatedReasoningPolicyTestResultsRequest.Builder> listAutomatedReasoningPolicyTestResultsRequest) {
        return listAutomatedReasoningPolicyTestResultsPaginator(ListAutomatedReasoningPolicyTestResultsRequest.builder()
                .applyMutation(listAutomatedReasoningPolicyTestResultsRequest).build());
    }

    /**
     * <p>
     * Lists custom model deployments in your account. You can filter the results by creation time, name, status, and
     * associated model. Use this operation to manage and monitor your custom model deployments.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * The following actions are related to the <code>ListCustomModelDeployments</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html">
     * CreateCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModelDeployment.html">
     * GetCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html">
     * DeleteCustomModelDeployment</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listCustomModelDeploymentsRequest
     * @return A Java Future containing the result of the ListCustomModelDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListCustomModelDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModelDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomModelDeploymentsResponse> listCustomModelDeployments(
            ListCustomModelDeploymentsRequest listCustomModelDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists custom model deployments in your account. You can filter the results by creation time, name, status, and
     * associated model. Use this operation to manage and monitor your custom model deployments.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * The following actions are related to the <code>ListCustomModelDeployments</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html">
     * CreateCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModelDeployment.html">
     * GetCustomModelDeployment</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html">
     * DeleteCustomModelDeployment</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomModelDeploymentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomModelDeploymentsRequest#builder()}
     * </p>
     *
     * @param listCustomModelDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListCustomModelDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListCustomModelDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModelDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomModelDeploymentsResponse> listCustomModelDeployments(
            Consumer<ListCustomModelDeploymentsRequest.Builder> listCustomModelDeploymentsRequest) {
        return listCustomModelDeployments(ListCustomModelDeploymentsRequest.builder()
                .applyMutation(listCustomModelDeploymentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomModelDeployments(software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListCustomModelDeploymentsPublisher publisher = client.listCustomModelDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListCustomModelDeploymentsPublisher publisher = client.listCustomModelDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomModelDeployments(software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomModelDeploymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListCustomModelDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModelDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomModelDeploymentsPublisher listCustomModelDeploymentsPaginator(
            ListCustomModelDeploymentsRequest listCustomModelDeploymentsRequest) {
        return new ListCustomModelDeploymentsPublisher(this, listCustomModelDeploymentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomModelDeployments(software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListCustomModelDeploymentsPublisher publisher = client.listCustomModelDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListCustomModelDeploymentsPublisher publisher = client.listCustomModelDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomModelDeployments(software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomModelDeploymentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomModelDeploymentsRequest#builder()}
     * </p>
     *
     * @param listCustomModelDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListCustomModelDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModelDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomModelDeploymentsPublisher listCustomModelDeploymentsPaginator(
            Consumer<ListCustomModelDeploymentsRequest.Builder> listCustomModelDeploymentsRequest) {
        return listCustomModelDeploymentsPaginator(ListCustomModelDeploymentsRequest.builder()
                .applyMutation(listCustomModelDeploymentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the custom models that you have created with the <code>CreateModelCustomizationJob</code>
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param listCustomModelsRequest
     * @return A Java Future containing the result of the ListCustomModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListCustomModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCustomModelsResponse> listCustomModels(ListCustomModelsRequest listCustomModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the custom models that you have created with the <code>CreateModelCustomizationJob</code>
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCustomModelsRequest#builder()}
     * </p>
     *
     * @param listCustomModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCustomModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListCustomModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCustomModelsResponse> listCustomModels(
            Consumer<ListCustomModelsRequest.Builder> listCustomModelsRequest) {
        return listCustomModels(ListCustomModelsRequest.builder().applyMutation(listCustomModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomModels(software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListCustomModelsPublisher publisher = client.listCustomModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListCustomModelsPublisher publisher = client.listCustomModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomModels(software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest)} operation.</b>
     * </p>
     *
     * @param listCustomModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListCustomModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCustomModelsPublisher listCustomModelsPaginator(ListCustomModelsRequest listCustomModelsRequest) {
        return new ListCustomModelsPublisher(this, listCustomModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomModels(software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListCustomModelsPublisher publisher = client.listCustomModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListCustomModelsPublisher publisher = client.listCustomModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomModels(software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCustomModelsRequest#builder()}
     * </p>
     *
     * @param listCustomModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListCustomModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCustomModelsPublisher listCustomModelsPaginator(Consumer<ListCustomModelsRequest.Builder> listCustomModelsRequest) {
        return listCustomModelsPaginator(ListCustomModelsRequest.builder().applyMutation(listCustomModelsRequest).build());
    }

    /**
     * <p>
     * Lists all existing evaluation jobs.
     * </p>
     *
     * @param listEvaluationJobsRequest
     * @return A Java Future containing the result of the ListEvaluationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListEvaluationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListEvaluationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEvaluationJobsResponse> listEvaluationJobs(ListEvaluationJobsRequest listEvaluationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all existing evaluation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEvaluationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEvaluationJobsRequest#builder()}
     * </p>
     *
     * @param listEvaluationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEvaluationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListEvaluationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListEvaluationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEvaluationJobsResponse> listEvaluationJobs(
            Consumer<ListEvaluationJobsRequest.Builder> listEvaluationJobsRequest) {
        return listEvaluationJobs(ListEvaluationJobsRequest.builder().applyMutation(listEvaluationJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvaluationJobs(software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListEvaluationJobsPublisher publisher = client.listEvaluationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListEvaluationJobsPublisher publisher = client.listEvaluationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvaluationJobs(software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEvaluationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListEvaluationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListEvaluationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEvaluationJobsPublisher listEvaluationJobsPaginator(ListEvaluationJobsRequest listEvaluationJobsRequest) {
        return new ListEvaluationJobsPublisher(this, listEvaluationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvaluationJobs(software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListEvaluationJobsPublisher publisher = client.listEvaluationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListEvaluationJobsPublisher publisher = client.listEvaluationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvaluationJobs(software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEvaluationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEvaluationJobsRequest#builder()}
     * </p>
     *
     * @param listEvaluationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListEvaluationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListEvaluationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEvaluationJobsPublisher listEvaluationJobsPaginator(
            Consumer<ListEvaluationJobsRequest.Builder> listEvaluationJobsRequest) {
        return listEvaluationJobsPaginator(ListEvaluationJobsRequest.builder().applyMutation(listEvaluationJobsRequest).build());
    }

    /**
     * <p>
     * Get the offers associated with the specified model.
     * </p>
     *
     * @param listFoundationModelAgreementOffersRequest
     * @return A Java Future containing the result of the ListFoundationModelAgreementOffers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListFoundationModelAgreementOffers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListFoundationModelAgreementOffers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFoundationModelAgreementOffersResponse> listFoundationModelAgreementOffers(
            ListFoundationModelAgreementOffersRequest listFoundationModelAgreementOffersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the offers associated with the specified model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFoundationModelAgreementOffersRequest.Builder}
     * avoiding the need to create one manually via {@link ListFoundationModelAgreementOffersRequest#builder()}
     * </p>
     *
     * @param listFoundationModelAgreementOffersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListFoundationModelAgreementOffersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFoundationModelAgreementOffers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListFoundationModelAgreementOffers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListFoundationModelAgreementOffers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFoundationModelAgreementOffersResponse> listFoundationModelAgreementOffers(
            Consumer<ListFoundationModelAgreementOffersRequest.Builder> listFoundationModelAgreementOffersRequest) {
        return listFoundationModelAgreementOffers(ListFoundationModelAgreementOffersRequest.builder()
                .applyMutation(listFoundationModelAgreementOffersRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Bedrock foundation models that you can use. You can filter the results with the request parameters.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/foundation-models.html">Foundation models</a> in the
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     *
     * @param listFoundationModelsRequest
     * @return A Java Future containing the result of the ListFoundationModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListFoundationModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListFoundationModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFoundationModelsResponse> listFoundationModels(
            ListFoundationModelsRequest listFoundationModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Bedrock foundation models that you can use. You can filter the results with the request parameters.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/foundation-models.html">Foundation models</a> in the
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFoundationModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFoundationModelsRequest#builder()}
     * </p>
     *
     * @param listFoundationModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListFoundationModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFoundationModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListFoundationModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListFoundationModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFoundationModelsResponse> listFoundationModels(
            Consumer<ListFoundationModelsRequest.Builder> listFoundationModelsRequest) {
        return listFoundationModels(ListFoundationModelsRequest.builder().applyMutation(listFoundationModelsRequest).build());
    }

    /**
     * <p>
     * Lists details about all the guardrails in an account. To list the <code>DRAFT</code> version of all your
     * guardrails, don't specify the <code>guardrailIdentifier</code> field. To list all versions of a guardrail,
     * specify the ARN of the guardrail in the <code>guardrailIdentifier</code> field.
     * </p>
     * <p>
     * You can set the maximum number of results to return in a response in the <code>maxResults</code> field. If there
     * are more results than the number you set, the response returns a <code>nextToken</code> that you can send in
     * another <code>ListGuardrails</code> request to see the next batch of results.
     * </p>
     *
     * @param listGuardrailsRequest
     * @return A Java Future containing the result of the ListGuardrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListGuardrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListGuardrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGuardrailsResponse> listGuardrails(ListGuardrailsRequest listGuardrailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all the guardrails in an account. To list the <code>DRAFT</code> version of all your
     * guardrails, don't specify the <code>guardrailIdentifier</code> field. To list all versions of a guardrail,
     * specify the ARN of the guardrail in the <code>guardrailIdentifier</code> field.
     * </p>
     * <p>
     * You can set the maximum number of results to return in a response in the <code>maxResults</code> field. If there
     * are more results than the number you set, the response returns a <code>nextToken</code> that you can send in
     * another <code>ListGuardrails</code> request to see the next batch of results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGuardrailsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGuardrailsRequest#builder()}
     * </p>
     *
     * @param listGuardrailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGuardrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListGuardrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListGuardrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGuardrailsResponse> listGuardrails(Consumer<ListGuardrailsRequest.Builder> listGuardrailsRequest) {
        return listGuardrails(ListGuardrailsRequest.builder().applyMutation(listGuardrailsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGuardrails(software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListGuardrailsPublisher publisher = client.listGuardrailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListGuardrailsPublisher publisher = client.listGuardrailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGuardrails(software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest)} operation.</b>
     * </p>
     *
     * @param listGuardrailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListGuardrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListGuardrails" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGuardrailsPublisher listGuardrailsPaginator(ListGuardrailsRequest listGuardrailsRequest) {
        return new ListGuardrailsPublisher(this, listGuardrailsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGuardrails(software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListGuardrailsPublisher publisher = client.listGuardrailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListGuardrailsPublisher publisher = client.listGuardrailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGuardrails(software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGuardrailsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGuardrailsRequest#builder()}
     * </p>
     *
     * @param listGuardrailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListGuardrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListGuardrails" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGuardrailsPublisher listGuardrailsPaginator(Consumer<ListGuardrailsRequest.Builder> listGuardrailsRequest) {
        return listGuardrailsPaginator(ListGuardrailsRequest.builder().applyMutation(listGuardrailsRequest).build());
    }

    /**
     * <p>
     * Returns a list of models you've imported. You can filter the results to return based on one or more criteria. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param listImportedModelsRequest
     * @return A Java Future containing the result of the ListImportedModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListImportedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListImportedModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportedModelsResponse> listImportedModels(ListImportedModelsRequest listImportedModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of models you've imported. You can filter the results to return based on one or more criteria. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportedModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportedModelsRequest#builder()}
     * </p>
     *
     * @param listImportedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImportedModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListImportedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListImportedModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportedModelsResponse> listImportedModels(
            Consumer<ListImportedModelsRequest.Builder> listImportedModelsRequest) {
        return listImportedModels(ListImportedModelsRequest.builder().applyMutation(listImportedModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportedModels(software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListImportedModelsPublisher publisher = client.listImportedModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListImportedModelsPublisher publisher = client.listImportedModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportedModels(software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImportedModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListImportedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListImportedModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportedModelsPublisher listImportedModelsPaginator(ListImportedModelsRequest listImportedModelsRequest) {
        return new ListImportedModelsPublisher(this, listImportedModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportedModels(software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListImportedModelsPublisher publisher = client.listImportedModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListImportedModelsPublisher publisher = client.listImportedModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportedModels(software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportedModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportedModelsRequest#builder()}
     * </p>
     *
     * @param listImportedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListImportedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListImportedModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportedModelsPublisher listImportedModelsPaginator(
            Consumer<ListImportedModelsRequest.Builder> listImportedModelsRequest) {
        return listImportedModelsPaginator(ListImportedModelsRequest.builder().applyMutation(listImportedModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of inference profiles that you can use. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">Increase throughput and
     * resilience with cross-region inference in Amazon Bedrock</a>. in the Amazon Bedrock User Guide.
     * </p>
     *
     * @param listInferenceProfilesRequest
     * @return A Java Future containing the result of the ListInferenceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListInferenceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListInferenceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInferenceProfilesResponse> listInferenceProfiles(
            ListInferenceProfilesRequest listInferenceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of inference profiles that you can use. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">Increase throughput and
     * resilience with cross-region inference in Amazon Bedrock</a>. in the Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInferenceProfilesRequest#builder()}
     * </p>
     *
     * @param listInferenceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInferenceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListInferenceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListInferenceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInferenceProfilesResponse> listInferenceProfiles(
            Consumer<ListInferenceProfilesRequest.Builder> listInferenceProfilesRequest) {
        return listInferenceProfiles(ListInferenceProfilesRequest.builder().applyMutation(listInferenceProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInferenceProfiles(software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListInferenceProfilesPublisher publisher = client.listInferenceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListInferenceProfilesPublisher publisher = client.listInferenceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceProfiles(software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListInferenceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListInferenceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInferenceProfilesPublisher listInferenceProfilesPaginator(
            ListInferenceProfilesRequest listInferenceProfilesRequest) {
        return new ListInferenceProfilesPublisher(this, listInferenceProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInferenceProfiles(software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListInferenceProfilesPublisher publisher = client.listInferenceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListInferenceProfilesPublisher publisher = client.listInferenceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceProfiles(software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInferenceProfilesRequest#builder()}
     * </p>
     *
     * @param listInferenceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListInferenceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListInferenceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInferenceProfilesPublisher listInferenceProfilesPaginator(
            Consumer<ListInferenceProfilesRequest.Builder> listInferenceProfilesRequest) {
        return listInferenceProfilesPaginator(ListInferenceProfilesRequest.builder().applyMutation(listInferenceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the endpoints for models from Amazon Bedrock Marketplace in your Amazon Web Services account.
     * </p>
     *
     * @param listMarketplaceModelEndpointsRequest
     * @return A Java Future containing the result of the ListMarketplaceModelEndpoints operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListMarketplaceModelEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListMarketplaceModelEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMarketplaceModelEndpointsResponse> listMarketplaceModelEndpoints(
            ListMarketplaceModelEndpointsRequest listMarketplaceModelEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the endpoints for models from Amazon Bedrock Marketplace in your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMarketplaceModelEndpointsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMarketplaceModelEndpointsRequest#builder()}
     * </p>
     *
     * @param listMarketplaceModelEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMarketplaceModelEndpoints operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListMarketplaceModelEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListMarketplaceModelEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMarketplaceModelEndpointsResponse> listMarketplaceModelEndpoints(
            Consumer<ListMarketplaceModelEndpointsRequest.Builder> listMarketplaceModelEndpointsRequest) {
        return listMarketplaceModelEndpoints(ListMarketplaceModelEndpointsRequest.builder()
                .applyMutation(listMarketplaceModelEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMarketplaceModelEndpoints(software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListMarketplaceModelEndpointsPublisher publisher = client.listMarketplaceModelEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListMarketplaceModelEndpointsPublisher publisher = client.listMarketplaceModelEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMarketplaceModelEndpoints(software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMarketplaceModelEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListMarketplaceModelEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListMarketplaceModelEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMarketplaceModelEndpointsPublisher listMarketplaceModelEndpointsPaginator(
            ListMarketplaceModelEndpointsRequest listMarketplaceModelEndpointsRequest) {
        return new ListMarketplaceModelEndpointsPublisher(this, listMarketplaceModelEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMarketplaceModelEndpoints(software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListMarketplaceModelEndpointsPublisher publisher = client.listMarketplaceModelEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListMarketplaceModelEndpointsPublisher publisher = client.listMarketplaceModelEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMarketplaceModelEndpoints(software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMarketplaceModelEndpointsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMarketplaceModelEndpointsRequest#builder()}
     * </p>
     *
     * @param listMarketplaceModelEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListMarketplaceModelEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListMarketplaceModelEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMarketplaceModelEndpointsPublisher listMarketplaceModelEndpointsPaginator(
            Consumer<ListMarketplaceModelEndpointsRequest.Builder> listMarketplaceModelEndpointsRequest) {
        return listMarketplaceModelEndpointsPaginator(ListMarketplaceModelEndpointsRequest.builder()
                .applyMutation(listMarketplaceModelEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of model copy jobs that you have submitted. You can filter the jobs to return based on one or more
     * criteria. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other
     * regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     *
     * @param listModelCopyJobsRequest
     * @return A Java Future containing the result of the ListModelCopyJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListModelCopyJobsResponse> listModelCopyJobs(ListModelCopyJobsRequest listModelCopyJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of model copy jobs that you have submitted. You can filter the jobs to return based on one or more
     * criteria. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other
     * regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelCopyJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListModelCopyJobsRequest#builder()}
     * </p>
     *
     * @param listModelCopyJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListModelCopyJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListModelCopyJobsResponse> listModelCopyJobs(
            Consumer<ListModelCopyJobsRequest.Builder> listModelCopyJobsRequest) {
        return listModelCopyJobs(ListModelCopyJobsRequest.builder().applyMutation(listModelCopyJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelCopyJobs(software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelCopyJobsPublisher publisher = client.listModelCopyJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelCopyJobsPublisher publisher = client.listModelCopyJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelCopyJobs(software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest)} operation.</b>
     * </p>
     *
     * @param listModelCopyJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelCopyJobsPublisher listModelCopyJobsPaginator(ListModelCopyJobsRequest listModelCopyJobsRequest) {
        return new ListModelCopyJobsPublisher(this, listModelCopyJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelCopyJobs(software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelCopyJobsPublisher publisher = client.listModelCopyJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelCopyJobsPublisher publisher = client.listModelCopyJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelCopyJobs(software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelCopyJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListModelCopyJobsRequest#builder()}
     * </p>
     *
     * @param listModelCopyJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelCopyJobsPublisher listModelCopyJobsPaginator(
            Consumer<ListModelCopyJobsRequest.Builder> listModelCopyJobsRequest) {
        return listModelCopyJobsPaginator(ListModelCopyJobsRequest.builder().applyMutation(listModelCopyJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of model customization jobs that you have submitted. You can filter the jobs to return based on
     * one or more criteria.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param listModelCustomizationJobsRequest
     * @return A Java Future containing the result of the ListModelCustomizationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelCustomizationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCustomizationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelCustomizationJobsResponse> listModelCustomizationJobs(
            ListModelCustomizationJobsRequest listModelCustomizationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of model customization jobs that you have submitted. You can filter the jobs to return based on
     * one or more criteria.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelCustomizationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListModelCustomizationJobsRequest#builder()}
     * </p>
     *
     * @param listModelCustomizationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListModelCustomizationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelCustomizationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCustomizationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelCustomizationJobsResponse> listModelCustomizationJobs(
            Consumer<ListModelCustomizationJobsRequest.Builder> listModelCustomizationJobsRequest) {
        return listModelCustomizationJobs(ListModelCustomizationJobsRequest.builder()
                .applyMutation(listModelCustomizationJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelCustomizationJobs(software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelCustomizationJobsPublisher publisher = client.listModelCustomizationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelCustomizationJobsPublisher publisher = client.listModelCustomizationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelCustomizationJobs(software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelCustomizationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelCustomizationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCustomizationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelCustomizationJobsPublisher listModelCustomizationJobsPaginator(
            ListModelCustomizationJobsRequest listModelCustomizationJobsRequest) {
        return new ListModelCustomizationJobsPublisher(this, listModelCustomizationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelCustomizationJobs(software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelCustomizationJobsPublisher publisher = client.listModelCustomizationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelCustomizationJobsPublisher publisher = client.listModelCustomizationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelCustomizationJobs(software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelCustomizationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListModelCustomizationJobsRequest#builder()}
     * </p>
     *
     * @param listModelCustomizationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelCustomizationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCustomizationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelCustomizationJobsPublisher listModelCustomizationJobsPaginator(
            Consumer<ListModelCustomizationJobsRequest.Builder> listModelCustomizationJobsRequest) {
        return listModelCustomizationJobsPaginator(ListModelCustomizationJobsRequest.builder()
                .applyMutation(listModelCustomizationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of import jobs you've submitted. You can filter the results to return based on one or more
     * criteria. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param listModelImportJobsRequest
     * @return A Java Future containing the result of the ListModelImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListModelImportJobsResponse> listModelImportJobs(
            ListModelImportJobsRequest listModelImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of import jobs you've submitted. You can filter the results to return based on one or more
     * criteria. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a
     * customized model</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelImportJobsRequest#builder()}
     * </p>
     *
     * @param listModelImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListModelImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListModelImportJobsResponse> listModelImportJobs(
            Consumer<ListModelImportJobsRequest.Builder> listModelImportJobsRequest) {
        return listModelImportJobs(ListModelImportJobsRequest.builder().applyMutation(listModelImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelImportJobs(software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelImportJobsPublisher publisher = client.listModelImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelImportJobsPublisher publisher = client.listModelImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelImportJobs(software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelImportJobsPublisher listModelImportJobsPaginator(ListModelImportJobsRequest listModelImportJobsRequest) {
        return new ListModelImportJobsPublisher(this, listModelImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelImportJobs(software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelImportJobsPublisher publisher = client.listModelImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelImportJobsPublisher publisher = client.listModelImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelImportJobs(software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelImportJobsRequest#builder()}
     * </p>
     *
     * @param listModelImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelImportJobsPublisher listModelImportJobsPaginator(
            Consumer<ListModelImportJobsRequest.Builder> listModelImportJobsRequest) {
        return listModelImportJobsPaginator(ListModelImportJobsRequest.builder().applyMutation(listModelImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all batch inference jobs in the account. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-view.html">View details about a batch
     * inference job</a>.
     * </p>
     *
     * @param listModelInvocationJobsRequest
     * @return A Java Future containing the result of the ListModelInvocationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelInvocationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelInvocationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelInvocationJobsResponse> listModelInvocationJobs(
            ListModelInvocationJobsRequest listModelInvocationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all batch inference jobs in the account. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-view.html">View details about a batch
     * inference job</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelInvocationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListModelInvocationJobsRequest#builder()}
     * </p>
     *
     * @param listModelInvocationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListModelInvocationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelInvocationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelInvocationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelInvocationJobsResponse> listModelInvocationJobs(
            Consumer<ListModelInvocationJobsRequest.Builder> listModelInvocationJobsRequest) {
        return listModelInvocationJobs(ListModelInvocationJobsRequest.builder().applyMutation(listModelInvocationJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelInvocationJobs(software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelInvocationJobsPublisher publisher = client.listModelInvocationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelInvocationJobsPublisher publisher = client.listModelInvocationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelInvocationJobs(software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelInvocationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelInvocationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelInvocationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelInvocationJobsPublisher listModelInvocationJobsPaginator(
            ListModelInvocationJobsRequest listModelInvocationJobsRequest) {
        return new ListModelInvocationJobsPublisher(this, listModelInvocationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelInvocationJobs(software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelInvocationJobsPublisher publisher = client.listModelInvocationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListModelInvocationJobsPublisher publisher = client.listModelInvocationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelInvocationJobs(software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelInvocationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListModelInvocationJobsRequest#builder()}
     * </p>
     *
     * @param listModelInvocationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListModelInvocationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelInvocationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelInvocationJobsPublisher listModelInvocationJobsPaginator(
            Consumer<ListModelInvocationJobsRequest.Builder> listModelInvocationJobsRequest) {
        return listModelInvocationJobsPaginator(ListModelInvocationJobsRequest.builder()
                .applyMutation(listModelInvocationJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of prompt routers.
     * </p>
     *
     * @param listPromptRoutersRequest
     * @return A Java Future containing the result of the ListPromptRouters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListPromptRouters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListPromptRouters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPromptRoutersResponse> listPromptRouters(ListPromptRoutersRequest listPromptRoutersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of prompt routers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPromptRoutersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPromptRoutersRequest#builder()}
     * </p>
     *
     * @param listPromptRoutersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPromptRouters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListPromptRouters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListPromptRouters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPromptRoutersResponse> listPromptRouters(
            Consumer<ListPromptRoutersRequest.Builder> listPromptRoutersRequest) {
        return listPromptRouters(ListPromptRoutersRequest.builder().applyMutation(listPromptRoutersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPromptRouters(software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListPromptRoutersPublisher publisher = client.listPromptRoutersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListPromptRoutersPublisher publisher = client.listPromptRoutersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListPromptRoutersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListPromptRoutersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPromptRouters(software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest)} operation.</b>
     * </p>
     *
     * @param listPromptRoutersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListPromptRouters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListPromptRouters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptRoutersPublisher listPromptRoutersPaginator(ListPromptRoutersRequest listPromptRoutersRequest) {
        return new ListPromptRoutersPublisher(this, listPromptRoutersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPromptRouters(software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListPromptRoutersPublisher publisher = client.listPromptRoutersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListPromptRoutersPublisher publisher = client.listPromptRoutersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListPromptRoutersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListPromptRoutersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPromptRouters(software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPromptRoutersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPromptRoutersRequest#builder()}
     * </p>
     *
     * @param listPromptRoutersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListPromptRouters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListPromptRouters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptRoutersPublisher listPromptRoutersPaginator(
            Consumer<ListPromptRoutersRequest.Builder> listPromptRoutersRequest) {
        return listPromptRoutersPaginator(ListPromptRoutersRequest.builder().applyMutation(listPromptRoutersRequest).build());
    }

    /**
     * <p>
     * Lists the Provisioned Throughputs in the account. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     *
     * @param listProvisionedModelThroughputsRequest
     * @return A Java Future containing the result of the ListProvisionedModelThroughputs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListProvisionedModelThroughputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListProvisionedModelThroughputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisionedModelThroughputsResponse> listProvisionedModelThroughputs(
            ListProvisionedModelThroughputsRequest listProvisionedModelThroughputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Provisioned Throughputs in the account. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedModelThroughputsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisionedModelThroughputsRequest#builder()}
     * </p>
     *
     * @param listProvisionedModelThroughputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListProvisionedModelThroughputs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListProvisionedModelThroughputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListProvisionedModelThroughputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisionedModelThroughputsResponse> listProvisionedModelThroughputs(
            Consumer<ListProvisionedModelThroughputsRequest.Builder> listProvisionedModelThroughputsRequest) {
        return listProvisionedModelThroughputs(ListProvisionedModelThroughputsRequest.builder()
                .applyMutation(listProvisionedModelThroughputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisionedModelThroughputs(software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListProvisionedModelThroughputsPublisher publisher = client.listProvisionedModelThroughputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListProvisionedModelThroughputsPublisher publisher = client.listProvisionedModelThroughputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisionedModelThroughputs(software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisionedModelThroughputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListProvisionedModelThroughputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListProvisionedModelThroughputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedModelThroughputsPublisher listProvisionedModelThroughputsPaginator(
            ListProvisionedModelThroughputsRequest listProvisionedModelThroughputsRequest) {
        return new ListProvisionedModelThroughputsPublisher(this, listProvisionedModelThroughputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisionedModelThroughputs(software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListProvisionedModelThroughputsPublisher publisher = client.listProvisionedModelThroughputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrock.paginators.ListProvisionedModelThroughputsPublisher publisher = client.listProvisionedModelThroughputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisionedModelThroughputs(software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedModelThroughputsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisionedModelThroughputsRequest#builder()}
     * </p>
     *
     * @param listProvisionedModelThroughputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListProvisionedModelThroughputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListProvisionedModelThroughputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedModelThroughputsPublisher listProvisionedModelThroughputsPaginator(
            Consumer<ListProvisionedModelThroughputsRequest.Builder> listProvisionedModelThroughputsRequest) {
        return listProvisionedModelThroughputsPaginator(ListProvisionedModelThroughputsRequest.builder()
                .applyMutation(listProvisionedModelThroughputsRequest).build());
    }

    /**
     * <p>
     * List the tags associated with the specified resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags associated with the specified resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Set the configuration values for model invocation logging.
     * </p>
     *
     * @param putModelInvocationLoggingConfigurationRequest
     * @return A Java Future containing the result of the PutModelInvocationLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.PutModelInvocationLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/PutModelInvocationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutModelInvocationLoggingConfigurationResponse> putModelInvocationLoggingConfiguration(
            PutModelInvocationLoggingConfigurationRequest putModelInvocationLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the configuration values for model invocation logging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutModelInvocationLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutModelInvocationLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param putModelInvocationLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutModelInvocationLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.PutModelInvocationLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/PutModelInvocationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutModelInvocationLoggingConfigurationResponse> putModelInvocationLoggingConfiguration(
            Consumer<PutModelInvocationLoggingConfigurationRequest.Builder> putModelInvocationLoggingConfigurationRequest) {
        return putModelInvocationLoggingConfiguration(PutModelInvocationLoggingConfigurationRequest.builder()
                .applyMutation(putModelInvocationLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Put usecase for model access.
     * </p>
     *
     * @param putUseCaseForModelAccessRequest
     * @return A Java Future containing the result of the PutUseCaseForModelAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.PutUseCaseForModelAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/PutUseCaseForModelAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutUseCaseForModelAccessResponse> putUseCaseForModelAccess(
            PutUseCaseForModelAccessRequest putUseCaseForModelAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put usecase for model access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutUseCaseForModelAccessRequest.Builder} avoiding
     * the need to create one manually via {@link PutUseCaseForModelAccessRequest#builder()}
     * </p>
     *
     * @param putUseCaseForModelAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.PutUseCaseForModelAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutUseCaseForModelAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.PutUseCaseForModelAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/PutUseCaseForModelAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutUseCaseForModelAccessResponse> putUseCaseForModelAccess(
            Consumer<PutUseCaseForModelAccessRequest.Builder> putUseCaseForModelAccessRequest) {
        return putUseCaseForModelAccess(PutUseCaseForModelAccessRequest.builder().applyMutation(putUseCaseForModelAccessRequest)
                .build());
    }

    /**
     * <p>
     * Registers an existing Amazon SageMaker endpoint with Amazon Bedrock Marketplace, allowing it to be used with
     * Amazon Bedrock APIs.
     * </p>
     *
     * @param registerMarketplaceModelEndpointRequest
     * @return A Java Future containing the result of the RegisterMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.RegisterMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/RegisterMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterMarketplaceModelEndpointResponse> registerMarketplaceModelEndpoint(
            RegisterMarketplaceModelEndpointRequest registerMarketplaceModelEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an existing Amazon SageMaker endpoint with Amazon Bedrock Marketplace, allowing it to be used with
     * Amazon Bedrock APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterMarketplaceModelEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterMarketplaceModelEndpointRequest#builder()}
     * </p>
     *
     * @param registerMarketplaceModelEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.RegisterMarketplaceModelEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RegisterMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ServiceUnavailableException Returned if the service cannot complete the request.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.RegisterMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/RegisterMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterMarketplaceModelEndpointResponse> registerMarketplaceModelEndpoint(
            Consumer<RegisterMarketplaceModelEndpointRequest.Builder> registerMarketplaceModelEndpointRequest) {
        return registerMarketplaceModelEndpoint(RegisterMarketplaceModelEndpointRequest.builder()
                .applyMutation(registerMarketplaceModelEndpointRequest).build());
    }

    /**
     * <p>
     * Starts a new build workflow for an Automated Reasoning policy. This initiates the process of analyzing source
     * documents and generating policy rules, variables, and types.
     * </p>
     *
     * @param startAutomatedReasoningPolicyBuildWorkflowRequest
     * @return A Java Future containing the result of the StartAutomatedReasoningPolicyBuildWorkflow operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ResourceInUseException Thrown when attempting to delete or modify a resource that is currently being
     *         used by other resources or operations. For example, trying to delete an Automated Reasoning policy that
     *         is referenced by an active guardrail.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StartAutomatedReasoningPolicyBuildWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StartAutomatedReasoningPolicyBuildWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAutomatedReasoningPolicyBuildWorkflowResponse> startAutomatedReasoningPolicyBuildWorkflow(
            StartAutomatedReasoningPolicyBuildWorkflowRequest startAutomatedReasoningPolicyBuildWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new build workflow for an Automated Reasoning policy. This initiates the process of analyzing source
     * documents and generating policy rules, variables, and types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartAutomatedReasoningPolicyBuildWorkflowRequest.Builder} avoiding the need to create one manually via
     * {@link StartAutomatedReasoningPolicyBuildWorkflowRequest#builder()}
     * </p>
     *
     * @param startAutomatedReasoningPolicyBuildWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.StartAutomatedReasoningPolicyBuildWorkflowRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartAutomatedReasoningPolicyBuildWorkflow operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ResourceInUseException Thrown when attempting to delete or modify a resource that is currently being
     *         used by other resources or operations. For example, trying to delete an Automated Reasoning policy that
     *         is referenced by an active guardrail.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StartAutomatedReasoningPolicyBuildWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StartAutomatedReasoningPolicyBuildWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAutomatedReasoningPolicyBuildWorkflowResponse> startAutomatedReasoningPolicyBuildWorkflow(
            Consumer<StartAutomatedReasoningPolicyBuildWorkflowRequest.Builder> startAutomatedReasoningPolicyBuildWorkflowRequest) {
        return startAutomatedReasoningPolicyBuildWorkflow(StartAutomatedReasoningPolicyBuildWorkflowRequest.builder()
                .applyMutation(startAutomatedReasoningPolicyBuildWorkflowRequest).build());
    }

    /**
     * <p>
     * Initiates a test workflow to validate Automated Reasoning policy tests. The workflow executes the specified tests
     * against the policy and generates validation results.
     * </p>
     *
     * @param startAutomatedReasoningPolicyTestWorkflowRequest
     * @return A Java Future containing the result of the StartAutomatedReasoningPolicyTestWorkflow operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ResourceInUseException Thrown when attempting to delete or modify a resource that is currently being
     *         used by other resources or operations. For example, trying to delete an Automated Reasoning policy that
     *         is referenced by an active guardrail.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StartAutomatedReasoningPolicyTestWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StartAutomatedReasoningPolicyTestWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAutomatedReasoningPolicyTestWorkflowResponse> startAutomatedReasoningPolicyTestWorkflow(
            StartAutomatedReasoningPolicyTestWorkflowRequest startAutomatedReasoningPolicyTestWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a test workflow to validate Automated Reasoning policy tests. The workflow executes the specified tests
     * against the policy and generates validation results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartAutomatedReasoningPolicyTestWorkflowRequest.Builder} avoiding the need to create one manually via
     * {@link StartAutomatedReasoningPolicyTestWorkflowRequest#builder()}
     * </p>
     *
     * @param startAutomatedReasoningPolicyTestWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.StartAutomatedReasoningPolicyTestWorkflowRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartAutomatedReasoningPolicyTestWorkflow operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ResourceInUseException Thrown when attempting to delete or modify a resource that is currently being
     *         used by other resources or operations. For example, trying to delete an Automated Reasoning policy that
     *         is referenced by an active guardrail.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StartAutomatedReasoningPolicyTestWorkflow
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StartAutomatedReasoningPolicyTestWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAutomatedReasoningPolicyTestWorkflowResponse> startAutomatedReasoningPolicyTestWorkflow(
            Consumer<StartAutomatedReasoningPolicyTestWorkflowRequest.Builder> startAutomatedReasoningPolicyTestWorkflowRequest) {
        return startAutomatedReasoningPolicyTestWorkflow(StartAutomatedReasoningPolicyTestWorkflowRequest.builder()
                .applyMutation(startAutomatedReasoningPolicyTestWorkflowRequest).build());
    }

    /**
     * <p>
     * Stops an evaluation job that is current being created or running.
     * </p>
     *
     * @param stopEvaluationJobRequest
     * @return A Java Future containing the result of the StopEvaluationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StopEvaluationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopEvaluationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopEvaluationJobResponse> stopEvaluationJob(StopEvaluationJobRequest stopEvaluationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an evaluation job that is current being created or running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEvaluationJobRequest.Builder} avoiding the need
     * to create one manually via {@link StopEvaluationJobRequest#builder()}
     * </p>
     *
     * @param stopEvaluationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.StopEvaluationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopEvaluationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StopEvaluationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopEvaluationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopEvaluationJobResponse> stopEvaluationJob(
            Consumer<StopEvaluationJobRequest.Builder> stopEvaluationJobRequest) {
        return stopEvaluationJob(StopEvaluationJobRequest.builder().applyMutation(stopEvaluationJobRequest).build());
    }

    /**
     * <p>
     * Stops an active model customization job. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param stopModelCustomizationJobRequest
     * @return A Java Future containing the result of the StopModelCustomizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StopModelCustomizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopModelCustomizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopModelCustomizationJobResponse> stopModelCustomizationJob(
            StopModelCustomizationJobRequest stopModelCustomizationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an active model customization job. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopModelCustomizationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopModelCustomizationJobRequest#builder()}
     * </p>
     *
     * @param stopModelCustomizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.StopModelCustomizationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopModelCustomizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StopModelCustomizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopModelCustomizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopModelCustomizationJobResponse> stopModelCustomizationJob(
            Consumer<StopModelCustomizationJobRequest.Builder> stopModelCustomizationJobRequest) {
        return stopModelCustomizationJob(StopModelCustomizationJobRequest.builder()
                .applyMutation(stopModelCustomizationJobRequest).build());
    }

    /**
     * <p>
     * Stops a batch inference job. You're only charged for tokens that were already processed. For more information,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-stop.html">Stop a batch
     * inference job</a>.
     * </p>
     *
     * @param stopModelInvocationJobRequest
     * @return A Java Future containing the result of the StopModelInvocationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StopModelInvocationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopModelInvocationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopModelInvocationJobResponse> stopModelInvocationJob(
            StopModelInvocationJobRequest stopModelInvocationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a batch inference job. You're only charged for tokens that were already processed. For more information,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-stop.html">Stop a batch
     * inference job</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopModelInvocationJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopModelInvocationJobRequest#builder()}
     * </p>
     *
     * @param stopModelInvocationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.StopModelInvocationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopModelInvocationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.StopModelInvocationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopModelInvocationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopModelInvocationJobResponse> stopModelInvocationJob(
            Consumer<StopModelInvocationJobRequest.Builder> stopModelInvocationJobRequest) {
        return stopModelInvocationJob(StopModelInvocationJobRequest.builder().applyMutation(stopModelInvocationJobRequest)
                .build());
    }

    /**
     * <p>
     * Associate tags with a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate tags with a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove one or more tags from a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more tags from a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Automated Reasoning policy with new rules, variables, or configuration. This creates a new
     * version of the policy while preserving the previous version.
     * </p>
     *
     * @param updateAutomatedReasoningPolicyRequest
     * @return A Java Future containing the result of the UpdateAutomatedReasoningPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateAutomatedReasoningPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateAutomatedReasoningPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutomatedReasoningPolicyResponse> updateAutomatedReasoningPolicy(
            UpdateAutomatedReasoningPolicyRequest updateAutomatedReasoningPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Automated Reasoning policy with new rules, variables, or configuration. This creates a new
     * version of the policy while preserving the previous version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAutomatedReasoningPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAutomatedReasoningPolicyRequest#builder()}
     * </p>
     *
     * @param updateAutomatedReasoningPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAutomatedReasoningPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateAutomatedReasoningPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateAutomatedReasoningPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutomatedReasoningPolicyResponse> updateAutomatedReasoningPolicy(
            Consumer<UpdateAutomatedReasoningPolicyRequest.Builder> updateAutomatedReasoningPolicyRequest) {
        return updateAutomatedReasoningPolicy(UpdateAutomatedReasoningPolicyRequest.builder()
                .applyMutation(updateAutomatedReasoningPolicyRequest).build());
    }

    /**
     * <p>
     * Updates the annotations for an Automated Reasoning policy build workflow. This allows you to modify extracted
     * rules, variables, and types before finalizing the policy.
     * </p>
     *
     * @param updateAutomatedReasoningPolicyAnnotationsRequest
     * @return A Java Future containing the result of the UpdateAutomatedReasoningPolicyAnnotations operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateAutomatedReasoningPolicyAnnotations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateAutomatedReasoningPolicyAnnotations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutomatedReasoningPolicyAnnotationsResponse> updateAutomatedReasoningPolicyAnnotations(
            UpdateAutomatedReasoningPolicyAnnotationsRequest updateAutomatedReasoningPolicyAnnotationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the annotations for an Automated Reasoning policy build workflow. This allows you to modify extracted
     * rules, variables, and types before finalizing the policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateAutomatedReasoningPolicyAnnotationsRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateAutomatedReasoningPolicyAnnotationsRequest#builder()}
     * </p>
     *
     * @param updateAutomatedReasoningPolicyAnnotationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyAnnotationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAutomatedReasoningPolicyAnnotations operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateAutomatedReasoningPolicyAnnotations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateAutomatedReasoningPolicyAnnotations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutomatedReasoningPolicyAnnotationsResponse> updateAutomatedReasoningPolicyAnnotations(
            Consumer<UpdateAutomatedReasoningPolicyAnnotationsRequest.Builder> updateAutomatedReasoningPolicyAnnotationsRequest) {
        return updateAutomatedReasoningPolicyAnnotations(UpdateAutomatedReasoningPolicyAnnotationsRequest.builder()
                .applyMutation(updateAutomatedReasoningPolicyAnnotationsRequest).build());
    }

    /**
     * <p>
     * Updates an existing Automated Reasoning policy test. You can modify the content, query, expected result, and
     * confidence threshold.
     * </p>
     *
     * @param updateAutomatedReasoningPolicyTestCaseRequest
     * @return A Java Future containing the result of the UpdateAutomatedReasoningPolicyTestCase operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ResourceInUseException Thrown when attempting to delete or modify a resource that is currently being
     *         used by other resources or operations. For example, trying to delete an Automated Reasoning policy that
     *         is referenced by an active guardrail.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateAutomatedReasoningPolicyTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateAutomatedReasoningPolicyTestCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutomatedReasoningPolicyTestCaseResponse> updateAutomatedReasoningPolicyTestCase(
            UpdateAutomatedReasoningPolicyTestCaseRequest updateAutomatedReasoningPolicyTestCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Automated Reasoning policy test. You can modify the content, query, expected result, and
     * confidence threshold.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateAutomatedReasoningPolicyTestCaseRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateAutomatedReasoningPolicyTestCaseRequest#builder()}
     * </p>
     *
     * @param updateAutomatedReasoningPolicyTestCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.UpdateAutomatedReasoningPolicyTestCaseRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAutomatedReasoningPolicyTestCase operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ResourceInUseException Thrown when attempting to delete or modify a resource that is currently being
     *         used by other resources or operations. For example, trying to delete an Automated Reasoning policy that
     *         is referenced by an active guardrail.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateAutomatedReasoningPolicyTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateAutomatedReasoningPolicyTestCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutomatedReasoningPolicyTestCaseResponse> updateAutomatedReasoningPolicyTestCase(
            Consumer<UpdateAutomatedReasoningPolicyTestCaseRequest.Builder> updateAutomatedReasoningPolicyTestCaseRequest) {
        return updateAutomatedReasoningPolicyTestCase(UpdateAutomatedReasoningPolicyTestCaseRequest.builder()
                .applyMutation(updateAutomatedReasoningPolicyTestCaseRequest).build());
    }

    /**
     * <p>
     * Updates a guardrail with the values you specify.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify a <code>name</code> and optional <code>description</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify messages for when the guardrail successfully blocks a prompt or a model response in the
     * <code>blockedInputMessaging</code> and <code>blockedOutputsMessaging</code> fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify topics for the guardrail to deny in the <code>topicPolicyConfig</code> object. Each <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailTopicConfig.html"
     * >GuardrailTopicConfig</a> object in the <code>topicsConfig</code> list pertains to one topic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Give a <code>name</code> and <code>description</code> so that the guardrail can properly identify the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify <code>DENY</code> in the <code>type</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Provide up to five prompts that you would categorize as belonging to the topic in the
     * <code>examples</code> list.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Specify filter strengths for the harmful categories defined in Amazon Bedrock in the
     * <code>contentPolicyConfig</code> object. Each <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html"
     * >GuardrailContentFilterConfig</a> object in the <code>filtersConfig</code> list pertains to a harmful category.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-content-filters">Content filters</a>. For
     * more information about the fields in a content filter, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html"
     * >GuardrailContentFilterConfig</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the category in the <code>type</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the strength of the filter for prompts in the <code>inputStrength</code> field and for model responses in
     * the <code>strength</code> field of the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html"
     * >GuardrailContentFilterConfig</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * (Optional) For security, include the ARN of a KMS key in the <code>kmsKeyId</code> field.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateGuardrailRequest
     * @return A Java Future containing the result of the UpdateGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGuardrailResponse> updateGuardrail(UpdateGuardrailRequest updateGuardrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a guardrail with the values you specify.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify a <code>name</code> and optional <code>description</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify messages for when the guardrail successfully blocks a prompt or a model response in the
     * <code>blockedInputMessaging</code> and <code>blockedOutputsMessaging</code> fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify topics for the guardrail to deny in the <code>topicPolicyConfig</code> object. Each <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailTopicConfig.html"
     * >GuardrailTopicConfig</a> object in the <code>topicsConfig</code> list pertains to one topic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Give a <code>name</code> and <code>description</code> so that the guardrail can properly identify the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify <code>DENY</code> in the <code>type</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Provide up to five prompts that you would categorize as belonging to the topic in the
     * <code>examples</code> list.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Specify filter strengths for the harmful categories defined in Amazon Bedrock in the
     * <code>contentPolicyConfig</code> object. Each <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html"
     * >GuardrailContentFilterConfig</a> object in the <code>filtersConfig</code> list pertains to a harmful category.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-content-filters">Content filters</a>. For
     * more information about the fields in a content filter, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html"
     * >GuardrailContentFilterConfig</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the category in the <code>type</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the strength of the filter for prompts in the <code>inputStrength</code> field and for model responses in
     * the <code>strength</code> field of the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html"
     * >GuardrailContentFilterConfig</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * (Optional) For security, include the ARN of a KMS key in the <code>kmsKeyId</code> field.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGuardrailRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateGuardrailRequest#builder()}
     * </p>
     *
     * @param updateGuardrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.UpdateGuardrailRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGuardrailResponse> updateGuardrail(
            Consumer<UpdateGuardrailRequest.Builder> updateGuardrailRequest) {
        return updateGuardrail(UpdateGuardrailRequest.builder().applyMutation(updateGuardrailRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing endpoint for a model from Amazon Bedrock Marketplace.
     * </p>
     *
     * @param updateMarketplaceModelEndpointRequest
     * @return A Java Future containing the result of the UpdateMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMarketplaceModelEndpointResponse> updateMarketplaceModelEndpoint(
            UpdateMarketplaceModelEndpointRequest updateMarketplaceModelEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing endpoint for a model from Amazon Bedrock Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMarketplaceModelEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateMarketplaceModelEndpointRequest#builder()}
     * </p>
     *
     * @param updateMarketplaceModelEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.UpdateMarketplaceModelEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateMarketplaceModelEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateMarketplaceModelEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateMarketplaceModelEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMarketplaceModelEndpointResponse> updateMarketplaceModelEndpoint(
            Consumer<UpdateMarketplaceModelEndpointRequest.Builder> updateMarketplaceModelEndpointRequest) {
        return updateMarketplaceModelEndpoint(UpdateMarketplaceModelEndpointRequest.builder()
                .applyMutation(updateMarketplaceModelEndpointRequest).build());
    }

    /**
     * <p>
     * Updates the name or associated model for a Provisioned Throughput. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     *
     * @param updateProvisionedModelThroughputRequest
     * @return A Java Future containing the result of the UpdateProvisionedModelThroughput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateProvisionedModelThroughput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateProvisionedModelThroughput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProvisionedModelThroughputResponse> updateProvisionedModelThroughput(
            UpdateProvisionedModelThroughputRequest updateProvisionedModelThroughputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name or associated model for a Provisioned Throughput. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProvisionedModelThroughputRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateProvisionedModelThroughputRequest#builder()}
     * </p>
     *
     * @param updateProvisionedModelThroughputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrock.model.UpdateProvisionedModelThroughputRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateProvisionedModelThroughput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAsyncClient.UpdateProvisionedModelThroughput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateProvisionedModelThroughput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProvisionedModelThroughputResponse> updateProvisionedModelThroughput(
            Consumer<UpdateProvisionedModelThroughputRequest.Builder> updateProvisionedModelThroughputRequest) {
        return updateProvisionedModelThroughput(UpdateProvisionedModelThroughputRequest.builder()
                .applyMutation(updateProvisionedModelThroughputRequest).build());
    }

    @Override
    default BedrockServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAsyncClient}.
     */
    static BedrockAsyncClientBuilder builder() {
        return new DefaultBedrockAsyncClientBuilder();
    }
}
