/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the logical translation of natural language input into formal logical statements, including premises,
 * claims, and confidence scores.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningCheckTranslation implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningCheckTranslation.Builder, AutomatedReasoningCheckTranslation> {
    private static final SdkField<List<AutomatedReasoningLogicStatement>> PREMISES_FIELD = SdkField
            .<List<AutomatedReasoningLogicStatement>> builder(MarshallingType.LIST)
            .memberName("premises")
            .getter(getter(AutomatedReasoningCheckTranslation::premises))
            .setter(setter(Builder::premises))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("premises").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningLogicStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningLogicStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutomatedReasoningLogicStatement>> CLAIMS_FIELD = SdkField
            .<List<AutomatedReasoningLogicStatement>> builder(MarshallingType.LIST)
            .memberName("claims")
            .getter(getter(AutomatedReasoningCheckTranslation::claims))
            .setter(setter(Builder::claims))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claims").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningLogicStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningLogicStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutomatedReasoningCheckInputTextReference>> UNTRANSLATED_PREMISES_FIELD = SdkField
            .<List<AutomatedReasoningCheckInputTextReference>> builder(MarshallingType.LIST)
            .memberName("untranslatedPremises")
            .getter(getter(AutomatedReasoningCheckTranslation::untranslatedPremises))
            .setter(setter(Builder::untranslatedPremises))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("untranslatedPremises").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningCheckInputTextReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningCheckInputTextReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutomatedReasoningCheckInputTextReference>> UNTRANSLATED_CLAIMS_FIELD = SdkField
            .<List<AutomatedReasoningCheckInputTextReference>> builder(MarshallingType.LIST)
            .memberName("untranslatedClaims")
            .getter(getter(AutomatedReasoningCheckTranslation::untranslatedClaims))
            .setter(setter(Builder::untranslatedClaims))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("untranslatedClaims").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningCheckInputTextReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningCheckInputTextReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("confidence").getter(getter(AutomatedReasoningCheckTranslation::confidence))
            .setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREMISES_FIELD, CLAIMS_FIELD,
            UNTRANSLATED_PREMISES_FIELD, UNTRANSLATED_CLAIMS_FIELD, CONFIDENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AutomatedReasoningLogicStatement> premises;

    private final List<AutomatedReasoningLogicStatement> claims;

    private final List<AutomatedReasoningCheckInputTextReference> untranslatedPremises;

    private final List<AutomatedReasoningCheckInputTextReference> untranslatedClaims;

    private final Double confidence;

    private AutomatedReasoningCheckTranslation(BuilderImpl builder) {
        this.premises = builder.premises;
        this.claims = builder.claims;
        this.untranslatedPremises = builder.untranslatedPremises;
        this.untranslatedClaims = builder.untranslatedClaims;
        this.confidence = builder.confidence;
    }

    /**
     * For responses, this returns true if the service returned a value for the Premises property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPremises() {
        return premises != null && !(premises instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logical statements that serve as the foundation or assumptions for the claims.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPremises} method.
     * </p>
     * 
     * @return The logical statements that serve as the foundation or assumptions for the claims.
     */
    public final List<AutomatedReasoningLogicStatement> premises() {
        return premises;
    }

    /**
     * For responses, this returns true if the service returned a value for the Claims property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClaims() {
        return claims != null && !(claims instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logical statements that are being validated against the premises and policy rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClaims} method.
     * </p>
     * 
     * @return The logical statements that are being validated against the premises and policy rules.
     */
    public final List<AutomatedReasoningLogicStatement> claims() {
        return claims;
    }

    /**
     * For responses, this returns true if the service returned a value for the UntranslatedPremises property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUntranslatedPremises() {
        return untranslatedPremises != null && !(untranslatedPremises instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * References to portions of the original input text that correspond to the premises but could not be fully
     * translated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUntranslatedPremises} method.
     * </p>
     * 
     * @return References to portions of the original input text that correspond to the premises but could not be fully
     *         translated.
     */
    public final List<AutomatedReasoningCheckInputTextReference> untranslatedPremises() {
        return untranslatedPremises;
    }

    /**
     * For responses, this returns true if the service returned a value for the UntranslatedClaims property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUntranslatedClaims() {
        return untranslatedClaims != null && !(untranslatedClaims instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * References to portions of the original input text that correspond to the claims but could not be fully
     * translated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUntranslatedClaims} method.
     * </p>
     * 
     * @return References to portions of the original input text that correspond to the claims but could not be fully
     *         translated.
     */
    public final List<AutomatedReasoningCheckInputTextReference> untranslatedClaims() {
        return untranslatedClaims;
    }

    /**
     * <p>
     * A confidence score between 0 and 1 indicating how certain the system is about the logical translation.
     * </p>
     * 
     * @return A confidence score between 0 and 1 indicating how certain the system is about the logical translation.
     */
    public final Double confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPremises() ? premises() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClaims() ? claims() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUntranslatedPremises() ? untranslatedPremises() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUntranslatedClaims() ? untranslatedClaims() : null);
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckTranslation)) {
            return false;
        }
        AutomatedReasoningCheckTranslation other = (AutomatedReasoningCheckTranslation) obj;
        return hasPremises() == other.hasPremises() && Objects.equals(premises(), other.premises())
                && hasClaims() == other.hasClaims() && Objects.equals(claims(), other.claims())
                && hasUntranslatedPremises() == other.hasUntranslatedPremises()
                && Objects.equals(untranslatedPremises(), other.untranslatedPremises())
                && hasUntranslatedClaims() == other.hasUntranslatedClaims()
                && Objects.equals(untranslatedClaims(), other.untranslatedClaims())
                && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningCheckTranslation").add("Premises", hasPremises() ? premises() : null)
                .add("Claims", hasClaims() ? claims() : null)
                .add("UntranslatedPremises", hasUntranslatedPremises() ? untranslatedPremises() : null)
                .add("UntranslatedClaims", hasUntranslatedClaims() ? untranslatedClaims() : null).add("Confidence", confidence())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "premises":
            return Optional.ofNullable(clazz.cast(premises()));
        case "claims":
            return Optional.ofNullable(clazz.cast(claims()));
        case "untranslatedPremises":
            return Optional.ofNullable(clazz.cast(untranslatedPremises()));
        case "untranslatedClaims":
            return Optional.ofNullable(clazz.cast(untranslatedClaims()));
        case "confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("premises", PREMISES_FIELD);
        map.put("claims", CLAIMS_FIELD);
        map.put("untranslatedPremises", UNTRANSLATED_PREMISES_FIELD);
        map.put("untranslatedClaims", UNTRANSLATED_CLAIMS_FIELD);
        map.put("confidence", CONFIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckTranslation, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckTranslation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningCheckTranslation> {
        /**
         * <p>
         * The logical statements that serve as the foundation or assumptions for the claims.
         * </p>
         * 
         * @param premises
         *        The logical statements that serve as the foundation or assumptions for the claims.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder premises(Collection<AutomatedReasoningLogicStatement> premises);

        /**
         * <p>
         * The logical statements that serve as the foundation or assumptions for the claims.
         * </p>
         * 
         * @param premises
         *        The logical statements that serve as the foundation or assumptions for the claims.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder premises(AutomatedReasoningLogicStatement... premises);

        /**
         * <p>
         * The logical statements that serve as the foundation or assumptions for the claims.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder#build()} is
         * called immediately and its result is passed to {@link #premises(List<AutomatedReasoningLogicStatement>)}.
         * 
         * @param premises
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #premises(java.util.Collection<AutomatedReasoningLogicStatement>)
         */
        Builder premises(Consumer<AutomatedReasoningLogicStatement.Builder>... premises);

        /**
         * <p>
         * The logical statements that are being validated against the premises and policy rules.
         * </p>
         * 
         * @param claims
         *        The logical statements that are being validated against the premises and policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claims(Collection<AutomatedReasoningLogicStatement> claims);

        /**
         * <p>
         * The logical statements that are being validated against the premises and policy rules.
         * </p>
         * 
         * @param claims
         *        The logical statements that are being validated against the premises and policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claims(AutomatedReasoningLogicStatement... claims);

        /**
         * <p>
         * The logical statements that are being validated against the premises and policy rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder#build()} is
         * called immediately and its result is passed to {@link #claims(List<AutomatedReasoningLogicStatement>)}.
         * 
         * @param claims
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claims(java.util.Collection<AutomatedReasoningLogicStatement>)
         */
        Builder claims(Consumer<AutomatedReasoningLogicStatement.Builder>... claims);

        /**
         * <p>
         * References to portions of the original input text that correspond to the premises but could not be fully
         * translated.
         * </p>
         * 
         * @param untranslatedPremises
         *        References to portions of the original input text that correspond to the premises but could not be
         *        fully translated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder untranslatedPremises(Collection<AutomatedReasoningCheckInputTextReference> untranslatedPremises);

        /**
         * <p>
         * References to portions of the original input text that correspond to the premises but could not be fully
         * translated.
         * </p>
         * 
         * @param untranslatedPremises
         *        References to portions of the original input text that correspond to the premises but could not be
         *        fully translated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder untranslatedPremises(AutomatedReasoningCheckInputTextReference... untranslatedPremises);

        /**
         * <p>
         * References to portions of the original input text that correspond to the premises but could not be fully
         * translated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #untranslatedPremises(List<AutomatedReasoningCheckInputTextReference>)}.
         * 
         * @param untranslatedPremises
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #untranslatedPremises(java.util.Collection<AutomatedReasoningCheckInputTextReference>)
         */
        Builder untranslatedPremises(Consumer<AutomatedReasoningCheckInputTextReference.Builder>... untranslatedPremises);

        /**
         * <p>
         * References to portions of the original input text that correspond to the claims but could not be fully
         * translated.
         * </p>
         * 
         * @param untranslatedClaims
         *        References to portions of the original input text that correspond to the claims but could not be fully
         *        translated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder untranslatedClaims(Collection<AutomatedReasoningCheckInputTextReference> untranslatedClaims);

        /**
         * <p>
         * References to portions of the original input text that correspond to the claims but could not be fully
         * translated.
         * </p>
         * 
         * @param untranslatedClaims
         *        References to portions of the original input text that correspond to the claims but could not be fully
         *        translated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder untranslatedClaims(AutomatedReasoningCheckInputTextReference... untranslatedClaims);

        /**
         * <p>
         * References to portions of the original input text that correspond to the claims but could not be fully
         * translated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #untranslatedClaims(List<AutomatedReasoningCheckInputTextReference>)}.
         * 
         * @param untranslatedClaims
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #untranslatedClaims(java.util.Collection<AutomatedReasoningCheckInputTextReference>)
         */
        Builder untranslatedClaims(Consumer<AutomatedReasoningCheckInputTextReference.Builder>... untranslatedClaims);

        /**
         * <p>
         * A confidence score between 0 and 1 indicating how certain the system is about the logical translation.
         * </p>
         * 
         * @param confidence
         *        A confidence score between 0 and 1 indicating how certain the system is about the logical translation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Double confidence);
    }

    static final class BuilderImpl implements Builder {
        private List<AutomatedReasoningLogicStatement> premises = DefaultSdkAutoConstructList.getInstance();

        private List<AutomatedReasoningLogicStatement> claims = DefaultSdkAutoConstructList.getInstance();

        private List<AutomatedReasoningCheckInputTextReference> untranslatedPremises = DefaultSdkAutoConstructList.getInstance();

        private List<AutomatedReasoningCheckInputTextReference> untranslatedClaims = DefaultSdkAutoConstructList.getInstance();

        private Double confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckTranslation model) {
            premises(model.premises);
            claims(model.claims);
            untranslatedPremises(model.untranslatedPremises);
            untranslatedClaims(model.untranslatedClaims);
            confidence(model.confidence);
        }

        public final List<AutomatedReasoningLogicStatement.Builder> getPremises() {
            List<AutomatedReasoningLogicStatement.Builder> result = AutomatedReasoningLogicStatementListCopier
                    .copyToBuilder(this.premises);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPremises(Collection<AutomatedReasoningLogicStatement.BuilderImpl> premises) {
            this.premises = AutomatedReasoningLogicStatementListCopier.copyFromBuilder(premises);
        }

        @Override
        public final Builder premises(Collection<AutomatedReasoningLogicStatement> premises) {
            this.premises = AutomatedReasoningLogicStatementListCopier.copy(premises);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(AutomatedReasoningLogicStatement... premises) {
            premises(Arrays.asList(premises));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(Consumer<AutomatedReasoningLogicStatement.Builder>... premises) {
            premises(Stream.of(premises).map(c -> AutomatedReasoningLogicStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningLogicStatement.Builder> getClaims() {
            List<AutomatedReasoningLogicStatement.Builder> result = AutomatedReasoningLogicStatementListCopier
                    .copyToBuilder(this.claims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClaims(Collection<AutomatedReasoningLogicStatement.BuilderImpl> claims) {
            this.claims = AutomatedReasoningLogicStatementListCopier.copyFromBuilder(claims);
        }

        @Override
        public final Builder claims(Collection<AutomatedReasoningLogicStatement> claims) {
            this.claims = AutomatedReasoningLogicStatementListCopier.copy(claims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(AutomatedReasoningLogicStatement... claims) {
            claims(Arrays.asList(claims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(Consumer<AutomatedReasoningLogicStatement.Builder>... claims) {
            claims(Stream.of(claims).map(c -> AutomatedReasoningLogicStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningCheckInputTextReference.Builder> getUntranslatedPremises() {
            List<AutomatedReasoningCheckInputTextReference.Builder> result = AutomatedReasoningCheckInputTextReferenceListCopier
                    .copyToBuilder(this.untranslatedPremises);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUntranslatedPremises(
                Collection<AutomatedReasoningCheckInputTextReference.BuilderImpl> untranslatedPremises) {
            this.untranslatedPremises = AutomatedReasoningCheckInputTextReferenceListCopier.copyFromBuilder(untranslatedPremises);
        }

        @Override
        public final Builder untranslatedPremises(Collection<AutomatedReasoningCheckInputTextReference> untranslatedPremises) {
            this.untranslatedPremises = AutomatedReasoningCheckInputTextReferenceListCopier.copy(untranslatedPremises);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedPremises(AutomatedReasoningCheckInputTextReference... untranslatedPremises) {
            untranslatedPremises(Arrays.asList(untranslatedPremises));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedPremises(
                Consumer<AutomatedReasoningCheckInputTextReference.Builder>... untranslatedPremises) {
            untranslatedPremises(Stream.of(untranslatedPremises)
                    .map(c -> AutomatedReasoningCheckInputTextReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningCheckInputTextReference.Builder> getUntranslatedClaims() {
            List<AutomatedReasoningCheckInputTextReference.Builder> result = AutomatedReasoningCheckInputTextReferenceListCopier
                    .copyToBuilder(this.untranslatedClaims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUntranslatedClaims(
                Collection<AutomatedReasoningCheckInputTextReference.BuilderImpl> untranslatedClaims) {
            this.untranslatedClaims = AutomatedReasoningCheckInputTextReferenceListCopier.copyFromBuilder(untranslatedClaims);
        }

        @Override
        public final Builder untranslatedClaims(Collection<AutomatedReasoningCheckInputTextReference> untranslatedClaims) {
            this.untranslatedClaims = AutomatedReasoningCheckInputTextReferenceListCopier.copy(untranslatedClaims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedClaims(AutomatedReasoningCheckInputTextReference... untranslatedClaims) {
            untranslatedClaims(Arrays.asList(untranslatedClaims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedClaims(Consumer<AutomatedReasoningCheckInputTextReference.Builder>... untranslatedClaims) {
            untranslatedClaims(Stream.of(untranslatedClaims)
                    .map(c -> AutomatedReasoningCheckInputTextReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Double getConfidence() {
            return confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public AutomatedReasoningCheckTranslation build() {
            return new AutomatedReasoningCheckTranslation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
