/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mutation operation that adds a new custom type to the policy definition during the build process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyAddTypeMutation implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyAddTypeMutation.Builder, AutomatedReasoningPolicyAddTypeMutation> {
    private static final SdkField<AutomatedReasoningPolicyDefinitionType> TYPE_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinitionType> builder(MarshallingType.SDK_POJO).memberName("type")
            .getter(getter(AutomatedReasoningPolicyAddTypeMutation::type)).setter(setter(Builder::type))
            .constructor(AutomatedReasoningPolicyDefinitionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyDefinitionType type;

    private AutomatedReasoningPolicyAddTypeMutation(BuilderImpl builder) {
        this.type = builder.type;
    }

    /**
     * <p>
     * The type definition that specifies the name, description, and possible values for the new custom type being added
     * to the policy.
     * </p>
     * 
     * @return The type definition that specifies the name, description, and possible values for the new custom type
     *         being added to the policy.
     */
    public final AutomatedReasoningPolicyDefinitionType type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyAddTypeMutation)) {
            return false;
        }
        AutomatedReasoningPolicyAddTypeMutation other = (AutomatedReasoningPolicyAddTypeMutation) obj;
        return Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyAddTypeMutation").add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyAddTypeMutation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyAddTypeMutation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyAddTypeMutation> {
        /**
         * <p>
         * The type definition that specifies the name, description, and possible values for the new custom type being
         * added to the policy.
         * </p>
         * 
         * @param type
         *        The type definition that specifies the name, description, and possible values for the new custom type
         *        being added to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(AutomatedReasoningPolicyDefinitionType type);

        /**
         * <p>
         * The type definition that specifies the name, description, and possible values for the new custom type being
         * added to the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinitionType.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinitionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinitionType.Builder#build()} is called
         * immediately and its result is passed to {@link #type(AutomatedReasoningPolicyDefinitionType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinitionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(AutomatedReasoningPolicyDefinitionType)
         */
        default Builder type(Consumer<AutomatedReasoningPolicyDefinitionType.Builder> type) {
            return type(AutomatedReasoningPolicyDefinitionType.builder().applyMutation(type).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyDefinitionType type;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyAddTypeMutation model) {
            type(model.type);
        }

        public final AutomatedReasoningPolicyDefinitionType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(AutomatedReasoningPolicyDefinitionType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(AutomatedReasoningPolicyDefinitionType type) {
            this.type = type;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyAddTypeMutation build() {
            return new AutomatedReasoningPolicyAddTypeMutation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
