/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the various operations that can be performed on an Automated Reasoning policy, including adding, updating,
 * and deleting rules, variables, and types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyAnnotation implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyAnnotation.Builder, AutomatedReasoningPolicyAnnotation> {
    private static final SdkField<AutomatedReasoningPolicyAddTypeAnnotation> ADD_TYPE_FIELD = SdkField
            .<AutomatedReasoningPolicyAddTypeAnnotation> builder(MarshallingType.SDK_POJO).memberName("addType")
            .getter(getter(AutomatedReasoningPolicyAnnotation::addType)).setter(setter(Builder::addType))
            .constructor(AutomatedReasoningPolicyAddTypeAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addType").build()).build();

    private static final SdkField<AutomatedReasoningPolicyUpdateTypeAnnotation> UPDATE_TYPE_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateTypeAnnotation> builder(MarshallingType.SDK_POJO).memberName("updateType")
            .getter(getter(AutomatedReasoningPolicyAnnotation::updateType)).setter(setter(Builder::updateType))
            .constructor(AutomatedReasoningPolicyUpdateTypeAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDeleteTypeAnnotation> DELETE_TYPE_FIELD = SdkField
            .<AutomatedReasoningPolicyDeleteTypeAnnotation> builder(MarshallingType.SDK_POJO).memberName("deleteType")
            .getter(getter(AutomatedReasoningPolicyAnnotation::deleteType)).setter(setter(Builder::deleteType))
            .constructor(AutomatedReasoningPolicyDeleteTypeAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteType").build()).build();

    private static final SdkField<AutomatedReasoningPolicyAddVariableAnnotation> ADD_VARIABLE_FIELD = SdkField
            .<AutomatedReasoningPolicyAddVariableAnnotation> builder(MarshallingType.SDK_POJO).memberName("addVariable")
            .getter(getter(AutomatedReasoningPolicyAnnotation::addVariable)).setter(setter(Builder::addVariable))
            .constructor(AutomatedReasoningPolicyAddVariableAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addVariable").build()).build();

    private static final SdkField<AutomatedReasoningPolicyUpdateVariableAnnotation> UPDATE_VARIABLE_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateVariableAnnotation> builder(MarshallingType.SDK_POJO).memberName("updateVariable")
            .getter(getter(AutomatedReasoningPolicyAnnotation::updateVariable)).setter(setter(Builder::updateVariable))
            .constructor(AutomatedReasoningPolicyUpdateVariableAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateVariable").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDeleteVariableAnnotation> DELETE_VARIABLE_FIELD = SdkField
            .<AutomatedReasoningPolicyDeleteVariableAnnotation> builder(MarshallingType.SDK_POJO).memberName("deleteVariable")
            .getter(getter(AutomatedReasoningPolicyAnnotation::deleteVariable)).setter(setter(Builder::deleteVariable))
            .constructor(AutomatedReasoningPolicyDeleteVariableAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteVariable").build()).build();

    private static final SdkField<AutomatedReasoningPolicyAddRuleAnnotation> ADD_RULE_FIELD = SdkField
            .<AutomatedReasoningPolicyAddRuleAnnotation> builder(MarshallingType.SDK_POJO).memberName("addRule")
            .getter(getter(AutomatedReasoningPolicyAnnotation::addRule)).setter(setter(Builder::addRule))
            .constructor(AutomatedReasoningPolicyAddRuleAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addRule").build()).build();

    private static final SdkField<AutomatedReasoningPolicyUpdateRuleAnnotation> UPDATE_RULE_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateRuleAnnotation> builder(MarshallingType.SDK_POJO).memberName("updateRule")
            .getter(getter(AutomatedReasoningPolicyAnnotation::updateRule)).setter(setter(Builder::updateRule))
            .constructor(AutomatedReasoningPolicyUpdateRuleAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateRule").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDeleteRuleAnnotation> DELETE_RULE_FIELD = SdkField
            .<AutomatedReasoningPolicyDeleteRuleAnnotation> builder(MarshallingType.SDK_POJO).memberName("deleteRule")
            .getter(getter(AutomatedReasoningPolicyAnnotation::deleteRule)).setter(setter(Builder::deleteRule))
            .constructor(AutomatedReasoningPolicyDeleteRuleAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteRule").build()).build();

    private static final SdkField<AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation> ADD_RULE_FROM_NATURAL_LANGUAGE_FIELD = SdkField
            .<AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation> builder(MarshallingType.SDK_POJO)
            .memberName("addRuleFromNaturalLanguage")
            .getter(getter(AutomatedReasoningPolicyAnnotation::addRuleFromNaturalLanguage))
            .setter(setter(Builder::addRuleFromNaturalLanguage))
            .constructor(AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addRuleFromNaturalLanguage").build())
            .build();

    private static final SdkField<AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation> UPDATE_FROM_RULES_FEEDBACK_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation> builder(MarshallingType.SDK_POJO)
            .memberName("updateFromRulesFeedback").getter(getter(AutomatedReasoningPolicyAnnotation::updateFromRulesFeedback))
            .setter(setter(Builder::updateFromRulesFeedback))
            .constructor(AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateFromRulesFeedback").build())
            .build();

    private static final SdkField<AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation> UPDATE_FROM_SCENARIO_FEEDBACK_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation> builder(MarshallingType.SDK_POJO)
            .memberName("updateFromScenarioFeedback")
            .getter(getter(AutomatedReasoningPolicyAnnotation::updateFromScenarioFeedback))
            .setter(setter(Builder::updateFromScenarioFeedback))
            .constructor(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateFromScenarioFeedback").build())
            .build();

    private static final SdkField<AutomatedReasoningPolicyIngestContentAnnotation> INGEST_CONTENT_FIELD = SdkField
            .<AutomatedReasoningPolicyIngestContentAnnotation> builder(MarshallingType.SDK_POJO).memberName("ingestContent")
            .getter(getter(AutomatedReasoningPolicyAnnotation::ingestContent)).setter(setter(Builder::ingestContent))
            .constructor(AutomatedReasoningPolicyIngestContentAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_TYPE_FIELD,
            UPDATE_TYPE_FIELD, DELETE_TYPE_FIELD, ADD_VARIABLE_FIELD, UPDATE_VARIABLE_FIELD, DELETE_VARIABLE_FIELD,
            ADD_RULE_FIELD, UPDATE_RULE_FIELD, DELETE_RULE_FIELD, ADD_RULE_FROM_NATURAL_LANGUAGE_FIELD,
            UPDATE_FROM_RULES_FEEDBACK_FIELD, UPDATE_FROM_SCENARIO_FEEDBACK_FIELD, INGEST_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyAddTypeAnnotation addType;

    private final AutomatedReasoningPolicyUpdateTypeAnnotation updateType;

    private final AutomatedReasoningPolicyDeleteTypeAnnotation deleteType;

    private final AutomatedReasoningPolicyAddVariableAnnotation addVariable;

    private final AutomatedReasoningPolicyUpdateVariableAnnotation updateVariable;

    private final AutomatedReasoningPolicyDeleteVariableAnnotation deleteVariable;

    private final AutomatedReasoningPolicyAddRuleAnnotation addRule;

    private final AutomatedReasoningPolicyUpdateRuleAnnotation updateRule;

    private final AutomatedReasoningPolicyDeleteRuleAnnotation deleteRule;

    private final AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation addRuleFromNaturalLanguage;

    private final AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation updateFromRulesFeedback;

    private final AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation updateFromScenarioFeedback;

    private final AutomatedReasoningPolicyIngestContentAnnotation ingestContent;

    private final Type type;

    private AutomatedReasoningPolicyAnnotation(BuilderImpl builder) {
        this.addType = builder.addType;
        this.updateType = builder.updateType;
        this.deleteType = builder.deleteType;
        this.addVariable = builder.addVariable;
        this.updateVariable = builder.updateVariable;
        this.deleteVariable = builder.deleteVariable;
        this.addRule = builder.addRule;
        this.updateRule = builder.updateRule;
        this.deleteRule = builder.deleteRule;
        this.addRuleFromNaturalLanguage = builder.addRuleFromNaturalLanguage;
        this.updateFromRulesFeedback = builder.updateFromRulesFeedback;
        this.updateFromScenarioFeedback = builder.updateFromScenarioFeedback;
        this.ingestContent = builder.ingestContent;
        this.type = builder.type;
    }

    /**
     * <p>
     * An operation to add a new custom type to the policy, defining a set of possible values for policy variables.
     * </p>
     * 
     * @return An operation to add a new custom type to the policy, defining a set of possible values for policy
     *         variables.
     */
    public final AutomatedReasoningPolicyAddTypeAnnotation addType() {
        return addType;
    }

    /**
     * <p>
     * An operation to modify an existing custom type in the policy, such as changing its name, description, or allowed
     * values.
     * </p>
     * 
     * @return An operation to modify an existing custom type in the policy, such as changing its name, description, or
     *         allowed values.
     */
    public final AutomatedReasoningPolicyUpdateTypeAnnotation updateType() {
        return updateType;
    }

    /**
     * <p>
     * An operation to remove a custom type from the policy. The type must not be referenced by any variables or rules.
     * </p>
     * 
     * @return An operation to remove a custom type from the policy. The type must not be referenced by any variables or
     *         rules.
     */
    public final AutomatedReasoningPolicyDeleteTypeAnnotation deleteType() {
        return deleteType;
    }

    /**
     * <p>
     * An operation to add a new variable to the policy, which can be used in rule expressions to represent dynamic
     * values.
     * </p>
     * 
     * @return An operation to add a new variable to the policy, which can be used in rule expressions to represent
     *         dynamic values.
     */
    public final AutomatedReasoningPolicyAddVariableAnnotation addVariable() {
        return addVariable;
    }

    /**
     * <p>
     * An operation to modify an existing variable in the policy, such as changing its name, type, or description.
     * </p>
     * 
     * @return An operation to modify an existing variable in the policy, such as changing its name, type, or
     *         description.
     */
    public final AutomatedReasoningPolicyUpdateVariableAnnotation updateVariable() {
        return updateVariable;
    }

    /**
     * <p>
     * An operation to remove a variable from the policy. The variable must not be referenced by any rules.
     * </p>
     * 
     * @return An operation to remove a variable from the policy. The variable must not be referenced by any rules.
     */
    public final AutomatedReasoningPolicyDeleteVariableAnnotation deleteVariable() {
        return deleteVariable;
    }

    /**
     * <p>
     * An operation to add a new logical rule to the policy using formal mathematical expressions.
     * </p>
     * 
     * @return An operation to add a new logical rule to the policy using formal mathematical expressions.
     */
    public final AutomatedReasoningPolicyAddRuleAnnotation addRule() {
        return addRule;
    }

    /**
     * <p>
     * An operation to modify an existing rule in the policy, such as changing its logical expression or conditions.
     * </p>
     * 
     * @return An operation to modify an existing rule in the policy, such as changing its logical expression or
     *         conditions.
     */
    public final AutomatedReasoningPolicyUpdateRuleAnnotation updateRule() {
        return updateRule;
    }

    /**
     * <p>
     * An operation to remove a rule from the policy.
     * </p>
     * 
     * @return An operation to remove a rule from the policy.
     */
    public final AutomatedReasoningPolicyDeleteRuleAnnotation deleteRule() {
        return deleteRule;
    }

    /**
     * <p>
     * An operation to add a new rule by converting natural language descriptions into formal logical expressions.
     * </p>
     * 
     * @return An operation to add a new rule by converting natural language descriptions into formal logical
     *         expressions.
     */
    public final AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation addRuleFromNaturalLanguage() {
        return addRuleFromNaturalLanguage;
    }

    /**
     * <p>
     * An operation to update the policy based on feedback about how specific rules performed during testing or
     * validation.
     * </p>
     * 
     * @return An operation to update the policy based on feedback about how specific rules performed during testing or
     *         validation.
     */
    public final AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation updateFromRulesFeedback() {
        return updateFromRulesFeedback;
    }

    /**
     * <p>
     * An operation to update the policy based on feedback about how it performed on specific test scenarios.
     * </p>
     * 
     * @return An operation to update the policy based on feedback about how it performed on specific test scenarios.
     */
    public final AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation updateFromScenarioFeedback() {
        return updateFromScenarioFeedback;
    }

    /**
     * <p>
     * An operation to process and incorporate new content into the policy, extracting additional rules and concepts.
     * </p>
     * 
     * @return An operation to process and incorporate new content into the policy, extracting additional rules and
     *         concepts.
     */
    public final AutomatedReasoningPolicyIngestContentAnnotation ingestContent() {
        return ingestContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addType());
        hashCode = 31 * hashCode + Objects.hashCode(updateType());
        hashCode = 31 * hashCode + Objects.hashCode(deleteType());
        hashCode = 31 * hashCode + Objects.hashCode(addVariable());
        hashCode = 31 * hashCode + Objects.hashCode(updateVariable());
        hashCode = 31 * hashCode + Objects.hashCode(deleteVariable());
        hashCode = 31 * hashCode + Objects.hashCode(addRule());
        hashCode = 31 * hashCode + Objects.hashCode(updateRule());
        hashCode = 31 * hashCode + Objects.hashCode(deleteRule());
        hashCode = 31 * hashCode + Objects.hashCode(addRuleFromNaturalLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(updateFromRulesFeedback());
        hashCode = 31 * hashCode + Objects.hashCode(updateFromScenarioFeedback());
        hashCode = 31 * hashCode + Objects.hashCode(ingestContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyAnnotation)) {
            return false;
        }
        AutomatedReasoningPolicyAnnotation other = (AutomatedReasoningPolicyAnnotation) obj;
        return Objects.equals(addType(), other.addType()) && Objects.equals(updateType(), other.updateType())
                && Objects.equals(deleteType(), other.deleteType()) && Objects.equals(addVariable(), other.addVariable())
                && Objects.equals(updateVariable(), other.updateVariable())
                && Objects.equals(deleteVariable(), other.deleteVariable()) && Objects.equals(addRule(), other.addRule())
                && Objects.equals(updateRule(), other.updateRule()) && Objects.equals(deleteRule(), other.deleteRule())
                && Objects.equals(addRuleFromNaturalLanguage(), other.addRuleFromNaturalLanguage())
                && Objects.equals(updateFromRulesFeedback(), other.updateFromRulesFeedback())
                && Objects.equals(updateFromScenarioFeedback(), other.updateFromScenarioFeedback())
                && Objects.equals(ingestContent(), other.ingestContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyAnnotation").add("AddType", addType()).add("UpdateType", updateType())
                .add("DeleteType", deleteType()).add("AddVariable", addVariable()).add("UpdateVariable", updateVariable())
                .add("DeleteVariable", deleteVariable()).add("AddRule", addRule()).add("UpdateRule", updateRule())
                .add("DeleteRule", deleteRule()).add("AddRuleFromNaturalLanguage", addRuleFromNaturalLanguage())
                .add("UpdateFromRulesFeedback", updateFromRulesFeedback())
                .add("UpdateFromScenarioFeedback", updateFromScenarioFeedback()).add("IngestContent", ingestContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addType":
            return Optional.ofNullable(clazz.cast(addType()));
        case "updateType":
            return Optional.ofNullable(clazz.cast(updateType()));
        case "deleteType":
            return Optional.ofNullable(clazz.cast(deleteType()));
        case "addVariable":
            return Optional.ofNullable(clazz.cast(addVariable()));
        case "updateVariable":
            return Optional.ofNullable(clazz.cast(updateVariable()));
        case "deleteVariable":
            return Optional.ofNullable(clazz.cast(deleteVariable()));
        case "addRule":
            return Optional.ofNullable(clazz.cast(addRule()));
        case "updateRule":
            return Optional.ofNullable(clazz.cast(updateRule()));
        case "deleteRule":
            return Optional.ofNullable(clazz.cast(deleteRule()));
        case "addRuleFromNaturalLanguage":
            return Optional.ofNullable(clazz.cast(addRuleFromNaturalLanguage()));
        case "updateFromRulesFeedback":
            return Optional.ofNullable(clazz.cast(updateFromRulesFeedback()));
        case "updateFromScenarioFeedback":
            return Optional.ofNullable(clazz.cast(updateFromScenarioFeedback()));
        case "ingestContent":
            return Optional.ofNullable(clazz.cast(ingestContent()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #addType()} initialized to the given value.
     *
     * <p>
     * An operation to add a new custom type to the policy, defining a set of possible values for policy variables.
     * </p>
     * 
     * @param addType
     *        An operation to add a new custom type to the policy, defining a set of possible values for policy
     *        variables.
     */
    public static AutomatedReasoningPolicyAnnotation fromAddType(AutomatedReasoningPolicyAddTypeAnnotation addType) {
        return builder().addType(addType).build();
    }

    /**
     * Create an instance of this class with {@link #addType()} initialized to the given value.
     *
     * <p>
     * An operation to add a new custom type to the policy, defining a set of possible values for policy variables.
     * </p>
     * 
     * @param addType
     *        An operation to add a new custom type to the policy, defining a set of possible values for policy
     *        variables.
     */
    public static AutomatedReasoningPolicyAnnotation fromAddType(
            Consumer<AutomatedReasoningPolicyAddTypeAnnotation.Builder> addType) {
        AutomatedReasoningPolicyAddTypeAnnotation.Builder builder = AutomatedReasoningPolicyAddTypeAnnotation.builder();
        addType.accept(builder);
        return fromAddType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateType()} initialized to the given value.
     *
     * <p>
     * An operation to modify an existing custom type in the policy, such as changing its name, description, or allowed
     * values.
     * </p>
     * 
     * @param updateType
     *        An operation to modify an existing custom type in the policy, such as changing its name, description, or
     *        allowed values.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateType(AutomatedReasoningPolicyUpdateTypeAnnotation updateType) {
        return builder().updateType(updateType).build();
    }

    /**
     * Create an instance of this class with {@link #updateType()} initialized to the given value.
     *
     * <p>
     * An operation to modify an existing custom type in the policy, such as changing its name, description, or allowed
     * values.
     * </p>
     * 
     * @param updateType
     *        An operation to modify an existing custom type in the policy, such as changing its name, description, or
     *        allowed values.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateType(
            Consumer<AutomatedReasoningPolicyUpdateTypeAnnotation.Builder> updateType) {
        AutomatedReasoningPolicyUpdateTypeAnnotation.Builder builder = AutomatedReasoningPolicyUpdateTypeAnnotation.builder();
        updateType.accept(builder);
        return fromUpdateType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteType()} initialized to the given value.
     *
     * <p>
     * An operation to remove a custom type from the policy. The type must not be referenced by any variables or rules.
     * </p>
     * 
     * @param deleteType
     *        An operation to remove a custom type from the policy. The type must not be referenced by any variables or
     *        rules.
     */
    public static AutomatedReasoningPolicyAnnotation fromDeleteType(AutomatedReasoningPolicyDeleteTypeAnnotation deleteType) {
        return builder().deleteType(deleteType).build();
    }

    /**
     * Create an instance of this class with {@link #deleteType()} initialized to the given value.
     *
     * <p>
     * An operation to remove a custom type from the policy. The type must not be referenced by any variables or rules.
     * </p>
     * 
     * @param deleteType
     *        An operation to remove a custom type from the policy. The type must not be referenced by any variables or
     *        rules.
     */
    public static AutomatedReasoningPolicyAnnotation fromDeleteType(
            Consumer<AutomatedReasoningPolicyDeleteTypeAnnotation.Builder> deleteType) {
        AutomatedReasoningPolicyDeleteTypeAnnotation.Builder builder = AutomatedReasoningPolicyDeleteTypeAnnotation.builder();
        deleteType.accept(builder);
        return fromDeleteType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #addVariable()} initialized to the given value.
     *
     * <p>
     * An operation to add a new variable to the policy, which can be used in rule expressions to represent dynamic
     * values.
     * </p>
     * 
     * @param addVariable
     *        An operation to add a new variable to the policy, which can be used in rule expressions to represent
     *        dynamic values.
     */
    public static AutomatedReasoningPolicyAnnotation fromAddVariable(AutomatedReasoningPolicyAddVariableAnnotation addVariable) {
        return builder().addVariable(addVariable).build();
    }

    /**
     * Create an instance of this class with {@link #addVariable()} initialized to the given value.
     *
     * <p>
     * An operation to add a new variable to the policy, which can be used in rule expressions to represent dynamic
     * values.
     * </p>
     * 
     * @param addVariable
     *        An operation to add a new variable to the policy, which can be used in rule expressions to represent
     *        dynamic values.
     */
    public static AutomatedReasoningPolicyAnnotation fromAddVariable(
            Consumer<AutomatedReasoningPolicyAddVariableAnnotation.Builder> addVariable) {
        AutomatedReasoningPolicyAddVariableAnnotation.Builder builder = AutomatedReasoningPolicyAddVariableAnnotation.builder();
        addVariable.accept(builder);
        return fromAddVariable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateVariable()} initialized to the given value.
     *
     * <p>
     * An operation to modify an existing variable in the policy, such as changing its name, type, or description.
     * </p>
     * 
     * @param updateVariable
     *        An operation to modify an existing variable in the policy, such as changing its name, type, or
     *        description.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateVariable(
            AutomatedReasoningPolicyUpdateVariableAnnotation updateVariable) {
        return builder().updateVariable(updateVariable).build();
    }

    /**
     * Create an instance of this class with {@link #updateVariable()} initialized to the given value.
     *
     * <p>
     * An operation to modify an existing variable in the policy, such as changing its name, type, or description.
     * </p>
     * 
     * @param updateVariable
     *        An operation to modify an existing variable in the policy, such as changing its name, type, or
     *        description.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateVariable(
            Consumer<AutomatedReasoningPolicyUpdateVariableAnnotation.Builder> updateVariable) {
        AutomatedReasoningPolicyUpdateVariableAnnotation.Builder builder = AutomatedReasoningPolicyUpdateVariableAnnotation
                .builder();
        updateVariable.accept(builder);
        return fromUpdateVariable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteVariable()} initialized to the given value.
     *
     * <p>
     * An operation to remove a variable from the policy. The variable must not be referenced by any rules.
     * </p>
     * 
     * @param deleteVariable
     *        An operation to remove a variable from the policy. The variable must not be referenced by any rules.
     */
    public static AutomatedReasoningPolicyAnnotation fromDeleteVariable(
            AutomatedReasoningPolicyDeleteVariableAnnotation deleteVariable) {
        return builder().deleteVariable(deleteVariable).build();
    }

    /**
     * Create an instance of this class with {@link #deleteVariable()} initialized to the given value.
     *
     * <p>
     * An operation to remove a variable from the policy. The variable must not be referenced by any rules.
     * </p>
     * 
     * @param deleteVariable
     *        An operation to remove a variable from the policy. The variable must not be referenced by any rules.
     */
    public static AutomatedReasoningPolicyAnnotation fromDeleteVariable(
            Consumer<AutomatedReasoningPolicyDeleteVariableAnnotation.Builder> deleteVariable) {
        AutomatedReasoningPolicyDeleteVariableAnnotation.Builder builder = AutomatedReasoningPolicyDeleteVariableAnnotation
                .builder();
        deleteVariable.accept(builder);
        return fromDeleteVariable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #addRule()} initialized to the given value.
     *
     * <p>
     * An operation to add a new logical rule to the policy using formal mathematical expressions.
     * </p>
     * 
     * @param addRule
     *        An operation to add a new logical rule to the policy using formal mathematical expressions.
     */
    public static AutomatedReasoningPolicyAnnotation fromAddRule(AutomatedReasoningPolicyAddRuleAnnotation addRule) {
        return builder().addRule(addRule).build();
    }

    /**
     * Create an instance of this class with {@link #addRule()} initialized to the given value.
     *
     * <p>
     * An operation to add a new logical rule to the policy using formal mathematical expressions.
     * </p>
     * 
     * @param addRule
     *        An operation to add a new logical rule to the policy using formal mathematical expressions.
     */
    public static AutomatedReasoningPolicyAnnotation fromAddRule(
            Consumer<AutomatedReasoningPolicyAddRuleAnnotation.Builder> addRule) {
        AutomatedReasoningPolicyAddRuleAnnotation.Builder builder = AutomatedReasoningPolicyAddRuleAnnotation.builder();
        addRule.accept(builder);
        return fromAddRule(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateRule()} initialized to the given value.
     *
     * <p>
     * An operation to modify an existing rule in the policy, such as changing its logical expression or conditions.
     * </p>
     * 
     * @param updateRule
     *        An operation to modify an existing rule in the policy, such as changing its logical expression or
     *        conditions.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateRule(AutomatedReasoningPolicyUpdateRuleAnnotation updateRule) {
        return builder().updateRule(updateRule).build();
    }

    /**
     * Create an instance of this class with {@link #updateRule()} initialized to the given value.
     *
     * <p>
     * An operation to modify an existing rule in the policy, such as changing its logical expression or conditions.
     * </p>
     * 
     * @param updateRule
     *        An operation to modify an existing rule in the policy, such as changing its logical expression or
     *        conditions.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateRule(
            Consumer<AutomatedReasoningPolicyUpdateRuleAnnotation.Builder> updateRule) {
        AutomatedReasoningPolicyUpdateRuleAnnotation.Builder builder = AutomatedReasoningPolicyUpdateRuleAnnotation.builder();
        updateRule.accept(builder);
        return fromUpdateRule(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteRule()} initialized to the given value.
     *
     * <p>
     * An operation to remove a rule from the policy.
     * </p>
     * 
     * @param deleteRule
     *        An operation to remove a rule from the policy.
     */
    public static AutomatedReasoningPolicyAnnotation fromDeleteRule(AutomatedReasoningPolicyDeleteRuleAnnotation deleteRule) {
        return builder().deleteRule(deleteRule).build();
    }

    /**
     * Create an instance of this class with {@link #deleteRule()} initialized to the given value.
     *
     * <p>
     * An operation to remove a rule from the policy.
     * </p>
     * 
     * @param deleteRule
     *        An operation to remove a rule from the policy.
     */
    public static AutomatedReasoningPolicyAnnotation fromDeleteRule(
            Consumer<AutomatedReasoningPolicyDeleteRuleAnnotation.Builder> deleteRule) {
        AutomatedReasoningPolicyDeleteRuleAnnotation.Builder builder = AutomatedReasoningPolicyDeleteRuleAnnotation.builder();
        deleteRule.accept(builder);
        return fromDeleteRule(builder.build());
    }

    /**
     * Create an instance of this class with {@link #addRuleFromNaturalLanguage()} initialized to the given value.
     *
     * <p>
     * An operation to add a new rule by converting natural language descriptions into formal logical expressions.
     * </p>
     * 
     * @param addRuleFromNaturalLanguage
     *        An operation to add a new rule by converting natural language descriptions into formal logical
     *        expressions.
     */
    public static AutomatedReasoningPolicyAnnotation fromAddRuleFromNaturalLanguage(
            AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation addRuleFromNaturalLanguage) {
        return builder().addRuleFromNaturalLanguage(addRuleFromNaturalLanguage).build();
    }

    /**
     * Create an instance of this class with {@link #addRuleFromNaturalLanguage()} initialized to the given value.
     *
     * <p>
     * An operation to add a new rule by converting natural language descriptions into formal logical expressions.
     * </p>
     * 
     * @param addRuleFromNaturalLanguage
     *        An operation to add a new rule by converting natural language descriptions into formal logical
     *        expressions.
     */
    public static AutomatedReasoningPolicyAnnotation fromAddRuleFromNaturalLanguage(
            Consumer<AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.Builder> addRuleFromNaturalLanguage) {
        AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.Builder builder = AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation
                .builder();
        addRuleFromNaturalLanguage.accept(builder);
        return fromAddRuleFromNaturalLanguage(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateFromRulesFeedback()} initialized to the given value.
     *
     * <p>
     * An operation to update the policy based on feedback about how specific rules performed during testing or
     * validation.
     * </p>
     * 
     * @param updateFromRulesFeedback
     *        An operation to update the policy based on feedback about how specific rules performed during testing or
     *        validation.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateFromRulesFeedback(
            AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation updateFromRulesFeedback) {
        return builder().updateFromRulesFeedback(updateFromRulesFeedback).build();
    }

    /**
     * Create an instance of this class with {@link #updateFromRulesFeedback()} initialized to the given value.
     *
     * <p>
     * An operation to update the policy based on feedback about how specific rules performed during testing or
     * validation.
     * </p>
     * 
     * @param updateFromRulesFeedback
     *        An operation to update the policy based on feedback about how specific rules performed during testing or
     *        validation.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateFromRulesFeedback(
            Consumer<AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.Builder> updateFromRulesFeedback) {
        AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.Builder builder = AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation
                .builder();
        updateFromRulesFeedback.accept(builder);
        return fromUpdateFromRulesFeedback(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateFromScenarioFeedback()} initialized to the given value.
     *
     * <p>
     * An operation to update the policy based on feedback about how it performed on specific test scenarios.
     * </p>
     * 
     * @param updateFromScenarioFeedback
     *        An operation to update the policy based on feedback about how it performed on specific test scenarios.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateFromScenarioFeedback(
            AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation updateFromScenarioFeedback) {
        return builder().updateFromScenarioFeedback(updateFromScenarioFeedback).build();
    }

    /**
     * Create an instance of this class with {@link #updateFromScenarioFeedback()} initialized to the given value.
     *
     * <p>
     * An operation to update the policy based on feedback about how it performed on specific test scenarios.
     * </p>
     * 
     * @param updateFromScenarioFeedback
     *        An operation to update the policy based on feedback about how it performed on specific test scenarios.
     */
    public static AutomatedReasoningPolicyAnnotation fromUpdateFromScenarioFeedback(
            Consumer<AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.Builder> updateFromScenarioFeedback) {
        AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.Builder builder = AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation
                .builder();
        updateFromScenarioFeedback.accept(builder);
        return fromUpdateFromScenarioFeedback(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ingestContent()} initialized to the given value.
     *
     * <p>
     * An operation to process and incorporate new content into the policy, extracting additional rules and concepts.
     * </p>
     * 
     * @param ingestContent
     *        An operation to process and incorporate new content into the policy, extracting additional rules and
     *        concepts.
     */
    public static AutomatedReasoningPolicyAnnotation fromIngestContent(
            AutomatedReasoningPolicyIngestContentAnnotation ingestContent) {
        return builder().ingestContent(ingestContent).build();
    }

    /**
     * Create an instance of this class with {@link #ingestContent()} initialized to the given value.
     *
     * <p>
     * An operation to process and incorporate new content into the policy, extracting additional rules and concepts.
     * </p>
     * 
     * @param ingestContent
     *        An operation to process and incorporate new content into the policy, extracting additional rules and
     *        concepts.
     */
    public static AutomatedReasoningPolicyAnnotation fromIngestContent(
            Consumer<AutomatedReasoningPolicyIngestContentAnnotation.Builder> ingestContent) {
        AutomatedReasoningPolicyIngestContentAnnotation.Builder builder = AutomatedReasoningPolicyIngestContentAnnotation
                .builder();
        ingestContent.accept(builder);
        return fromIngestContent(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addType", ADD_TYPE_FIELD);
        map.put("updateType", UPDATE_TYPE_FIELD);
        map.put("deleteType", DELETE_TYPE_FIELD);
        map.put("addVariable", ADD_VARIABLE_FIELD);
        map.put("updateVariable", UPDATE_VARIABLE_FIELD);
        map.put("deleteVariable", DELETE_VARIABLE_FIELD);
        map.put("addRule", ADD_RULE_FIELD);
        map.put("updateRule", UPDATE_RULE_FIELD);
        map.put("deleteRule", DELETE_RULE_FIELD);
        map.put("addRuleFromNaturalLanguage", ADD_RULE_FROM_NATURAL_LANGUAGE_FIELD);
        map.put("updateFromRulesFeedback", UPDATE_FROM_RULES_FEEDBACK_FIELD);
        map.put("updateFromScenarioFeedback", UPDATE_FROM_SCENARIO_FEEDBACK_FIELD);
        map.put("ingestContent", INGEST_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyAnnotation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyAnnotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyAnnotation> {
        /**
         * <p>
         * An operation to add a new custom type to the policy, defining a set of possible values for policy variables.
         * </p>
         * 
         * @param addType
         *        An operation to add a new custom type to the policy, defining a set of possible values for policy
         *        variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addType(AutomatedReasoningPolicyAddTypeAnnotation addType);

        /**
         * <p>
         * An operation to add a new custom type to the policy, defining a set of possible values for policy variables.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAddTypeAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyAddTypeAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyAddTypeAnnotation.Builder#build()} is
         * called immediately and its result is passed to {@link #addType(AutomatedReasoningPolicyAddTypeAnnotation)}.
         * 
         * @param addType
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyAddTypeAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addType(AutomatedReasoningPolicyAddTypeAnnotation)
         */
        default Builder addType(Consumer<AutomatedReasoningPolicyAddTypeAnnotation.Builder> addType) {
            return addType(AutomatedReasoningPolicyAddTypeAnnotation.builder().applyMutation(addType).build());
        }

        /**
         * <p>
         * An operation to modify an existing custom type in the policy, such as changing its name, description, or
         * allowed values.
         * </p>
         * 
         * @param updateType
         *        An operation to modify an existing custom type in the policy, such as changing its name, description,
         *        or allowed values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateType(AutomatedReasoningPolicyUpdateTypeAnnotation updateType);

        /**
         * <p>
         * An operation to modify an existing custom type in the policy, such as changing its name, description, or
         * allowed values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateTypeAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyUpdateTypeAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyUpdateTypeAnnotation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #updateType(AutomatedReasoningPolicyUpdateTypeAnnotation)}.
         * 
         * @param updateType
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyUpdateTypeAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateType(AutomatedReasoningPolicyUpdateTypeAnnotation)
         */
        default Builder updateType(Consumer<AutomatedReasoningPolicyUpdateTypeAnnotation.Builder> updateType) {
            return updateType(AutomatedReasoningPolicyUpdateTypeAnnotation.builder().applyMutation(updateType).build());
        }

        /**
         * <p>
         * An operation to remove a custom type from the policy. The type must not be referenced by any variables or
         * rules.
         * </p>
         * 
         * @param deleteType
         *        An operation to remove a custom type from the policy. The type must not be referenced by any variables
         *        or rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteType(AutomatedReasoningPolicyDeleteTypeAnnotation deleteType);

        /**
         * <p>
         * An operation to remove a custom type from the policy. The type must not be referenced by any variables or
         * rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDeleteTypeAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDeleteTypeAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDeleteTypeAnnotation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deleteType(AutomatedReasoningPolicyDeleteTypeAnnotation)}.
         * 
         * @param deleteType
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDeleteTypeAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteType(AutomatedReasoningPolicyDeleteTypeAnnotation)
         */
        default Builder deleteType(Consumer<AutomatedReasoningPolicyDeleteTypeAnnotation.Builder> deleteType) {
            return deleteType(AutomatedReasoningPolicyDeleteTypeAnnotation.builder().applyMutation(deleteType).build());
        }

        /**
         * <p>
         * An operation to add a new variable to the policy, which can be used in rule expressions to represent dynamic
         * values.
         * </p>
         * 
         * @param addVariable
         *        An operation to add a new variable to the policy, which can be used in rule expressions to represent
         *        dynamic values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addVariable(AutomatedReasoningPolicyAddVariableAnnotation addVariable);

        /**
         * <p>
         * An operation to add a new variable to the policy, which can be used in rule expressions to represent dynamic
         * values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAddVariableAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyAddVariableAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyAddVariableAnnotation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #addVariable(AutomatedReasoningPolicyAddVariableAnnotation)}.
         * 
         * @param addVariable
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyAddVariableAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addVariable(AutomatedReasoningPolicyAddVariableAnnotation)
         */
        default Builder addVariable(Consumer<AutomatedReasoningPolicyAddVariableAnnotation.Builder> addVariable) {
            return addVariable(AutomatedReasoningPolicyAddVariableAnnotation.builder().applyMutation(addVariable).build());
        }

        /**
         * <p>
         * An operation to modify an existing variable in the policy, such as changing its name, type, or description.
         * </p>
         * 
         * @param updateVariable
         *        An operation to modify an existing variable in the policy, such as changing its name, type, or
         *        description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateVariable(AutomatedReasoningPolicyUpdateVariableAnnotation updateVariable);

        /**
         * <p>
         * An operation to modify an existing variable in the policy, such as changing its name, type, or description.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateVariableAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyUpdateVariableAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyUpdateVariableAnnotation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #updateVariable(AutomatedReasoningPolicyUpdateVariableAnnotation)}.
         * 
         * @param updateVariable
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyUpdateVariableAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateVariable(AutomatedReasoningPolicyUpdateVariableAnnotation)
         */
        default Builder updateVariable(Consumer<AutomatedReasoningPolicyUpdateVariableAnnotation.Builder> updateVariable) {
            return updateVariable(AutomatedReasoningPolicyUpdateVariableAnnotation.builder().applyMutation(updateVariable)
                    .build());
        }

        /**
         * <p>
         * An operation to remove a variable from the policy. The variable must not be referenced by any rules.
         * </p>
         * 
         * @param deleteVariable
         *        An operation to remove a variable from the policy. The variable must not be referenced by any rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteVariable(AutomatedReasoningPolicyDeleteVariableAnnotation deleteVariable);

        /**
         * <p>
         * An operation to remove a variable from the policy. The variable must not be referenced by any rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDeleteVariableAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDeleteVariableAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDeleteVariableAnnotation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #deleteVariable(AutomatedReasoningPolicyDeleteVariableAnnotation)}.
         * 
         * @param deleteVariable
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDeleteVariableAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteVariable(AutomatedReasoningPolicyDeleteVariableAnnotation)
         */
        default Builder deleteVariable(Consumer<AutomatedReasoningPolicyDeleteVariableAnnotation.Builder> deleteVariable) {
            return deleteVariable(AutomatedReasoningPolicyDeleteVariableAnnotation.builder().applyMutation(deleteVariable)
                    .build());
        }

        /**
         * <p>
         * An operation to add a new logical rule to the policy using formal mathematical expressions.
         * </p>
         * 
         * @param addRule
         *        An operation to add a new logical rule to the policy using formal mathematical expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRule(AutomatedReasoningPolicyAddRuleAnnotation addRule);

        /**
         * <p>
         * An operation to add a new logical rule to the policy using formal mathematical expressions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAddRuleAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyAddRuleAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyAddRuleAnnotation.Builder#build()} is
         * called immediately and its result is passed to {@link #addRule(AutomatedReasoningPolicyAddRuleAnnotation)}.
         * 
         * @param addRule
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyAddRuleAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addRule(AutomatedReasoningPolicyAddRuleAnnotation)
         */
        default Builder addRule(Consumer<AutomatedReasoningPolicyAddRuleAnnotation.Builder> addRule) {
            return addRule(AutomatedReasoningPolicyAddRuleAnnotation.builder().applyMutation(addRule).build());
        }

        /**
         * <p>
         * An operation to modify an existing rule in the policy, such as changing its logical expression or conditions.
         * </p>
         * 
         * @param updateRule
         *        An operation to modify an existing rule in the policy, such as changing its logical expression or
         *        conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateRule(AutomatedReasoningPolicyUpdateRuleAnnotation updateRule);

        /**
         * <p>
         * An operation to modify an existing rule in the policy, such as changing its logical expression or conditions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateRuleAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyUpdateRuleAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyUpdateRuleAnnotation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #updateRule(AutomatedReasoningPolicyUpdateRuleAnnotation)}.
         * 
         * @param updateRule
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyUpdateRuleAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateRule(AutomatedReasoningPolicyUpdateRuleAnnotation)
         */
        default Builder updateRule(Consumer<AutomatedReasoningPolicyUpdateRuleAnnotation.Builder> updateRule) {
            return updateRule(AutomatedReasoningPolicyUpdateRuleAnnotation.builder().applyMutation(updateRule).build());
        }

        /**
         * <p>
         * An operation to remove a rule from the policy.
         * </p>
         * 
         * @param deleteRule
         *        An operation to remove a rule from the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteRule(AutomatedReasoningPolicyDeleteRuleAnnotation deleteRule);

        /**
         * <p>
         * An operation to remove a rule from the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDeleteRuleAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDeleteRuleAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDeleteRuleAnnotation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deleteRule(AutomatedReasoningPolicyDeleteRuleAnnotation)}.
         * 
         * @param deleteRule
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDeleteRuleAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteRule(AutomatedReasoningPolicyDeleteRuleAnnotation)
         */
        default Builder deleteRule(Consumer<AutomatedReasoningPolicyDeleteRuleAnnotation.Builder> deleteRule) {
            return deleteRule(AutomatedReasoningPolicyDeleteRuleAnnotation.builder().applyMutation(deleteRule).build());
        }

        /**
         * <p>
         * An operation to add a new rule by converting natural language descriptions into formal logical expressions.
         * </p>
         * 
         * @param addRuleFromNaturalLanguage
         *        An operation to add a new rule by converting natural language descriptions into formal logical
         *        expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRuleFromNaturalLanguage(AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation addRuleFromNaturalLanguage);

        /**
         * <p>
         * An operation to add a new rule by converting natural language descriptions into formal logical expressions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.Builder} avoiding the need to create one
         * manually via {@link AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #addRuleFromNaturalLanguage(AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation)}.
         * 
         * @param addRuleFromNaturalLanguage
         *        a consumer that will call methods on
         *        {@link AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addRuleFromNaturalLanguage(AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation)
         */
        default Builder addRuleFromNaturalLanguage(
                Consumer<AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.Builder> addRuleFromNaturalLanguage) {
            return addRuleFromNaturalLanguage(AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.builder()
                    .applyMutation(addRuleFromNaturalLanguage).build());
        }

        /**
         * <p>
         * An operation to update the policy based on feedback about how specific rules performed during testing or
         * validation.
         * </p>
         * 
         * @param updateFromRulesFeedback
         *        An operation to update the policy based on feedback about how specific rules performed during testing
         *        or validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateFromRulesFeedback(AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation updateFromRulesFeedback);

        /**
         * <p>
         * An operation to update the policy based on feedback about how specific rules performed during testing or
         * validation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.Builder} avoiding the need to create one
         * manually via {@link AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #updateFromRulesFeedback(AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation)}.
         * 
         * @param updateFromRulesFeedback
         *        a consumer that will call methods on
         *        {@link AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateFromRulesFeedback(AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation)
         */
        default Builder updateFromRulesFeedback(
                Consumer<AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.Builder> updateFromRulesFeedback) {
            return updateFromRulesFeedback(AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.builder()
                    .applyMutation(updateFromRulesFeedback).build());
        }

        /**
         * <p>
         * An operation to update the policy based on feedback about how it performed on specific test scenarios.
         * </p>
         * 
         * @param updateFromScenarioFeedback
         *        An operation to update the policy based on feedback about how it performed on specific test scenarios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateFromScenarioFeedback(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation updateFromScenarioFeedback);

        /**
         * <p>
         * An operation to update the policy based on feedback about how it performed on specific test scenarios.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.Builder} avoiding the need to create one
         * manually via {@link AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #updateFromScenarioFeedback(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation)}.
         * 
         * @param updateFromScenarioFeedback
         *        a consumer that will call methods on
         *        {@link AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateFromScenarioFeedback(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation)
         */
        default Builder updateFromScenarioFeedback(
                Consumer<AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.Builder> updateFromScenarioFeedback) {
            return updateFromScenarioFeedback(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.builder()
                    .applyMutation(updateFromScenarioFeedback).build());
        }

        /**
         * <p>
         * An operation to process and incorporate new content into the policy, extracting additional rules and
         * concepts.
         * </p>
         * 
         * @param ingestContent
         *        An operation to process and incorporate new content into the policy, extracting additional rules and
         *        concepts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestContent(AutomatedReasoningPolicyIngestContentAnnotation ingestContent);

        /**
         * <p>
         * An operation to process and incorporate new content into the policy, extracting additional rules and
         * concepts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyIngestContentAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyIngestContentAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyIngestContentAnnotation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #ingestContent(AutomatedReasoningPolicyIngestContentAnnotation)}.
         * 
         * @param ingestContent
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyIngestContentAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestContent(AutomatedReasoningPolicyIngestContentAnnotation)
         */
        default Builder ingestContent(Consumer<AutomatedReasoningPolicyIngestContentAnnotation.Builder> ingestContent) {
            return ingestContent(AutomatedReasoningPolicyIngestContentAnnotation.builder().applyMutation(ingestContent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyAddTypeAnnotation addType;

        private AutomatedReasoningPolicyUpdateTypeAnnotation updateType;

        private AutomatedReasoningPolicyDeleteTypeAnnotation deleteType;

        private AutomatedReasoningPolicyAddVariableAnnotation addVariable;

        private AutomatedReasoningPolicyUpdateVariableAnnotation updateVariable;

        private AutomatedReasoningPolicyDeleteVariableAnnotation deleteVariable;

        private AutomatedReasoningPolicyAddRuleAnnotation addRule;

        private AutomatedReasoningPolicyUpdateRuleAnnotation updateRule;

        private AutomatedReasoningPolicyDeleteRuleAnnotation deleteRule;

        private AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation addRuleFromNaturalLanguage;

        private AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation updateFromRulesFeedback;

        private AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation updateFromScenarioFeedback;

        private AutomatedReasoningPolicyIngestContentAnnotation ingestContent;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyAnnotation model) {
            addType(model.addType);
            updateType(model.updateType);
            deleteType(model.deleteType);
            addVariable(model.addVariable);
            updateVariable(model.updateVariable);
            deleteVariable(model.deleteVariable);
            addRule(model.addRule);
            updateRule(model.updateRule);
            deleteRule(model.deleteRule);
            addRuleFromNaturalLanguage(model.addRuleFromNaturalLanguage);
            updateFromRulesFeedback(model.updateFromRulesFeedback);
            updateFromScenarioFeedback(model.updateFromScenarioFeedback);
            ingestContent(model.ingestContent);
        }

        public final AutomatedReasoningPolicyAddTypeAnnotation.Builder getAddType() {
            return addType != null ? addType.toBuilder() : null;
        }

        public final void setAddType(AutomatedReasoningPolicyAddTypeAnnotation.BuilderImpl addType) {
            Object oldValue = this.addType;
            this.addType = addType != null ? addType.build() : null;
            handleUnionValueChange(Type.ADD_TYPE, oldValue, this.addType);
        }

        @Override
        public final Builder addType(AutomatedReasoningPolicyAddTypeAnnotation addType) {
            Object oldValue = this.addType;
            this.addType = addType;
            handleUnionValueChange(Type.ADD_TYPE, oldValue, this.addType);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateTypeAnnotation.Builder getUpdateType() {
            return updateType != null ? updateType.toBuilder() : null;
        }

        public final void setUpdateType(AutomatedReasoningPolicyUpdateTypeAnnotation.BuilderImpl updateType) {
            Object oldValue = this.updateType;
            this.updateType = updateType != null ? updateType.build() : null;
            handleUnionValueChange(Type.UPDATE_TYPE, oldValue, this.updateType);
        }

        @Override
        public final Builder updateType(AutomatedReasoningPolicyUpdateTypeAnnotation updateType) {
            Object oldValue = this.updateType;
            this.updateType = updateType;
            handleUnionValueChange(Type.UPDATE_TYPE, oldValue, this.updateType);
            return this;
        }

        public final AutomatedReasoningPolicyDeleteTypeAnnotation.Builder getDeleteType() {
            return deleteType != null ? deleteType.toBuilder() : null;
        }

        public final void setDeleteType(AutomatedReasoningPolicyDeleteTypeAnnotation.BuilderImpl deleteType) {
            Object oldValue = this.deleteType;
            this.deleteType = deleteType != null ? deleteType.build() : null;
            handleUnionValueChange(Type.DELETE_TYPE, oldValue, this.deleteType);
        }

        @Override
        public final Builder deleteType(AutomatedReasoningPolicyDeleteTypeAnnotation deleteType) {
            Object oldValue = this.deleteType;
            this.deleteType = deleteType;
            handleUnionValueChange(Type.DELETE_TYPE, oldValue, this.deleteType);
            return this;
        }

        public final AutomatedReasoningPolicyAddVariableAnnotation.Builder getAddVariable() {
            return addVariable != null ? addVariable.toBuilder() : null;
        }

        public final void setAddVariable(AutomatedReasoningPolicyAddVariableAnnotation.BuilderImpl addVariable) {
            Object oldValue = this.addVariable;
            this.addVariable = addVariable != null ? addVariable.build() : null;
            handleUnionValueChange(Type.ADD_VARIABLE, oldValue, this.addVariable);
        }

        @Override
        public final Builder addVariable(AutomatedReasoningPolicyAddVariableAnnotation addVariable) {
            Object oldValue = this.addVariable;
            this.addVariable = addVariable;
            handleUnionValueChange(Type.ADD_VARIABLE, oldValue, this.addVariable);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateVariableAnnotation.Builder getUpdateVariable() {
            return updateVariable != null ? updateVariable.toBuilder() : null;
        }

        public final void setUpdateVariable(AutomatedReasoningPolicyUpdateVariableAnnotation.BuilderImpl updateVariable) {
            Object oldValue = this.updateVariable;
            this.updateVariable = updateVariable != null ? updateVariable.build() : null;
            handleUnionValueChange(Type.UPDATE_VARIABLE, oldValue, this.updateVariable);
        }

        @Override
        public final Builder updateVariable(AutomatedReasoningPolicyUpdateVariableAnnotation updateVariable) {
            Object oldValue = this.updateVariable;
            this.updateVariable = updateVariable;
            handleUnionValueChange(Type.UPDATE_VARIABLE, oldValue, this.updateVariable);
            return this;
        }

        public final AutomatedReasoningPolicyDeleteVariableAnnotation.Builder getDeleteVariable() {
            return deleteVariable != null ? deleteVariable.toBuilder() : null;
        }

        public final void setDeleteVariable(AutomatedReasoningPolicyDeleteVariableAnnotation.BuilderImpl deleteVariable) {
            Object oldValue = this.deleteVariable;
            this.deleteVariable = deleteVariable != null ? deleteVariable.build() : null;
            handleUnionValueChange(Type.DELETE_VARIABLE, oldValue, this.deleteVariable);
        }

        @Override
        public final Builder deleteVariable(AutomatedReasoningPolicyDeleteVariableAnnotation deleteVariable) {
            Object oldValue = this.deleteVariable;
            this.deleteVariable = deleteVariable;
            handleUnionValueChange(Type.DELETE_VARIABLE, oldValue, this.deleteVariable);
            return this;
        }

        public final AutomatedReasoningPolicyAddRuleAnnotation.Builder getAddRule() {
            return addRule != null ? addRule.toBuilder() : null;
        }

        public final void setAddRule(AutomatedReasoningPolicyAddRuleAnnotation.BuilderImpl addRule) {
            Object oldValue = this.addRule;
            this.addRule = addRule != null ? addRule.build() : null;
            handleUnionValueChange(Type.ADD_RULE, oldValue, this.addRule);
        }

        @Override
        public final Builder addRule(AutomatedReasoningPolicyAddRuleAnnotation addRule) {
            Object oldValue = this.addRule;
            this.addRule = addRule;
            handleUnionValueChange(Type.ADD_RULE, oldValue, this.addRule);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateRuleAnnotation.Builder getUpdateRule() {
            return updateRule != null ? updateRule.toBuilder() : null;
        }

        public final void setUpdateRule(AutomatedReasoningPolicyUpdateRuleAnnotation.BuilderImpl updateRule) {
            Object oldValue = this.updateRule;
            this.updateRule = updateRule != null ? updateRule.build() : null;
            handleUnionValueChange(Type.UPDATE_RULE, oldValue, this.updateRule);
        }

        @Override
        public final Builder updateRule(AutomatedReasoningPolicyUpdateRuleAnnotation updateRule) {
            Object oldValue = this.updateRule;
            this.updateRule = updateRule;
            handleUnionValueChange(Type.UPDATE_RULE, oldValue, this.updateRule);
            return this;
        }

        public final AutomatedReasoningPolicyDeleteRuleAnnotation.Builder getDeleteRule() {
            return deleteRule != null ? deleteRule.toBuilder() : null;
        }

        public final void setDeleteRule(AutomatedReasoningPolicyDeleteRuleAnnotation.BuilderImpl deleteRule) {
            Object oldValue = this.deleteRule;
            this.deleteRule = deleteRule != null ? deleteRule.build() : null;
            handleUnionValueChange(Type.DELETE_RULE, oldValue, this.deleteRule);
        }

        @Override
        public final Builder deleteRule(AutomatedReasoningPolicyDeleteRuleAnnotation deleteRule) {
            Object oldValue = this.deleteRule;
            this.deleteRule = deleteRule;
            handleUnionValueChange(Type.DELETE_RULE, oldValue, this.deleteRule);
            return this;
        }

        public final AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.Builder getAddRuleFromNaturalLanguage() {
            return addRuleFromNaturalLanguage != null ? addRuleFromNaturalLanguage.toBuilder() : null;
        }

        public final void setAddRuleFromNaturalLanguage(
                AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation.BuilderImpl addRuleFromNaturalLanguage) {
            Object oldValue = this.addRuleFromNaturalLanguage;
            this.addRuleFromNaturalLanguage = addRuleFromNaturalLanguage != null ? addRuleFromNaturalLanguage.build() : null;
            handleUnionValueChange(Type.ADD_RULE_FROM_NATURAL_LANGUAGE, oldValue, this.addRuleFromNaturalLanguage);
        }

        @Override
        public final Builder addRuleFromNaturalLanguage(
                AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation addRuleFromNaturalLanguage) {
            Object oldValue = this.addRuleFromNaturalLanguage;
            this.addRuleFromNaturalLanguage = addRuleFromNaturalLanguage;
            handleUnionValueChange(Type.ADD_RULE_FROM_NATURAL_LANGUAGE, oldValue, this.addRuleFromNaturalLanguage);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.Builder getUpdateFromRulesFeedback() {
            return updateFromRulesFeedback != null ? updateFromRulesFeedback.toBuilder() : null;
        }

        public final void setUpdateFromRulesFeedback(
                AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.BuilderImpl updateFromRulesFeedback) {
            Object oldValue = this.updateFromRulesFeedback;
            this.updateFromRulesFeedback = updateFromRulesFeedback != null ? updateFromRulesFeedback.build() : null;
            handleUnionValueChange(Type.UPDATE_FROM_RULES_FEEDBACK, oldValue, this.updateFromRulesFeedback);
        }

        @Override
        public final Builder updateFromRulesFeedback(
                AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation updateFromRulesFeedback) {
            Object oldValue = this.updateFromRulesFeedback;
            this.updateFromRulesFeedback = updateFromRulesFeedback;
            handleUnionValueChange(Type.UPDATE_FROM_RULES_FEEDBACK, oldValue, this.updateFromRulesFeedback);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.Builder getUpdateFromScenarioFeedback() {
            return updateFromScenarioFeedback != null ? updateFromScenarioFeedback.toBuilder() : null;
        }

        public final void setUpdateFromScenarioFeedback(
                AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.BuilderImpl updateFromScenarioFeedback) {
            Object oldValue = this.updateFromScenarioFeedback;
            this.updateFromScenarioFeedback = updateFromScenarioFeedback != null ? updateFromScenarioFeedback.build() : null;
            handleUnionValueChange(Type.UPDATE_FROM_SCENARIO_FEEDBACK, oldValue, this.updateFromScenarioFeedback);
        }

        @Override
        public final Builder updateFromScenarioFeedback(
                AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation updateFromScenarioFeedback) {
            Object oldValue = this.updateFromScenarioFeedback;
            this.updateFromScenarioFeedback = updateFromScenarioFeedback;
            handleUnionValueChange(Type.UPDATE_FROM_SCENARIO_FEEDBACK, oldValue, this.updateFromScenarioFeedback);
            return this;
        }

        public final AutomatedReasoningPolicyIngestContentAnnotation.Builder getIngestContent() {
            return ingestContent != null ? ingestContent.toBuilder() : null;
        }

        public final void setIngestContent(AutomatedReasoningPolicyIngestContentAnnotation.BuilderImpl ingestContent) {
            Object oldValue = this.ingestContent;
            this.ingestContent = ingestContent != null ? ingestContent.build() : null;
            handleUnionValueChange(Type.INGEST_CONTENT, oldValue, this.ingestContent);
        }

        @Override
        public final Builder ingestContent(AutomatedReasoningPolicyIngestContentAnnotation ingestContent) {
            Object oldValue = this.ingestContent;
            this.ingestContent = ingestContent;
            handleUnionValueChange(Type.INGEST_CONTENT, oldValue, this.ingestContent);
            return this;
        }

        @Override
        public AutomatedReasoningPolicyAnnotation build() {
            return new AutomatedReasoningPolicyAnnotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedReasoningPolicyAnnotation#type()
     */
    public enum Type {
        ADD_TYPE,

        UPDATE_TYPE,

        DELETE_TYPE,

        ADD_VARIABLE,

        UPDATE_VARIABLE,

        DELETE_VARIABLE,

        ADD_RULE,

        UPDATE_RULE,

        DELETE_RULE,

        ADD_RULE_FROM_NATURAL_LANGUAGE,

        UPDATE_FROM_RULES_FEEDBACK,

        UPDATE_FROM_SCENARIO_FEEDBACK,

        INGEST_CONTENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
