/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single entry in the policy build log, containing information about a specific step or event in the build
 * process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyBuildLogEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyBuildLogEntry.Builder, AutomatedReasoningPolicyBuildLogEntry> {
    private static final SdkField<AutomatedReasoningPolicyAnnotation> ANNOTATION_FIELD = SdkField
            .<AutomatedReasoningPolicyAnnotation> builder(MarshallingType.SDK_POJO).memberName("annotation")
            .getter(getter(AutomatedReasoningPolicyBuildLogEntry::annotation)).setter(setter(Builder::annotation))
            .constructor(AutomatedReasoningPolicyAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotation").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AutomatedReasoningPolicyBuildLogEntry::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyBuildStep>> BUILD_STEPS_FIELD = SdkField
            .<List<AutomatedReasoningPolicyBuildStep>> builder(MarshallingType.LIST)
            .memberName("buildSteps")
            .getter(getter(AutomatedReasoningPolicyBuildLogEntry::buildSteps))
            .setter(setter(Builder::buildSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyBuildStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyBuildStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_FIELD,
            STATUS_FIELD, BUILD_STEPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyAnnotation annotation;

    private final String status;

    private final List<AutomatedReasoningPolicyBuildStep> buildSteps;

    private AutomatedReasoningPolicyBuildLogEntry(BuilderImpl builder) {
        this.annotation = builder.annotation;
        this.status = builder.status;
        this.buildSteps = builder.buildSteps;
    }

    /**
     * <p>
     * The annotation or operation that was being processed when this log entry was created.
     * </p>
     * 
     * @return The annotation or operation that was being processed when this log entry was created.
     */
    public final AutomatedReasoningPolicyAnnotation annotation() {
        return annotation;
    }

    /**
     * <p>
     * The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedReasoningPolicyAnnotationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
     * @see AutomatedReasoningPolicyAnnotationStatus
     */
    public final AutomatedReasoningPolicyAnnotationStatus status() {
        return AutomatedReasoningPolicyAnnotationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedReasoningPolicyAnnotationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
     * @see AutomatedReasoningPolicyAnnotationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the BuildSteps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBuildSteps() {
        return buildSteps != null && !(buildSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Detailed information about the specific build steps that were executed, including any sub-operations or
     * transformations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuildSteps} method.
     * </p>
     * 
     * @return Detailed information about the specific build steps that were executed, including any sub-operations or
     *         transformations.
     */
    public final List<AutomatedReasoningPolicyBuildStep> buildSteps() {
        return buildSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(annotation());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBuildSteps() ? buildSteps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildLogEntry)) {
            return false;
        }
        AutomatedReasoningPolicyBuildLogEntry other = (AutomatedReasoningPolicyBuildLogEntry) obj;
        return Objects.equals(annotation(), other.annotation()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasBuildSteps() == other.hasBuildSteps() && Objects.equals(buildSteps(), other.buildSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyBuildLogEntry").add("Annotation", annotation())
                .add("Status", statusAsString()).add("BuildSteps", hasBuildSteps() ? buildSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "annotation":
            return Optional.ofNullable(clazz.cast(annotation()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "buildSteps":
            return Optional.ofNullable(clazz.cast(buildSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("annotation", ANNOTATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("buildSteps", BUILD_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildLogEntry, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildLogEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyBuildLogEntry> {
        /**
         * <p>
         * The annotation or operation that was being processed when this log entry was created.
         * </p>
         * 
         * @param annotation
         *        The annotation or operation that was being processed when this log entry was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotation(AutomatedReasoningPolicyAnnotation annotation);

        /**
         * <p>
         * The annotation or operation that was being processed when this log entry was created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAnnotation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyAnnotation.Builder#build()} is called
         * immediately and its result is passed to {@link #annotation(AutomatedReasoningPolicyAnnotation)}.
         * 
         * @param annotation
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotation(AutomatedReasoningPolicyAnnotation)
         */
        default Builder annotation(Consumer<AutomatedReasoningPolicyAnnotation.Builder> annotation) {
            return annotation(AutomatedReasoningPolicyAnnotation.builder().applyMutation(annotation).build());
        }

        /**
         * <p>
         * The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
         * </p>
         * 
         * @param status
         *        The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
         * @see AutomatedReasoningPolicyAnnotationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyAnnotationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
         * </p>
         * 
         * @param status
         *        The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
         * @see AutomatedReasoningPolicyAnnotationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyAnnotationStatus
         */
        Builder status(AutomatedReasoningPolicyAnnotationStatus status);

        /**
         * <p>
         * Detailed information about the specific build steps that were executed, including any sub-operations or
         * transformations.
         * </p>
         * 
         * @param buildSteps
         *        Detailed information about the specific build steps that were executed, including any sub-operations
         *        or transformations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSteps(Collection<AutomatedReasoningPolicyBuildStep> buildSteps);

        /**
         * <p>
         * Detailed information about the specific build steps that were executed, including any sub-operations or
         * transformations.
         * </p>
         * 
         * @param buildSteps
         *        Detailed information about the specific build steps that were executed, including any sub-operations
         *        or transformations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSteps(AutomatedReasoningPolicyBuildStep... buildSteps);

        /**
         * <p>
         * Detailed information about the specific build steps that were executed, including any sub-operations or
         * transformations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStep.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStep.Builder#build()} is
         * called immediately and its result is passed to {@link #buildSteps(List<AutomatedReasoningPolicyBuildStep>)}.
         * 
         * @param buildSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildSteps(java.util.Collection<AutomatedReasoningPolicyBuildStep>)
         */
        Builder buildSteps(Consumer<AutomatedReasoningPolicyBuildStep.Builder>... buildSteps);
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyAnnotation annotation;

        private String status;

        private List<AutomatedReasoningPolicyBuildStep> buildSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildLogEntry model) {
            annotation(model.annotation);
            status(model.status);
            buildSteps(model.buildSteps);
        }

        public final AutomatedReasoningPolicyAnnotation.Builder getAnnotation() {
            return annotation != null ? annotation.toBuilder() : null;
        }

        public final void setAnnotation(AutomatedReasoningPolicyAnnotation.BuilderImpl annotation) {
            this.annotation = annotation != null ? annotation.build() : null;
        }

        @Override
        public final Builder annotation(AutomatedReasoningPolicyAnnotation annotation) {
            this.annotation = annotation;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomatedReasoningPolicyAnnotationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<AutomatedReasoningPolicyBuildStep.Builder> getBuildSteps() {
            List<AutomatedReasoningPolicyBuildStep.Builder> result = AutomatedReasoningPolicyBuildStepListCopier
                    .copyToBuilder(this.buildSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuildSteps(Collection<AutomatedReasoningPolicyBuildStep.BuilderImpl> buildSteps) {
            this.buildSteps = AutomatedReasoningPolicyBuildStepListCopier.copyFromBuilder(buildSteps);
        }

        @Override
        public final Builder buildSteps(Collection<AutomatedReasoningPolicyBuildStep> buildSteps) {
            this.buildSteps = AutomatedReasoningPolicyBuildStepListCopier.copy(buildSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildSteps(AutomatedReasoningPolicyBuildStep... buildSteps) {
            buildSteps(Arrays.asList(buildSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildSteps(Consumer<AutomatedReasoningPolicyBuildStep.Builder>... buildSteps) {
            buildSteps(Stream.of(buildSteps).map(c -> AutomatedReasoningPolicyBuildStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyBuildLogEntry build() {
            return new AutomatedReasoningPolicyBuildLogEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
