/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the source content for a policy build workflow, which can include documents, repair instructions, or other
 * input materials.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyBuildWorkflowSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyBuildWorkflowSource.Builder, AutomatedReasoningPolicyBuildWorkflowSource> {
    private static final SdkField<AutomatedReasoningPolicyDefinition> POLICY_DEFINITION_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinition> builder(MarshallingType.SDK_POJO).memberName("policyDefinition")
            .getter(getter(AutomatedReasoningPolicyBuildWorkflowSource::policyDefinition))
            .setter(setter(Builder::policyDefinition)).constructor(AutomatedReasoningPolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinition").build()).build();

    private static final SdkField<AutomatedReasoningPolicyWorkflowTypeContent> WORKFLOW_CONTENT_FIELD = SdkField
            .<AutomatedReasoningPolicyWorkflowTypeContent> builder(MarshallingType.SDK_POJO).memberName("workflowContent")
            .getter(getter(AutomatedReasoningPolicyBuildWorkflowSource::workflowContent))
            .setter(setter(Builder::workflowContent)).constructor(AutomatedReasoningPolicyWorkflowTypeContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DEFINITION_FIELD,
            WORKFLOW_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyDefinition policyDefinition;

    private final AutomatedReasoningPolicyWorkflowTypeContent workflowContent;

    private AutomatedReasoningPolicyBuildWorkflowSource(BuilderImpl builder) {
        this.policyDefinition = builder.policyDefinition;
        this.workflowContent = builder.workflowContent;
    }

    /**
     * <p>
     * An existing policy definition that serves as the starting point for the build workflow, typically used in policy
     * repair or update scenarios.
     * </p>
     * 
     * @return An existing policy definition that serves as the starting point for the build workflow, typically used in
     *         policy repair or update scenarios.
     */
    public final AutomatedReasoningPolicyDefinition policyDefinition() {
        return policyDefinition;
    }

    /**
     * <p>
     * The actual content to be processed in the build workflow, such as documents to analyze or repair instructions to
     * apply.
     * </p>
     * 
     * @return The actual content to be processed in the build workflow, such as documents to analyze or repair
     *         instructions to apply.
     */
    public final AutomatedReasoningPolicyWorkflowTypeContent workflowContent() {
        return workflowContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(workflowContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildWorkflowSource)) {
            return false;
        }
        AutomatedReasoningPolicyBuildWorkflowSource other = (AutomatedReasoningPolicyBuildWorkflowSource) obj;
        return Objects.equals(policyDefinition(), other.policyDefinition())
                && Objects.equals(workflowContent(), other.workflowContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyBuildWorkflowSource").add("PolicyDefinition", policyDefinition())
                .add("WorkflowContent", workflowContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyDefinition":
            return Optional.ofNullable(clazz.cast(policyDefinition()));
        case "workflowContent":
            return Optional.ofNullable(clazz.cast(workflowContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyDefinition", POLICY_DEFINITION_FIELD);
        map.put("workflowContent", WORKFLOW_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildWorkflowSource, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildWorkflowSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyBuildWorkflowSource> {
        /**
         * <p>
         * An existing policy definition that serves as the starting point for the build workflow, typically used in
         * policy repair or update scenarios.
         * </p>
         * 
         * @param policyDefinition
         *        An existing policy definition that serves as the starting point for the build workflow, typically used
         *        in policy repair or update scenarios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition);

        /**
         * <p>
         * An existing policy definition that serves as the starting point for the build workflow, typically used in
         * policy repair or update scenarios.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinition.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDefinition(AutomatedReasoningPolicyDefinition)}.
         * 
         * @param policyDefinition
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDefinition(AutomatedReasoningPolicyDefinition)
         */
        default Builder policyDefinition(Consumer<AutomatedReasoningPolicyDefinition.Builder> policyDefinition) {
            return policyDefinition(AutomatedReasoningPolicyDefinition.builder().applyMutation(policyDefinition).build());
        }

        /**
         * <p>
         * The actual content to be processed in the build workflow, such as documents to analyze or repair instructions
         * to apply.
         * </p>
         * 
         * @param workflowContent
         *        The actual content to be processed in the build workflow, such as documents to analyze or repair
         *        instructions to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowContent(AutomatedReasoningPolicyWorkflowTypeContent workflowContent);

        /**
         * <p>
         * The actual content to be processed in the build workflow, such as documents to analyze or repair instructions
         * to apply.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyWorkflowTypeContent.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyWorkflowTypeContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyWorkflowTypeContent.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #workflowContent(AutomatedReasoningPolicyWorkflowTypeContent)}.
         * 
         * @param workflowContent
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyWorkflowTypeContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowContent(AutomatedReasoningPolicyWorkflowTypeContent)
         */
        default Builder workflowContent(Consumer<AutomatedReasoningPolicyWorkflowTypeContent.Builder> workflowContent) {
            return workflowContent(AutomatedReasoningPolicyWorkflowTypeContent.builder().applyMutation(workflowContent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyDefinition policyDefinition;

        private AutomatedReasoningPolicyWorkflowTypeContent workflowContent;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildWorkflowSource model) {
            policyDefinition(model.policyDefinition);
            workflowContent(model.workflowContent);
        }

        public final AutomatedReasoningPolicyDefinition.Builder getPolicyDefinition() {
            return policyDefinition != null ? policyDefinition.toBuilder() : null;
        }

        public final void setPolicyDefinition(AutomatedReasoningPolicyDefinition.BuilderImpl policyDefinition) {
            this.policyDefinition = policyDefinition != null ? policyDefinition.build() : null;
        }

        @Override
        public final Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition) {
            this.policyDefinition = policyDefinition;
            return this;
        }

        public final AutomatedReasoningPolicyWorkflowTypeContent.Builder getWorkflowContent() {
            return workflowContent != null ? workflowContent.toBuilder() : null;
        }

        public final void setWorkflowContent(AutomatedReasoningPolicyWorkflowTypeContent.BuilderImpl workflowContent) {
            this.workflowContent = workflowContent != null ? workflowContent.build() : null;
        }

        @Override
        public final Builder workflowContent(AutomatedReasoningPolicyWorkflowTypeContent workflowContent) {
            this.workflowContent = workflowContent;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyBuildWorkflowSource build() {
            return new AutomatedReasoningPolicyBuildWorkflowSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
