/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a comprehensive analysis of the quality and completeness of an Automated Reasoning policy definition,
 * highlighting potential issues and optimization opportunities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyDefinitionQualityReport
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyDefinitionQualityReport.Builder, AutomatedReasoningPolicyDefinitionQualityReport> {
    private static final SdkField<Integer> TYPE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("typeCount").getter(getter(AutomatedReasoningPolicyDefinitionQualityReport::typeCount))
            .setter(setter(Builder::typeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeCount").build()).build();

    private static final SdkField<Integer> VARIABLE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("variableCount").getter(getter(AutomatedReasoningPolicyDefinitionQualityReport::variableCount))
            .setter(setter(Builder::variableCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableCount").build()).build();

    private static final SdkField<Integer> RULE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ruleCount").getter(getter(AutomatedReasoningPolicyDefinitionQualityReport::ruleCount))
            .setter(setter(Builder::ruleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleCount").build()).build();

    private static final SdkField<List<String>> UNUSED_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("unusedTypes")
            .getter(getter(AutomatedReasoningPolicyDefinitionQualityReport::unusedTypes))
            .setter(setter(Builder::unusedTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyDefinitionTypeValuePair>> UNUSED_TYPE_VALUES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyDefinitionTypeValuePair>> builder(MarshallingType.LIST)
            .memberName("unusedTypeValues")
            .getter(getter(AutomatedReasoningPolicyDefinitionQualityReport::unusedTypeValues))
            .setter(setter(Builder::unusedTypeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedTypeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyDefinitionTypeValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyDefinitionTypeValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> UNUSED_VARIABLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("unusedVariables")
            .getter(getter(AutomatedReasoningPolicyDefinitionQualityReport::unusedVariables))
            .setter(setter(Builder::unusedVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedVariables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONFLICTING_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("conflictingRules")
            .getter(getter(AutomatedReasoningPolicyDefinitionQualityReport::conflictingRules))
            .setter(setter(Builder::conflictingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyDisjointRuleSet>> DISJOINT_RULE_SETS_FIELD = SdkField
            .<List<AutomatedReasoningPolicyDisjointRuleSet>> builder(MarshallingType.LIST)
            .memberName("disjointRuleSets")
            .getter(getter(AutomatedReasoningPolicyDefinitionQualityReport::disjointRuleSets))
            .setter(setter(Builder::disjointRuleSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disjointRuleSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyDisjointRuleSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyDisjointRuleSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_COUNT_FIELD,
            VARIABLE_COUNT_FIELD, RULE_COUNT_FIELD, UNUSED_TYPES_FIELD, UNUSED_TYPE_VALUES_FIELD, UNUSED_VARIABLES_FIELD,
            CONFLICTING_RULES_FIELD, DISJOINT_RULE_SETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer typeCount;

    private final Integer variableCount;

    private final Integer ruleCount;

    private final List<String> unusedTypes;

    private final List<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues;

    private final List<String> unusedVariables;

    private final List<String> conflictingRules;

    private final List<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets;

    private AutomatedReasoningPolicyDefinitionQualityReport(BuilderImpl builder) {
        this.typeCount = builder.typeCount;
        this.variableCount = builder.variableCount;
        this.ruleCount = builder.ruleCount;
        this.unusedTypes = builder.unusedTypes;
        this.unusedTypeValues = builder.unusedTypeValues;
        this.unusedVariables = builder.unusedVariables;
        this.conflictingRules = builder.conflictingRules;
        this.disjointRuleSets = builder.disjointRuleSets;
    }

    /**
     * <p>
     * The total number of custom types defined in the policy.
     * </p>
     * 
     * @return The total number of custom types defined in the policy.
     */
    public final Integer typeCount() {
        return typeCount;
    }

    /**
     * <p>
     * The total number of variables defined in the policy.
     * </p>
     * 
     * @return The total number of variables defined in the policy.
     */
    public final Integer variableCount() {
        return variableCount;
    }

    /**
     * <p>
     * The total number of rules defined in the policy.
     * </p>
     * 
     * @return The total number of rules defined in the policy.
     */
    public final Integer ruleCount() {
        return ruleCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnusedTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnusedTypes() {
        return unusedTypes != null && !(unusedTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom types that are defined but not referenced by any variables or rules, suggesting they may be
     * unnecessary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnusedTypes} method.
     * </p>
     * 
     * @return A list of custom types that are defined but not referenced by any variables or rules, suggesting they may
     *         be unnecessary.
     */
    public final List<String> unusedTypes() {
        return unusedTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnusedTypeValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnusedTypeValues() {
        return unusedTypeValues != null && !(unusedTypeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of type values that are defined but never used in any rules, indicating potential cleanup opportunities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnusedTypeValues} method.
     * </p>
     * 
     * @return A list of type values that are defined but never used in any rules, indicating potential cleanup
     *         opportunities.
     */
    public final List<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues() {
        return unusedTypeValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnusedVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnusedVariables() {
        return unusedVariables != null && !(unusedVariables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of variables that are defined but not referenced by any rules, suggesting they may be unnecessary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnusedVariables} method.
     * </p>
     * 
     * @return A list of variables that are defined but not referenced by any rules, suggesting they may be unnecessary.
     */
    public final List<String> unusedVariables() {
        return unusedVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConflictingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConflictingRules() {
        return conflictingRules != null && !(conflictingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of rules that may conflict with each other, potentially leading to inconsistent policy behavior.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConflictingRules} method.
     * </p>
     * 
     * @return A list of rules that may conflict with each other, potentially leading to inconsistent policy behavior.
     */
    public final List<String> conflictingRules() {
        return conflictingRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisjointRuleSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisjointRuleSets() {
        return disjointRuleSets != null && !(disjointRuleSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Groups of rules that operate on completely separate sets of variables, indicating the policy may be addressing
     * multiple unrelated concerns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisjointRuleSets} method.
     * </p>
     * 
     * @return Groups of rules that operate on completely separate sets of variables, indicating the policy may be
     *         addressing multiple unrelated concerns.
     */
    public final List<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets() {
        return disjointRuleSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeCount());
        hashCode = 31 * hashCode + Objects.hashCode(variableCount());
        hashCode = 31 * hashCode + Objects.hashCode(ruleCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnusedTypes() ? unusedTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnusedTypeValues() ? unusedTypeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnusedVariables() ? unusedVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConflictingRules() ? conflictingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDisjointRuleSets() ? disjointRuleSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDefinitionQualityReport)) {
            return false;
        }
        AutomatedReasoningPolicyDefinitionQualityReport other = (AutomatedReasoningPolicyDefinitionQualityReport) obj;
        return Objects.equals(typeCount(), other.typeCount()) && Objects.equals(variableCount(), other.variableCount())
                && Objects.equals(ruleCount(), other.ruleCount()) && hasUnusedTypes() == other.hasUnusedTypes()
                && Objects.equals(unusedTypes(), other.unusedTypes()) && hasUnusedTypeValues() == other.hasUnusedTypeValues()
                && Objects.equals(unusedTypeValues(), other.unusedTypeValues())
                && hasUnusedVariables() == other.hasUnusedVariables()
                && Objects.equals(unusedVariables(), other.unusedVariables())
                && hasConflictingRules() == other.hasConflictingRules()
                && Objects.equals(conflictingRules(), other.conflictingRules())
                && hasDisjointRuleSets() == other.hasDisjointRuleSets()
                && Objects.equals(disjointRuleSets(), other.disjointRuleSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyDefinitionQualityReport").add("TypeCount", typeCount())
                .add("VariableCount", variableCount()).add("RuleCount", ruleCount())
                .add("UnusedTypes", unusedTypes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UnusedTypeValues", hasUnusedTypeValues() ? unusedTypeValues() : null)
                .add("UnusedVariables", unusedVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConflictingRules", hasConflictingRules() ? conflictingRules() : null)
                .add("DisjointRuleSets", hasDisjointRuleSets() ? disjointRuleSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "typeCount":
            return Optional.ofNullable(clazz.cast(typeCount()));
        case "variableCount":
            return Optional.ofNullable(clazz.cast(variableCount()));
        case "ruleCount":
            return Optional.ofNullable(clazz.cast(ruleCount()));
        case "unusedTypes":
            return Optional.ofNullable(clazz.cast(unusedTypes()));
        case "unusedTypeValues":
            return Optional.ofNullable(clazz.cast(unusedTypeValues()));
        case "unusedVariables":
            return Optional.ofNullable(clazz.cast(unusedVariables()));
        case "conflictingRules":
            return Optional.ofNullable(clazz.cast(conflictingRules()));
        case "disjointRuleSets":
            return Optional.ofNullable(clazz.cast(disjointRuleSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("typeCount", TYPE_COUNT_FIELD);
        map.put("variableCount", VARIABLE_COUNT_FIELD);
        map.put("ruleCount", RULE_COUNT_FIELD);
        map.put("unusedTypes", UNUSED_TYPES_FIELD);
        map.put("unusedTypeValues", UNUSED_TYPE_VALUES_FIELD);
        map.put("unusedVariables", UNUSED_VARIABLES_FIELD);
        map.put("conflictingRules", CONFLICTING_RULES_FIELD);
        map.put("disjointRuleSets", DISJOINT_RULE_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDefinitionQualityReport, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDefinitionQualityReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyDefinitionQualityReport> {
        /**
         * <p>
         * The total number of custom types defined in the policy.
         * </p>
         * 
         * @param typeCount
         *        The total number of custom types defined in the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeCount(Integer typeCount);

        /**
         * <p>
         * The total number of variables defined in the policy.
         * </p>
         * 
         * @param variableCount
         *        The total number of variables defined in the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableCount(Integer variableCount);

        /**
         * <p>
         * The total number of rules defined in the policy.
         * </p>
         * 
         * @param ruleCount
         *        The total number of rules defined in the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleCount(Integer ruleCount);

        /**
         * <p>
         * A list of custom types that are defined but not referenced by any variables or rules, suggesting they may be
         * unnecessary.
         * </p>
         * 
         * @param unusedTypes
         *        A list of custom types that are defined but not referenced by any variables or rules, suggesting they
         *        may be unnecessary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedTypes(Collection<String> unusedTypes);

        /**
         * <p>
         * A list of custom types that are defined but not referenced by any variables or rules, suggesting they may be
         * unnecessary.
         * </p>
         * 
         * @param unusedTypes
         *        A list of custom types that are defined but not referenced by any variables or rules, suggesting they
         *        may be unnecessary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedTypes(String... unusedTypes);

        /**
         * <p>
         * A list of type values that are defined but never used in any rules, indicating potential cleanup
         * opportunities.
         * </p>
         * 
         * @param unusedTypeValues
         *        A list of type values that are defined but never used in any rules, indicating potential cleanup
         *        opportunities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedTypeValues(Collection<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues);

        /**
         * <p>
         * A list of type values that are defined but never used in any rules, indicating potential cleanup
         * opportunities.
         * </p>
         * 
         * @param unusedTypeValues
         *        A list of type values that are defined but never used in any rules, indicating potential cleanup
         *        opportunities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedTypeValues(AutomatedReasoningPolicyDefinitionTypeValuePair... unusedTypeValues);

        /**
         * <p>
         * A list of type values that are defined but never used in any rules, indicating potential cleanup
         * opportunities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValuePair.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValuePair#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValuePair.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #unusedTypeValues(List<AutomatedReasoningPolicyDefinitionTypeValuePair>)}.
         * 
         * @param unusedTypeValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedTypeValues(java.util.Collection<AutomatedReasoningPolicyDefinitionTypeValuePair>)
         */
        Builder unusedTypeValues(Consumer<AutomatedReasoningPolicyDefinitionTypeValuePair.Builder>... unusedTypeValues);

        /**
         * <p>
         * A list of variables that are defined but not referenced by any rules, suggesting they may be unnecessary.
         * </p>
         * 
         * @param unusedVariables
         *        A list of variables that are defined but not referenced by any rules, suggesting they may be
         *        unnecessary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedVariables(Collection<String> unusedVariables);

        /**
         * <p>
         * A list of variables that are defined but not referenced by any rules, suggesting they may be unnecessary.
         * </p>
         * 
         * @param unusedVariables
         *        A list of variables that are defined but not referenced by any rules, suggesting they may be
         *        unnecessary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedVariables(String... unusedVariables);

        /**
         * <p>
         * A list of rules that may conflict with each other, potentially leading to inconsistent policy behavior.
         * </p>
         * 
         * @param conflictingRules
         *        A list of rules that may conflict with each other, potentially leading to inconsistent policy
         *        behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictingRules(Collection<String> conflictingRules);

        /**
         * <p>
         * A list of rules that may conflict with each other, potentially leading to inconsistent policy behavior.
         * </p>
         * 
         * @param conflictingRules
         *        A list of rules that may conflict with each other, potentially leading to inconsistent policy
         *        behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictingRules(String... conflictingRules);

        /**
         * <p>
         * Groups of rules that operate on completely separate sets of variables, indicating the policy may be
         * addressing multiple unrelated concerns.
         * </p>
         * 
         * @param disjointRuleSets
         *        Groups of rules that operate on completely separate sets of variables, indicating the policy may be
         *        addressing multiple unrelated concerns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disjointRuleSets(Collection<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets);

        /**
         * <p>
         * Groups of rules that operate on completely separate sets of variables, indicating the policy may be
         * addressing multiple unrelated concerns.
         * </p>
         * 
         * @param disjointRuleSets
         *        Groups of rules that operate on completely separate sets of variables, indicating the policy may be
         *        addressing multiple unrelated concerns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disjointRuleSets(AutomatedReasoningPolicyDisjointRuleSet... disjointRuleSets);

        /**
         * <p>
         * Groups of rules that operate on completely separate sets of variables, indicating the policy may be
         * addressing multiple unrelated concerns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDisjointRuleSet.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDisjointRuleSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDisjointRuleSet.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #disjointRuleSets(List<AutomatedReasoningPolicyDisjointRuleSet>)}.
         * 
         * @param disjointRuleSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDisjointRuleSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disjointRuleSets(java.util.Collection<AutomatedReasoningPolicyDisjointRuleSet>)
         */
        Builder disjointRuleSets(Consumer<AutomatedReasoningPolicyDisjointRuleSet.Builder>... disjointRuleSets);
    }

    static final class BuilderImpl implements Builder {
        private Integer typeCount;

        private Integer variableCount;

        private Integer ruleCount;

        private List<String> unusedTypes = DefaultSdkAutoConstructList.getInstance();

        private List<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues = DefaultSdkAutoConstructList
                .getInstance();

        private List<String> unusedVariables = DefaultSdkAutoConstructList.getInstance();

        private List<String> conflictingRules = DefaultSdkAutoConstructList.getInstance();

        private List<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDefinitionQualityReport model) {
            typeCount(model.typeCount);
            variableCount(model.variableCount);
            ruleCount(model.ruleCount);
            unusedTypes(model.unusedTypes);
            unusedTypeValues(model.unusedTypeValues);
            unusedVariables(model.unusedVariables);
            conflictingRules(model.conflictingRules);
            disjointRuleSets(model.disjointRuleSets);
        }

        public final Integer getTypeCount() {
            return typeCount;
        }

        public final void setTypeCount(Integer typeCount) {
            this.typeCount = typeCount;
        }

        @Override
        public final Builder typeCount(Integer typeCount) {
            this.typeCount = typeCount;
            return this;
        }

        public final Integer getVariableCount() {
            return variableCount;
        }

        public final void setVariableCount(Integer variableCount) {
            this.variableCount = variableCount;
        }

        @Override
        public final Builder variableCount(Integer variableCount) {
            this.variableCount = variableCount;
            return this;
        }

        public final Integer getRuleCount() {
            return ruleCount;
        }

        public final void setRuleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
        }

        @Override
        public final Builder ruleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
            return this;
        }

        public final Collection<String> getUnusedTypes() {
            if (unusedTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return unusedTypes;
        }

        public final void setUnusedTypes(Collection<String> unusedTypes) {
            this.unusedTypes = AutomatedReasoningPolicyDefinitionTypeNameListCopier.copy(unusedTypes);
        }

        @Override
        public final Builder unusedTypes(Collection<String> unusedTypes) {
            this.unusedTypes = AutomatedReasoningPolicyDefinitionTypeNameListCopier.copy(unusedTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedTypes(String... unusedTypes) {
            unusedTypes(Arrays.asList(unusedTypes));
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionTypeValuePair.Builder> getUnusedTypeValues() {
            List<AutomatedReasoningPolicyDefinitionTypeValuePair.Builder> result = AutomatedReasoningPolicyDefinitionTypeValuePairListCopier
                    .copyToBuilder(this.unusedTypeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnusedTypeValues(
                Collection<AutomatedReasoningPolicyDefinitionTypeValuePair.BuilderImpl> unusedTypeValues) {
            this.unusedTypeValues = AutomatedReasoningPolicyDefinitionTypeValuePairListCopier.copyFromBuilder(unusedTypeValues);
        }

        @Override
        public final Builder unusedTypeValues(Collection<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues) {
            this.unusedTypeValues = AutomatedReasoningPolicyDefinitionTypeValuePairListCopier.copy(unusedTypeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedTypeValues(AutomatedReasoningPolicyDefinitionTypeValuePair... unusedTypeValues) {
            unusedTypeValues(Arrays.asList(unusedTypeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedTypeValues(
                Consumer<AutomatedReasoningPolicyDefinitionTypeValuePair.Builder>... unusedTypeValues) {
            unusedTypeValues(Stream.of(unusedTypeValues)
                    .map(c -> AutomatedReasoningPolicyDefinitionTypeValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUnusedVariables() {
            if (unusedVariables instanceof SdkAutoConstructList) {
                return null;
            }
            return unusedVariables;
        }

        public final void setUnusedVariables(Collection<String> unusedVariables) {
            this.unusedVariables = AutomatedReasoningPolicyDefinitionVariableNameListCopier.copy(unusedVariables);
        }

        @Override
        public final Builder unusedVariables(Collection<String> unusedVariables) {
            this.unusedVariables = AutomatedReasoningPolicyDefinitionVariableNameListCopier.copy(unusedVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedVariables(String... unusedVariables) {
            unusedVariables(Arrays.asList(unusedVariables));
            return this;
        }

        public final Collection<String> getConflictingRules() {
            if (conflictingRules instanceof SdkAutoConstructList) {
                return null;
            }
            return conflictingRules;
        }

        public final void setConflictingRules(Collection<String> conflictingRules) {
            this.conflictingRules = AutomatedReasoningPolicyConflictedRuleIdListCopier.copy(conflictingRules);
        }

        @Override
        public final Builder conflictingRules(Collection<String> conflictingRules) {
            this.conflictingRules = AutomatedReasoningPolicyConflictedRuleIdListCopier.copy(conflictingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictingRules(String... conflictingRules) {
            conflictingRules(Arrays.asList(conflictingRules));
            return this;
        }

        public final List<AutomatedReasoningPolicyDisjointRuleSet.Builder> getDisjointRuleSets() {
            List<AutomatedReasoningPolicyDisjointRuleSet.Builder> result = AutomatedReasoningPolicyDisjointRuleSetListCopier
                    .copyToBuilder(this.disjointRuleSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisjointRuleSets(Collection<AutomatedReasoningPolicyDisjointRuleSet.BuilderImpl> disjointRuleSets) {
            this.disjointRuleSets = AutomatedReasoningPolicyDisjointRuleSetListCopier.copyFromBuilder(disjointRuleSets);
        }

        @Override
        public final Builder disjointRuleSets(Collection<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets) {
            this.disjointRuleSets = AutomatedReasoningPolicyDisjointRuleSetListCopier.copy(disjointRuleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disjointRuleSets(AutomatedReasoningPolicyDisjointRuleSet... disjointRuleSets) {
            disjointRuleSets(Arrays.asList(disjointRuleSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disjointRuleSets(Consumer<AutomatedReasoningPolicyDisjointRuleSet.Builder>... disjointRuleSets) {
            disjointRuleSets(Stream.of(disjointRuleSets)
                    .map(c -> AutomatedReasoningPolicyDisjointRuleSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyDefinitionQualityReport build() {
            return new AutomatedReasoningPolicyDefinitionQualityReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
