/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a custom user-defined viarble type in an Automated Reasoning policy. Types are enum-based and provide
 * additional context beyond predefined variable types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyDefinitionType implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyDefinitionType.Builder, AutomatedReasoningPolicyDefinitionType> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AutomatedReasoningPolicyDefinitionType::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AutomatedReasoningPolicyDefinitionType::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyDefinitionTypeValue>> VALUES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyDefinitionTypeValue>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(AutomatedReasoningPolicyDefinitionType::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyDefinitionTypeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyDefinitionTypeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final List<AutomatedReasoningPolicyDefinitionTypeValue> values;

    private AutomatedReasoningPolicyDefinitionType(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the custom type.
     * </p>
     * 
     * @return The name of the custom type.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of what the custom type represents.
     * </p>
     * 
     * @return The description of what the custom type represents.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The possible values for this enum-based type, each with its own description.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The possible values for this enum-based type, each with its own description.
     */
    public final List<AutomatedReasoningPolicyDefinitionTypeValue> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDefinitionType)) {
            return false;
        }
        AutomatedReasoningPolicyDefinitionType other = (AutomatedReasoningPolicyDefinitionType) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyDefinitionType")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDefinitionType, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDefinitionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyDefinitionType> {
        /**
         * <p>
         * The name of the custom type.
         * </p>
         * 
         * @param name
         *        The name of the custom type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of what the custom type represents.
         * </p>
         * 
         * @param description
         *        The description of what the custom type represents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The possible values for this enum-based type, each with its own description.
         * </p>
         * 
         * @param values
         *        The possible values for this enum-based type, each with its own description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<AutomatedReasoningPolicyDefinitionTypeValue> values);

        /**
         * <p>
         * The possible values for this enum-based type, each with its own description.
         * </p>
         * 
         * @param values
         *        The possible values for this enum-based type, each with its own description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(AutomatedReasoningPolicyDefinitionTypeValue... values);

        /**
         * <p>
         * The possible values for this enum-based type, each with its own description.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValue.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValue.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #values(List<AutomatedReasoningPolicyDefinitionTypeValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<AutomatedReasoningPolicyDefinitionTypeValue>)
         */
        Builder values(Consumer<AutomatedReasoningPolicyDefinitionTypeValue.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<AutomatedReasoningPolicyDefinitionTypeValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDefinitionType model) {
            name(model.name);
            description(model.description);
            values(model.values);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionTypeValue.Builder> getValues() {
            List<AutomatedReasoningPolicyDefinitionTypeValue.Builder> result = AutomatedReasoningPolicyDefinitionTypeValueListCopier
                    .copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<AutomatedReasoningPolicyDefinitionTypeValue.BuilderImpl> values) {
            this.values = AutomatedReasoningPolicyDefinitionTypeValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<AutomatedReasoningPolicyDefinitionTypeValue> values) {
            this.values = AutomatedReasoningPolicyDefinitionTypeValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(AutomatedReasoningPolicyDefinitionTypeValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<AutomatedReasoningPolicyDefinitionTypeValue.Builder>... values) {
            values(Stream.of(values).map(c -> AutomatedReasoningPolicyDefinitionTypeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyDefinitionType build() {
            return new AutomatedReasoningPolicyDefinitionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
