/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for various mutation operations that can be applied to an Automated Reasoning policy, including adding,
 * updating, and deleting policy elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyMutation implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyMutation.Builder, AutomatedReasoningPolicyMutation> {
    private static final SdkField<AutomatedReasoningPolicyAddTypeMutation> ADD_TYPE_FIELD = SdkField
            .<AutomatedReasoningPolicyAddTypeMutation> builder(MarshallingType.SDK_POJO).memberName("addType")
            .getter(getter(AutomatedReasoningPolicyMutation::addType)).setter(setter(Builder::addType))
            .constructor(AutomatedReasoningPolicyAddTypeMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addType").build()).build();

    private static final SdkField<AutomatedReasoningPolicyUpdateTypeMutation> UPDATE_TYPE_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateTypeMutation> builder(MarshallingType.SDK_POJO).memberName("updateType")
            .getter(getter(AutomatedReasoningPolicyMutation::updateType)).setter(setter(Builder::updateType))
            .constructor(AutomatedReasoningPolicyUpdateTypeMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDeleteTypeMutation> DELETE_TYPE_FIELD = SdkField
            .<AutomatedReasoningPolicyDeleteTypeMutation> builder(MarshallingType.SDK_POJO).memberName("deleteType")
            .getter(getter(AutomatedReasoningPolicyMutation::deleteType)).setter(setter(Builder::deleteType))
            .constructor(AutomatedReasoningPolicyDeleteTypeMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteType").build()).build();

    private static final SdkField<AutomatedReasoningPolicyAddVariableMutation> ADD_VARIABLE_FIELD = SdkField
            .<AutomatedReasoningPolicyAddVariableMutation> builder(MarshallingType.SDK_POJO).memberName("addVariable")
            .getter(getter(AutomatedReasoningPolicyMutation::addVariable)).setter(setter(Builder::addVariable))
            .constructor(AutomatedReasoningPolicyAddVariableMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addVariable").build()).build();

    private static final SdkField<AutomatedReasoningPolicyUpdateVariableMutation> UPDATE_VARIABLE_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateVariableMutation> builder(MarshallingType.SDK_POJO).memberName("updateVariable")
            .getter(getter(AutomatedReasoningPolicyMutation::updateVariable)).setter(setter(Builder::updateVariable))
            .constructor(AutomatedReasoningPolicyUpdateVariableMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateVariable").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDeleteVariableMutation> DELETE_VARIABLE_FIELD = SdkField
            .<AutomatedReasoningPolicyDeleteVariableMutation> builder(MarshallingType.SDK_POJO).memberName("deleteVariable")
            .getter(getter(AutomatedReasoningPolicyMutation::deleteVariable)).setter(setter(Builder::deleteVariable))
            .constructor(AutomatedReasoningPolicyDeleteVariableMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteVariable").build()).build();

    private static final SdkField<AutomatedReasoningPolicyAddRuleMutation> ADD_RULE_FIELD = SdkField
            .<AutomatedReasoningPolicyAddRuleMutation> builder(MarshallingType.SDK_POJO).memberName("addRule")
            .getter(getter(AutomatedReasoningPolicyMutation::addRule)).setter(setter(Builder::addRule))
            .constructor(AutomatedReasoningPolicyAddRuleMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addRule").build()).build();

    private static final SdkField<AutomatedReasoningPolicyUpdateRuleMutation> UPDATE_RULE_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateRuleMutation> builder(MarshallingType.SDK_POJO).memberName("updateRule")
            .getter(getter(AutomatedReasoningPolicyMutation::updateRule)).setter(setter(Builder::updateRule))
            .constructor(AutomatedReasoningPolicyUpdateRuleMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateRule").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDeleteRuleMutation> DELETE_RULE_FIELD = SdkField
            .<AutomatedReasoningPolicyDeleteRuleMutation> builder(MarshallingType.SDK_POJO).memberName("deleteRule")
            .getter(getter(AutomatedReasoningPolicyMutation::deleteRule)).setter(setter(Builder::deleteRule))
            .constructor(AutomatedReasoningPolicyDeleteRuleMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_TYPE_FIELD,
            UPDATE_TYPE_FIELD, DELETE_TYPE_FIELD, ADD_VARIABLE_FIELD, UPDATE_VARIABLE_FIELD, DELETE_VARIABLE_FIELD,
            ADD_RULE_FIELD, UPDATE_RULE_FIELD, DELETE_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyAddTypeMutation addType;

    private final AutomatedReasoningPolicyUpdateTypeMutation updateType;

    private final AutomatedReasoningPolicyDeleteTypeMutation deleteType;

    private final AutomatedReasoningPolicyAddVariableMutation addVariable;

    private final AutomatedReasoningPolicyUpdateVariableMutation updateVariable;

    private final AutomatedReasoningPolicyDeleteVariableMutation deleteVariable;

    private final AutomatedReasoningPolicyAddRuleMutation addRule;

    private final AutomatedReasoningPolicyUpdateRuleMutation updateRule;

    private final AutomatedReasoningPolicyDeleteRuleMutation deleteRule;

    private final Type type;

    private AutomatedReasoningPolicyMutation(BuilderImpl builder) {
        this.addType = builder.addType;
        this.updateType = builder.updateType;
        this.deleteType = builder.deleteType;
        this.addVariable = builder.addVariable;
        this.updateVariable = builder.updateVariable;
        this.deleteVariable = builder.deleteVariable;
        this.addRule = builder.addRule;
        this.updateRule = builder.updateRule;
        this.deleteRule = builder.deleteRule;
        this.type = builder.type;
    }

    /**
     * <p>
     * A mutation to add a new custom type to the policy.
     * </p>
     * 
     * @return A mutation to add a new custom type to the policy.
     */
    public final AutomatedReasoningPolicyAddTypeMutation addType() {
        return addType;
    }

    /**
     * <p>
     * A mutation to modify an existing custom type in the policy.
     * </p>
     * 
     * @return A mutation to modify an existing custom type in the policy.
     */
    public final AutomatedReasoningPolicyUpdateTypeMutation updateType() {
        return updateType;
    }

    /**
     * <p>
     * A mutation to remove a custom type from the policy.
     * </p>
     * 
     * @return A mutation to remove a custom type from the policy.
     */
    public final AutomatedReasoningPolicyDeleteTypeMutation deleteType() {
        return deleteType;
    }

    /**
     * <p>
     * A mutation to add a new variable to the policy.
     * </p>
     * 
     * @return A mutation to add a new variable to the policy.
     */
    public final AutomatedReasoningPolicyAddVariableMutation addVariable() {
        return addVariable;
    }

    /**
     * <p>
     * A mutation to modify an existing variable in the policy.
     * </p>
     * 
     * @return A mutation to modify an existing variable in the policy.
     */
    public final AutomatedReasoningPolicyUpdateVariableMutation updateVariable() {
        return updateVariable;
    }

    /**
     * <p>
     * A mutation to remove a variable from the policy.
     * </p>
     * 
     * @return A mutation to remove a variable from the policy.
     */
    public final AutomatedReasoningPolicyDeleteVariableMutation deleteVariable() {
        return deleteVariable;
    }

    /**
     * <p>
     * A mutation to add a new rule to the policy.
     * </p>
     * 
     * @return A mutation to add a new rule to the policy.
     */
    public final AutomatedReasoningPolicyAddRuleMutation addRule() {
        return addRule;
    }

    /**
     * <p>
     * A mutation to modify an existing rule in the policy.
     * </p>
     * 
     * @return A mutation to modify an existing rule in the policy.
     */
    public final AutomatedReasoningPolicyUpdateRuleMutation updateRule() {
        return updateRule;
    }

    /**
     * <p>
     * A mutation to remove a rule from the policy.
     * </p>
     * 
     * @return A mutation to remove a rule from the policy.
     */
    public final AutomatedReasoningPolicyDeleteRuleMutation deleteRule() {
        return deleteRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addType());
        hashCode = 31 * hashCode + Objects.hashCode(updateType());
        hashCode = 31 * hashCode + Objects.hashCode(deleteType());
        hashCode = 31 * hashCode + Objects.hashCode(addVariable());
        hashCode = 31 * hashCode + Objects.hashCode(updateVariable());
        hashCode = 31 * hashCode + Objects.hashCode(deleteVariable());
        hashCode = 31 * hashCode + Objects.hashCode(addRule());
        hashCode = 31 * hashCode + Objects.hashCode(updateRule());
        hashCode = 31 * hashCode + Objects.hashCode(deleteRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyMutation)) {
            return false;
        }
        AutomatedReasoningPolicyMutation other = (AutomatedReasoningPolicyMutation) obj;
        return Objects.equals(addType(), other.addType()) && Objects.equals(updateType(), other.updateType())
                && Objects.equals(deleteType(), other.deleteType()) && Objects.equals(addVariable(), other.addVariable())
                && Objects.equals(updateVariable(), other.updateVariable())
                && Objects.equals(deleteVariable(), other.deleteVariable()) && Objects.equals(addRule(), other.addRule())
                && Objects.equals(updateRule(), other.updateRule()) && Objects.equals(deleteRule(), other.deleteRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyMutation").add("AddType", addType()).add("UpdateType", updateType())
                .add("DeleteType", deleteType()).add("AddVariable", addVariable()).add("UpdateVariable", updateVariable())
                .add("DeleteVariable", deleteVariable()).add("AddRule", addRule()).add("UpdateRule", updateRule())
                .add("DeleteRule", deleteRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addType":
            return Optional.ofNullable(clazz.cast(addType()));
        case "updateType":
            return Optional.ofNullable(clazz.cast(updateType()));
        case "deleteType":
            return Optional.ofNullable(clazz.cast(deleteType()));
        case "addVariable":
            return Optional.ofNullable(clazz.cast(addVariable()));
        case "updateVariable":
            return Optional.ofNullable(clazz.cast(updateVariable()));
        case "deleteVariable":
            return Optional.ofNullable(clazz.cast(deleteVariable()));
        case "addRule":
            return Optional.ofNullable(clazz.cast(addRule()));
        case "updateRule":
            return Optional.ofNullable(clazz.cast(updateRule()));
        case "deleteRule":
            return Optional.ofNullable(clazz.cast(deleteRule()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #addType()} initialized to the given value.
     *
     * <p>
     * A mutation to add a new custom type to the policy.
     * </p>
     * 
     * @param addType
     *        A mutation to add a new custom type to the policy.
     */
    public static AutomatedReasoningPolicyMutation fromAddType(AutomatedReasoningPolicyAddTypeMutation addType) {
        return builder().addType(addType).build();
    }

    /**
     * Create an instance of this class with {@link #addType()} initialized to the given value.
     *
     * <p>
     * A mutation to add a new custom type to the policy.
     * </p>
     * 
     * @param addType
     *        A mutation to add a new custom type to the policy.
     */
    public static AutomatedReasoningPolicyMutation fromAddType(Consumer<AutomatedReasoningPolicyAddTypeMutation.Builder> addType) {
        AutomatedReasoningPolicyAddTypeMutation.Builder builder = AutomatedReasoningPolicyAddTypeMutation.builder();
        addType.accept(builder);
        return fromAddType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateType()} initialized to the given value.
     *
     * <p>
     * A mutation to modify an existing custom type in the policy.
     * </p>
     * 
     * @param updateType
     *        A mutation to modify an existing custom type in the policy.
     */
    public static AutomatedReasoningPolicyMutation fromUpdateType(AutomatedReasoningPolicyUpdateTypeMutation updateType) {
        return builder().updateType(updateType).build();
    }

    /**
     * Create an instance of this class with {@link #updateType()} initialized to the given value.
     *
     * <p>
     * A mutation to modify an existing custom type in the policy.
     * </p>
     * 
     * @param updateType
     *        A mutation to modify an existing custom type in the policy.
     */
    public static AutomatedReasoningPolicyMutation fromUpdateType(
            Consumer<AutomatedReasoningPolicyUpdateTypeMutation.Builder> updateType) {
        AutomatedReasoningPolicyUpdateTypeMutation.Builder builder = AutomatedReasoningPolicyUpdateTypeMutation.builder();
        updateType.accept(builder);
        return fromUpdateType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteType()} initialized to the given value.
     *
     * <p>
     * A mutation to remove a custom type from the policy.
     * </p>
     * 
     * @param deleteType
     *        A mutation to remove a custom type from the policy.
     */
    public static AutomatedReasoningPolicyMutation fromDeleteType(AutomatedReasoningPolicyDeleteTypeMutation deleteType) {
        return builder().deleteType(deleteType).build();
    }

    /**
     * Create an instance of this class with {@link #deleteType()} initialized to the given value.
     *
     * <p>
     * A mutation to remove a custom type from the policy.
     * </p>
     * 
     * @param deleteType
     *        A mutation to remove a custom type from the policy.
     */
    public static AutomatedReasoningPolicyMutation fromDeleteType(
            Consumer<AutomatedReasoningPolicyDeleteTypeMutation.Builder> deleteType) {
        AutomatedReasoningPolicyDeleteTypeMutation.Builder builder = AutomatedReasoningPolicyDeleteTypeMutation.builder();
        deleteType.accept(builder);
        return fromDeleteType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #addVariable()} initialized to the given value.
     *
     * <p>
     * A mutation to add a new variable to the policy.
     * </p>
     * 
     * @param addVariable
     *        A mutation to add a new variable to the policy.
     */
    public static AutomatedReasoningPolicyMutation fromAddVariable(AutomatedReasoningPolicyAddVariableMutation addVariable) {
        return builder().addVariable(addVariable).build();
    }

    /**
     * Create an instance of this class with {@link #addVariable()} initialized to the given value.
     *
     * <p>
     * A mutation to add a new variable to the policy.
     * </p>
     * 
     * @param addVariable
     *        A mutation to add a new variable to the policy.
     */
    public static AutomatedReasoningPolicyMutation fromAddVariable(
            Consumer<AutomatedReasoningPolicyAddVariableMutation.Builder> addVariable) {
        AutomatedReasoningPolicyAddVariableMutation.Builder builder = AutomatedReasoningPolicyAddVariableMutation.builder();
        addVariable.accept(builder);
        return fromAddVariable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateVariable()} initialized to the given value.
     *
     * <p>
     * A mutation to modify an existing variable in the policy.
     * </p>
     * 
     * @param updateVariable
     *        A mutation to modify an existing variable in the policy.
     */
    public static AutomatedReasoningPolicyMutation fromUpdateVariable(
            AutomatedReasoningPolicyUpdateVariableMutation updateVariable) {
        return builder().updateVariable(updateVariable).build();
    }

    /**
     * Create an instance of this class with {@link #updateVariable()} initialized to the given value.
     *
     * <p>
     * A mutation to modify an existing variable in the policy.
     * </p>
     * 
     * @param updateVariable
     *        A mutation to modify an existing variable in the policy.
     */
    public static AutomatedReasoningPolicyMutation fromUpdateVariable(
            Consumer<AutomatedReasoningPolicyUpdateVariableMutation.Builder> updateVariable) {
        AutomatedReasoningPolicyUpdateVariableMutation.Builder builder = AutomatedReasoningPolicyUpdateVariableMutation.builder();
        updateVariable.accept(builder);
        return fromUpdateVariable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteVariable()} initialized to the given value.
     *
     * <p>
     * A mutation to remove a variable from the policy.
     * </p>
     * 
     * @param deleteVariable
     *        A mutation to remove a variable from the policy.
     */
    public static AutomatedReasoningPolicyMutation fromDeleteVariable(
            AutomatedReasoningPolicyDeleteVariableMutation deleteVariable) {
        return builder().deleteVariable(deleteVariable).build();
    }

    /**
     * Create an instance of this class with {@link #deleteVariable()} initialized to the given value.
     *
     * <p>
     * A mutation to remove a variable from the policy.
     * </p>
     * 
     * @param deleteVariable
     *        A mutation to remove a variable from the policy.
     */
    public static AutomatedReasoningPolicyMutation fromDeleteVariable(
            Consumer<AutomatedReasoningPolicyDeleteVariableMutation.Builder> deleteVariable) {
        AutomatedReasoningPolicyDeleteVariableMutation.Builder builder = AutomatedReasoningPolicyDeleteVariableMutation.builder();
        deleteVariable.accept(builder);
        return fromDeleteVariable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #addRule()} initialized to the given value.
     *
     * <p>
     * A mutation to add a new rule to the policy.
     * </p>
     * 
     * @param addRule
     *        A mutation to add a new rule to the policy.
     */
    public static AutomatedReasoningPolicyMutation fromAddRule(AutomatedReasoningPolicyAddRuleMutation addRule) {
        return builder().addRule(addRule).build();
    }

    /**
     * Create an instance of this class with {@link #addRule()} initialized to the given value.
     *
     * <p>
     * A mutation to add a new rule to the policy.
     * </p>
     * 
     * @param addRule
     *        A mutation to add a new rule to the policy.
     */
    public static AutomatedReasoningPolicyMutation fromAddRule(Consumer<AutomatedReasoningPolicyAddRuleMutation.Builder> addRule) {
        AutomatedReasoningPolicyAddRuleMutation.Builder builder = AutomatedReasoningPolicyAddRuleMutation.builder();
        addRule.accept(builder);
        return fromAddRule(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateRule()} initialized to the given value.
     *
     * <p>
     * A mutation to modify an existing rule in the policy.
     * </p>
     * 
     * @param updateRule
     *        A mutation to modify an existing rule in the policy.
     */
    public static AutomatedReasoningPolicyMutation fromUpdateRule(AutomatedReasoningPolicyUpdateRuleMutation updateRule) {
        return builder().updateRule(updateRule).build();
    }

    /**
     * Create an instance of this class with {@link #updateRule()} initialized to the given value.
     *
     * <p>
     * A mutation to modify an existing rule in the policy.
     * </p>
     * 
     * @param updateRule
     *        A mutation to modify an existing rule in the policy.
     */
    public static AutomatedReasoningPolicyMutation fromUpdateRule(
            Consumer<AutomatedReasoningPolicyUpdateRuleMutation.Builder> updateRule) {
        AutomatedReasoningPolicyUpdateRuleMutation.Builder builder = AutomatedReasoningPolicyUpdateRuleMutation.builder();
        updateRule.accept(builder);
        return fromUpdateRule(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteRule()} initialized to the given value.
     *
     * <p>
     * A mutation to remove a rule from the policy.
     * </p>
     * 
     * @param deleteRule
     *        A mutation to remove a rule from the policy.
     */
    public static AutomatedReasoningPolicyMutation fromDeleteRule(AutomatedReasoningPolicyDeleteRuleMutation deleteRule) {
        return builder().deleteRule(deleteRule).build();
    }

    /**
     * Create an instance of this class with {@link #deleteRule()} initialized to the given value.
     *
     * <p>
     * A mutation to remove a rule from the policy.
     * </p>
     * 
     * @param deleteRule
     *        A mutation to remove a rule from the policy.
     */
    public static AutomatedReasoningPolicyMutation fromDeleteRule(
            Consumer<AutomatedReasoningPolicyDeleteRuleMutation.Builder> deleteRule) {
        AutomatedReasoningPolicyDeleteRuleMutation.Builder builder = AutomatedReasoningPolicyDeleteRuleMutation.builder();
        deleteRule.accept(builder);
        return fromDeleteRule(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addType", ADD_TYPE_FIELD);
        map.put("updateType", UPDATE_TYPE_FIELD);
        map.put("deleteType", DELETE_TYPE_FIELD);
        map.put("addVariable", ADD_VARIABLE_FIELD);
        map.put("updateVariable", UPDATE_VARIABLE_FIELD);
        map.put("deleteVariable", DELETE_VARIABLE_FIELD);
        map.put("addRule", ADD_RULE_FIELD);
        map.put("updateRule", UPDATE_RULE_FIELD);
        map.put("deleteRule", DELETE_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyMutation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyMutation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyMutation> {
        /**
         * <p>
         * A mutation to add a new custom type to the policy.
         * </p>
         * 
         * @param addType
         *        A mutation to add a new custom type to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addType(AutomatedReasoningPolicyAddTypeMutation addType);

        /**
         * <p>
         * A mutation to add a new custom type to the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAddTypeMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyAddTypeMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyAddTypeMutation.Builder#build()} is
         * called immediately and its result is passed to {@link #addType(AutomatedReasoningPolicyAddTypeMutation)}.
         * 
         * @param addType
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyAddTypeMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addType(AutomatedReasoningPolicyAddTypeMutation)
         */
        default Builder addType(Consumer<AutomatedReasoningPolicyAddTypeMutation.Builder> addType) {
            return addType(AutomatedReasoningPolicyAddTypeMutation.builder().applyMutation(addType).build());
        }

        /**
         * <p>
         * A mutation to modify an existing custom type in the policy.
         * </p>
         * 
         * @param updateType
         *        A mutation to modify an existing custom type in the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateType(AutomatedReasoningPolicyUpdateTypeMutation updateType);

        /**
         * <p>
         * A mutation to modify an existing custom type in the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateTypeMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyUpdateTypeMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyUpdateTypeMutation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #updateType(AutomatedReasoningPolicyUpdateTypeMutation)}.
         * 
         * @param updateType
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyUpdateTypeMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateType(AutomatedReasoningPolicyUpdateTypeMutation)
         */
        default Builder updateType(Consumer<AutomatedReasoningPolicyUpdateTypeMutation.Builder> updateType) {
            return updateType(AutomatedReasoningPolicyUpdateTypeMutation.builder().applyMutation(updateType).build());
        }

        /**
         * <p>
         * A mutation to remove a custom type from the policy.
         * </p>
         * 
         * @param deleteType
         *        A mutation to remove a custom type from the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteType(AutomatedReasoningPolicyDeleteTypeMutation deleteType);

        /**
         * <p>
         * A mutation to remove a custom type from the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDeleteTypeMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDeleteTypeMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDeleteTypeMutation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deleteType(AutomatedReasoningPolicyDeleteTypeMutation)}.
         * 
         * @param deleteType
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDeleteTypeMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteType(AutomatedReasoningPolicyDeleteTypeMutation)
         */
        default Builder deleteType(Consumer<AutomatedReasoningPolicyDeleteTypeMutation.Builder> deleteType) {
            return deleteType(AutomatedReasoningPolicyDeleteTypeMutation.builder().applyMutation(deleteType).build());
        }

        /**
         * <p>
         * A mutation to add a new variable to the policy.
         * </p>
         * 
         * @param addVariable
         *        A mutation to add a new variable to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addVariable(AutomatedReasoningPolicyAddVariableMutation addVariable);

        /**
         * <p>
         * A mutation to add a new variable to the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAddVariableMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyAddVariableMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyAddVariableMutation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #addVariable(AutomatedReasoningPolicyAddVariableMutation)}.
         * 
         * @param addVariable
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyAddVariableMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addVariable(AutomatedReasoningPolicyAddVariableMutation)
         */
        default Builder addVariable(Consumer<AutomatedReasoningPolicyAddVariableMutation.Builder> addVariable) {
            return addVariable(AutomatedReasoningPolicyAddVariableMutation.builder().applyMutation(addVariable).build());
        }

        /**
         * <p>
         * A mutation to modify an existing variable in the policy.
         * </p>
         * 
         * @param updateVariable
         *        A mutation to modify an existing variable in the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateVariable(AutomatedReasoningPolicyUpdateVariableMutation updateVariable);

        /**
         * <p>
         * A mutation to modify an existing variable in the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateVariableMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyUpdateVariableMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyUpdateVariableMutation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #updateVariable(AutomatedReasoningPolicyUpdateVariableMutation)}.
         * 
         * @param updateVariable
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyUpdateVariableMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateVariable(AutomatedReasoningPolicyUpdateVariableMutation)
         */
        default Builder updateVariable(Consumer<AutomatedReasoningPolicyUpdateVariableMutation.Builder> updateVariable) {
            return updateVariable(AutomatedReasoningPolicyUpdateVariableMutation.builder().applyMutation(updateVariable).build());
        }

        /**
         * <p>
         * A mutation to remove a variable from the policy.
         * </p>
         * 
         * @param deleteVariable
         *        A mutation to remove a variable from the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteVariable(AutomatedReasoningPolicyDeleteVariableMutation deleteVariable);

        /**
         * <p>
         * A mutation to remove a variable from the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDeleteVariableMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDeleteVariableMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDeleteVariableMutation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #deleteVariable(AutomatedReasoningPolicyDeleteVariableMutation)}.
         * 
         * @param deleteVariable
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDeleteVariableMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteVariable(AutomatedReasoningPolicyDeleteVariableMutation)
         */
        default Builder deleteVariable(Consumer<AutomatedReasoningPolicyDeleteVariableMutation.Builder> deleteVariable) {
            return deleteVariable(AutomatedReasoningPolicyDeleteVariableMutation.builder().applyMutation(deleteVariable).build());
        }

        /**
         * <p>
         * A mutation to add a new rule to the policy.
         * </p>
         * 
         * @param addRule
         *        A mutation to add a new rule to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRule(AutomatedReasoningPolicyAddRuleMutation addRule);

        /**
         * <p>
         * A mutation to add a new rule to the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAddRuleMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyAddRuleMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyAddRuleMutation.Builder#build()} is
         * called immediately and its result is passed to {@link #addRule(AutomatedReasoningPolicyAddRuleMutation)}.
         * 
         * @param addRule
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyAddRuleMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addRule(AutomatedReasoningPolicyAddRuleMutation)
         */
        default Builder addRule(Consumer<AutomatedReasoningPolicyAddRuleMutation.Builder> addRule) {
            return addRule(AutomatedReasoningPolicyAddRuleMutation.builder().applyMutation(addRule).build());
        }

        /**
         * <p>
         * A mutation to modify an existing rule in the policy.
         * </p>
         * 
         * @param updateRule
         *        A mutation to modify an existing rule in the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateRule(AutomatedReasoningPolicyUpdateRuleMutation updateRule);

        /**
         * <p>
         * A mutation to modify an existing rule in the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateRuleMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyUpdateRuleMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyUpdateRuleMutation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #updateRule(AutomatedReasoningPolicyUpdateRuleMutation)}.
         * 
         * @param updateRule
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyUpdateRuleMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateRule(AutomatedReasoningPolicyUpdateRuleMutation)
         */
        default Builder updateRule(Consumer<AutomatedReasoningPolicyUpdateRuleMutation.Builder> updateRule) {
            return updateRule(AutomatedReasoningPolicyUpdateRuleMutation.builder().applyMutation(updateRule).build());
        }

        /**
         * <p>
         * A mutation to remove a rule from the policy.
         * </p>
         * 
         * @param deleteRule
         *        A mutation to remove a rule from the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteRule(AutomatedReasoningPolicyDeleteRuleMutation deleteRule);

        /**
         * <p>
         * A mutation to remove a rule from the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDeleteRuleMutation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDeleteRuleMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDeleteRuleMutation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deleteRule(AutomatedReasoningPolicyDeleteRuleMutation)}.
         * 
         * @param deleteRule
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDeleteRuleMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteRule(AutomatedReasoningPolicyDeleteRuleMutation)
         */
        default Builder deleteRule(Consumer<AutomatedReasoningPolicyDeleteRuleMutation.Builder> deleteRule) {
            return deleteRule(AutomatedReasoningPolicyDeleteRuleMutation.builder().applyMutation(deleteRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyAddTypeMutation addType;

        private AutomatedReasoningPolicyUpdateTypeMutation updateType;

        private AutomatedReasoningPolicyDeleteTypeMutation deleteType;

        private AutomatedReasoningPolicyAddVariableMutation addVariable;

        private AutomatedReasoningPolicyUpdateVariableMutation updateVariable;

        private AutomatedReasoningPolicyDeleteVariableMutation deleteVariable;

        private AutomatedReasoningPolicyAddRuleMutation addRule;

        private AutomatedReasoningPolicyUpdateRuleMutation updateRule;

        private AutomatedReasoningPolicyDeleteRuleMutation deleteRule;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyMutation model) {
            addType(model.addType);
            updateType(model.updateType);
            deleteType(model.deleteType);
            addVariable(model.addVariable);
            updateVariable(model.updateVariable);
            deleteVariable(model.deleteVariable);
            addRule(model.addRule);
            updateRule(model.updateRule);
            deleteRule(model.deleteRule);
        }

        public final AutomatedReasoningPolicyAddTypeMutation.Builder getAddType() {
            return addType != null ? addType.toBuilder() : null;
        }

        public final void setAddType(AutomatedReasoningPolicyAddTypeMutation.BuilderImpl addType) {
            Object oldValue = this.addType;
            this.addType = addType != null ? addType.build() : null;
            handleUnionValueChange(Type.ADD_TYPE, oldValue, this.addType);
        }

        @Override
        public final Builder addType(AutomatedReasoningPolicyAddTypeMutation addType) {
            Object oldValue = this.addType;
            this.addType = addType;
            handleUnionValueChange(Type.ADD_TYPE, oldValue, this.addType);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateTypeMutation.Builder getUpdateType() {
            return updateType != null ? updateType.toBuilder() : null;
        }

        public final void setUpdateType(AutomatedReasoningPolicyUpdateTypeMutation.BuilderImpl updateType) {
            Object oldValue = this.updateType;
            this.updateType = updateType != null ? updateType.build() : null;
            handleUnionValueChange(Type.UPDATE_TYPE, oldValue, this.updateType);
        }

        @Override
        public final Builder updateType(AutomatedReasoningPolicyUpdateTypeMutation updateType) {
            Object oldValue = this.updateType;
            this.updateType = updateType;
            handleUnionValueChange(Type.UPDATE_TYPE, oldValue, this.updateType);
            return this;
        }

        public final AutomatedReasoningPolicyDeleteTypeMutation.Builder getDeleteType() {
            return deleteType != null ? deleteType.toBuilder() : null;
        }

        public final void setDeleteType(AutomatedReasoningPolicyDeleteTypeMutation.BuilderImpl deleteType) {
            Object oldValue = this.deleteType;
            this.deleteType = deleteType != null ? deleteType.build() : null;
            handleUnionValueChange(Type.DELETE_TYPE, oldValue, this.deleteType);
        }

        @Override
        public final Builder deleteType(AutomatedReasoningPolicyDeleteTypeMutation deleteType) {
            Object oldValue = this.deleteType;
            this.deleteType = deleteType;
            handleUnionValueChange(Type.DELETE_TYPE, oldValue, this.deleteType);
            return this;
        }

        public final AutomatedReasoningPolicyAddVariableMutation.Builder getAddVariable() {
            return addVariable != null ? addVariable.toBuilder() : null;
        }

        public final void setAddVariable(AutomatedReasoningPolicyAddVariableMutation.BuilderImpl addVariable) {
            Object oldValue = this.addVariable;
            this.addVariable = addVariable != null ? addVariable.build() : null;
            handleUnionValueChange(Type.ADD_VARIABLE, oldValue, this.addVariable);
        }

        @Override
        public final Builder addVariable(AutomatedReasoningPolicyAddVariableMutation addVariable) {
            Object oldValue = this.addVariable;
            this.addVariable = addVariable;
            handleUnionValueChange(Type.ADD_VARIABLE, oldValue, this.addVariable);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateVariableMutation.Builder getUpdateVariable() {
            return updateVariable != null ? updateVariable.toBuilder() : null;
        }

        public final void setUpdateVariable(AutomatedReasoningPolicyUpdateVariableMutation.BuilderImpl updateVariable) {
            Object oldValue = this.updateVariable;
            this.updateVariable = updateVariable != null ? updateVariable.build() : null;
            handleUnionValueChange(Type.UPDATE_VARIABLE, oldValue, this.updateVariable);
        }

        @Override
        public final Builder updateVariable(AutomatedReasoningPolicyUpdateVariableMutation updateVariable) {
            Object oldValue = this.updateVariable;
            this.updateVariable = updateVariable;
            handleUnionValueChange(Type.UPDATE_VARIABLE, oldValue, this.updateVariable);
            return this;
        }

        public final AutomatedReasoningPolicyDeleteVariableMutation.Builder getDeleteVariable() {
            return deleteVariable != null ? deleteVariable.toBuilder() : null;
        }

        public final void setDeleteVariable(AutomatedReasoningPolicyDeleteVariableMutation.BuilderImpl deleteVariable) {
            Object oldValue = this.deleteVariable;
            this.deleteVariable = deleteVariable != null ? deleteVariable.build() : null;
            handleUnionValueChange(Type.DELETE_VARIABLE, oldValue, this.deleteVariable);
        }

        @Override
        public final Builder deleteVariable(AutomatedReasoningPolicyDeleteVariableMutation deleteVariable) {
            Object oldValue = this.deleteVariable;
            this.deleteVariable = deleteVariable;
            handleUnionValueChange(Type.DELETE_VARIABLE, oldValue, this.deleteVariable);
            return this;
        }

        public final AutomatedReasoningPolicyAddRuleMutation.Builder getAddRule() {
            return addRule != null ? addRule.toBuilder() : null;
        }

        public final void setAddRule(AutomatedReasoningPolicyAddRuleMutation.BuilderImpl addRule) {
            Object oldValue = this.addRule;
            this.addRule = addRule != null ? addRule.build() : null;
            handleUnionValueChange(Type.ADD_RULE, oldValue, this.addRule);
        }

        @Override
        public final Builder addRule(AutomatedReasoningPolicyAddRuleMutation addRule) {
            Object oldValue = this.addRule;
            this.addRule = addRule;
            handleUnionValueChange(Type.ADD_RULE, oldValue, this.addRule);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateRuleMutation.Builder getUpdateRule() {
            return updateRule != null ? updateRule.toBuilder() : null;
        }

        public final void setUpdateRule(AutomatedReasoningPolicyUpdateRuleMutation.BuilderImpl updateRule) {
            Object oldValue = this.updateRule;
            this.updateRule = updateRule != null ? updateRule.build() : null;
            handleUnionValueChange(Type.UPDATE_RULE, oldValue, this.updateRule);
        }

        @Override
        public final Builder updateRule(AutomatedReasoningPolicyUpdateRuleMutation updateRule) {
            Object oldValue = this.updateRule;
            this.updateRule = updateRule;
            handleUnionValueChange(Type.UPDATE_RULE, oldValue, this.updateRule);
            return this;
        }

        public final AutomatedReasoningPolicyDeleteRuleMutation.Builder getDeleteRule() {
            return deleteRule != null ? deleteRule.toBuilder() : null;
        }

        public final void setDeleteRule(AutomatedReasoningPolicyDeleteRuleMutation.BuilderImpl deleteRule) {
            Object oldValue = this.deleteRule;
            this.deleteRule = deleteRule != null ? deleteRule.build() : null;
            handleUnionValueChange(Type.DELETE_RULE, oldValue, this.deleteRule);
        }

        @Override
        public final Builder deleteRule(AutomatedReasoningPolicyDeleteRuleMutation deleteRule) {
            Object oldValue = this.deleteRule;
            this.deleteRule = deleteRule;
            handleUnionValueChange(Type.DELETE_RULE, oldValue, this.deleteRule);
            return this;
        }

        @Override
        public AutomatedReasoningPolicyMutation build() {
            return new AutomatedReasoningPolicyMutation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedReasoningPolicyMutation#type()
     */
    public enum Type {
        ADD_TYPE,

        UPDATE_TYPE,

        DELETE_TYPE,

        ADD_VARIABLE,

        UPDATE_VARIABLE,

        DELETE_VARIABLE,

        ADD_RULE,

        UPDATE_RULE,

        DELETE_RULE,

        UNKNOWN_TO_SDK_VERSION
    }
}
