/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a test for validating an Automated Reasoning policy. tests contain sample inputs and expected outcomes to
 * verify policy behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyTestCase implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyTestCase.Builder, AutomatedReasoningPolicyTestCase> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(AutomatedReasoningPolicyTestCase::testCaseId))
            .setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()).build();

    private static final SdkField<String> GUARD_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardContent").getter(getter(AutomatedReasoningPolicyTestCase::guardContent))
            .setter(setter(Builder::guardContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()).build();

    private static final SdkField<String> QUERY_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryContent").getter(getter(AutomatedReasoningPolicyTestCase::queryContent))
            .setter(setter(Builder::queryContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryContent").build()).build();

    private static final SdkField<String> EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("expectedAggregatedFindingsResult")
            .getter(getter(AutomatedReasoningPolicyTestCase::expectedAggregatedFindingsResultAsString))
            .setter(setter(Builder::expectedAggregatedFindingsResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedAggregatedFindingsResult")
                    .build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AutomatedReasoningPolicyTestCase::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AutomatedReasoningPolicyTestCase::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Double> CONFIDENCE_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("confidenceThreshold").getter(getter(AutomatedReasoningPolicyTestCase::confidenceThreshold))
            .setter(setter(Builder::confidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD,
            GUARD_CONTENT_FIELD, QUERY_CONTENT_FIELD, EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, CONFIDENCE_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String testCaseId;

    private final String guardContent;

    private final String queryContent;

    private final String expectedAggregatedFindingsResult;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Double confidenceThreshold;

    private AutomatedReasoningPolicyTestCase(BuilderImpl builder) {
        this.testCaseId = builder.testCaseId;
        this.guardContent = builder.guardContent;
        this.queryContent = builder.queryContent;
        this.expectedAggregatedFindingsResult = builder.expectedAggregatedFindingsResult;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.confidenceThreshold = builder.confidenceThreshold;
    }

    /**
     * <p>
     * The unique identifier of the test.
     * </p>
     * 
     * @return The unique identifier of the test.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The output content to be validated by the policy, typically representing a foundation model response.
     * </p>
     * 
     * @return The output content to be validated by the policy, typically representing a foundation model response.
     */
    public final String guardContent() {
        return guardContent;
    }

    /**
     * <p>
     * The input query or prompt that generated the content. This provides context for the validation.
     * </p>
     * 
     * @return The input query or prompt that generated the content. This provides context for the validation.
     */
    public final String queryContent() {
        return queryContent;
    }

    /**
     * <p>
     * The expected result of the Automated Reasoning check for this test.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedAggregatedFindingsResult} will return
     * {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expectedAggregatedFindingsResultAsString}.
     * </p>
     * 
     * @return The expected result of the Automated Reasoning check for this test.
     * @see AutomatedReasoningCheckResult
     */
    public final AutomatedReasoningCheckResult expectedAggregatedFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(expectedAggregatedFindingsResult);
    }

    /**
     * <p>
     * The expected result of the Automated Reasoning check for this test.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedAggregatedFindingsResult} will return
     * {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expectedAggregatedFindingsResultAsString}.
     * </p>
     * 
     * @return The expected result of the Automated Reasoning check for this test.
     * @see AutomatedReasoningCheckResult
     */
    public final String expectedAggregatedFindingsResultAsString() {
        return expectedAggregatedFindingsResult;
    }

    /**
     * <p>
     * The timestamp when the test was created.
     * </p>
     * 
     * @return The timestamp when the test was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the test was last updated.
     * </p>
     * 
     * @return The timestamp when the test was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The minimum confidence level for logic validation. Content meeting this threshold is considered high-confidence
     * and can be validated.
     * </p>
     * 
     * @return The minimum confidence level for logic validation. Content meeting this threshold is considered
     *         high-confidence and can be validated.
     */
    public final Double confidenceThreshold() {
        return confidenceThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(queryContent());
        hashCode = 31 * hashCode + Objects.hashCode(expectedAggregatedFindingsResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyTestCase)) {
            return false;
        }
        AutomatedReasoningPolicyTestCase other = (AutomatedReasoningPolicyTestCase) obj;
        return Objects.equals(testCaseId(), other.testCaseId()) && Objects.equals(guardContent(), other.guardContent())
                && Objects.equals(queryContent(), other.queryContent())
                && Objects.equals(expectedAggregatedFindingsResultAsString(), other.expectedAggregatedFindingsResultAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(confidenceThreshold(), other.confidenceThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyTestCase").add("TestCaseId", testCaseId())
                .add("GuardContent", guardContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QueryContent", queryContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExpectedAggregatedFindingsResult", expectedAggregatedFindingsResultAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("ConfidenceThreshold", confidenceThreshold())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "guardContent":
            return Optional.ofNullable(clazz.cast(guardContent()));
        case "queryContent":
            return Optional.ofNullable(clazz.cast(queryContent()));
        case "expectedAggregatedFindingsResult":
            return Optional.ofNullable(clazz.cast(expectedAggregatedFindingsResultAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "confidenceThreshold":
            return Optional.ofNullable(clazz.cast(confidenceThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("queryContent", QUERY_CONTENT_FIELD);
        map.put("expectedAggregatedFindingsResult", EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyTestCase, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyTestCase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyTestCase> {
        /**
         * <p>
         * The unique identifier of the test.
         * </p>
         * 
         * @param testCaseId
         *        The unique identifier of the test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The output content to be validated by the policy, typically representing a foundation model response.
         * </p>
         * 
         * @param guardContent
         *        The output content to be validated by the policy, typically representing a foundation model response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardContent(String guardContent);

        /**
         * <p>
         * The input query or prompt that generated the content. This provides context for the validation.
         * </p>
         * 
         * @param queryContent
         *        The input query or prompt that generated the content. This provides context for the validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryContent(String queryContent);

        /**
         * <p>
         * The expected result of the Automated Reasoning check for this test.
         * </p>
         * 
         * @param expectedAggregatedFindingsResult
         *        The expected result of the Automated Reasoning check for this test.
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult);

        /**
         * <p>
         * The expected result of the Automated Reasoning check for this test.
         * </p>
         * 
         * @param expectedAggregatedFindingsResult
         *        The expected result of the Automated Reasoning check for this test.
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult);

        /**
         * <p>
         * The timestamp when the test was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the test was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the test was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the test was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The minimum confidence level for logic validation. Content meeting this threshold is considered
         * high-confidence and can be validated.
         * </p>
         * 
         * @param confidenceThreshold
         *        The minimum confidence level for logic validation. Content meeting this threshold is considered
         *        high-confidence and can be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidenceThreshold(Double confidenceThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String testCaseId;

        private String guardContent;

        private String queryContent;

        private String expectedAggregatedFindingsResult;

        private Instant createdAt;

        private Instant updatedAt;

        private Double confidenceThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyTestCase model) {
            testCaseId(model.testCaseId);
            guardContent(model.guardContent);
            queryContent(model.queryContent);
            expectedAggregatedFindingsResult(model.expectedAggregatedFindingsResult);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            confidenceThreshold(model.confidenceThreshold);
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getGuardContent() {
            return guardContent;
        }

        public final void setGuardContent(String guardContent) {
            this.guardContent = guardContent;
        }

        @Override
        public final Builder guardContent(String guardContent) {
            this.guardContent = guardContent;
            return this;
        }

        public final String getQueryContent() {
            return queryContent;
        }

        public final void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        @Override
        public final Builder queryContent(String queryContent) {
            this.queryContent = queryContent;
            return this;
        }

        public final String getExpectedAggregatedFindingsResult() {
            return expectedAggregatedFindingsResult;
        }

        public final void setExpectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
            return this;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult(expectedAggregatedFindingsResult == null ? null
                    : expectedAggregatedFindingsResult.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Double getConfidenceThreshold() {
            return confidenceThreshold;
        }

        public final void setConfidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyTestCase build() {
            return new AutomatedReasoningPolicyTestCase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
