/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AutomatedReasoningPolicyTypeValueAnnotationListCopier {
    static List<AutomatedReasoningPolicyTypeValueAnnotation> copy(
            Collection<? extends AutomatedReasoningPolicyTypeValueAnnotation> automatedReasoningPolicyTypeValueAnnotationListParam) {
        List<AutomatedReasoningPolicyTypeValueAnnotation> list;
        if (automatedReasoningPolicyTypeValueAnnotationListParam == null
                || automatedReasoningPolicyTypeValueAnnotationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomatedReasoningPolicyTypeValueAnnotation> modifiableList = new ArrayList<>(
                    automatedReasoningPolicyTypeValueAnnotationListParam.size());
            automatedReasoningPolicyTypeValueAnnotationListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutomatedReasoningPolicyTypeValueAnnotation> copyFromBuilder(
            Collection<? extends AutomatedReasoningPolicyTypeValueAnnotation.Builder> automatedReasoningPolicyTypeValueAnnotationListParam) {
        List<AutomatedReasoningPolicyTypeValueAnnotation> list;
        if (automatedReasoningPolicyTypeValueAnnotationListParam == null
                || automatedReasoningPolicyTypeValueAnnotationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomatedReasoningPolicyTypeValueAnnotation> modifiableList = new ArrayList<>(
                    automatedReasoningPolicyTypeValueAnnotationListParam.size());
            automatedReasoningPolicyTypeValueAnnotationListParam.forEach(entry -> {
                AutomatedReasoningPolicyTypeValueAnnotation member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutomatedReasoningPolicyTypeValueAnnotation.Builder> copyToBuilder(
            Collection<? extends AutomatedReasoningPolicyTypeValueAnnotation> automatedReasoningPolicyTypeValueAnnotationListParam) {
        List<AutomatedReasoningPolicyTypeValueAnnotation.Builder> list;
        if (automatedReasoningPolicyTypeValueAnnotationListParam == null
                || automatedReasoningPolicyTypeValueAnnotationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomatedReasoningPolicyTypeValueAnnotation.Builder> modifiableList = new ArrayList<>(
                    automatedReasoningPolicyTypeValueAnnotationListParam.size());
            automatedReasoningPolicyTypeValueAnnotationListParam.forEach(entry -> {
                AutomatedReasoningPolicyTypeValueAnnotation.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
