/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An annotation for modifying an existing variable in an Automated Reasoning policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyUpdateVariableAnnotation
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyUpdateVariableAnnotation.Builder, AutomatedReasoningPolicyUpdateVariableAnnotation> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AutomatedReasoningPolicyUpdateVariableAnnotation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newName").getter(getter(AutomatedReasoningPolicyUpdateVariableAnnotation::newName))
            .setter(setter(Builder::newName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AutomatedReasoningPolicyUpdateVariableAnnotation::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NEW_NAME_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String newName;

    private final String description;

    private AutomatedReasoningPolicyUpdateVariableAnnotation(BuilderImpl builder) {
        this.name = builder.name;
        this.newName = builder.newName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The current name of the variable to update.
     * </p>
     * 
     * @return The current name of the variable to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new name for the variable, if you want to rename it. If not provided, the name remains unchanged.
     * </p>
     * 
     * @return The new name for the variable, if you want to rename it. If not provided, the name remains unchanged.
     */
    public final String newName() {
        return newName;
    }

    /**
     * <p>
     * The new description for the variable, replacing the previous description.
     * </p>
     * 
     * @return The new description for the variable, replacing the previous description.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(newName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyUpdateVariableAnnotation)) {
            return false;
        }
        AutomatedReasoningPolicyUpdateVariableAnnotation other = (AutomatedReasoningPolicyUpdateVariableAnnotation) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(newName(), other.newName())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyUpdateVariableAnnotation")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NewName", newName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "newName":
            return Optional.ofNullable(clazz.cast(newName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("newName", NEW_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyUpdateVariableAnnotation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyUpdateVariableAnnotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyUpdateVariableAnnotation> {
        /**
         * <p>
         * The current name of the variable to update.
         * </p>
         * 
         * @param name
         *        The current name of the variable to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new name for the variable, if you want to rename it. If not provided, the name remains unchanged.
         * </p>
         * 
         * @param newName
         *        The new name for the variable, if you want to rename it. If not provided, the name remains unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newName(String newName);

        /**
         * <p>
         * The new description for the variable, replacing the previous description.
         * </p>
         * 
         * @param description
         *        The new description for the variable, replacing the previous description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String newName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyUpdateVariableAnnotation model) {
            name(model.name);
            newName(model.newName);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNewName() {
            return newName;
        }

        public final void setNewName(String newName) {
            this.newName = newName;
        }

        @Override
        public final Builder newName(String newName) {
            this.newName = newName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyUpdateVariableAnnotation build() {
            return new AutomatedReasoningPolicyUpdateVariableAnnotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
